/*
 * Decompiled with CFR 0.152.
 */
package com.shephertz.app42.paas.sdk.jme.social;

import com.shephertz.app42.paas.sdk.jme.App42CallBack;
import com.shephertz.app42.paas.sdk.jme.App42Exception;
import com.shephertz.app42.paas.sdk.jme.App42Log;
import com.shephertz.app42.paas.sdk.jme.App42Response;
import com.shephertz.app42.paas.sdk.jme.App42Service;
import com.shephertz.app42.paas.sdk.jme.Config;
import com.shephertz.app42.paas.sdk.jme.connection.RESTConnector;
import com.shephertz.app42.paas.sdk.jme.connection.RESTConnectorAsync;
import com.shephertz.app42.paas.sdk.jme.message.Queue;
import com.shephertz.app42.paas.sdk.jme.message.QueueResponseBuilder;
import com.shephertz.app42.paas.sdk.jme.social.Social;
import com.shephertz.app42.paas.sdk.jme.social.SocialResponseBuilder;
import com.shephertz.app42.paas.sdk.jme.util.URLEncoder;
import com.shephertz.app42.paas.sdk.jme.util.Util;
import java.io.InputStream;
import java.util.Date;
import java.util.Hashtable;
import java.util.Random;
import javax.microedition.midlet.MIDlet;
import org.json.jme.JSONObject;

public class SocialService
extends App42Service {
    private Config config = Config.getInstance();
    private String resource = "social";
    private String baseURL;
    private final int RANDOM_LENGTH;
    private static boolean isStopRequestFBOAuth = false;
    private static boolean isStoppedFBOAuth = true;
    private static boolean isFBOAuthRunning = false;
    private static int MAX_ACCESSTOKEN_ATTEMPT = 30;

    public SocialService(String apiKey, String secretKey, String baseURL) {
        this.RANDOM_LENGTH = 10;
        this.apiKey = apiKey;
        this.secretKey = secretKey;
        this.baseURL = baseURL;
        this.version = "1.0";
    }

    public Social linkUserFacebookAccount(String userName, String accessToken, String appId, String appSecret) throws App42Exception {
        String response = null;
        Social social = null;
        Util.throwExceptionIfNullOrBlank(userName, "userName");
        Util.throwExceptionIfNullOrBlank(appId, "appId");
        Util.throwExceptionIfNullOrBlank(appSecret, "appSecret");
        Util.throwExceptionIfNullOrBlank(accessToken, "accessToken");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            JSONObject obj = new JSONObject();
            obj.put("userName", userName);
            obj.put("accessToken", accessToken);
            obj.put("appId", appId);
            obj.put("appSecret", appSecret);
            StringBuffer sb = new StringBuffer();
            sb.append("{\"app42\":{\"social\":").append(obj.toString()).append("}}");
            App42Log.debug(" Json String : " + sb.toString());
            signParams.put("body", sb.toString());
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/facebook/linkuser";
            response = RESTConnectorAsync.getInstance().executePost(resourceURL, queryParams, sb.toString(), headerParams);
            social = new SocialResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return social;
    }

    public void linkUserFacebookAccount(final String userName, final String accessToken, final String appId, final String appSecret, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Social social = SocialService.this.linkUserFacebookAccount(userName, accessToken, appId, appSecret);
                    callBack.onSuccess(social);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Social linkUserFacebookAccount(String userName, String accessToken) throws App42Exception {
        String response = null;
        Social social = null;
        Util.throwExceptionIfNullOrBlank(userName, "userName");
        Util.throwExceptionIfNullOrBlank(accessToken, "accessToken");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            JSONObject obj = new JSONObject();
            obj.put("userName", userName);
            obj.put("accessToken", accessToken);
            StringBuffer sb = new StringBuffer();
            sb.append("{\"app42\":{\"social\":").append(obj.toString()).append("}}");
            App42Log.debug(" Json String : " + sb.toString());
            signParams.put("body", sb.toString());
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/facebook/linkuser/accesscredentials";
            response = RESTConnectorAsync.getInstance().executePost(resourceURL, queryParams, sb.toString(), headerParams);
            social = new SocialResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return social;
    }

    public void linkUserFacebookAccount(final String userName, final String accessToken, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Social social = SocialService.this.linkUserFacebookAccount(userName, accessToken);
                    callBack.onSuccess(social);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Social updateFacebookStatus(String userName, String status) throws App42Exception {
        String response = null;
        Social social = null;
        Util.throwExceptionIfNullOrBlank(userName, "userName");
        Util.throwExceptionIfNullOrBlank(status, "status");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            JSONObject obj = new JSONObject();
            obj.put("userName", userName);
            obj.put("status", status);
            StringBuffer sb = new StringBuffer();
            sb.append("{\"app42\":{\"social\":").append(obj.toString()).append("}}");
            App42Log.debug(" Json String : " + sb.toString());
            signParams.put("body", sb.toString());
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/facebook/updatestatus";
            response = RESTConnectorAsync.getInstance().executePost(resourceURL, queryParams, sb.toString(), headerParams);
            social = new SocialResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return social;
    }

    public void updateFacebookStatus(final String userName, final String status, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Social social = SocialService.this.updateFacebookStatus(userName, status);
                    callBack.onSuccess(social);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Social linkUserTwitterAccount(String userName, String accessToken, String accessTokenSecret, String consumerKey, String consumerSecret) throws App42Exception {
        String response = null;
        Social social = null;
        Util.throwExceptionIfNullOrBlank(userName, "userName");
        Util.throwExceptionIfNullOrBlank(consumerKey, "consumerKey");
        Util.throwExceptionIfNullOrBlank(consumerSecret, "consumerSecret");
        Util.throwExceptionIfNullOrBlank(accessToken, "accessToken");
        Util.throwExceptionIfNullOrBlank(accessTokenSecret, "accessTokenSecret");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            JSONObject obj = new JSONObject();
            obj.put("userName", userName);
            obj.put("consumerKey", consumerKey);
            obj.put("consumerSecret", consumerSecret);
            obj.put("accessToken", accessToken);
            obj.put("accessTokenSecret", accessTokenSecret);
            StringBuffer sb = new StringBuffer();
            sb.append("{\"app42\":{\"social\":").append(obj.toString()).append("}}");
            App42Log.debug(" Json String : " + sb.toString());
            signParams.put("body", sb.toString());
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/twitter/linkuser";
            response = RESTConnectorAsync.getInstance().executePost(resourceURL, queryParams, sb.toString(), headerParams);
            social = new SocialResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return social;
    }

    public void linkUserTwitterAccount(final String userName, final String accessToken, final String accessTokenSecret, final String consumerKey, final String consumerSecret, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Social social = SocialService.this.linkUserTwitterAccount(userName, accessToken, accessTokenSecret, consumerKey, consumerSecret);
                    callBack.onSuccess(social);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Social linkUserTwitterAccount(String userName, String accessToken, String accessTokenSecret) throws App42Exception {
        String response = null;
        Social social = null;
        Util.throwExceptionIfNullOrBlank(userName, "userName");
        Util.throwExceptionIfNullOrBlank(accessToken, "accessToken");
        Util.throwExceptionIfNullOrBlank(accessTokenSecret, "accessTokenSecret");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            JSONObject obj = new JSONObject();
            obj.put("userName", userName);
            obj.put("accessToken", accessToken);
            obj.put("accessTokenSecret", accessTokenSecret);
            StringBuffer sb = new StringBuffer();
            sb.append("{\"app42\":{\"social\":").append(obj.toString()).append("}}");
            App42Log.debug(" Json String : " + sb.toString());
            signParams.put("body", sb.toString());
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/twitter/linkuser/accesscredentials";
            response = RESTConnectorAsync.getInstance().executePost(resourceURL, queryParams, sb.toString(), headerParams);
            social = new SocialResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return social;
    }

    public void linkUserTwitterAccount(final String userName, final String accessToken, final String accessTokenSecret, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Social social = SocialService.this.linkUserTwitterAccount(userName, accessToken, accessTokenSecret);
                    callBack.onSuccess(social);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Social updateTwitterStatus(String userName, String status) throws App42Exception {
        String response = null;
        Social social = null;
        Util.throwExceptionIfNullOrBlank(userName, "userName");
        Util.throwExceptionIfNullOrBlank(status, "status");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            JSONObject obj = new JSONObject();
            obj.put("userName", userName);
            obj.put("status", status);
            StringBuffer sb = new StringBuffer();
            sb.append("{\"app42\":{\"social\":").append(obj.toString()).append("}}");
            App42Log.debug(" Json String : " + sb.toString());
            signParams.put("body", sb.toString());
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/twitter/updatestatus";
            response = RESTConnectorAsync.getInstance().executePost(resourceURL, queryParams, sb.toString(), headerParams);
            social = new SocialResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return social;
    }

    public void updateTwitterStatus(final String userName, final String status, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Social social = SocialService.this.updateTwitterStatus(userName, status);
                    callBack.onSuccess(social);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Social linkUserLinkedInAccount(String userName, String accessToken, String accessTokenSecret, String apiKey, String secretKey) throws App42Exception {
        String response = null;
        Social social = null;
        Util.throwExceptionIfNullOrBlank(userName, "userName");
        Util.throwExceptionIfNullOrBlank(apiKey, "apiKey");
        Util.throwExceptionIfNullOrBlank(secretKey, "secretKey");
        Util.throwExceptionIfNullOrBlank(accessToken, "accessToken");
        Util.throwExceptionIfNullOrBlank(accessTokenSecret, "accessTokenSecret");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            JSONObject obj = new JSONObject();
            obj.put("userName", userName);
            obj.put("apiKey", apiKey);
            obj.put("secretKey", secretKey);
            obj.put("accessToken", accessToken);
            obj.put("accessTokenSecret", accessTokenSecret);
            StringBuffer sb = new StringBuffer();
            sb.append("{\"app42\":{\"social\":").append(obj.toString()).append("}}");
            App42Log.debug(" Json String : " + sb.toString());
            signParams.put("body", sb.toString());
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/linkedin/linkuser";
            response = RESTConnectorAsync.getInstance().executePost(resourceURL, queryParams, sb.toString(), headerParams);
            social = new SocialResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return social;
    }

    public void linkUserLinkedInAccount(final String userName, final String accessToken, final String accessTokenSecret, final String apiKey, final String secretKey, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Social social = SocialService.this.linkUserLinkedInAccount(userName, accessToken, accessTokenSecret, apiKey, secretKey);
                    callBack.onSuccess(social);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Social linkUserLinkedInAccount(String userName, String accessToken, String accessTokenSecret) throws App42Exception {
        String response = null;
        Social social = null;
        Util.throwExceptionIfNullOrBlank(userName, "userName");
        Util.throwExceptionIfNullOrBlank(accessToken, "accessToken");
        Util.throwExceptionIfNullOrBlank(accessTokenSecret, "accessTokenSecret");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            JSONObject obj = new JSONObject();
            obj.put("userName", userName);
            obj.put("accessToken", accessToken);
            obj.put("accessTokenSecret", accessTokenSecret);
            StringBuffer sb = new StringBuffer();
            sb.append("{\"app42\":{\"social\":").append(obj.toString()).append("}}");
            App42Log.debug(" Json String : " + sb.toString());
            signParams.put("body", sb.toString());
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/linkedin/linkuser/accesscredentials";
            response = RESTConnectorAsync.getInstance().executePost(resourceURL, queryParams, sb.toString(), headerParams);
            social = new SocialResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return social;
    }

    public void linkUserLinkedInAccount(final String userName, final String accessToken, final String accessTokenSecret, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Social social = SocialService.this.linkUserLinkedInAccount(userName, accessToken, accessTokenSecret);
                    callBack.onSuccess(social);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Social updateLinkedInStatus(String userName, String status) throws App42Exception {
        String response = null;
        Social social = null;
        Util.throwExceptionIfNullOrBlank(userName, "userName");
        Util.throwExceptionIfNullOrBlank(status, "status");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            JSONObject obj = new JSONObject();
            obj.put("userName", userName);
            obj.put("status", status);
            StringBuffer sb = new StringBuffer();
            sb.append("{\"app42\":{\"social\":").append(obj.toString()).append("}}");
            App42Log.debug(" Json String : " + sb.toString());
            signParams.put("body", sb.toString());
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/linkedin/updatestatus";
            response = RESTConnectorAsync.getInstance().executePost(resourceURL, queryParams, sb.toString(), headerParams);
            social = new SocialResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return social;
    }

    public void updateLinkedInStatus(final String userName, final String status, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Social social = SocialService.this.updateLinkedInStatus(userName, status);
                    callBack.onSuccess(social);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Social updateSocialStatusForAll(String userName, String status) throws App42Exception {
        String response = null;
        Social social = null;
        Util.throwExceptionIfNullOrBlank(userName, "userName");
        Util.throwExceptionIfNullOrBlank(status, "status");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            JSONObject obj = new JSONObject();
            obj.put("userName", userName);
            obj.put("status", status);
            StringBuffer sb = new StringBuffer();
            sb.append("{\"app42\":{\"social\":").append(obj.toString()).append("}}");
            App42Log.debug(" Json String : " + sb.toString());
            signParams.put("body", sb.toString());
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/social/updatestatus/all";
            response = RESTConnectorAsync.getInstance().executePost(resourceURL, queryParams, sb.toString(), headerParams);
            social = new SocialResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return social;
    }

    public void updateSocialStatusForAll(final String userName, final String status, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Social social = SocialService.this.updateSocialStatusForAll(userName, status);
                    callBack.onSuccess(social);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Social getFacebookFriendsFromLinkUser(String userName) throws App42Exception {
        String response = null;
        Social social = null;
        Util.throwExceptionIfNullOrBlank(userName, "UserName");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("userName", userName);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + "facebook/friends/" + userName;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            social = new SocialResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return social;
    }

    public void getFacebookFriendsFromLinkUser(final String userName, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Social social = SocialService.this.getFacebookFriendsFromLinkUser(userName);
                    callBack.onSuccess(social);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Social getFacebookFriendsFromAccessToken(String accessToken) throws App42Exception {
        String response = null;
        Social social = null;
        Util.throwExceptionIfNullOrBlank(accessToken, "AccessToken");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("accessToken", accessToken);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + "facebook/friends/OAuth/" + accessToken;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            social = new SocialResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return social;
    }

    public void getFacebookFriendsFromAccessToken(final String accessToken, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Social social = SocialService.this.getFacebookFriendsFromAccessToken(accessToken);
                    callBack.onSuccess(social);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Social getFacebookProfile(String accessToken) throws App42Exception {
        String response = null;
        Social social = null;
        Util.throwExceptionIfNullOrBlank(accessToken, "AccessToken");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("accessToken", accessToken);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + "facebook/me/OAuth/" + accessToken;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            social = new SocialResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return social;
    }

    public void getFacebookProfile(final String accessToken, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Social social = SocialService.this.getFacebookProfile(accessToken);
                    callBack.onSuccess(social);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public String doFBOAuthAndGetToken(MIDlet midlet, String fbAppID, String[] permission) throws App42Exception {
        this.cancelFBOAuth();
        Util.throwExceptionIfNullOrBlank(fbAppID, "fbAppID");
        try {
            String token = new Date().getTime() + "";
            App42Log.debug(" Starting OAuth " + token);
            String sessionToken = token + this.getRandomHexString(10);
            Hashtable<String, String> params = new Hashtable<String, String>();
            String timeStamp = Util.getUTCFormattedTimestamp();
            String secretKey = this.secretKey;
            params.put("apiKey", this.apiKey);
            params.put("version", this.version);
            params.put("timeStamp", timeStamp);
            params.put("sessionToken", "" + sessionToken);
            String signature = Util.sign(this.secretKey, params);
            JSONObject jsonObj = new JSONObject();
            jsonObj.put("apiKey", this.apiKey);
            jsonObj.put("version", this.version);
            jsonObj.put("timeStamp", timeStamp);
            jsonObj.put("sessionToken", "" + sessionToken);
            jsonObj.put("signature", signature);
            StringBuffer state = new StringBuffer();
            state.append("{\"app42\":").append(jsonObj.toString()).append("}");
            String stateStr = URLEncoder.encode(state.toString());
            String returnToURI = "/facebook/saveFeaturePhoneFBToken/?&response_type=code";
            if (permission != null && permission.length > 0) {
                StringBuffer sb = new StringBuffer("&scope=");
                for (int i = 0; i < permission.length; ++i) {
                    sb.append(permission[i]);
                    if (i == permission.length) continue;
                    sb.append(',');
                }
                returnToURI = returnToURI + sb.toString();
            }
            String string = this.handlePlatformRequest(fbAppID, stateStr, returnToURI, midlet, params, sessionToken);
            return string;
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        finally {
            isFBOAuthRunning = false;
            isStoppedFBOAuth = true;
        }
    }

    public String handlePlatformRequest(String fbAppID, String stateStr, String returnToURI, MIDlet midlet, Hashtable params, String sessionToken) throws Exception {
        String fbOAuthURL = "http://m.facebook.com/dialog/oauth/?display=touch&client_id=" + fbAppID + "&state=" + stateStr + "&redirect_uri=" + this.baseURL + this.version + "/" + this.resource + returnToURI;
        App42Log.debug(" FB OAuth URL : " + fbOAuthURL);
        boolean status = midlet.platformRequest(fbOAuthURL);
        int counter = 0;
        String accessToken = null;
        isFBOAuthRunning = true;
        isStoppedFBOAuth = false;
        while (!isStopRequestFBOAuth) {
            Thread.currentThread();
            Thread.sleep(5000L);
            if (counter >= MAX_ACCESSTOKEN_ATTEMPT) break;
            ++counter;
            Hashtable queryParams = new Hashtable();
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, params);
            String timeOutInSeconds = "1";
            params.put("timeOutInSeconds", timeOutInSeconds);
            String resourceURL = this.version + "/" + this.resource + "/" + "facebook/getFeaturePhoneAccessToken/" + sessionToken + "/" + timeOutInSeconds;
            String sign = Util.sign(this.secretKey, params);
            try {
                String response = RESTConnector.getInstance().executeGet(sign, resourceURL, queryParams);
                App42Log.debug("Access Token : " + response);
                accessToken = ((Queue.Message)new QueueResponseBuilder().buildRespoonse(response).getMessageList().elementAt(0)).getPayLoad();
                break;
            }
            catch (App42Exception ex) {
                if (ex.getAppErrorCode() == 2402) {
                    App42Log.debug(" No AccessToken Received in Attempt  :  " + counter);
                    if (counter != MAX_ACCESSTOKEN_ATTEMPT) continue;
                    throw new App42Exception("Facebook AccessToken Not Found. Either your OAuth failed or User has not initiated it yet");
                }
                ex.printStackTrace();
                throw ex;
            }
            catch (Exception ex) {
                App42Log.debug(" Exception : " + ex);
            }
        }
        return accessToken;
    }

    public void setAccessTokenAttempt(int count) {
        MAX_ACCESSTOKEN_ATTEMPT = count;
    }

    public void handlePlatformRequest(final String fbAppID, final String stateStr, final String returnToURI, final MIDlet midlet, final Hashtable params, final String sessionToken, final App42CallBack callBack) throws Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    String social = SocialService.this.handlePlatformRequest(fbAppID, stateStr, returnToURI, midlet, params, sessionToken);
                    callBack.onSuccess(social);
                }
                catch (Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public void cancelFBOAuth() {
        if (isFBOAuthRunning) {
            isStopRequestFBOAuth = true;
            while (!isStoppedFBOAuth) {
            }
        }
        isStopRequestFBOAuth = false;
    }

    public String getAccessTokenFromCode(String code, String appId, String appSecret) throws Exception {
        String redirectURL = this.baseURL + this.version + "/" + this.resource + "/facebook/saveFeaturePhoneFBToken/";
        String url = "https://graph.facebook.com/oauth/access_token?client_id=" + appId + "&redirect_uri=" + redirectURL + "&client_secret=" + appSecret + "&code=" + code;
        String result = RESTConnector.getInstance().executeGet(url);
        String token = result.substring(result.indexOf(61) + 1, result.indexOf(38));
        return token;
    }

    public void getAccessTokenFromCode(final String code, final String appId, final String appSecret, final App42CallBack callBack) throws Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    String social = SocialService.this.getAccessTokenFromCode(code, appId, appSecret);
                    callBack.onSuccess(social);
                }
                catch (Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public App42Response facebookPublishStream(String accessToken, String name, InputStream fileStream, String message) throws App42Exception {
        String response = null;
        App42Response responseObj = new App42Response();
        Util.throwExceptionIfNullOrBlank(accessToken, "Access Token");
        Util.throwExceptionIfNullOrBlank(name, "File Name");
        Util.throwExceptionIfNullOrBlank(fileStream, "fileStream");
        Util.throwExceptionIfNullOrBlank(message, "Message");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            Hashtable<String, String> postParams = new Hashtable<String, String>();
            postParams.put("name", name);
            postParams.put("accessToken", accessToken);
            if (message != null && message != "") {
                postParams.put("message", message);
            }
            signParams = net.oauth.jme.Util.hashtableMerge(signParams, postParams);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceUrl = Config.getInstance().getBaseURL() + this.version + "/" + this.resource + "/facebook/wallpost";
            response = Util.multiPartRequest("uploadFile", fileStream, name, queryParams, postParams, headerParams, resourceUrl, Config.getInstance().getAccept());
            responseObj.setStrResponse(response);
            responseObj.setResponseSuccess(true);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return responseObj;
    }

    public void facebookPublishStream(final String accessToken, final String name, final InputStream fileStream, final String message, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    App42Response social = SocialService.this.facebookPublishStream(accessToken, name, fileStream, message);
                    callBack.onSuccess(social);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    private App42Response facebookPublishStreamOnFriendsWall(String accessToken, String friendFacebookId, String name, InputStream fileStream, String message) throws App42Exception {
        String response = null;
        App42Response responseObj = new App42Response();
        Util.throwExceptionIfNullOrBlank(accessToken, "Access Token");
        Util.throwExceptionIfNullOrBlank(friendFacebookId, "Facebook Id");
        Util.throwExceptionIfNullOrBlank(name, "File Name");
        Util.throwExceptionIfNullOrBlank(fileStream, "fileStream");
        Util.throwExceptionIfNullOrBlank(message, "Message");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            Hashtable<String, String> postParams = new Hashtable<String, String>();
            postParams.put("name", name);
            postParams.put("accessToken", accessToken);
            postParams.put("userId", friendFacebookId);
            if (message != null && message != "") {
                postParams.put("message", message);
            }
            signParams = net.oauth.jme.Util.hashtableMerge(signParams, postParams);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceUrl = Config.getInstance().getBaseURL() + this.version + "/" + this.resource + "/facebook/wallpost";
            response = Util.multiPartRequest("uploadFile", fileStream, name, queryParams, postParams, headerParams, resourceUrl, Config.getInstance().getAccept());
            responseObj.setStrResponse(response);
            responseObj.setResponseSuccess(true);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return responseObj;
    }

    public App42Response facebookLinkPost(String accessToken, String link, String message) throws App42Exception {
        String response = null;
        App42Response responseObj = new App42Response();
        Util.throwExceptionIfNullOrBlank(accessToken, "Access Token");
        Util.throwExceptionIfNullOrBlank(link, "Link");
        Util.throwExceptionIfNullOrBlank(message, "Message");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            JSONObject obj = new JSONObject();
            obj.put("link", link);
            obj.put("accessToken", accessToken);
            obj.put("message", message);
            StringBuffer sb = new StringBuffer();
            sb.append("{\"app42\":{\"social\":").append(obj.toString()).append("}}");
            App42Log.debug(" Json String : " + sb.toString());
            signParams.put("body", sb.toString());
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/facebook/publishstream";
            response = RESTConnectorAsync.getInstance().executePost(resourceURL, queryParams, sb.toString(), headerParams);
            responseObj.setStrResponse(response);
            responseObj.setResponseSuccess(true);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return responseObj;
    }

    public void facebookLinkPost(final String accessToken, final String link, final String message, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    App42Response social = SocialService.this.facebookLinkPost(accessToken, link, message);
                    callBack.onSuccess(social);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public App42Response facebookLinkPostWithCustomThumbnail(String accessToken, String link, String message, String pictureUrl, String name, String description) throws App42Exception {
        String response = null;
        App42Response responseObj = new App42Response();
        Util.throwExceptionIfNullOrBlank(accessToken, "Access Token");
        Util.throwExceptionIfNullOrBlank(link, "Link");
        Util.throwExceptionIfNullOrBlank(message, "Message");
        Util.throwExceptionIfNullOrBlank(pictureUrl, "PictureUrl");
        Util.throwExceptionIfNullOrBlank(name, "File Name");
        Util.throwExceptionIfNullOrBlank(description, "Description");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            JSONObject obj = new JSONObject();
            obj.put("link", link);
            obj.put("accessToken", accessToken);
            obj.put("message", message);
            obj.put("picture", pictureUrl);
            obj.put("name", name);
            obj.put("description", description);
            StringBuffer sb = new StringBuffer();
            sb.append("{\"app42\":{\"social\":").append(obj.toString()).append("}}");
            App42Log.debug(" Json String : " + sb.toString());
            signParams.put("body", sb.toString());
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/facebook/publishstream";
            response = RESTConnectorAsync.getInstance().executePost(resourceURL, queryParams, sb.toString(), headerParams);
            responseObj.setStrResponse(response);
            responseObj.setResponseSuccess(true);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return responseObj;
    }

    public void facebookLinkPostWithCustomThumbnail(final String accessToken, final String link, final String message, final String pictureUrl, final String name, final String description, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    App42Response social = SocialService.this.facebookLinkPostWithCustomThumbnail(accessToken, link, message, pictureUrl, name, description);
                    callBack.onSuccess(social);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    private String getRandomHexString(int numchars) {
        Random r = new Random();
        StringBuffer sb = new StringBuffer();
        while (sb.length() < numchars) {
            sb.append(Integer.toHexString(r.nextInt()));
        }
        return sb.toString().substring(0, numchars);
    }
}

