/*
 * Decompiled with CFR 0.152.
 */
package com.shephertz.app42.paas.sdk.jme.upload;

import com.shephertz.app42.paas.sdk.jme.ACL;
import com.shephertz.app42.paas.sdk.jme.App42CallBack;
import com.shephertz.app42.paas.sdk.jme.App42Exception;
import com.shephertz.app42.paas.sdk.jme.App42Log;
import com.shephertz.app42.paas.sdk.jme.App42Response;
import com.shephertz.app42.paas.sdk.jme.App42Service;
import com.shephertz.app42.paas.sdk.jme.Config;
import com.shephertz.app42.paas.sdk.jme.connection.RESTConnectorAsync;
import com.shephertz.app42.paas.sdk.jme.upload.Upload;
import com.shephertz.app42.paas.sdk.jme.upload.UploadFileType;
import com.shephertz.app42.paas.sdk.jme.upload.UploadResponseBuilder;
import com.shephertz.app42.paas.sdk.jme.util.URLEncoder;
import com.shephertz.app42.paas.sdk.jme.util.Util;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import org.json.jme.JSONArray;
import org.json.jme.JSONObject;

public class UploadService
extends App42Service {
    private String resource = "upload";

    public UploadService(String apiKey, String secretKey, String baseURL) {
        this.apiKey = apiKey;
        this.secretKey = secretKey;
        this.version = "1.0";
    }

    public Upload uploadFile(String name, InputStream fileStream, String fileType, String description) throws App42Exception {
        String response = null;
        Upload upload = null;
        Util.throwExceptionIfNullOrBlank(name, "Name");
        Util.throwExceptionIfNullOrBlank(fileStream, "FileStream");
        Util.throwExceptionIfNullOrBlank(fileType, "fileType");
        Util.throwExceptionIfNullOrBlank(description, "Description");
        UploadFileType.throwExceptionIfNotValid(fileType);
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            Hashtable<String, String> postParams = new Hashtable<String, String>();
            postParams.put("name", name);
            postParams.put("type", fileType);
            postParams.put("description", description);
            signParams = net.oauth.jme.Util.hashtableMerge(signParams, postParams);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceUrl = Config.getInstance().getBaseURL() + this.version + "/" + this.resource;
            response = Util.multiPartRequest("uploadFile", fileStream, name, queryParams, postParams, headerParams, resourceUrl, Config.getInstance().getAccept());
            upload = new UploadResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return upload;
    }

    public void uploadFile(final String name, final InputStream fileStream, final String fileType, final String description, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Upload upload = UploadService.this.uploadFile(name, fileStream, fileType, description);
                    callBack.onSuccess(upload);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Upload getAllFiles() throws App42Exception {
        String response = null;
        Upload upload = null;
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            upload = new UploadResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return upload;
    }

    public void getAllFiles(final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Upload upload = UploadService.this.getAllFiles();
                    callBack.onSuccess(upload);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public App42Response getAllFilesCount() throws App42Exception {
        String response = null;
        App42Response responseObj = new App42Response();
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/count";
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            responseObj.setStrResponse(response);
            responseObj.setResponseSuccess(true);
            responseObj.setTotalRecords(new UploadResponseBuilder().getTotalRecords(response));
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return responseObj;
    }

    public void getAllFilesCount(final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    App42Response upload = UploadService.this.getAllFilesCount();
                    callBack.onSuccess(upload);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Upload getAllFiles(Integer max, Integer offset) throws App42Exception {
        String response = null;
        Upload upload = null;
        Util.validateMax(max);
        Util.throwExceptionIfNullOrBlank(max, "Max");
        Util.throwExceptionIfNullOrBlank(offset, "Offset");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            signParams.put("max", "" + max);
            signParams.put("offset", "" + offset);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/paging" + "/" + max + "/" + offset;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            upload = new UploadResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return upload;
    }

    public void getAllFiles(final Integer max, final Integer offset, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Upload upload = UploadService.this.getAllFiles(max, offset);
                    callBack.onSuccess(upload);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Upload getFileByName(String name) throws App42Exception {
        String response = null;
        Upload upload = null;
        Util.throwExceptionIfNullOrBlank(name, "Name");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("name", name);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + name;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            upload = new UploadResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return upload;
    }

    public void getFileByName(final String name, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Upload upload = UploadService.this.getFileByName(name);
                    callBack.onSuccess(upload);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public App42Response removeFileByName(String name) throws App42Exception {
        String response = null;
        App42Response responseObj = new App42Response();
        Util.throwExceptionIfNullOrBlank(name, "Name");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("name", name);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + name;
            response = RESTConnectorAsync.getInstance().executeDelete(resourceURL, queryParams, headerParams);
            responseObj.setStrResponse(response);
            responseObj.setResponseSuccess(true);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return responseObj;
    }

    public void removeFileByName(final String name, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    App42Response upload = UploadService.this.removeFileByName(name);
                    callBack.onSuccess(upload);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public App42Response removeAllFiles() throws App42Exception {
        String response = null;
        App42Response responseObj = new App42Response();
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource;
            response = RESTConnectorAsync.getInstance().executeDelete(resourceURL, queryParams, headerParams);
            responseObj.setStrResponse(response);
            responseObj.setResponseSuccess(true);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return responseObj;
    }

    public void removeAllFiles(final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    App42Response upload = UploadService.this.removeAllFiles();
                    callBack.onSuccess(upload);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Upload getFilesByType(String uploadFileType) throws App42Exception {
        String response = null;
        Upload upload = null;
        Util.throwExceptionIfNullOrBlank(uploadFileType, "uploadFileType");
        UploadFileType.throwExceptionIfNotValid(uploadFileType);
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("type", uploadFileType);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/type/" + uploadFileType;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            upload = new UploadResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return upload;
    }

    public void getFilesByType(final String uploadFileType, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Upload upload = UploadService.this.getFilesByType(uploadFileType);
                    callBack.onSuccess(upload);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public App42Response getFilesCountByType(String uploadFileType) throws App42Exception {
        String response = null;
        App42Response responseObj = new App42Response();
        Util.throwExceptionIfNullOrBlank(uploadFileType, "uploadFileType");
        UploadFileType.throwExceptionIfNotValid(uploadFileType);
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("type", uploadFileType);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/type/" + uploadFileType + "/count";
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            responseObj.setStrResponse(response);
            responseObj.setResponseSuccess(true);
            responseObj.setTotalRecords(new UploadResponseBuilder().getTotalRecords(response));
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return responseObj;
    }

    public void getFilesCountByType(final String uploadFileType, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    App42Response upload = UploadService.this.getFilesCountByType(uploadFileType);
                    callBack.onSuccess(upload);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Upload getFilesByType(String uploadFileType, Integer max, Integer offset) throws App42Exception {
        String response = null;
        Upload upload = null;
        Util.validateMax(max);
        Util.throwExceptionIfNullOrBlank(uploadFileType, "uploadFileType");
        UploadFileType.throwExceptionIfNotValid(uploadFileType);
        Util.throwExceptionIfNullOrBlank(max, "Max");
        Util.throwExceptionIfNullOrBlank(offset, "Offset");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("type", uploadFileType);
            signParams.put("max", "" + max);
            signParams.put("offset", "" + offset);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/type/" + uploadFileType + "/" + max + "/" + offset;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            upload = new UploadResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return upload;
    }

    public void getFilesByType(final String uploadFileType, final Integer max, final Integer offset, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Upload upload = UploadService.this.getFilesByType(uploadFileType, max, offset);
                    callBack.onSuccess(upload);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Upload uploadFileForUser(String name, String userName, InputStream fileInputStream, String fileType, String description) throws App42Exception {
        String response = null;
        Upload upload = null;
        Util.throwExceptionIfNullOrBlank(name, "File Name");
        Util.throwExceptionIfNullOrBlank(userName, "User Name");
        Util.throwExceptionIfNullOrBlank(fileInputStream, "File Stream");
        Util.throwExceptionIfNullOrBlank(fileType, "fileType");
        Util.throwExceptionIfNullOrBlank(description, "Description");
        UploadFileType.throwExceptionIfNotValid(fileType);
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            Hashtable<String, String> postParams = new Hashtable<String, String>();
            postParams.put("name", name);
            postParams.put("userName", userName);
            postParams.put("type", fileType);
            postParams.put("description", description);
            signParams = net.oauth.jme.Util.hashtableMerge(signParams, postParams);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceUrl = Config.getInstance().getBaseURL() + this.version + "/" + this.resource + "/" + userName;
            response = Util.multiPartRequest("uploadFile", fileInputStream, name, queryParams, postParams, headerParams, resourceUrl, Config.getInstance().getAccept());
            upload = new UploadResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return upload;
    }

    public void uploadFileForUser(final String name, final String userName, final InputStream fileInputStream, final String fileType, final String description, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Upload upload = UploadService.this.uploadFileForUser(name, userName, fileInputStream, fileType, description);
                    callBack.onSuccess(upload);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Upload getFileByUser(String name, String userName) throws App42Exception {
        String response = null;
        Upload upload = null;
        Util.throwExceptionIfNullOrBlank(name, "File Name");
        Util.throwExceptionIfNullOrBlank(userName, "User Name");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("name", name);
            signParams.put("userName", userName);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + userName + "/" + name;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            upload = new UploadResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return upload;
    }

    public void getFileByUser(final String name, final String userName, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Upload upload = UploadService.this.getFileByUser(name, userName);
                    callBack.onSuccess(upload);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Upload getAllFilesByUser(String userName) throws App42Exception {
        String response = null;
        Upload upload = null;
        Util.throwExceptionIfNullOrBlank(userName, "User Name");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("userName", userName);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + "user" + "/" + userName;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            upload = new UploadResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return upload;
    }

    public void getAllFilesByUser(final String userName, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Upload upload = UploadService.this.getAllFilesByUser(userName);
                    callBack.onSuccess(upload);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public App42Response getAllFilesCountByUser(String userName) throws App42Exception {
        String response = null;
        App42Response responseObj = new App42Response();
        Util.throwExceptionIfNullOrBlank(userName, "User Name");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("userName", userName);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + "user" + "/" + userName + "/count";
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            responseObj.setStrResponse(response);
            responseObj.setResponseSuccess(true);
            responseObj.setTotalRecords(new UploadResponseBuilder().getTotalRecords(response));
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return responseObj;
    }

    public void getAllFilesCountByUser(final String userName, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    App42Response upload = UploadService.this.getAllFilesCountByUser(userName);
                    callBack.onSuccess(upload);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Upload getAllFilesByUser(String userName, Integer max, Integer offset) throws App42Exception {
        String response = null;
        Upload upload = null;
        Util.validateMax(max);
        Util.throwExceptionIfNullOrBlank(userName, "User Name");
        Util.throwExceptionIfNullOrBlank(max, "Max");
        Util.throwExceptionIfNullOrBlank(offset, "Offset");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("userName", userName);
            signParams.put("max", max + "");
            signParams.put("offset", offset + "");
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + "user" + "/" + userName + "/" + max + "/" + offset;
            response = RESTConnectorAsync.getInstance().executeGet(resourceURL, queryParams, headerParams);
            upload = new UploadResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return upload;
    }

    public void getAllFilesByUser(final String userName, final Integer max, final Integer offset, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Upload upload = UploadService.this.getAllFilesByUser(userName, max, offset);
                    callBack.onSuccess(upload);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public App42Response removeFileByUser(String name, String userName) throws App42Exception {
        String response = null;
        App42Response responseObj = new App42Response();
        Util.throwExceptionIfNullOrBlank(name, "File Name");
        Util.throwExceptionIfNullOrBlank(userName, "User Name");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("name", name);
            signParams.put("userName", userName);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + userName + "/" + name;
            response = RESTConnectorAsync.getInstance().executeDelete(resourceURL, queryParams, headerParams);
            responseObj.setStrResponse(response);
            responseObj.setResponseSuccess(true);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return responseObj;
    }

    public void removeFileByUser(final String name, final String userName, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    App42Response upload = UploadService.this.removeFileByUser(name, userName);
                    callBack.onSuccess(upload);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public App42Response removeAllFilesByUser(String userName) throws App42Exception {
        String response = null;
        App42Response responseObj = new App42Response();
        Util.throwExceptionIfNullOrBlank(userName, "User Name");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            signParams.put("userName", userName);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + "user" + "/" + userName;
            response = RESTConnectorAsync.getInstance().executeDelete(resourceURL, queryParams, headerParams);
            responseObj.setStrResponse(response);
            responseObj.setResponseSuccess(true);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return responseObj;
    }

    public void removeAllFilesByUser(final String userName, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    App42Response upload = UploadService.this.removeAllFilesByUser(userName);
                    callBack.onSuccess(upload);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public App42Response revokeAccess(String fileName, String userName, Hashtable aclList) throws App42Exception {
        String response = null;
        App42Response responseObj = new App42Response();
        Util.throwExceptionIfNullOrBlank(fileName, "FileName");
        Util.throwExceptionIfNullOrBlank(userName, "UserName");
        Util.throwExceptionIfNullOrBlank(aclList, "acl");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            Enumeration enum_keys = signParams.keys();
            while (enum_keys.hasMoreElements()) {
                String key = (String)enum_keys.nextElement();
                queryParams.put(key, signParams.get(key));
            }
            signParams.put("fileName", fileName);
            signParams.put("userName", userName);
            JSONArray aclArray = new JSONArray();
            Enumeration aclListEnum = aclList.keys();
            while (aclListEnum.hasMoreElements()) {
                String key = aclListEnum.nextElement().toString();
                ACL acl = new ACL(key, aclList.get(key).toString());
                aclArray.put(acl.getJSONObject());
            }
            JSONObject obj = new JSONObject();
            obj.put("acls", "{\"acl\":" + aclArray + "}");
            StringBuffer sb = new StringBuffer();
            sb.append("{\"app42\":{\"upload\":").append(obj.toString()).append("}}");
            signParams.put("body", sb.toString());
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + "revokeAccess" + "/" + URLEncoder.encode(userName) + "/" + fileName;
            response = RESTConnectorAsync.getInstance().executePut(resourceURL, queryParams, sb.toString(), headerParams);
            responseObj.setStrResponse(response);
            responseObj.setResponseSuccess(true);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return responseObj;
    }

    public void revokeAccess(final String fileName, final String userName, final Hashtable aclList, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    App42Response upload = UploadService.this.revokeAccess(fileName, userName, aclList);
                    callBack.onSuccess(upload);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public App42Response grantAccess(String fileName, String userName, Hashtable aclList) throws App42Exception {
        String response = null;
        App42Response responseObj = new App42Response();
        Util.throwExceptionIfNullOrBlank(fileName, "FileName");
        Util.throwExceptionIfNullOrBlank(userName, "UserName");
        Util.throwExceptionIfNullOrBlank(aclList, "acl");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            Enumeration enum_keys = signParams.keys();
            while (enum_keys.hasMoreElements()) {
                String key = (String)enum_keys.nextElement();
                queryParams.put(key, signParams.get(key));
            }
            signParams.put("fileName", fileName);
            signParams.put("userName", userName);
            JSONArray aclArray = new JSONArray();
            Enumeration aclListEnum = aclList.keys();
            while (aclListEnum.hasMoreElements()) {
                String key = aclListEnum.nextElement().toString();
                ACL acl = new ACL(key, aclList.get(key).toString());
                aclArray.put(acl.getJSONObject());
            }
            JSONObject obj = new JSONObject();
            obj.put("acls", "{\"acl\":" + aclArray + "}");
            StringBuffer sb = new StringBuffer();
            sb.append("{\"app42\":{\"upload\":").append(obj.toString()).append("}}");
            signParams.put("body", sb.toString());
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceURL = this.version + "/" + this.resource + "/" + "grantAccess" + "/" + URLEncoder.encode(userName) + "/" + fileName;
            response = RESTConnectorAsync.getInstance().executePut(resourceURL, queryParams, sb.toString(), headerParams);
            responseObj.setStrResponse(response);
            responseObj.setResponseSuccess(true);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return responseObj;
    }

    public void grantAccess(final String fileName, final String userName, final Hashtable aclList, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    App42Response upload = UploadService.this.grantAccess(fileName, userName, aclList);
                    callBack.onSuccess(upload);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Upload uploadFileForGroup(String name, String userName, String ownerName, String groupName, InputStream fileStream, String fileType, String description) throws App42Exception {
        String response = null;
        Upload upload = null;
        Util.throwExceptionIfNullOrBlank(name, "File Name");
        Util.throwExceptionIfNullOrBlank(userName, "User Name");
        Util.throwExceptionIfNullOrBlank(fileStream, "FileStream");
        Util.throwExceptionIfNullOrBlank(fileType, "fileType");
        Util.throwExceptionIfNullOrBlank(description, "Description");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            Hashtable<String, String> postParams = new Hashtable<String, String>();
            postParams.put("name", name);
            postParams.put("userName", userName);
            postParams.put("ownerName", ownerName);
            postParams.put("groupName", groupName);
            postParams.put("type", fileType);
            postParams.put("description", description);
            signParams = net.oauth.jme.Util.hashtableMerge(signParams, postParams);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceUrl = Config.getInstance().getBaseURL() + this.version + "/" + this.resource + "/group/" + userName;
            response = Util.multiPartRequest("uploadFile", fileStream, name, queryParams, postParams, headerParams, resourceUrl, Config.getInstance().getAccept());
            upload = new UploadResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return upload;
    }

    public void uploadFileForGroup(final String name, final String userName, final String ownerName, final String groupName, final InputStream fileStream, final String fileType, final String description, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Upload upload = UploadService.this.uploadFileForGroup(name, userName, ownerName, groupName, fileStream, fileType, description);
                    callBack.onSuccess(upload);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Upload uploadFileForFriend(String name, String userName, String buddyName, InputStream fileStream, String fileType, String description) throws App42Exception {
        String response = null;
        Upload upload = null;
        Util.throwExceptionIfNullOrBlank(name, "File Name");
        Util.throwExceptionIfNullOrBlank(userName, "User Name");
        Util.throwExceptionIfNullOrBlank(fileStream, "FileStream");
        Util.throwExceptionIfNullOrBlank(fileType, "fileType");
        Util.throwExceptionIfNullOrBlank(description, "Description");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            Hashtable<String, String> postParams = new Hashtable<String, String>();
            postParams.put("name", name);
            postParams.put("userName", userName);
            postParams.put("buddyName", buddyName);
            postParams.put("type", fileType);
            postParams.put("description", description);
            signParams = net.oauth.jme.Util.hashtableMerge(signParams, postParams);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceUrl = Config.getInstance().getBaseURL() + this.version + "/" + this.resource + "/friend/" + userName;
            response = Util.multiPartRequest("uploadFile", fileStream, name, queryParams, postParams, headerParams, resourceUrl, Config.getInstance().getAccept());
            upload = new UploadResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return upload;
    }

    public void uploadFileForFriend(final String name, final String userName, final String buddyName, final InputStream fileStream, final String fileType, final String description, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Upload upload = UploadService.this.uploadFileForFriend(name, userName, buddyName, fileStream, fileType, description);
                    callBack.onSuccess(upload);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }

    public Upload uploadFileForFriends(String name, String userName, InputStream fileStream, String fileType, String description) throws App42Exception {
        String response = null;
        Upload upload = null;
        Util.throwExceptionIfNullOrBlank(name, "File Name");
        Util.throwExceptionIfNullOrBlank(userName, "User Name");
        Util.throwExceptionIfNullOrBlank(fileStream, "FileStream");
        Util.throwExceptionIfNullOrBlank(fileType, "fileType");
        Util.throwExceptionIfNullOrBlank(description, "Description");
        try {
            Hashtable queryParams = new Hashtable();
            Hashtable headerParams = new Hashtable();
            Hashtable signParams = this.populateSignParams();
            Hashtable metaHeaders = this.populateMetaHeaderParams();
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, metaHeaders);
            headerParams = net.oauth.jme.Util.hashtableMerge(headerParams, signParams);
            queryParams = net.oauth.jme.Util.hashtableMerge(queryParams, signParams);
            Hashtable<String, String> postParams = new Hashtable<String, String>();
            postParams.put("name", name);
            postParams.put("userName", userName);
            postParams.put("type", fileType);
            postParams.put("description", description);
            signParams = net.oauth.jme.Util.hashtableMerge(signParams, postParams);
            String signature = Util.sign(this.secretKey, signParams);
            headerParams.put("signature", signature);
            String resourceUrl = Config.getInstance().getBaseURL() + this.version + "/" + this.resource + "/friendsAll/" + userName;
            response = Util.multiPartRequest("uploadFile", fileStream, name, queryParams, postParams, headerParams, resourceUrl, Config.getInstance().getAccept());
            upload = new UploadResponseBuilder().buildResponse(response);
        }
        catch (App42Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new App42Exception(e);
        }
        return upload;
    }

    public void uploadFileForFriends(final String name, final String userName, final InputStream fileStream, final String fileType, final String description, final App42CallBack callBack) throws App42Exception {
        Util.throwExceptionIfNullOrBlank(callBack, "callBack");
        new Thread(){

            public void run() {
                try {
                    Upload upload = UploadService.this.uploadFileForFriends(name, userName, fileStream, fileType, description);
                    callBack.onSuccess(upload);
                }
                catch (App42Exception ex) {
                    App42Log.error(" Exception :" + ex);
                    callBack.onException(ex);
                }
            }
        }.start();
    }
}

