/*
 * Decompiled with CFR 0.152.
 */
package com.shephertz.app42.paas.sdk.jme.user;

import com.shephertz.app42.paas.sdk.jme.App42Log;
import com.shephertz.app42.paas.sdk.jme.App42ResponseBuilder;
import com.shephertz.app42.paas.sdk.jme.user.User;
import com.shephertz.app42.paas.sdk.jme.util.Util;
import java.util.Vector;
import org.json.jme.JSONArray;
import org.json.jme.JSONObject;

public class UserResponseBuilder
extends App42ResponseBuilder {
    public User buildResponse(String json) throws Exception {
        JSONObject usersJSONObj = this.getServiceJSONObject("users", json);
        JSONObject userJSOnObj = usersJSONObj.getJSONObject("user");
        User user = this.buildUserObject(userJSOnObj);
        user.setStrResponse(json);
        user.setResponseSuccess(this.isResponseSuccess(json));
        return user;
    }

    private User buildUserObject(JSONObject userJSONObj) throws Exception {
        User user = new User();
        this.buildObjectFromJSONTree(user, userJSONObj);
        if (userJSONObj.has("profile")) {
            JSONObject profileJSONObj = userJSONObj.getJSONObject("profile");
            User.Profile profile = user.new User.Profile();
            this.buildObjectFromJSONTree(profile, profileJSONObj);
        }
        if (userJSONObj.has("role")) {
            Vector<String> roleList = new Vector<String>();
            if (userJSONObj.get("role") instanceof JSONArray) {
                JSONArray roleArr = userJSONObj.getJSONArray("role");
                for (int i = 0; i < roleArr.length(); ++i) {
                    roleList.addElement(roleArr.get(i).toString());
                }
            } else {
                roleList.addElement(userJSONObj.getString("role"));
            }
            user.setRoleList(roleList);
        }
        return user;
    }

    public Vector buildArrayResponse(String json) throws Exception {
        JSONObject usersJSONObj = this.getServiceJSONObject("users", json);
        Vector<User> userList = new Vector<User>();
        if (usersJSONObj.get("user") instanceof JSONArray) {
            JSONArray userJSONArray = usersJSONObj.getJSONArray("user");
            for (int i = 0; i < userJSONArray.length(); ++i) {
                JSONObject userJSONObject = userJSONArray.getJSONObject(i);
                User user = this.buildUserObject(userJSONObject);
                user.setStrResponse(json);
                user.setResponseSuccess(this.isResponseSuccess(json));
                userList.addElement(user);
            }
        } else {
            JSONObject userJSONObject = usersJSONObj.getJSONObject("user");
            User user = this.buildUserObject(userJSONObject);
            user.setStrResponse(json);
            user.setResponseSuccess(this.isResponseSuccess(json));
            userList.addElement(user);
        }
        return userList;
    }

    public void buildObjectFromJSONTree(Object obj, JSONObject jsonObj) throws Exception {
        block20: {
            block19: {
                if (!(obj instanceof User.Profile)) break block19;
                User.Profile profile = (User.Profile)obj;
                String[] names = this.getNames(jsonObj);
                if (names == null) break block20;
                for (int i = 0; i < names.length; ++i) {
                    String dob;
                    String name = names[i];
                    if (name.equals("firstName")) {
                        profile.setFirstName("" + jsonObj.get(name));
                    }
                    if (name.equals("lastName")) {
                        profile.setLastName("" + jsonObj.get(name));
                    }
                    if (name.equals("sex")) {
                        profile.setSex("" + jsonObj.get(name));
                    }
                    if (name.equals("mobile")) {
                        profile.setMobile("" + jsonObj.get(name));
                    }
                    if (name.equals("line1")) {
                        profile.setLine1("" + jsonObj.get(name));
                    }
                    if (name.equals("line2")) {
                        profile.setLine2("" + jsonObj.get(name));
                    }
                    if (name.equals("city")) {
                        profile.setCity("" + jsonObj.get(name));
                    }
                    if (name.equals("state")) {
                        profile.setState("" + jsonObj.get(name));
                    }
                    if (name.equals("country")) {
                        profile.setCountry("" + jsonObj.get(name));
                    }
                    if (name.equals("pincode")) {
                        profile.setPincode("" + jsonObj.get(name));
                    }
                    if (name.equals("homeLandLine")) {
                        profile.setHomeLandLine("" + jsonObj.get(name));
                    }
                    if (name.equals("officeLandLine")) {
                        profile.setOfficeLandLine("" + jsonObj.get(name));
                    }
                    if (!name.equals("dateOfBirth") || jsonObj.get(name) == null || (dob = "" + jsonObj.get(name)).equals("null")) continue;
                    App42Log.debug(" DateOfBirth Not Null " + jsonObj.get(name));
                    profile.setDateOfBirth(Util.getDateFromUTCTimeStamp("" + jsonObj.get(name)));
                }
                break block20;
            }
            if (obj instanceof User) {
                User user = (User)obj;
                String[] names = this.getNames(jsonObj);
                if (names != null) {
                    for (int i = 0; i < names.length; ++i) {
                        String name = names[i];
                        if (name.equals("userName")) {
                            user.setUserName("" + jsonObj.get(name));
                        }
                        if (name.equals("password")) {
                            user.setPassword("" + jsonObj.get(name));
                        }
                        if (name.equals("email")) {
                            user.setEmail("" + jsonObj.get(name));
                        }
                        if (!name.equals("sessionId")) continue;
                        user.setSessionId("" + jsonObj.get(name));
                    }
                }
            }
        }
    }
}

