/*
 * Decompiled with CFR 0.152.
 */
package ingame;

import component.CUtility;
import component.gameData;
import game.CCanvas;
import ingame.CIngameManager;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class CStateBikeSelection {
    private Image[] imgArrBikeList;
    private int iSelIndex;
    private int iTotalHeight;
    private int iStartY;
    private int iTotalBikeOption = gameData.getData(5) + 1;
    private Image imgBtnNext;
    private int[][] iArrSelectionRegion;

    public CStateBikeSelection() {
        try {
            this.imgArrBikeList = new Image[this.iTotalBikeOption];
            this.imgArrBikeList[0] = Image.createImage((String)"/bike_normal.png");
            this.imgArrBikeList[1] = Image.createImage((String)"/bike_bullet.png");
            if (this.iTotalBikeOption > 2) {
                this.imgArrBikeList[2] = Image.createImage((String)"/bike_missile.png");
            }
            this.iArrSelectionRegion = new int[this.iTotalBikeOption][4];
            int w = 0;
            int h = 0;
            for (int i = 0; i < this.iTotalBikeOption; ++i) {
                if (w < this.imgArrBikeList[i].getWidth()) {
                    w = this.imgArrBikeList[i].getWidth();
                }
                if (h >= this.imgArrBikeList[i].getHeight()) continue;
                h = this.imgArrBikeList[i].getHeight();
            }
            w += w >> 1;
            h += h >> 3;
            this.iTotalHeight = h * this.iTotalBikeOption + (h >> 1) * (this.iTotalBikeOption - 1);
            int iTmpY = this.iStartY = (CCanvas.iScreenH >> 1) - (this.iTotalHeight >> 1);
            for (int i = 0; i < this.iTotalBikeOption; ++i) {
                this.iArrSelectionRegion[i][0] = (CCanvas.iScreenW >> 1) - (w >> 1);
                this.iArrSelectionRegion[i][1] = iTmpY;
                this.iArrSelectionRegion[i][2] = w;
                this.iArrSelectionRegion[i][3] = h;
                iTmpY += h + (h >> 1);
            }
            this.imgBtnNext = Image.createImage((String)"/next.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.iSelIndex = this.iTotalBikeOption - 1;
    }

    public void update() {
    }

    public void unload() {
        for (int i = 0; i < this.iTotalBikeOption; ++i) {
            this.imgArrBikeList[i] = null;
        }
        this.imgArrBikeList = null;
        this.iArrSelectionRegion = null;
        this.imgBtnNext = null;
    }

    public void paint(Graphics g) {
        CUtility.drawBorder(g, 5, this.iStartY - (this.iTotalHeight >> 3) - 4, CCanvas.iScreenW - 10, this.iTotalHeight + (this.iTotalHeight >> 2) + (this.iTotalHeight >> 3));
        for (int i = 0; i < this.iTotalBikeOption; ++i) {
            if (i == this.iSelIndex) {
                g.setColor(0xFFFFFF);
                g.fillRoundRect(this.iArrSelectionRegion[i][0] - 4, this.iArrSelectionRegion[i][1] - 4, this.iArrSelectionRegion[i][2] + 8, this.iArrSelectionRegion[i][3] + 8, 8, 8);
                g.setColor(0x555555);
                g.fillRoundRect(this.iArrSelectionRegion[i][0] - 2, this.iArrSelectionRegion[i][1] - 2, this.iArrSelectionRegion[i][2] + 4, this.iArrSelectionRegion[i][3] + 4, 8, 8);
            } else {
                g.setColor(0x333333);
                g.fillRoundRect(this.iArrSelectionRegion[i][0] - 2, this.iArrSelectionRegion[i][1] - 2, this.iArrSelectionRegion[i][2] + 4, this.iArrSelectionRegion[i][3] + 4, 6, 6);
                g.setColor(0x999999);
                g.drawRoundRect(this.iArrSelectionRegion[i][0] - 2, this.iArrSelectionRegion[i][1] - 2, this.iArrSelectionRegion[i][2] + 4, this.iArrSelectionRegion[i][3] + 4, 6, 6);
            }
            g.drawImage(this.imgArrBikeList[i], CCanvas.iScreenW >> 1, this.iArrSelectionRegion[i][1] + (this.iArrSelectionRegion[i][3] >> 1), 3);
        }
        CUtility.paintSoftKeys(g, this.imgBtnNext, null);
    }

    public void handleInput(int key, boolean isPressed) {
        if (!isPressed) {
            if (key == 202) {
                this.iSelIndex = (this.iSelIndex + (this.iTotalBikeOption - 1)) % this.iTotalBikeOption;
            } else if (key == 208) {
                ++this.iSelIndex;
                this.iSelIndex %= this.iTotalBikeOption;
            } else if (key == 205 || key == 211) {
                CIngameManager.getInstance().setCurrentBike(this.iSelIndex);
                CIngameManager.getInstance().switchToStates(0);
            }
        }
    }

    public void handleTouchInput(int pointerX, int pointerY, int iTouchState) {
        block5: {
            block4: {
                if (iTouchState != 2) break block4;
                if (CUtility.isLSKPressed(pointerX, pointerY)) {
                    CIngameManager.getInstance().setCurrentBike(this.iSelIndex);
                    CIngameManager.getInstance().switchToStates(0);
                } else {
                    for (int i = 0; i < this.iTotalBikeOption; ++i) {
                        if (!CUtility.isPointInRect(pointerX, pointerY, this.iArrSelectionRegion[i][0], this.iArrSelectionRegion[i][1], this.iArrSelectionRegion[i][2], this.iArrSelectionRegion[i][3])) continue;
                        CIngameManager.getInstance().setCurrentBike(this.iSelIndex);
                        CIngameManager.getInstance().switchToStates(0);
                        return;
                    }
                }
                break block5;
            }
            if (iTouchState != 0) break block5;
            for (int i = 0; i < this.iTotalBikeOption; ++i) {
                if (!CUtility.isPointInRect(pointerX, pointerY, this.iArrSelectionRegion[i][0], this.iArrSelectionRegion[i][1], this.iArrSelectionRegion[i][2], this.iArrSelectionRegion[i][3])) continue;
                this.iSelIndex = i;
                return;
            }
        }
    }
}

