/*
 * Decompiled with CFR 0.152.
 */
package component;

import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;

public class CSoundPlayer {
    private Player[] sPlayer;
    private int iTotalSound;

    public void loadSound(String[] soundList) {
        this.iTotalSound = soundList.length;
        this.sPlayer = new Player[this.iTotalSound];
        for (int i2 = 0; i2 < this.iTotalSound; ++i2) {
            InputStream is = this.getClass().getResourceAsStream(soundList[i2]);
            try {
                this.sPlayer[i2] = Manager.createPlayer((InputStream)is, (String)"audio/midi");
                this.sPlayer[i2].prefetch();
                this.sPlayer[i2].realize();
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    public void playSound(int iSoundIndex, boolean isLooping) {
        if (iSoundIndex < 0 || iSoundIndex >= this.iTotalSound) {
            return;
        }
        try {
            if (this.sPlayer[iSoundIndex].getState() == 400) {
                this.stopSound(iSoundIndex);
            }
            if (isLooping) {
                this.sPlayer[iSoundIndex].setLoopCount(-1);
            }
            this.sPlayer[iSoundIndex].start();
        }
        catch (MediaException mediaException) {
            // empty catch block
        }
    }

    public void stopSound(int iSoundIndex) {
        if (iSoundIndex < 0 || iSoundIndex >= this.iTotalSound) {
            return;
        }
        try {
            this.sPlayer[iSoundIndex].stop();
            if (this.sPlayer[iSoundIndex].getState() != 200) {
                this.sPlayer[iSoundIndex].prefetch();
                this.sPlayer[iSoundIndex].realize();
            }
        }
        catch (MediaException mediaException) {
            // empty catch block
        }
    }

    public void unloadSound() {
        for (int i2 = 0; i2 < this.iTotalSound; ++i2) {
            this.sPlayer[i2].deallocate();
            this.sPlayer[i2].close();
            this.sPlayer[i2] = null;
        }
        this.sPlayer = null;
    }
}

