/*
 * Decompiled with CFR 0.152.
 */
package component;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class gameData {
    private static int maxRecords = 18;
    private static RecordStore myRecordStore;

    private gameData() {
    }

    public static void initializeScores() {
        try {
            myRecordStore = RecordStore.openRecordStore((String)"yrf_d3_data", (boolean)true);
            if (myRecordStore.getNumRecords() > 0) {
                return;
            }
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            byte[] b2;
            try {
                dos.writeShort(0);
                dos.writeUTF("");
                b2 = baos.toByteArray();
                dos.close();
            }
            catch (IOException ioe) {
                throw new RecordStoreException();
            }
            for (int i2 = 0; i2 < maxRecords; ++i2) {
                myRecordStore.addRecord(b2, 0, b2.length);
            }
            gameData.saveData(16, 1);
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    static void closeHighScores() {
        if (myRecordStore != null) {
            try {
                myRecordStore.closeRecordStore();
            }
            catch (RecordStoreException recordStoreException) {
                // empty catch block
            }
            myRecordStore = null;
        }
    }

    public static void saveData(int iKey, int iValue) {
        try {
            byte[] data;
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DataOutputStream das = new DataOutputStream(baos);
                das.writeInt(iValue);
                data = baos.toByteArray();
                das.close();
            }
            catch (IOException ioe) {
                throw new RecordStoreException();
            }
            if (myRecordStore == null) {
                gameData.initializeScores();
            }
            myRecordStore.setRecord(iKey, data, 0, data.length);
        }
        catch (RecordStoreException rse) {
            // empty catch block
        }
    }

    public static void saveData(int iKey, String iValue) {
        try {
            byte[] data;
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DataOutputStream das = new DataOutputStream(baos);
                das.writeUTF(iValue);
                data = baos.toByteArray();
                das.close();
            }
            catch (IOException ioe) {
                throw new RecordStoreException();
            }
            if (myRecordStore == null) {
                gameData.initializeScores();
            }
            myRecordStore.setRecord(iKey, data, 0, data.length);
        }
        catch (RecordStoreException rse) {
            // empty catch block
        }
    }

    public static int getData(int iKey) {
        int iRecordValue = 0;
        try {
            byte[] data = myRecordStore.getRecord(iKey);
            if (data != null) {
                try {
                    ByteArrayInputStream bais = new ByteArrayInputStream(data);
                    DataInputStream dis = new DataInputStream(bais);
                    iRecordValue = dis.readInt();
                    dis.close();
                }
                catch (IOException ioe) {}
            }
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
        return iRecordValue;
    }

    public static String getString(int iKey) {
        String strPlayerName = "";
        try {
            byte[] data = myRecordStore.getRecord(iKey);
            if (data != null) {
                try {
                    ByteArrayInputStream bais = new ByteArrayInputStream(data);
                    DataInputStream dis = new DataInputStream(bais);
                    strPlayerName = dis.readUTF();
                    dis.close();
                }
                catch (IOException ioe) {}
            }
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
        return strPlayerName;
    }
}

