/*
 * Decompiled with CFR 0.152.
 */
package ingame;

import component.CSpriteAnimation;
import component.CUtility;
import component.gameData;
import game.CCanvas;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class CFirableAmmo {
    public static final int TYPE_NONE = 0;
    public static final int TYPE_BULLET = 1;
    public static final int TYPE_MISSILE = 2;
    private Image imgBullet;
    private CSpriteAnimation animMissile;
    private int iWidth;
    private int iHeigth;
    private Vector vBulletPos = new Vector();
    private int iBulletSpeed;
    private int iCurAmmoType;
    public int iDamage;
    public int iAmmoCount;

    public CFirableAmmo(int iType) {
        this.iCurAmmoType = iType;
        try {
            switch (this.iCurAmmoType) {
                case 0: {
                    this.imgBullet = null;
                    this.iBulletSpeed = 0;
                    this.iAmmoCount = 0;
                    this.iDamage = 0;
                    break;
                }
                case 1: {
                    this.imgBullet = Image.createImage((String)"/bullete.png");
                    this.iWidth = this.imgBullet.getWidth();
                    this.iHeigth = this.imgBullet.getHeight();
                    this.iBulletSpeed = 20;
                    this.iDamage = 25;
                    this.iAmmoCount = gameData.getData(8);
                    break;
                }
                case 2: {
                    this.animMissile = new CSpriteAnimation("/missile.png", 4, 2, false, false);
                    this.iWidth = this.animMissile.getCurFrameWidth();
                    this.iHeigth = this.animMissile.getCurFrameHeight() >> 2;
                    this.iBulletSpeed = 12;
                    this.iDamage = 100;
                    this.iAmmoCount = gameData.getData(9);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getType() {
        return this.iCurAmmoType;
    }

    public void fireBullet(int x2, int y2) {
        if (this.iAmmoCount <= 0 || this.iCurAmmoType == 0) {
            return;
        }
        if (this.iCurAmmoType == 1) {
            CPos tmp = new CPos(x2, y2);
            this.vBulletPos.addElement(tmp);
            tmp = null;
            --this.iAmmoCount;
        } else if (this.vBulletPos.isEmpty() || ((CPos)this.vBulletPos.lastElement()).iY < CCanvas.iScreenH >> 3) {
            CPos tmp = new CPos(x2, y2);
            this.vBulletPos.addElement(tmp);
            tmp = null;
            --this.iAmmoCount;
        }
    }

    public void update(int iPanSpd) {
        CPos tmp;
        int i2;
        int iNumBullet = this.vBulletPos.size();
        if (iNumBullet <= 0 || this.iCurAmmoType == 0) {
            return;
        }
        for (i2 = 0; i2 < iNumBullet; ++i2) {
            tmp = (CPos)this.vBulletPos.elementAt(i2);
            tmp.iY -= this.iBulletSpeed;
            if (iPanSpd == 0) {
                tmp.iY -= this.iBulletSpeed >> 1;
            }
            tmp = null;
            if (this.iCurAmmoType != 2) continue;
            this.animMissile.update();
        }
        for (i2 = 0; i2 < iNumBullet; ++i2) {
            tmp = (CPos)this.vBulletPos.elementAt(i2);
            if (this.iCurAmmoType == 2) {
                if (tmp.iY < -this.animMissile.getCurFrameHeight()) {
                    this.vBulletPos.removeElementAt(i2);
                    --iNumBullet;
                    --i2;
                }
            } else if (tmp.iY < -this.imgBullet.getHeight()) {
                this.vBulletPos.removeElementAt(i2);
                --iNumBullet;
                --i2;
            }
            tmp = null;
        }
    }

    public boolean checkBulletColl(int x2, int y2, int w2, int h2) {
        if (this.vBulletPos.isEmpty()) {
            return false;
        }
        CPos tmp = (CPos)this.vBulletPos.elementAt(0);
        if (CUtility.isCollideRect(x2, y2, w2, h2, tmp.iX - (this.iWidth >> 1), tmp.iY - this.iHeigth, this.iWidth, this.iHeigth)) {
            tmp = null;
            this.vBulletPos.removeElementAt(0);
            System.out.println("Bullet collided ....");
            return true;
        }
        tmp = null;
        return false;
    }

    public void paint(Graphics g2) {
        int iNumBullet = this.vBulletPos.size();
        if (iNumBullet <= 0 || this.iCurAmmoType == 0) {
            return;
        }
        for (int i2 = 0; i2 < iNumBullet; ++i2) {
            CPos tmp = (CPos)this.vBulletPos.elementAt(i2);
            if (this.iCurAmmoType == 2) {
                this.animMissile.paint(g2, tmp.iX, tmp.iY + (this.iHeigth >> 1), 3);
            } else {
                g2.drawImage(this.imgBullet, tmp.iX, tmp.iY, 33);
            }
            tmp = null;
        }
    }

    private class CPos {
        int iX;
        int iY;

        CPos(int x2, int y2) {
            this.iX = x2;
            this.iY = y2;
        }
    }
}

