/*
 * Decompiled with CFR 0.152.
 */
package game;

import javax.microedition.rms.RecordStore;

public abstract class BaseRMS {
    private String rmsName;
    private RecordStore recordStore;

    BaseRMS(String rmsName) {
        this.rmsName = rmsName;
    }

    public void open() throws Exception {
        try {
            this.recordStore = RecordStore.openRecordStore((String)this.rmsName, (boolean)true);
            if (this.recordStore.getNumRecords() > 0) {
                this.loadData();
            } else {
                this.createDefaultData();
            }
        }
        catch (Exception e) {
            throw new Exception(this.rmsName + "::open::" + e);
        }
    }

    public void close() throws Exception {
        if (this.recordStore != null) {
            try {
                this.recordStore.closeRecordStore();
            }
            catch (Exception e) {
                throw new Exception(this.rmsName + "::close::" + e);
            }
        }
    }

    public RecordStore getRecordStore() {
        return this.recordStore;
    }

    public String getRMSName() {
        return this.rmsName;
    }

    abstract void loadData() throws Exception;

    abstract void createDefaultData() throws Exception;

    abstract void updateData() throws Exception;

    abstract void saveGameData() throws Exception;

    abstract void loadStageData() throws Exception;
}

