/*
 * Decompiled with CFR 0.152.
 */
package WelderTools;

import WelderTools.MSpriteData;
import WelderTools.MSpriteLoader;
import com.kitmaker.finalkombat2.SP;
import javax.microedition.lcdui.Graphics;

public class WeeldSprite {
    private static boolean restartPoolK;
    private static long currentTime;
    protected static MSpriteData[] poolData;
    private int poolDataID;
    private int animation;
    private int frame;
    private int frameCount;
    private boolean firstLoopFinished = false;
    private int loopCount;
    public long delayCount;
    private int framePoolPointer;
    private int spriteX;
    private int spriteY;
    private byte spriteOrientation;
    private boolean isPlaying;
    private int[] rect = new int[4];
    private final byte POSITIONERRECTANGLE_FLAG = (byte)15;
    private boolean loopAnimation = true;

    public WeeldSprite(int poolID, String[] img, String anu, int spriteX, int spriteY, int poolMaxNumber) {
        if (restartPoolK) {
            poolData = null;
            restartPoolK = false;
        }
        if (poolData == null) {
            poolData = new MSpriteData[poolMaxNumber];
        } else if (poolID >= poolData.length) {
            System.out.println("id de pool mayor al permitido.. se expande el pool de datos.. evitarlo por favor");
            MSpriteData[] auxData = new MSpriteData[poolID + 1];
            System.arraycopy(poolData, 0, auxData, 0, poolData.length);
            poolData = auxData;
        }
        try {
            this.poolDataID = poolID;
            if (poolData[this.poolDataID] == null) {
                WeeldSprite.poolData[this.poolDataID] = MSpriteLoader.loadMSprite(img, anu);
            }
        }
        catch (Exception e) {
            System.out.println("error al tratar de crear data de sprites");
            e.printStackTrace();
        }
        this.spriteX = spriteX;
        this.spriteY = spriteY;
    }

    public void setAnimation(int id, boolean _loop) {
        this.animation = id;
        int pos = this.animation << 1;
        this.frameCount = WeeldSprite.poolData[this.poolDataID].animationTable[pos + 1] - WeeldSprite.poolData[this.poolDataID].animationTable[pos] + 1;
        this.setFrame(0);
        this.notifyStartOfAnimation();
        this.loopAnimation = _loop;
    }

    public int getAnimation() {
        return this.animation;
    }

    public int getFrameCount() {
        return this.frameCount;
    }

    public int getCurrentFrame() {
        return this.frame;
    }

    public int getNumberOfFramesOfCurrentAnim() {
        short startIndex = WeeldSprite.poolData[this.poolDataID].frameTableIndex[this.framePoolPointer << 1];
        short endIndex = WeeldSprite.poolData[this.poolDataID].frameTableIndex[(this.framePoolPointer << 1) + 1];
        return endIndex - startIndex;
    }

    public void setFrame(int frame) {
        this.frame = frame;
        this.delayCount = currentTime;
        int frameIndex = WeeldSprite.poolData[this.poolDataID].animationTable[this.animation << 1] + frame;
        this.framePoolPointer = WeeldSprite.poolData[this.poolDataID].frameTable[frameIndex << 2];
    }

    public int getAnimationCount() {
        return WeeldSprite.poolData[this.poolDataID].animationTable.length >>> 1;
    }

    public int getNumberOfCollisionRect() {
        int count = 0;
        int startIndex = WeeldSprite.poolData[this.poolDataID].frameTableIndex[this.framePoolPointer << 1];
        short endIndex = WeeldSprite.poolData[this.poolDataID].frameTableIndex[(this.framePoolPointer << 1) + 1];
        while (startIndex < endIndex) {
            startIndex += 3;
            if ((byte)WeeldSprite.poolData[this.poolDataID].framePoolTable[startIndex++] != 15) continue;
            ++count;
        }
        return count;
    }

    public int[] getCollisionRect(int index) {
        int count = -1;
        int startIndex = WeeldSprite.poolData[this.poolDataID].frameTableIndex[this.framePoolPointer << 1];
        short endIndex = WeeldSprite.poolData[this.poolDataID].frameTableIndex[(this.framePoolPointer << 1) + 1];
        while (startIndex < endIndex) {
            int clipIndex = WeeldSprite.poolData[this.poolDataID].framePoolTable[startIndex++];
            int x = WeeldSprite.poolData[this.poolDataID].framePoolTable[startIndex++];
            int y = WeeldSprite.poolData[this.poolDataID].framePoolTable[startIndex++];
            if ((byte)WeeldSprite.poolData[this.poolDataID].framePoolTable[startIndex++] != 15 || ++count != index) continue;
            this.rect[2] = WeeldSprite.poolData[this.poolDataID].positionerRectangleClipPool[clipIndex <<= 1];
            this.rect[3] = WeeldSprite.poolData[this.poolDataID].positionerRectangleClipPool[clipIndex + 1];
            byte spriteOrientation = this.getSpriteOrientation();
            if (spriteOrientation == 1) {
                x = -x - this.rect[2];
            } else if (spriteOrientation == 2) {
                y = -y - this.rect[3];
            }
            this.rect[0] = x;
            this.rect[1] = y;
            return this.rect;
        }
        return null;
    }

    public void update() {
        if (poolData[this.poolDataID] == null) {
            System.out.println("There is no data for the animation");
            return;
        }
        if (!this.isPlaying) {
            return;
        }
        int frameIndex = WeeldSprite.poolData[this.poolDataID].animationTable[this.animation << 1] + this.frame;
        int deltaAnim = 50;
        if (!SP.isFastDevice) {
            deltaAnim = 80;
        }
        if ((currentTime - this.delayCount) / (long)deltaAnim < (long)WeeldSprite.poolData[this.poolDataID].frameTable[(frameIndex << 2) + 1]) {
            return;
        }
        this.delayCount = currentTime;
        if (this.frame >= this.frameCount - 1) {
            this.firstLoopFinished = true;
            ++this.loopCount;
        }
        if (!this.loopAnimation) {
            if (!this.firstLoopFinished) {
                this.setFrame((this.frame + 1) % this.frameCount);
            }
        } else {
            this.setFrame((this.frame + 1) % this.frameCount);
        }
    }

    public void drawFrame(Graphics g) {
        if (poolData[this.poolDataID] == null) {
            System.out.println("There is no data for this sprite.");
            return;
        }
        int startIndex = WeeldSprite.poolData[this.poolDataID].frameTableIndex[this.framePoolPointer << 1];
        short endIndex = WeeldSprite.poolData[this.poolDataID].frameTableIndex[(this.framePoolPointer << 1) + 1];
        while (startIndex < endIndex) {
            short clipIndex = WeeldSprite.poolData[this.poolDataID].framePoolTable[startIndex++];
            short x = WeeldSprite.poolData[this.poolDataID].framePoolTable[startIndex++];
            short y = WeeldSprite.poolData[this.poolDataID].framePoolTable[startIndex++];
            byte flag = (byte)WeeldSprite.poolData[this.poolDataID].framePoolTable[startIndex++];
            this.drawClip(g, x, y, clipIndex, flag);
        }
    }

    protected void drawClip(Graphics g, int x, int y, int clipIndex, byte flag) {
        int iX = x;
        int iY = y;
        if ((flag & 1) == 0) {
            byte imageId = (byte)((flag & 0xF8) >> 3);
            byte orientation = (byte)(flag & 7);
            orientation = (byte)(orientation >> 1);
            this.drawImageClip(g, iX, iY, imageId, clipIndex, this.spriteOrientation);
        } else if (flag == 1) {
            int index = clipIndex * 5;
            int[] pool = WeeldSprite.poolData[this.poolDataID].ellipseClipPool;
            g.setColor(pool[index + 4]);
            g.drawArc(this.spriteX + x, this.spriteY + y, pool[index], pool[index + 1], pool[index + 2], pool[index + 3]);
        } else if (flag == 3) {
            int index = clipIndex * 5;
            int[] pool = WeeldSprite.poolData[this.poolDataID].ellipseClipPool;
            g.setColor(pool[index + 4]);
            if (this.spriteOrientation == 0) {
                g.fillArc(this.spriteX + x, this.spriteY + y, pool[index], pool[index + 1], pool[index + 2], pool[index + 3]);
            } else if (this.spriteOrientation == 1) {
                g.fillArc(this.spriteX - x - pool[index], this.spriteY + y, pool[index], pool[index + 1], pool[index + 2], pool[index + 3]);
            }
        } else if (flag == 5) {
            int index = clipIndex * 3;
            int[] pool = WeeldSprite.poolData[this.poolDataID].lineClipPool;
            g.setColor(pool[index + 2]);
            g.drawLine(this.spriteX + x, this.spriteY + y, this.spriteX + pool[index], this.spriteY + pool[index + 1]);
        } else if (flag == 7) {
            int index = clipIndex * 3;
            int[] pool = WeeldSprite.poolData[this.poolDataID].rectangleClipPool;
            g.setColor(pool[index + 2]);
            g.drawRect(this.spriteX + x, this.spriteY + y, pool[index], pool[index + 1]);
        } else if (flag == 9) {
            int index = clipIndex * 3;
            int[] pool = WeeldSprite.poolData[this.poolDataID].rectangleClipPool;
            g.setColor(pool[index + 2]);
            if (this.spriteOrientation == 0) {
                g.fillRect(this.spriteX + x, this.spriteY + y, pool[index], pool[index + 1]);
            } else if (this.spriteOrientation == 1) {
                g.fillRect(this.spriteX - x - pool[index], this.spriteY + y, pool[index], pool[index + 1]);
            }
        } else if (flag == 11) {
            int index = clipIndex * 5;
            int[] pool = WeeldSprite.poolData[this.poolDataID].roundedRectangleClipPool;
            g.setColor(pool[index + 4]);
            g.drawRoundRect(this.spriteX + x, this.spriteY + y, pool[index], pool[index + 1], pool[index + 2], pool[index + 3]);
        } else if (flag == 13) {
            int index = clipIndex * 5;
            int[] pool = WeeldSprite.poolData[this.poolDataID].roundedRectangleClipPool;
            g.setColor(pool[index + 4]);
            g.fillRoundRect(this.spriteX + x, this.spriteY + y, pool[index], pool[index + 1], pool[index + 2], pool[index + 3]);
        }
    }

    protected void drawImageClip(Graphics g, int x, int y, byte imageId, int clipIndex, byte orientation) {
        if (WeeldSprite.poolData[this.poolDataID].imageData[imageId] == null) {
            System.out.println("There is no image for this sprite");
            return;
        }
        int index = clipIndex * 4;
        short clipX = WeeldSprite.poolData[this.poolDataID].imageClipPool[index++];
        short clipY = WeeldSprite.poolData[this.poolDataID].imageClipPool[index++];
        short clipW = WeeldSprite.poolData[this.poolDataID].imageClipPool[index++];
        short clipH = WeeldSprite.poolData[this.poolDataID].imageClipPool[index++];
        int rot = 0;
        int xPos = x + this.spriteX;
        int yPos = y + this.spriteY;
        if (orientation == 1) {
            rot = 2;
            xPos = this.spriteX - clipW - x;
        } else if (orientation == 2) {
            rot = 1;
        }
        try {
            g.drawRegion(WeeldSprite.poolData[this.poolDataID].imageData[imageId], (int)clipX, (int)clipY, (int)clipW, (int)clipH, rot, xPos, yPos, 0);
        }
        catch (Exception w) {
            System.out.println("Fallo en el pintado del trozo de imagen Motion Welder. Fallo tipo " + w);
        }
    }

    public int getX() {
        return this.spriteX;
    }

    public int getY() {
        return this.spriteY;
    }

    public void setDrawPosition(int x, int y) {
        this.spriteX = x;
        this.spriteY = y;
    }

    public void setDrawX(int dX) {
        this.spriteX = dX;
    }

    public void setDrawY(int dY) {
        this.spriteY = dY;
    }

    public void updateSpritePositionBy(int xinc, int yinc) {
        this.spriteX += xinc;
        this.spriteY += yinc;
    }

    public byte getSpriteOrientation() {
        return this.spriteOrientation;
    }

    public boolean isPlaying() {
        return this.isPlaying;
    }

    public void setSpriteOrientation(byte orientation) {
        this.spriteOrientation = orientation;
    }

    public void notifyStartOfAnimation() {
        this.firstLoopFinished = false;
        this.loopCount = 0;
        this.isPlaying = true;
    }

    public void notifyEndOfAnimation() {
        this.firstLoopFinished = true;
        this.isPlaying = false;
    }

    public boolean loopFinished() {
        return this.firstLoopFinished;
    }

    public void loadPoolImage() {
        poolData[this.poolDataID].loadPoolImage();
    }

    public void unloadPoolImage() {
        poolData[this.poolDataID].unloadPoolImage();
        restartPoolK = true;
    }

    public void unloadSpriteData() {
        WeeldSprite.poolData[this.poolDataID] = null;
    }

    public static void setCurrentTime(long time) {
        currentTime = time;
    }

    public int getLoopCount() {
        return this.loopCount;
    }
}

