/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VolumeControl;

public class DeviceSound
implements PlayerListener {
    private static byte[][] midi_sounds;
    private static Player midi_current;
    private static int[] MIDI_FILES;
    private static boolean[] MIDI_LOOPS;
    private static int[] SOUND_MAPPING;
    private static DeviceSound instance;

    DeviceSound() {
        instance = this;
    }

    public static void init() {
        try {
            midi_sounds = new byte[MIDI_FILES.length][];
            for (int i = 0; i < midi_sounds.length; ++i) {
                DeviceSound.midi_sounds[i] = (byte[])(MIDI_FILES[i] == -1 || MIDI_FILES[i] == -1 || MIDI_FILES[i] == -1 ? null : ResourceMaster.getResource(MIDI_FILES[i]));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void playerUpdate(Player player, String string, Object object) {
        if (string != "endOfMedia") return;
        try {
            if (Engine.lastSound == -1) return;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void play(int n) {
        int n2 = SOUND_MAPPING[n];
        if (n2 == -1) {
            return;
        }
        int n3 = Engine.lastSound = MIDI_LOOPS[n2] ? n2 : -1;
        if (!Engine.soundOn || Engine.hideNotify) {
            return;
        }
        try {
            DeviceSound.stop();
            midi_current = Manager.createPlayer((InputStream)new ByteArrayInputStream(midi_sounds[n2]), (String)"audio/midi");
            midi_current.realize();
            midi_current.prefetch();
            midi_current.setLoopCount(MIDI_LOOPS[n2] ? -1 : 1);
            VolumeControl volumeControl = (VolumeControl)midi_current.getControl("VolumeControl");
            if (volumeControl != null) {
                volumeControl.setLevel(50);
            }
            midi_current.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void stop() {
        try {
            if (midi_current != null) {
                midi_current.stop();
                midi_current.close();
                midi_current = null;
                System.gc();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean resume() {
        int n = Engine.lastSound;
        if (Engine.soundOn && n != -1 && !DeviceSound.isSoundPlaying()) {
            DeviceSound.play(n);
            return DeviceSound.isSoundPlaying();
        }
        return true;
    }

    public static boolean isSoundPlaying() {
        return midi_current != null && midi_current.getState() == 400;
    }

    static {
        MIDI_FILES = new int[]{90, 83, 84, 89, 87, 85, 86, 88, 91, -1, -1, -1};
        MIDI_LOOPS = new boolean[]{true, true, true, false, false, false, false, false, false, false, false, false};
        SOUND_MAPPING = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
    }
}

