/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;

public class Engine
extends Device
implements Runnable,
CommandListener {
    private boolean resumeSound;
    public static boolean handleEvent;
    public static boolean ignoreEvent;
    public static boolean ignoreKeys;
    public static boolean running;
    private static String exitUrl;
    public static boolean hideNotify;
    public static boolean ignoreHideNotify;
    private long lastTick;
    public static final int EVENT_NONE = 0;
    public static final int EVENT_FORCE_SOUND = 1;
    public static final int EVENT_SHOW_PAUSE_SCREEN = 2;
    public static int lastSound;
    public static boolean vibrateOn;
    public static boolean soundOn;
    public static Display display;
    public static Main parent;
    public static Engine instance;
    public static Random random;
    public static int tick;
    private int logicCounter;
    public static DeviceImage[] imgTips;
    public static DeviceImage[] phoneFriendArrows;
    public static DeviceImage[] imgFriends;
    public static Command commandSoft1;
    public static Command commandSoft2;
    public static final int GS_UNUSED = -1;
    public static final int GS_INIT_APP = 0;
    public static final int GS_SPLASH = 2;
    public static final int GS_LOADING = 3;
    public static final int GS_PAUSE = 4;
    public static final int GS_BRAND = 5;
    public static final int GS_MENU = 10;
    public static final int GS_COMMUNICATING = 11;
    public static final int GS_INPUT = 20;
    public static final int GS_DEMO = 30;
    public static final int GS_CLOSE_GAMEWORLD = 40;
    public static final int GS_SHOW_3D_CUTSCENE = 41;
    public static final int GS_INGAME = 100;
    public static final int GS_CAMERA = 200;
    public static int state;
    public static int pauseState;
    private static boolean isPainting;
    DeviceImage sliderImg;
    public static boolean diplaySizeWarn;
    private long lastBackLight = 0L;
    public static boolean frenchLocale;
    public static String lang;
    public static boolean DOUBLE_BUFFERING;
    Image dbuff = null;
    private int debugTick;
    private int debugPaint;
    private long debugStartFPSTime;
    private int debugFramesRendered;
    private int debugAvgFPS;
    private static final int FPS_RECALC = 6;
    private static boolean CLIENT;
    public static final int PRECISION = 8;
    public static final int ONE = 256;
    private static boolean debugStepByStep_stopped;
    private static boolean debugStepByStep_stopOnNextFrame;
    public static GameStage curGameStage;
    public static int skipFrameCounter;
    public DeviceImage buffer;
    private int[] srcBuffer;
    private int[] dstBuffer;
    public Graphics bufferGraphics;
    public static int brandIndex;
    private static DeviceImage imgBrand;
    private static DeviceImage imgBrand_TF1_1;
    private static DeviceImage imgBrand_TF1_2;
    private static final int BRAND_DELAY = 2000;
    boolean celedorLogoDisplayed = true;
    public static final int DEMO_MENU_EXTRA_OPTION = 0;
    public static final int DEMO_MENU_EXTRA_MENU = 1;
    private static int demoTimer;
    DeviceImage imgLogo;
    DeviceImage imgSplashGluStrip;
    Lozenge titleLozenge;
    private String[] languageFiles;
    static MainStage newStage;
    public static boolean reverseTooltips;
    public static final int TOOLTIP_BACK = 1;
    public static final int TOOLTIP_OK = 2;
    public static final int TOOLTIP_MENU = 4;
    public static final int TOOLTIP_PRESS = 8;
    public static final int TOOLTIP_DEL = 16;
    public static final int TOOLTIP_BOTH = 3;
    public static final int IMG_OK = 0;
    public static final int IMG_BACK = 1;
    public static final int IMG_ARROW_DOWN = 2;
    public static final int IMG_ARROW_UP = 3;
    public static final int IMG_PRESS = 6;
    public static final int IMG_DELETE = 7;
    public static final int IMG_TRASH = 8;
    public static Menu menuCurrent;
    public static Menu menuMain;
    public static Menu menuSettings;
    public static Menu menuExit;
    public static Menu menuSound;
    public static Menu menuScores;
    public static Menu menuInGame;
    public static Menu menuUpsell;
    private static final int NUMBER_OF_SCORES = 3;
    public static int[] hiScores;
    public static String[] hiNames;
    private static String defaultName;
    private static String uploadName;
    private static int uploadScore;
    public static boolean uploadEnabled;
    public static boolean scoreUploaded;
    private static String UID;
    private static int runCount;
    public static final String RMS_NAME = "MILLIONAIRE4";
    public static final int RMS_SETTINGS = 0;
    public static final int RMS_SAVEGAME = 1;
    public static boolean[] questionPackDownloaded;
    private static Random rand;
    public static String[] text;
    private boolean displayDebugInfo;
    public static String trace;
    private static int debugMsgTop;
    private static String[] debugMsgs;
    private static boolean displayDebugWrite;
    static String strDebug;
    private static int keysPressed;
    public static int keyLatch;
    public static int keyUnmapped;
    private long keyTime = 0L;
    public static int qwertyInput;
    public static boolean requestedURL;
    static Vector vOnlineProfiles;
    static Vector vOnlineProfileDataIds;
    public static final int CLIENT_STATE_START = 0;
    public static final int CLIENT_STATE_SEND_GET_DATA = 1;
    public static final int CLIENT_STATE_GET_BILLING_ANSWERS = 2;
    public static final int CLIENT_STATE_RECEIVED_QPACK = 3;
    public static final int CLIENT_STATE_START_PROFILE_UPLOAD = 4;
    public static final int CLIENT_STATE_START_PROFILES_DOWNLOAD = 5;
    public static final int CLIENT_STATE_GET_PROFILE_DATA = 6;
    public static final int CLIENT_STATE_START_PPP = 7;
    public static final int CLIENT_STATE_START_DOWNLOAD_LEADERBOARD = 8;
    static final String[] STR_CLIENT_STATES;
    public static Vector downloadPackNames;
    public static int clientState;
    public static int clientPrevState;
    public static String clientSerial;
    public static String clientQATitle;
    public static String clientQABody;
    public static boolean startAlreadyCalled;
    public static boolean gluBillingOn;
    public static int clientCurrAnswer;
    public static String[] clientAnswerName;
    public static long[] clientAnswerId;
    public static int[] clientAnswerFileSize;
    public static String[] clientBillingAnswerName;
    public static long[] clientBillingAnswerId;
    public static int clientBillingCurrAnswer;
    public static byte downloadConfirmSequence;
    public static String billingQuestionTitle;
    public static String billingQuestionInfo;
    public static String currQuestionPackName;
    public static String strBillingQuestionTitle;
    public static String strBillingQuestionBody;
    static MenuStage questionPackMenu;
    static MenuStage billingQuestionMenu;
    static MenuStage comFailureForm;
    static MenuStage qPackDownloadInfoForm;
    static MenuStage allQpacksDownloadedForm;
    static MenuStage newGameQuestionPackMenu;
    static MenuStage downloadedProfileListMenu;
    public static String currQuestionPackBeingPlayed;
    public static long billingPPPTime;
    public static int billingPPPLevels;
    static final byte PPP_DEMO = 0;
    static final byte PPP_LEVEL = 1;
    static final byte PPP_TIME_BASED = 2;
    static final byte PPP_BUY_FULL = 3;
    public static byte pppGameType;
    static final int NUM_FILE_IN_QPACK = 16;
    static final int QUESTIONS_FF = 0;
    static final int QUESTIONS_Q0 = 1;
    static final int QUESTIONS_Q1 = 2;
    static final int QUESTIONS_Q2 = 3;
    static final int QUESTIONS_Q3 = 4;
    static final int QUESTIONS_Q4 = 5;
    static final int QUESTIONS_Q5 = 6;
    static final int QUESTIONS_Q6 = 7;
    static final int QUESTIONS_Q7 = 8;
    static final int QUESTIONS_Q8 = 9;
    static final int QUESTIONS_Q9 = 10;
    static final int QUESTIONS_Q10 = 11;
    static final int QUESTIONS_Q11 = 12;
    static final int QUESTIONS_Q12 = 13;
    static final int QUESTIONS_Q13 = 14;
    static final int QUESTIONS_Q14 = 15;
    public static byte[] downloadedQPackBytes;
    static String qPackDownloadInfoFormTitle;
    static final boolean SHOW_DOWNLOAD_SYSTEM_ERROR = true;

    public Engine(Main main) {
        super(main);
        parent = main;
        instance = this;
        ignoreKeys = false;
        exitUrl = null;
        display = Display.getDisplay((MIDlet)main);
        display.setCurrent((Displayable)this);
        Thread thread = new Thread(this);
        thread.start();
    }

    public void run() {
        running = true;
        state = 0;
        while (running) {
            long l = System.currentTimeMillis();
            try {
                long l2;
                if (handleEvent) {
                    this.handleEvent();
                }
                if (!hideNotify) {
                    this.tick();
                    Engine.doRepaint();
                }
                if ((l2 = System.currentTimeMillis() - l) >= 50L) continue;
                Thread.sleep(50L - l2);
            }
            catch (Exception exception) {}
        }
        Device.soundFunction(1);
        parent.destroyApp(true);
        parent.notifyDestroyed();
    }

    private void tick() {
        try {
            if (this.resumeSound) {
                this.resumeSound = Device.soundFunction(2) == 0;
            }
            switch (state) {
                case 41: {
                    break;
                }
                case 100: {
                    if (curGameStage == null) break;
                    curGameStage.tick();
                    if (InputString.state == -1 || (defaultName = InputString.tickInputString()) == null) break;
                    if (PlayerProfile.checkForDuplicateNames(defaultName)) {
                        newStage.showDuplicateNameInfo();
                        return;
                    }
                    switch (InputString.state) {
                        case 0: {
                            PlayerProfile.profileName[PlayerProfile.currProfile] = defaultName;
                            PlayerProfile.saveProfilesToRMS();
                            Engine.setCurrentGameStage(MainStage.rootMenu);
                        }
                    }
                    InputString.reset();
                    break;
                }
                case 5: {
                    this.tickBrand(false);
                    break;
                }
                case 10: {
                    break;
                }
                case 0: {
                    this.initApp();
                    break;
                }
                case 2: {
                    this.tickSplash();
                    break;
                }
                case 30: {
                    break;
                }
                case 20: {
                    break;
                }
                case 4: {
                    if (!Engine.hasAnyKeyPressed()) break;
                    state = pauseState;
                    if (lastSound != -1) {
                        Device.soundFunction(3, lastSound);
                    }
                    Engine.resetKeyBuffers();
                    if (newStage == null) break;
                    newStage.resetKeyPressTiming();
                    Engine.newStage.repaintAll = true;
                    break;
                }
                case 11: {
                    break;
                }
                case 40: {
                    int n = 3;
                    state = 10;
                }
            }
            ++tick;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void paint(Graphics graphics) {
        Graphics graphics2;
        if (DOUBLE_BUFFERING) {
            if (this.dbuff == null) {
                this.dbuff = Image.createImage((int)208, (int)208);
            }
            graphics2 = this.dbuff.getGraphics();
        } else {
            graphics2 = graphics;
        }
        if (skipFrameCounter > 0) {
            return;
        }
        try {
            switch (state) {
                case 41: {
                    break;
                }
                case 100: {
                    if (curGameStage == null) break;
                    curGameStage.paintScreen(graphics2);
                    if (InputString.state == -1) break;
                    Engine.newStage.enterNameBgMenu.repaintAll = true;
                    InputString.paintInputString(graphics2, 2, 113);
                    break;
                }
                case 5: {
                    this.paintBrand(graphics2);
                    break;
                }
                case 10: {
                    break;
                }
                case 2: {
                    this.paintSplash(graphics2);
                    break;
                }
                case 30: {
                    break;
                }
                case 20: {
                    break;
                }
                case 3: 
                case 40: 
                case 200: {
                    Engine.cls(graphics2, 0);
                    FontMgr.realise(4);
                    FontMgr.drawString(4, graphics2, text == null ? "..." : text[41], 104, 208 - FontMgr.charHeight[0] >> 1, 17);
                    break;
                }
                case 11: {
                    Engine.cls(graphics2, 0);
                    FontMgr.drawString(4, graphics2, text[124], 104, 208 - FontMgr.charHeight[0] >> 1, 17);
                    break;
                }
                case 4: {
                    Engine.cls(graphics2, 0);
                    if (!Device.USE_BITMAP_FONTS) {
                        graphics2.setColor(0xFFFFFF);
                        FontMgr.drawString(1, graphics2, text[43], 104, 208 - FontMgr.charHeight[0] >> 1, 17);
                        break;
                    }
                    FontMgr.drawString(4, graphics2, text[43], 104, 208 - FontMgr.charHeight[0] >> 1, 17);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.paint(graphics2);
        if (DOUBLE_BUFFERING) {
            graphics.drawImage(this.dbuff, 0, 0, 20);
        }
        isPainting = false;
    }

    private void initApp() {
        this.setBackLight(true);
        Engine.paintLoading();
        Engine.debugLoad("imgTips");
        imgTips = new DeviceImage(ResourceMaster.getResource(75)).divide(9);
        for (int i = 0; i < 16; ++i) {
            FontMgr.realise(i);
        }
        String string = Engine.getJadValue("ms-skPos");
        if (string != null) {
            reverseTooltips = string.equals("1");
        }
        Engine.debugLoad("RMS");
        Engine.loadRMS(0);
        ++runCount;
        try {
            Engine.debugLoad("MainStage");
            newStage = new MainStage(Main.instance.engine);
            Engine.debugLoad("Backgrounds");
            newStage.initBgImage();
            Engine.debugLoad("Menu Res");
            newStage.initMenuRes();
            state = 100;
            ignoreEvent = false;
        }
        catch (Exception exception) {
            // empty catch block
        }
        Engine.debugLoad("initApp2 ");
        Engine.paintLoading();
        this.setLanguageSelect();
        Engine.debugLoad("initApp3 ");
        Engine.debugLoad("end init APP");
        this.lastTick = System.currentTimeMillis();
    }

    private void initGameWorld() {
        Engine.paintLoading();
        System.gc();
        state = 100;
    }

    public void setBrand() {
        brandIndex = 0;
        Engine.resetKeyBuffers();
        state = 5;
        this.tickBrand(true);
    }

    public void closeBrand() {
        imgBrand = null;
        if (frenchLocale && brandIndex > 0) {
            imgBrand_TF1_1 = null;
            imgBrand_TF1_2 = null;
        }
    }

    public void tickBrand(boolean bl) {
        boolean bl2 = false;
        if (!bl && Engine.key(64)) {
            bl2 = true;
        } else if ((int)System.currentTimeMillis() - this.logicCounter > 2000 || bl) {
            try {
                if (imgBrand != null) {
                    this.celedorLogoDisplayed = false;
                }
                imgBrand = null;
                byte[] byArray = ResourceMaster.getResourceFromJar("brand" + brandIndex + ".png");
                if (byArray != null) {
                    imgBrand = new DeviceImage(byArray);
                }
                if (frenchLocale && brandIndex == 0) {
                    byArray = ResourceMaster.getResourceFromJar("tfl.png");
                    if (byArray != null) {
                        imgBrand_TF1_1 = new DeviceImage(byArray);
                    }
                    if ((byArray = ResourceMaster.getResourceFromJar("presents.png")) != null) {
                        imgBrand_TF1_2 = new DeviceImage(byArray);
                    }
                }
                if (imgBrand == null) {
                    bl2 = true;
                }
                ++brandIndex;
                this.logicCounter = (int)System.currentTimeMillis();
            }
            catch (Exception exception) {
                bl2 = true;
            }
        }
        if (bl2) {
            this.closeBrand();
            System.gc();
            this.setSplash();
        }
    }

    private void paintBrand(Graphics graphics) {
        if (this.celedorLogoDisplayed) {
            Engine.cls(graphics, 0xFFFFFF);
        } else {
            Engine.cls(graphics, 0);
        }
        if (frenchLocale && brandIndex == 1) {
            if (imgBrand != null && imgBrand_TF1_1 != null && imgBrand_TF1_2 != null) {
                int n = 208 - Engine.imgBrand.height - Engine.imgBrand_TF1_1.height - (Engine.imgBrand_TF1_2.height >> 1) >> 1;
                imgBrand_TF1_1.drawImage(graphics, 208 - Engine.imgBrand_TF1_1.width >> 1, n);
                imgBrand.drawImage(graphics, 208 - Engine.imgBrand.width >> 1, n += Engine.imgBrand_TF1_1.height);
                imgBrand_TF1_2.drawImage(graphics, 208 - Engine.imgBrand_TF1_2.width >> 1, n += Engine.imgBrand.height + (Engine.imgBrand_TF1_2.height >> 1));
            }
        } else if (imgBrand != null) {
            imgBrand.drawImage(graphics, 208 - Engine.imgBrand.width >> 1, 208 - Engine.imgBrand.height >> 1);
        }
        Engine.paintTooltips(graphics, 8);
    }

    public static void cls(Graphics graphics, int n) {
        graphics.setColor(n);
        graphics.fillRect(0, 0, 208, 208);
    }

    public static void initDemoTimer(int n) {
        demoTimer = n * 1000;
    }

    public static void pauseDemoTimer() {
        if (demoTimer > 0) {
            demoTimer = -demoTimer;
        }
    }

    public static void resumeDemoTimer() {
        if (demoTimer < 0) {
            demoTimer = -demoTimer;
        }
    }

    public static boolean tickDemoTimer() {
        if (demoTimer > 0 && (demoTimer -= 50) < 0) {
            demoTimer = 0;
        }
        return demoTimer == 0;
    }

    private void setSoundEnable() {
        state = 100;
        newStage.setEnableSound();
    }

    private void setSplash() {
        byte[] byArray;
        ignoreEvent = false;
        state = 3;
        Engine.paintLoading();
        Device.soundFunction(3, 0);
        Engine.resetKeyBuffers();
        byte[] byArray2 = frenchLocale ? ResourceMaster.getResourceFromJar("splash_glu_strip_fr.png") : ResourceMaster.getResourceFromJar("splash_glu_strip.png");
        if (byArray2 != null) {
            this.imgSplashGluStrip = new DeviceImage(byArray2);
        }
        if ((byArray = ResourceMaster.getResourceFromJar("logo_" + text[102] + ".png")) == null) {
            byArray = ResourceMaster.getResourceFromJar("logo.png");
        }
        this.imgLogo = new DeviceImage(byArray);
        this.titleLozenge = new Lozenge(null, text[164], 0, 124, 0, 0, 0, newStage);
        if (lang != null) {
            // empty if block
        }
        this.titleLozenge.setState((byte)2);
        this.titleLozenge.setState((byte)1);
        state = 2;
        Engine.resetKeyBuffers();
    }

    private void tickSplash() {
        if (Engine.hasAnyKeyPressed()) {
            this.closeSplash();
            if (Engine.newStage.bgImage == null) {
                try {
                    newStage.initBgImage();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Engine.resetKeyBuffers();
            Engine.showSelectProfileMenu(-1, MainStage.rootMenu, text[168]);
            state = 100;
            this.initGameWorld();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void paintSplash(Graphics var1_1) {
        block9: {
            block7: {
                block8: {
                    if (Engine.newStage.bgImage == null) break block7;
                    if (MainStage.bgStyle == 2) break block8;
                    if (MainStage.bgStyle != 1) ** GOTO lbl-1000
                }
                if (!Engine.text[102].equals("en")) {
                    Engine.cls(var1_1, 2629720);
                } else lbl-1000:
                // 2 sources

                {
                    Engine.newStage.bgImage.drawImage(var1_1, 0, 0);
                }
                if (this.imgSplashGluStrip != null) {
                    this.imgSplashGluStrip.drawImage(var1_1, 0, 208 - this.imgSplashGluStrip.height);
                }
                this.imgLogo.drawImage(var1_1, 208 - this.imgLogo.width >> 1, 2);
                this.titleLozenge.paint(var1_1);
                break block9;
            }
            if (MainStage.bgStyle == 1 && !Engine.text[102].equals("en")) {
                Engine.cls(var1_1, 2629720);
            } else {
                Engine.cls(var1_1, 4335997);
            }
            if (this.imgSplashGluStrip != null) {
                this.imgSplashGluStrip.drawImage(var1_1, 0, 208 - this.imgSplashGluStrip.height);
            }
            this.imgLogo.drawImage(var1_1, 208 - this.imgLogo.width >> 1, 2);
            this.titleLozenge.paint(var1_1);
        }
        var2_2 = FontMgr.getCharHeight(0);
        if (this.titleLozenge.state == 1 && (Engine.tick & 4) != 0) {
            FontMgr.drawStringGlow(var1_1, Engine.text[43], 104, 208 - (var2_2 << 1) - 8, 17);
        }
    }

    public void closeSplash() {
        this.imgLogo = null;
        this.titleLozenge = null;
        newStage.freeGlowLozenges();
        this.imgSplashGluStrip = null;
        System.gc();
        state = 3;
        Engine.paintLoading();
        phoneFriendArrows = new DeviceImage(ResourceMaster.getResource(68)).divide(2);
        newStage.loadInGameSprites();
    }

    private void setLanguageSelect() {
        Engine.debugLoad("En.setLanguageSelect");
        lang = Engine.getJadValue("ms-multiLang");
        String string = "lang.dat";
        if (lang != null && !lang.equals("en")) {
            string = lang + ".dat";
            if (lang.equals("fr")) {
                frenchLocale = true;
            }
        }
        this.initLanguage(string);
        this.setLozengerColourWithLanguage();
        this.setSoundEnable();
    }

    private void closeLanguageSelect() {
        this.languageFiles = null;
        Engine.newStage.langSelMenu = null;
    }

    private void initLanguage(String string) {
        Engine.debugLoad("En.initLanguage");
        Engine.paintLoading();
        Engine.initText("/" + string);
        InputString.reset();
        PlayerProfile.resetAllProfiles();
        PlayerProfile.loadProfilesFromRMS();
        try {
            MainStage.NUM_MONEY_TREE_STEPS = Integer.parseInt(text[90]);
            MainStage.MONEY_TREE_VALUES = new int[MainStage.NUM_MONEY_TREE_STEPS + 1];
            MainStage.MONEY_TREE_ITEMS = new String[MainStage.NUM_MONEY_TREE_STEPS + 1];
            MainStage.MILESTONE_LEVELS[0] = Integer.parseInt(text[91]);
            MainStage.MILESTONE_LEVELS[1] = Integer.parseInt(text[92]);
            MainStage.MILESTONE_LEVELS[2] = Integer.parseInt(text[93]);
            Lozenge.baseLozengeSprite = null;
            newStage.initGame1();
            Engine cfr_ignored_0 = Main.instance.engine;
            Engine.setCurrentGameStage(newStage);
            int n = 0;
            while (true) {
                if (n < MainStage.MONEY_TREE_VALUES.length) {
                    MainStage.MONEY_TREE_VALUES[n] = Integer.parseInt(text[70 + n]);
                    ++n;
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Device.deviceFunction(1, text[162]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void paintTooltips(Graphics graphics, int n) {
        int n2 = 1;
        int n3 = 208 - Engine.imgTips[0].width - 1;
        int n4 = 208 - Engine.imgTips[0].height + 1;
        if ((n & 1) != 0 || (n & 0x10) != 0) {
            if (newStage != null) {
                if (reverseTooltips) {
                    Engine.newStage.labelPanelSprite.paint(graphics, 0, 0, 208 - Engine.newStage.labelPanelSprite.getHeight());
                } else {
                    Engine.newStage.labelPanelSprite.paint(graphics, 1, 208 - Engine.newStage.labelPanelSprite.getWidth(), 208 - Engine.newStage.labelPanelSprite.getHeight());
                }
            }
        } else if ((n & 8) != 0 || (n & 2) != 0) {
            if (reverseTooltips) {
                Engine.newStage.labelPanelSprite.paint(graphics, 1, 208 - Engine.newStage.labelPanelSprite.getWidth(), 208 - Engine.newStage.labelPanelSprite.getHeight());
            } else {
                Engine.newStage.labelPanelSprite.paint(graphics, 0, 0, 208 - Engine.newStage.labelPanelSprite.getHeight());
            }
        }
        if ((n & 1) != 0) {
            imgTips[1].drawImage(graphics, reverseTooltips ? n2 : n3, n4);
        } else if ((n & 4) != 0) {
            imgTips[2].drawImage(graphics, reverseTooltips ? n2 : n3, n4);
        }
        if ((n & 2) != 0) {
            imgTips[0].drawImage(graphics, reverseTooltips ? n3 : n2, n4);
        } else if ((n & 8) != 0) {
            imgTips[6].drawImage(graphics, reverseTooltips ? n3 : n2, n4);
        }
        if ((n & 0x10) != 0) {
            imgTips[7].drawImage(graphics, reverseTooltips ? n2 : n3, n4);
        }
    }

    public static void paintLoading() {
        int n = state;
        state = 3;
        Engine.doRepaint();
        state = n;
    }

    private void initMenus() {
    }

    private void initSettingsMenu() {
    }

    public void loadFriendImg() {
        Engine.debugLoad("friends");
        byte[] byArray = ResourceMaster.getResource(18);
        if (byArray != null) {
            imgFriends = new DeviceImage(byArray).divide(8);
        }
    }

    public void unloadFriendImg() {
        imgFriends = null;
    }

    public static void setMenu(Menu menu) {
    }

    public static void paintMenu(Graphics graphics) {
    }

    public void tickMenu() {
    }

    private static void updateMenuDrawPoints() {
    }

    private void doMenuAction(Menu menu, int n) {
    }

    public void doMultiLangSelAction(int n) {
        this.initLanguage(this.languageFiles[n]);
        this.setLozengerColourWithLanguage();
        this.closeLanguageSelect();
        this.setSoundEnable();
    }

    public static Menu createForm(String string, String string2, Menu menu, Menu menu2) {
        Menu menu3 = new Menu(string, Engine.getStrings(string2, 208, 1), 2);
        menu3.previous = menu;
        menu3.next = menu2;
        return menu3;
    }

    public void commandAction(Command command, Displayable displayable) {
    }

    private void initMGS() {
    }

    public static void loadRMS(int n) {
        String string = RMS_NAME;
        int n2 = n;
        string = string + n;
        n = 0;
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)string, (boolean)true);
            if (recordStore.getNumRecords() > n) {
                byte[] byArray = recordStore.getRecord(n + 1);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                if (n2 == 0) {
                    runCount = dataInputStream.readInt();
                    vibrateOn = dataInputStream.readBoolean();
                    defaultName = dataInputStream.readUTF();
                    int n3 = dataInputStream.readInt();
                    if (n3 > 0) {
                        downloadPackNames = new Vector();
                        for (int i = 0; i < n3; ++i) {
                            downloadPackNames.addElement(dataInputStream.readUTF());
                        }
                    }
                    pppGameType = dataInputStream.readByte();
                    billingPPPTime = dataInputStream.readLong();
                    billingPPPLevels = dataInputStream.readInt();
                    currQuestionPackBeingPlayed = dataInputStream.readUTF();
                } else if (n2 == 1) {
                    // empty if block
                }
                dataInputStream.close();
                byteArrayInputStream.close();
            }
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean saveRMS(int n) {
        String string = RMS_NAME;
        int n2 = n;
        string = string + n;
        n = 0;
        Engine.deleteRMS(string);
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)string, (boolean)true);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            if (n2 == 0) {
                dataOutputStream.writeInt(runCount);
                dataOutputStream.writeBoolean(vibrateOn);
                dataOutputStream.writeUTF(defaultName);
                dataOutputStream.writeInt(downloadPackNames.size());
                if (downloadPackNames.size() != 0) {
                    for (int i = 0; i < downloadPackNames.size(); ++i) {
                        dataOutputStream.writeUTF((String)downloadPackNames.elementAt(i));
                    }
                }
                dataOutputStream.writeByte(pppGameType);
                dataOutputStream.writeLong(billingPPPTime);
                dataOutputStream.writeInt(billingPPPLevels);
                dataOutputStream.writeUTF(currQuestionPackBeingPlayed);
            } else if (n2 == 1) {
                // empty if block
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            dataOutputStream.close();
            byteArrayOutputStream.close();
            if (recordStore.getNumRecords() <= n) {
                recordStore.addRecord(byArray, 0, byArray.length);
            } else {
                recordStore.setRecord(n + 1, byArray, 0, byArray.length);
            }
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private static void deleteRMS(String string) {
        try {
            RecordStore.deleteRecordStore((String)string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setRandSeed(long l) {
        rand.setSeed(l);
    }

    public static int nextRandInt(int n) {
        if (n == 0) {
            return 0;
        }
        return Math.abs(rand.nextInt() % n);
    }

    public static int nextRandInt() {
        return rand.nextInt();
    }

    public static void setColor(Graphics graphics, int n) {
        graphics.setColor(n);
    }

    public static void setARGBColor(Graphics graphics, int n) {
    }

    public static void deleteBytes(String string) {
        try {
            RecordStore.deleteRecordStore((String)string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void writeBytes(String string, byte[] byArray) throws Exception {
        try {
            RecordStore.deleteRecordStore((String)string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        RecordStore recordStore = RecordStore.openRecordStore((String)string, (boolean)true);
        if (recordStore.getNumRecords() == 0) {
            recordStore.addRecord(byArray, 0, byArray.length);
        } else {
            recordStore.setRecord(1, byArray, 0, byArray.length);
        }
        recordStore.closeRecordStore();
    }

    public static byte[] readBytes(String string) throws Exception {
        RecordStore recordStore = RecordStore.openRecordStore((String)string, (boolean)false);
        byte[] byArray = recordStore.getRecord(1);
        recordStore.closeRecordStore();
        return byArray;
    }

    public static byte[] readBytes(String string, int n) throws Exception {
        RecordStore recordStore = RecordStore.openRecordStore((String)string, (boolean)false);
        byte[] byArray = recordStore.getRecord(n + 1);
        recordStore.closeRecordStore();
        return byArray;
    }

    public static void writeBytes(String string, int n, byte[] byArray) throws Exception {
        RecordStore recordStore = RecordStore.openRecordStore((String)string, (boolean)true);
        int n2 = recordStore.getNumRecords();
        if (n2 <= n) {
            while (n2 < n - 1) {
                recordStore.addRecord(null, 0, 0);
                ++n2;
            }
            recordStore.addRecord(byArray, 0, byArray.length);
        } else {
            recordStore.setRecord(n + 1, byArray, 0, byArray.length);
        }
        recordStore.closeRecordStore();
    }

    public static void initText(String string) {
        try {
            InputStream inputStream = null;
            DataInputStream dataInputStream = null;
            inputStream = instance.getClass().getResourceAsStream(string);
            dataInputStream = new DataInputStream(inputStream);
            text = new String[dataInputStream.readInt()];
            for (int i = 0; i < text.length; ++i) {
                Engine.text[i] = dataInputStream.readUTF();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getText(int n) {
        if (n < text.length) {
            return text[n];
        }
        return "No text: " + n;
    }

    public static String getText(int n, String[] stringArray) {
        String string = new String(Engine.getText(n));
        if (stringArray.length == 1) {
            string = Engine.replaceText(string, "%U", stringArray[0]);
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                string = Engine.replaceText(string, "%U", stringArray[i]);
            }
        }
        return string;
    }

    public static String replaceText(String string, String string2, String string3) {
        String string4 = "";
        int n = 0;
        n = string.indexOf(string2);
        string4 = n != -1 ? string.substring(0, n) + string3 + string.substring(n + string2.length()) : string;
        return string4;
    }

    public static String[] getStrings(String string, int n, int n2) {
        int n3;
        Vector<String> vector = new Vector<String>();
        int n4 = 0;
        boolean bl = false;
        int n5 = string.length();
        String string2 = null;
        do {
            n3 = n4;
            int n6 = string.indexOf(10, n3);
            block1: do {
                int n7 = n3;
                String string3 = string2;
                n3 = Engine.getWordIndex(string, n3);
                if (n6 > -1 && n6 < n3) {
                    n3 = n6;
                }
                if (FontMgr.stringWidth(n2, string2 = string.substring(n4, n3).trim()) <= n) continue;
                if (n7 == n4) {
                    for (int i = string2.length() - 1; i > 0; --i) {
                        String string4 = string2.substring(0, i);
                        if (FontMgr.stringWidth(n2, string4) > n) continue;
                        n3 = n7 + i;
                        string2 = string4;
                        break block1;
                    }
                    break;
                }
                n3 = n7;
                string2 = string3;
                break;
            } while (n3 != n6 && n3 < n5);
            vector.addElement(string2);
        } while ((n4 = ++n3) < n5);
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private static int getWordIndex(String string, int n) {
        int n2;
        char c = string.charAt(n);
        if (Engine.charIsWord(c)) {
            return n + 1;
        }
        int n3 = 0;
        while ((n2 = string.indexOf(32, n)) == 0) {
            ++n;
        }
        n3 = n2;
        n3 = n3 == -1 ? string.length() : ++n3;
        for (n2 = n + 1; n2 < n3; ++n2) {
            if (!Engine.charIsWord(string.charAt(n2))) continue;
            return n2;
        }
        return n3;
    }

    private static boolean charIsWord(int n) {
        return n >= 11904 && n < 44032 || n >= 63744 && n < 64256 || n >= 65280 && n < 65504;
    }

    public static String getJadValue(String string) {
        String string2 = parent.getAppProperty(string);
        return string2 != null ? string2.trim() : null;
    }

    public static int rnd(int n) {
        return random.nextInt() % n;
    }

    public static int rndPositive(int n) {
        return Math.abs(random.nextInt() % n);
    }

    public static void paintDebug(Graphics graphics) {
    }

    public static void debugWrite(String string, boolean bl) {
    }

    public static void debugLoad(String string) {
    }

    public static void setOnScreenDebug(String string) {
        strDebug = string;
    }

    private void paintDebugPanel(Graphics graphics) {
    }

    public static String getFreeMemory() {
        System.gc();
        return (Runtime.getRuntime().freeMemory() >> 10) + " K";
    }

    public static String getTotalMemory() {
        return (Runtime.getRuntime().totalMemory() >> 10) + " K";
    }

    public static boolean isPressed(int n) {
        return (keysPressed & n) != 0;
    }

    public static boolean key(int n) {
        if ((keyLatch & n) != 0) {
            keyLatch = 0;
            return true;
        }
        return false;
    }

    public static boolean hasAnyKeyPressed() {
        if (keyLatch != 0) {
            keyLatch = 0;
            return true;
        }
        return false;
    }

    public static void resetKeyBuffers() {
        keyUnmapped = 0;
        keyLatch = 0;
    }

    public static void allResetKeyPressed() {
        keysPressed = 0;
    }

    public static void pushKeyMapping(int n) {
        keyLatch |= n;
        keysPressed |= n;
    }

    public synchronized void keyPressed(int n) {
        try {
            if (Device.IGNORE_SYSTEM_KEYS && (n == Device.SYSTEM_BACK_KEY || n == Device.SYSTEM_CLEAR_KEY)) {
                Engine.resetKeyBuffers();
                return;
            }
            int n2 = this.getKeyMap(n);
            if (ignoreKeys) {
                Engine.resetKeyBuffers();
                return;
            }
            keysPressed |= n2;
            keyLatch |= n2;
            keyUnmapped = n;
            if (state == 100 && newStage != null) {
                newStage.keyPressed(n, n2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void keyReleased(int n) {
        try {
            if (Device.IGNORE_SYSTEM_KEYS && (n == Device.SYSTEM_BACK_KEY || n == Device.SYSTEM_CLEAR_KEY)) {
                Engine.resetKeyBuffers();
                return;
            }
            if (ignoreKeys) {
                Engine.resetKeyBuffers();
                return;
            }
            int n2 = this.getKeyMap(n);
            keysPressed &= ~n2;
            qwertyInput = -1;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void doRepaint() {
        isPainting = true;
        instance.repaint();
        instance.serviceRepaints();
        while (isPainting) {
            Thread.yield();
        }
    }

    private void handleEvent() {
        handleEvent = false;
        if (state == 11) {
            return;
        }
        Engine.resetKeyBuffers();
        ignoreKeys = false;
        if (newStage != null) {
            newStage.resetKeyPressTiming();
        }
        if (state != 4) {
            Device.soundFunction(1);
            if (text != null) {
                pauseState = state;
                state = 4;
            }
        }
    }

    public static byte[] insertPLTE(byte[] byArray, byte[] byArray2) {
        int n;
        int n2 = 37;
        for (n = 0; n < byArray.length - 4; ++n) {
            if (byArray[n] != 80 || byArray[n + 1] != 76 || byArray[n + 2] != 84 || byArray[n + 3] != 69) continue;
            n2 = n;
            break;
        }
        n = n2 - 4;
        int n3 = ((byArray[n] & 0xFF) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF) & 0xFFFFFFFF;
        byte[] byArray3 = new byte[byArray.length - (n3 += 12) + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, n);
        System.arraycopy(byArray2, 0, byArray3, n, byArray2.length);
        System.arraycopy(byArray, n + n3, byArray3, n + byArray2.length, byArray.length - (n + n3));
        return byArray3;
    }

    public static int scaleX(int n) {
        return n * 208 / 100;
    }

    public static int scaleY(int n) {
        return n * 208 / 100;
    }

    public static int div(int n, int n2) {
        int n3 = n2 >> 8 == 0 ? n : (n << 8) / n2;
        return n3;
    }

    public static int intToFixed(int n) {
        return n << 8;
    }

    public static int fixedToInt(int n) {
        return n >> 8;
    }

    public static int divideFixed(int n, int n2) {
        return (n << 8) / n2;
    }

    public static int multiFixed(int n, int n2) {
        return n2 * n >> 8;
    }

    public void clearHideNotify() {
        hideNotify = false;
        handleEvent = false;
    }

    public static void exit() {
        if (requestedURL) {
            // empty if block
        }
        running = false;
        if (requestedURL) {
            requestedURL = false;
        }
    }

    public static void exitLaunch(String string) {
        if (requestedURL) {
            // empty if block
        }
        running = false;
        exitUrl = string;
        if (requestedURL) {
            requestedURL = false;
        }
    }

    public static void debug(String string) {
    }

    public static void setCurrentGameStage(GameStage gameStage) {
        if (curGameStage != gameStage) {
            if (curGameStage != null) {
                curGameStage.hideNotify(false);
            }
            if (gameStage == MainStage.rootMenu) {
                Engine.resetRootMenuPosition();
                System.gc();
            } else if (gameStage == Engine.newStage.helpMenu) {
                Engine.newStage.helpMenu.selectedIndex = 0;
            }
            gameStage.showNotify();
            curGameStage = gameStage;
            Engine.resetKeyBuffers();
        }
    }

    public static void resetRootMenuPosition() {
        MainStage.rootMenu.selectedIndex = 0;
        MainStage.curState = 0;
        MainStage.rootMenu.topIndex = 0;
        MainStage.rootMenu.setMenuAction((byte)0, true);
    }

    public static void drawOutlinedString(Graphics graphics, String string, int n, int n2, int n3) {
        if ((n3 & 0x20) == 0) {
            n2 -= 2;
        }
        graphics.setColor(0xFFFFFF);
        FontMgr.drawString(13, graphics, string, n, n2, n3);
    }

    public static void setCurrClientBillingAnswer(String string, long l) {
        Engine.clientBillingAnswerName[Engine.clientBillingCurrAnswer] = string;
        Engine.clientBillingAnswerId[Engine.clientBillingCurrAnswer] = l;
        ++clientBillingCurrAnswer;
    }

    public static boolean checkIfQPackWillFitInRMS(String string) {
        int n = 0;
        int n2 = 0;
        try {
            for (int i = 0; i < clientAnswerName.length; ++i) {
                if (!clientAnswerName[i].equals(string)) continue;
                n2 = clientAnswerFileSize[i];
                break;
            }
            RecordStore recordStore = RecordStore.openRecordStore((String)string, (boolean)true);
            n = recordStore.getSizeAvailable();
            RecordStore.deleteRecordStore((String)string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n > n2;
    }

    public static long getQPackId(String string) {
        for (int i = 0; i < clientAnswerName.length; ++i) {
            if (!string.equals(clientAnswerName[i])) continue;
            return clientAnswerId[i];
        }
        return 0L;
    }

    public static void saveDownloadedPackToRMS(byte[] byArray) {
        try {
            Engine.writeBytes(text[102] + currQuestionPackName, byArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static byte[] getQuestions(int n, byte[] byArray) {
        byte[] byArray2 = null;
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            for (int i = 0; i < 16; ++i) {
                int n2 = dataInputStream.readInt();
                if (n == i) {
                    byArray2 = new byte[n2];
                    dataInputStream.read(byArray2, 0, byArray2.length);
                    break;
                }
                dataInputStream.skip(n2);
                byArray2 = null;
            }
            byteArrayInputStream.close();
            byteArrayInputStream = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return byArray2;
    }

    public static byte[] loadDownloadPackFromRMS(String string) {
        try {
            return Engine.readBytes(text[102] + string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void deleteSaveQPack(String string) {
        try {
            downloadPackNames.removeElement(string);
            Engine.deleteBytes(text[102] + string);
            Engine.saveRMS(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setAllQPacksDownloadedForm() {
    }

    public static void setDownloadInfoForm(String string, String string2) {
        state = 100;
        qPackDownloadInfoFormTitle = string;
        qPackDownloadInfoForm = new MenuStage(Main.instance.engine);
        qPackDownloadInfoForm.initTextBox(string, string2, newStage);
        qPackDownloadInfoForm.setCallback(MainStage.rootMenu, (Displayable)Main.instance.engine);
        qPackDownloadInfoForm.setMenuAction((byte)0, true);
        qPackDownloadInfoForm.setMenuAction((byte)1, false);
        Engine.setCurrentGameStage(qPackDownloadInfoForm);
    }

    public static void setCommunicationFailureScreen(String string, String string2) {
        state = 100;
        comFailureForm = new MenuStage(Main.instance.engine);
        comFailureForm.initTextBox(text[165], text[219], newStage);
        comFailureForm.setCallback(MainStage.rootMenu, (Displayable)Main.instance.engine);
        comFailureForm.setMenuAction((byte)0, true);
        comFailureForm.setMenuAction((byte)1, false);
        Engine.setCurrentGameStage(comFailureForm);
    }

    public static void setBillingQuestionMenu(String string, String string2, MenuStage menuStage) {
        state = 100;
        billingQuestionTitle = string;
        billingQuestionInfo = string2;
        billingQuestionMenu = new MenuStage(Main.instance.engine);
        billingQuestionMenu.initTextBox(billingQuestionTitle, billingQuestionInfo, newStage, true);
        billingQuestionMenu.setCallback(questionPackMenu, (Displayable)Main.instance.engine);
        Engine.billingQuestionMenu.childMenu = new MenuStage(Main.instance.engine);
        Engine.billingQuestionMenu.childMenu.maxMenuHeight = Engine.scale(100);
        Engine.billingQuestionMenu.childMenu.initMenuList("  ", null, clientBillingAnswerName, true, 0, newStage);
        Engine.billingQuestionMenu.childMenu.curState = 0;
        Engine.billingQuestionMenu.childMenu.isChildMenu = true;
        Engine.billingQuestionMenu.childMenu.parentMenu = billingQuestionMenu;
        Engine.billingQuestionMenu.childMenu.setMenuAction((byte)0, true);
        Engine.billingQuestionMenu.childMenu.setMenuAction((byte)1, true);
        Engine.billingQuestionMenu.childMenu.setCallback(menuStage, (Displayable)Main.instance.engine);
        if (Engine.billingQuestionMenu.linesPerPage == Engine.billingQuestionMenu.numLines) {
            Engine.billingQuestionMenu.childHasInputFocus = true;
        }
        Engine.setCurrentGameStage(billingQuestionMenu);
        Engine.resetKeyBuffers();
    }

    public static void setQuestionPackMenu() {
    }

    public static void setNewGameQuestionPackMenu() {
    }

    public static void setCurrClientAnswer(String string, long l, int n) {
        Engine.clientAnswerName[Engine.clientCurrAnswer] = string;
        Engine.clientAnswerId[Engine.clientCurrAnswer] = l;
        Engine.clientAnswerFileSize[Engine.clientCurrAnswer] = n;
        ++clientCurrAnswer;
    }

    public static void drawClientDebug() {
    }

    public static boolean checkAllQPacksDownloaded() {
        String string = "";
        int n = 0;
        if (downloadPackNames.size() != 0) {
            block0: for (int i = 0; i < clientAnswerName.length; ++i) {
                for (int j = 0; j < downloadPackNames.size(); ++j) {
                    string = (String)downloadPackNames.elementAt(j);
                    if (!clientAnswerName[i].equals(string)) continue;
                    ++n;
                    continue block0;
                }
            }
        } else {
            Engine.debug("NO QPACKS SAVED!");
            return false;
        }
        if (n == clientAnswerName.length) {
            Engine.debug("numQpackInlist " + n);
            return true;
        }
        return false;
    }

    public static void showSelectProfileMenu(int n, MenuStage menuStage, String string) {
        Engine.newStage.profileMenuSelectedItem = n;
        Engine.newStage.profileSelectMenu = new MenuStage(Main.instance.engine);
        PlayerProfile.loadProfilesFromRMS();
        Engine.newStage.profileSelectMenu.initMenuList(string, null, PlayerProfile.profileName, true, 0, newStage);
        Engine.newStage.profileSelectMenu.setCallback(menuStage, (Displayable)Main.instance.engine);
        Engine.newStage.profileSelectMenu.setMenuAction((byte)1, false);
        Engine.setCurrentGameStage(Engine.newStage.profileSelectMenu);
    }

    public static int scale(int n) {
        return n * 100 / 100;
    }

    public void setLozengerColourWithLanguage() {
        try {
            Engine.newStage.bgImage = null;
            newStage.initBgImage();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (text[0].equals("0")) {
            for (int i = 0; i < 5; ++i) {
                String string = Engine.getText(1 + i);
                int n = Integer.parseInt(string);
                Lozenge.changeLozengerColour(2 + i, n);
            }
        }
        System.gc();
    }

    public final String getTodayDate() {
        return "";
    }

    public static boolean canUploadProfile() {
        return true;
    }

    public static void savePreviousUploadedScore() {
    }

    static {
        lastSound = -1;
        vibrateOn = true;
        soundOn = true;
        random = new Random();
        state = -1;
        diplaySizeWarn = false;
        frenchLocale = false;
        lang = null;
        DOUBLE_BUFFERING = false;
        skipFrameCounter = 0;
        defaultName = "";
        scoreUploaded = true;
        UID = new String();
        questionPackDownloaded = new boolean[3];
        rand = new Random(System.currentTimeMillis());
        displayDebugWrite = true;
        strDebug = "";
        qwertyInput = -1;
        requestedURL = false;
        vOnlineProfiles = new Vector();
        vOnlineProfileDataIds = new Vector();
        STR_CLIENT_STATES = new String[]{"CLIENT_STATE_START", "CLIENT_STATE_SEND_GET_DATA", "CLIENT_STATE_GET_BILLING_ANSWERS", "CLIENT_STATE_RECEIVED_QPACK", "CLIENT_STATE_START_PROFILE_UPLOAD", "CLIENT_STATE_START_PROFILES_DOWNLOAD", "CLIENT_STATE_GET_PROFILE_DATA", "CLIENT_STATE_START_PPP", "CLIENT_STATE_START_DOWNLOAD_LEADERBOARD", "UNKNOWN", "UNKNOWN", "UNKNOWN", "UNKNOWN", "UNKNOWN"};
        downloadPackNames = new Vector();
        clientState = 0;
        clientPrevState = 0;
        clientSerial = null;
        clientQATitle = "";
        clientQABody = "";
        gluBillingOn = false;
        clientCurrAnswer = 0;
        clientBillingCurrAnswer = 0;
        currQuestionPackBeingPlayed = "";
        billingPPPTime = -1L;
        billingPPPLevels = -1;
        pppGameType = (byte)-1;
    }
}

