/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;

class PlayerProfile {
    static final int NUM_PROFILES = 3;
    static final int PROFILE_ID_1 = 0;
    static final int PROFILE_ID_2 = 1;
    static final int PROFILE_ID_3 = 2;
    static String[] profileName = new String[3];
    static String[] profileOnlineSerialKey = new String[3];
    public static int[] gamesPlayed = new int[3];
    public static int[] totalWins = new int[3];
    public static int[] totalCash = new int[3];
    public static int[] correctQuestionsInRow = new int[3];
    public static int[] highestScoreEarned = new int[3];
    public static int[] totalScore = new int[3];
    public static int[] averageTimePerQuestion = new int[3];
    public static int[] averageCashPerGame = new int[3];
    public static int[] totalMoneyForfeited = new int[3];
    public static int[] highestScoreFastestFingerFirstRound = new int[3];
    public static int[] currAnswerTime = new int[3];
    public static int[] correctAnswersInRow = new int[3];
    public static int[] preTotalScore = new int[3];
    public static int currProfile = 0;
    public static MenuStage profileForm;

    PlayerProfile() {
    }

    public static void loadProfilesFromRMS() {
        try {
            byte[] byArray = Engine.readBytes(Engine.text[102] + "profiles");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            PlayerProfile.loadAllProfilesFromRMS(dataInputStream);
            dataInputStream.close();
            byteArrayInputStream.close();
            dataInputStream = null;
            byteArrayInputStream = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void saveProfilesToRMS() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            PlayerProfile.saveAllProfilesToRMS(dataOutputStream);
            Engine.writeBytes(Engine.text[102] + "profiles", byteArrayOutputStream.toByteArray());
            dataOutputStream.close();
            byteArrayOutputStream.close();
            dataOutputStream = null;
            byteArrayOutputStream = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void loadAllProfilesFromRMS(DataInputStream dataInputStream) {
        try {
            currProfile = dataInputStream.readInt();
            for (int i = 0; i < 3; ++i) {
                PlayerProfile.profileName[i] = dataInputStream.readUTF();
                PlayerProfile.profileOnlineSerialKey[i] = dataInputStream.readUTF();
                PlayerProfile.gamesPlayed[i] = dataInputStream.readInt();
                PlayerProfile.totalWins[i] = dataInputStream.readInt();
                PlayerProfile.totalCash[i] = dataInputStream.readInt();
                PlayerProfile.correctQuestionsInRow[i] = dataInputStream.readInt();
                PlayerProfile.highestScoreEarned[i] = dataInputStream.readInt();
                PlayerProfile.totalScore[i] = dataInputStream.readInt();
                PlayerProfile.averageTimePerQuestion[i] = dataInputStream.readInt();
                PlayerProfile.averageCashPerGame[i] = dataInputStream.readInt();
                PlayerProfile.totalMoneyForfeited[i] = dataInputStream.readInt();
                PlayerProfile.highestScoreFastestFingerFirstRound[i] = dataInputStream.readInt();
                PlayerProfile.correctAnswersInRow[i] = dataInputStream.readInt();
                PlayerProfile.preTotalScore[i] = dataInputStream.readInt();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void writeProfileToDataStream(int n, DataOutputStream dataOutputStream) {
        try {
            dataOutputStream.writeUTF(profileName[n]);
            dataOutputStream.writeUTF(profileOnlineSerialKey[n]);
            dataOutputStream.writeInt(gamesPlayed[n]);
            dataOutputStream.writeInt(totalWins[n]);
            dataOutputStream.writeInt(totalCash[n]);
            dataOutputStream.writeInt(correctQuestionsInRow[n]);
            dataOutputStream.writeInt(highestScoreEarned[n]);
            dataOutputStream.writeInt(totalScore[n]);
            dataOutputStream.writeInt(averageTimePerQuestion[n]);
            if (gamesPlayed[n] != 0) {
                PlayerProfile.averageCashPerGame[n] = totalCash[n] / gamesPlayed[n];
            }
            dataOutputStream.writeInt(averageCashPerGame[n]);
            dataOutputStream.writeInt(totalMoneyForfeited[n]);
            dataOutputStream.writeInt(highestScoreFastestFingerFirstRound[n]);
            dataOutputStream.writeInt(correctAnswersInRow[n]);
            dataOutputStream.writeInt(preTotalScore[n]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static byte[] getProfileAsByteArray(int n) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            PlayerProfile.writeProfileToDataStream(n, dataOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            dataOutputStream.close();
            byteArrayOutputStream.close();
            dataOutputStream = null;
            byteArrayOutputStream = null;
            return byArray;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void saveAllProfilesToRMS(DataOutputStream dataOutputStream) {
        try {
            dataOutputStream.writeInt(currProfile);
            for (int i = 0; i < 3; ++i) {
                PlayerProfile.writeProfileToDataStream(i, dataOutputStream);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String currProfileName() {
        return profileName[currProfile];
    }

    public static String currProfileShort() {
        return "" + currProfile;
    }

    public static void resetAllProfiles() {
        currProfile = 0;
        for (int i = 0; i < 3; ++i) {
            PlayerProfile.resetProfile(i);
        }
    }

    public static void resetProfile(int n) {
        currProfile = n;
        Engine.deleteBytes(Engine.text[102] + "save" + PlayerProfile.currProfileName());
        PlayerProfile.profileName[PlayerProfile.currProfile] = Engine.text[167];
        PlayerProfile.profileOnlineSerialKey[PlayerProfile.currProfile] = "";
        PlayerProfile.gamesPlayed[PlayerProfile.currProfile] = 0;
        PlayerProfile.totalWins[PlayerProfile.currProfile] = 0;
        PlayerProfile.totalCash[PlayerProfile.currProfile] = 0;
        PlayerProfile.highestScoreEarned[PlayerProfile.currProfile] = 0;
        PlayerProfile.totalScore[PlayerProfile.currProfile] = 0;
        PlayerProfile.averageCashPerGame[PlayerProfile.currProfile] = 0;
        PlayerProfile.highestScoreFastestFingerFirstRound[PlayerProfile.currProfile] = 0;
        PlayerProfile.averageTimePerQuestion[PlayerProfile.currProfile] = 0;
        PlayerProfile.totalMoneyForfeited[PlayerProfile.currProfile] = 0;
        PlayerProfile.currAnswerTime[PlayerProfile.currProfile] = 0;
        PlayerProfile.correctQuestionsInRow[PlayerProfile.currProfile] = 0;
        PlayerProfile.preTotalScore[PlayerProfile.currProfile] = 0;
    }

    public static void showProfileForm(int n, MenuStage menuStage) {
        profileForm = new MenuStage(Main.instance.engine);
        PlayerProfile.profileForm.isViewProfileMenu = true;
        String[] stringArray = new String[]{Engine.text[179], "" + gamesPlayed[currProfile], Engine.text[180], "" + totalWins[currProfile], Engine.text[181], "" + Engine.text[52] + totalCash[currProfile], Engine.text[183], "" + highestScoreEarned[currProfile], Engine.text[184], "" + totalScore[currProfile], Engine.text[185], averageTimePerQuestion[currProfile] + "", Engine.text[186], Engine.text[52] + averageCashPerGame[currProfile], Engine.text[187], Engine.text[52] + totalMoneyForfeited[currProfile], Engine.text[188], "" + highestScoreFastestFingerFirstRound[currProfile]};
        Engine cfr_ignored_0 = Main.instance.engine;
        profileForm.initMenuList(profileName[n], null, stringArray, false, 0, Engine.newStage, true);
        for (int i = 1; i < 18; i += 2) {
            PlayerProfile.profileForm.curLozenges[i].isViewProfile = true;
            PlayerProfile.profileForm.curLozenges[i].isSplashLozenge = true;
        }
        profileForm.setMenuAction((byte)0, false);
        profileForm.setMenuAction((byte)1, true);
        Engine cfr_ignored_1 = Main.instance.engine;
        Engine.setCurrentGameStage(profileForm);
    }

    public static void showOnlineProfileForm2(byte[] byArray) {
    }

    public static boolean checkForDuplicateNames(String string) {
        for (int i = 0; i < 3; ++i) {
            if (!string.equals(profileName[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean isCheatProfile() {
        return profileName[currProfile].equals("CHEAT");
    }
}

