/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;

class GS60_SoundMgr {
    private gs60bjc2 applet;
    private boolean initialized;
    private int playing_priority;
    private boolean sound_enabled;
    private long last_sound_time;
    private boolean music_enabled;
    private boolean music_loaded;
    private boolean music_playing;
    private String menu_music;
    private Player playing_sound;
    public Object bg_task_lock = new Object();
    public Object bg_task_lock__for_stopping_sound = new Object();
    public String bg_sound_to_play;
    public boolean bg_sound_being_started;

    public int PlayingPriority() {
        return this.playing_priority;
    }

    public boolean IsSoundEnabled() {
        return this.sound_enabled;
    }

    public void EnableSound(boolean bl) {
        this.sound_enabled = bl;
    }

    public boolean IsMusicEnabled() {
        return this.music_enabled;
    }

    public void EnableMusic(boolean bl) {
        this.music_enabled = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void BackgroundTask__Process() {
        String string = null;
        Object object = this.bg_task_lock;
        synchronized (object) {
            if (this.bg_sound_to_play != null) {
                string = this.bg_sound_to_play;
                this.bg_sound_being_started = true;
                this.bg_sound_to_play = null;
            }
        }
        if (string != null) {
            object = this.bg_task_lock__for_stopping_sound;
            synchronized (object) {
                if (this.bg_sound_being_started) {
                    try {
                        this.playing_sound = this.Load(string);
                        this.playing_sound.start();
                    }
                    catch (Exception exception) {
                        this.playing_sound = null;
                    }
                }
            }
        }
        this.bg_sound_being_started = false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean IsIdle() {
        if (this.bg_sound_to_play != null) return false;
        if (this.bg_sound_being_started) {
            return false;
        }
        if (this.playing_sound == null) return true;
        if (this.playing_sound.getState() == 400) return false;
        return true;
    }

    public GS60_SoundMgr(gs60bjc2 gs60bjc22) {
        this.applet = gs60bjc22;
        this.playing_sound = null;
        this.playing_priority = 0;
        this.sound_enabled = true;
        this.music_enabled = true;
        this.music_loaded = false;
        this.last_sound_time = 0L;
    }

    public Player Load(String string) {
        Player player = null;
        byte[] byArray = null;
        String string2 = null;
        if (byArray == null && GS60_AssetMgr.CheckIfAssetExists(string + ".mp3")) {
            byArray = GS60_AssetMgr.LoadBinaryData(string + ".mp3");
            string2 = "audio/mpeg";
        }
        if (byArray == null && GS60_AssetMgr.CheckIfAssetExists(string + ".amr")) {
            byArray = GS60_AssetMgr.LoadBinaryData(string + ".amr");
            string2 = "audio/amr";
        }
        if (byArray == null && GS60_AssetMgr.CheckIfAssetExists(string + ".wav")) {
            byArray = GS60_AssetMgr.LoadBinaryData(string + ".wav");
            string2 = "audio/x-wav";
        }
        if (byArray == null && GS60_AssetMgr.CheckIfAssetExists(string + ".mid")) {
            byArray = GS60_AssetMgr.LoadBinaryData(string + ".mid");
            string2 = "audio/midi";
        }
        if (byArray != null) {
            try {
                player = Manager.createPlayer((InputStream)new ByteArrayInputStream(byArray), string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (player != null) {
            try {
                player.realize();
            }
            catch (Exception exception) {
                try {
                    player.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                player = null;
            }
        }
        return player;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Play(String string, int n, long l) {
        long l2 = System.currentTimeMillis();
        if (!(!this.sound_enabled || string == null || this.music_loaded && this.music_enabled || l2 - this.last_sound_time <= l && this.last_sound_time != 0L)) {
            this.last_sound_time = l2;
            if (this.IsIdle() || n >= this.playing_priority) {
                if (this.playing_sound != null) {
                    try {
                        this.playing_sound.stop();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        this.playing_sound.deallocate();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        this.playing_sound.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.playing_sound = null;
                }
                try {
                    Object object = this.bg_task_lock;
                    synchronized (object) {
                        this.bg_sound_to_play = string;
                    }
                    this.playing_priority = n;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void StopAll() {
        Object object = this.bg_task_lock;
        synchronized (object) {
            this.bg_sound_to_play = null;
        }
        object = this.bg_task_lock__for_stopping_sound;
        synchronized (object) {
            if (this.playing_sound != null) {
                try {
                    this.playing_sound.stop();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.playing_sound.deallocate();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.playing_sound.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.playing_sound = null;
            this.playing_priority = 0;
            this.bg_sound_being_started = false;
        }
    }

    public void Sound_Pause() {
        try {
            this.playing_sound.stop();
            this.menu_music = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void Sound_Resume() {
        try {
            if (this.sound_enabled) {
                this.playing_sound.start();
            } else {
                this.StopAll();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void Sound_Process() {
        if (this.music_loaded) {
            if (this.music_enabled && this.sound_enabled) {
                if (this.IsIdle()) {
                    this.music_loaded = false;
                    this.Play(this.menu_music, 100, 0L);
                    this.music_playing = true;
                    this.music_loaded = true;
                }
            } else if (this.music_playing && !this.IsIdle()) {
                this.StopAll();
                this.music_playing = false;
            }
        }
    }

    public void Music_LoadAndPlay(String string) {
        if (!this.music_loaded) {
            this.menu_music = string;
            if (this.menu_music != null) {
                this.music_loaded = true;
            }
        }
    }

    public void Music_StopAndUnload() {
        if (this.music_loaded) {
            this.StopAll();
            this.music_loaded = false;
            this.menu_music = null;
        }
    }
}

