/*
 * Decompiled with CFR 0.152.
 */
class GS60_XmlReader {
    private byte[] file_data = null;
    private int file_len = 0;
    private int cur_offset;
    private int peek_offset;
    private boolean last_char_was_ampersand_char;
    private boolean error;
    private int bytes_per_char;
    private int offset_name_begin;
    private int offset_name_end;
    private int offset_attribute_tag_begin;
    private int offset_attribute_tag_end;
    private int offset_text_begin;
    private int offset_text_end;
    private int element_type;

    public void Init(byte[] byArray, int n) {
        this.file_data = byArray;
        this.file_len = n;
        this.peek_offset = 0;
        this.cur_offset = 0;
        this.error = false;
        this.bytes_per_char = 2;
        this.element_type = -1;
        char c = this.PeekRawChar();
        if (c != '\ufeff') {
            this.bytes_per_char = 1;
            this.cur_offset = 0;
        }
        this.BypassHeader();
    }

    public void CopyFrom(GS60_XmlReader gS60_XmlReader) {
        this.file_data = gS60_XmlReader.file_data;
        this.file_len = gS60_XmlReader.file_len;
        this.cur_offset = gS60_XmlReader.cur_offset;
        this.peek_offset = gS60_XmlReader.peek_offset;
        this.last_char_was_ampersand_char = gS60_XmlReader.last_char_was_ampersand_char;
        this.error = gS60_XmlReader.error;
        this.bytes_per_char = gS60_XmlReader.bytes_per_char;
        this.offset_name_begin = gS60_XmlReader.offset_name_begin;
        this.offset_name_end = gS60_XmlReader.offset_name_end;
        this.offset_attribute_tag_begin = gS60_XmlReader.offset_attribute_tag_begin;
        this.offset_attribute_tag_end = gS60_XmlReader.offset_attribute_tag_end;
        this.offset_text_begin = gS60_XmlReader.offset_text_begin;
        this.offset_text_end = gS60_XmlReader.offset_text_end;
        this.element_type = gS60_XmlReader.element_type;
    }

    private void BypassHeader() {
        int n = 32;
        int n2 = 32;
        while (n != 65535) {
            n2 = n;
            n = this.GetChar();
            if (n2 != 63 || n != 62) continue;
        }
        this.GetSkipWhitespace();
        if (this.PeekRawChar() != '<') {
            this.ThrowError();
        }
    }

    private char ThrowError() {
        boolean bl = true;
        if (bl) {
            // empty if block
        }
        this.element_type = 0;
        return '\uffff';
    }

    private char PeekRawChar() {
        if (this.peek_offset > this.file_len) {
            if (this.element_type != 0) {
                this.element_type = 0;
                return '\uffff';
            }
            return this.ThrowError();
        }
        char c = (char)(this.file_data[this.peek_offset++] & 0xFF);
        if (this.bytes_per_char == 2) {
            if (this.peek_offset > this.file_len) {
                return this.ThrowError();
            }
            c = (char)(c | (this.file_data[this.peek_offset++] & 0xFF) << 8);
        }
        return c;
    }

    private void PeekSkipWhitespace() {
        int n;
        char c;
        do {
            n = this.peek_offset;
        } while (this.peek_offset < this.file_len && ((c = this.PeekChar()) == ' ' || c == '\t' || c == '\n' || c == '\r'));
        this.peek_offset = n;
    }

    private void GetSkipWhitespace() {
        this.PeekSkipWhitespace();
        this.cur_offset = this.peek_offset;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private char PeekChar() {
        int n;
        block23: {
            this.last_char_was_ampersand_char = false;
            int n2 = this.peek_offset;
            n = this.PeekRawChar();
            if (n == 60) {
                n = this.PeekRawChar();
                if (n == 33) {
                    do {
                        if ((n = this.PeekRawChar()) != 62) continue;
                        n = this.PeekRawChar();
                        break block23;
                    } while (n != 65535);
                    return '\uffff';
                }
                this.peek_offset = n2;
                n = this.PeekRawChar();
            }
        }
        if (n != 38) return (char)n;
        this.last_char_was_ampersand_char = true;
        n = this.PeekRawChar();
        if (n == 97) {
            n = this.PeekRawChar();
            if (n == 109) {
                if (this.PeekRawChar() != 'p') {
                    return this.ThrowError();
                }
                if (this.PeekRawChar() == ';') return (char)38;
                return this.ThrowError();
            }
            if (n != 112) return this.ThrowError();
            if (this.PeekRawChar() != 'o') {
                return this.ThrowError();
            }
            if (this.PeekRawChar() != 's') {
                return this.ThrowError();
            }
            if (this.PeekRawChar() == ';') return (char)39;
            return this.ThrowError();
        }
        if (n == 113) {
            if (this.PeekRawChar() != 'u') {
                return this.ThrowError();
            }
            if (this.PeekRawChar() != 'o') {
                return this.ThrowError();
            }
            if (this.PeekRawChar() != 't') {
                return this.ThrowError();
            }
            if (this.PeekRawChar() == ';') return (char)34;
            return this.ThrowError();
        }
        if (n == 108) {
            if (this.PeekRawChar() != 't') {
                return this.ThrowError();
            }
            if (this.PeekRawChar() == ';') return (char)60;
            return this.ThrowError();
        }
        if (n == 103) {
            if (this.PeekRawChar() != 't') {
                return this.ThrowError();
            }
            if (this.PeekRawChar() == ';') return (char)62;
            return this.ThrowError();
        }
        if (n != 35) return this.ThrowError();
        n = this.PeekRawChar();
        int n3 = 0;
        if (n == 120) {
            n = this.PeekRawChar();
            while (n != 59) {
                if (n >= 48 && n <= 57) {
                    n3 = (char)(n3 * 16 + (n - 48));
                } else if (n >= 97 && n <= 102) {
                    n3 = (char)(n3 * 16 + (n - 97 + 10));
                } else {
                    if (n < 65) return this.ThrowError();
                    if (n > 70) return this.ThrowError();
                    n3 = (char)(n3 * 16 + (n - 65 + 10));
                }
                n = this.PeekRawChar();
            }
            return (char)n3;
        }
        while (n != 59) {
            if (n < 48) return this.ThrowError();
            if (n > 57) return this.ThrowError();
            n3 = (char)(n3 * 10 + (n - 48));
            n = this.PeekRawChar();
        }
        return (char)n3;
    }

    private int StripTrailingCRLF(int n, int n2) {
        int n3 = this.cur_offset;
        int n4 = n;
        this.peek_offset = this.cur_offset = n;
        while (this.cur_offset < n2) {
            n4 = this.cur_offset;
            char c = this.GetChar();
            if (c != '\r' && c != '\n') continue;
            this.cur_offset = this.peek_offset = n3;
            return n4;
        }
        this.cur_offset = this.peek_offset = n3;
        return n2;
    }

    private char GetChar() {
        this.peek_offset = this.cur_offset;
        char c = this.PeekChar();
        this.cur_offset = this.peek_offset;
        return c;
    }

    public void AdvanceElement_ParseNewChild() {
        if (this.PeekChar() != '<') {
            this.ThrowError();
            return;
        }
        this.GetChar();
        this.GetSkipWhitespace();
        this.offset_name_begin = this.cur_offset;
        while (true) {
            this.offset_name_end = this.cur_offset;
            char c = this.PeekChar();
            if (c == ' ' || c == '\t' || c == '/' || c == '>' || c == '\r' || c == '\n') break;
            if (this.Error()) {
                return;
            }
            this.GetChar();
        }
        this.peek_offset = this.cur_offset;
        this.element_type = 1;
        this.GetSkipWhitespace();
    }

    private boolean AdvanceElement_CheckForChildEnd_InAttributes() {
        int n = this.cur_offset;
        char c = this.GetChar();
        if (c == '/') {
            if (this.GetChar() != '>') {
                this.ThrowError();
            } else {
                this.element_type = 2;
                this.GetSkipWhitespace();
                return true;
            }
        }
        this.cur_offset = n;
        return false;
    }

    private boolean AdvanceElement_CheckForChildEnd_NotInAttributes() {
        int n = this.cur_offset;
        char c = this.PeekChar();
        if (c == '<') {
            this.GetChar();
            this.GetSkipWhitespace();
            if (this.GetChar() == '/') {
                char c2;
                this.offset_name_begin = this.cur_offset;
                this.offset_name_end = 0;
                do {
                    int n2 = this.cur_offset;
                    c2 = this.GetChar();
                    if ((c2 == ' ' || c2 == '\t') && this.offset_name_end == 0) {
                        this.offset_name_end = n2;
                    }
                    if (c2 != '>') continue;
                    if (this.offset_name_end == 0) {
                        this.offset_name_end = n2;
                    }
                    this.GetSkipWhitespace();
                    this.element_type = 2;
                    return true;
                } while (c2 != '\uffff');
                this.element_type = 0;
                return false;
            }
        }
        this.cur_offset = n;
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean AdvanceElement_CheckForAttribute() {
        block10: {
            int n = this.cur_offset;
            char c = this.GetChar();
            if (c == '/') {
                if (this.GetChar() != '>') {
                    this.ThrowError();
                } else {
                    if (this.element_type != 4) {
                        this.element_type = 4;
                        this.cur_offset = n;
                        return true;
                    }
                    this.element_type = 2;
                }
            } else if (c == '>') {
                this.element_type = 4;
            } else {
                char c2;
                block11: {
                    block12: {
                        this.element_type = 3;
                        this.offset_attribute_tag_begin = n;
                        do {
                            this.offset_attribute_tag_end = this.cur_offset;
                            c = this.GetChar();
                            if (c != '=') continue;
                            c2 = this.GetChar();
                            if (c2 == '\'') break block11;
                            break block12;
                        } while (c != '\uffff');
                        this.ThrowError();
                        return true;
                    }
                    if (c2 != '\"') {
                        this.ThrowError();
                        return true;
                    }
                }
                this.offset_text_begin = this.cur_offset;
                do {
                    this.offset_text_end = this.cur_offset;
                    c = this.GetChar();
                    if (c == c2 && !this.last_char_was_ampersand_char) break block10;
                } while (c != '\uffff');
                this.ThrowError();
                return true;
            }
        }
        this.GetSkipWhitespace();
        return true;
    }

    private boolean AdvanceElement_CheckForChildBegin() {
        if (this.PeekChar() == '<' && this.PeekChar() != '/') {
            this.peek_offset = this.cur_offset;
            this.AdvanceElement_ParseNewChild();
            return true;
        }
        this.peek_offset = this.cur_offset;
        return false;
    }

    private boolean AdvanceElement_CheckForText() {
        block2: {
            char c;
            this.offset_text_begin = this.cur_offset;
            do {
                this.offset_text_end = this.cur_offset;
                c = this.GetChar();
                if (c == '\uffff') {
                    this.element_type = 0;
                    return true;
                }
                if (c == '<') break block2;
            } while (c != '\uffff');
            this.ThrowError();
            return true;
        }
        this.element_type = 5;
        this.cur_offset = this.peek_offset = this.offset_text_end;
        this.offset_text_end = this.StripTrailingCRLF(this.offset_text_begin, this.offset_text_end);
        return true;
    }

    public void AdvanceElement() {
        this.peek_offset = this.cur_offset;
        switch (this.element_type) {
            case -1: {
                this.AdvanceElement_ParseNewChild();
                break;
            }
            case 1: {
                if (this.AdvanceElement_CheckForAttribute()) break;
                this.ThrowError();
                break;
            }
            case 3: {
                if (this.AdvanceElement_CheckForAttribute()) break;
                this.ThrowError();
                break;
            }
            case 4: {
                if (this.AdvanceElement_CheckForChildEnd_InAttributes()) break;
                this.peek_offset = this.cur_offset;
            }
            case 2: {
                if (this.AdvanceElement_CheckForChildEnd_NotInAttributes()) break;
                this.peek_offset = this.cur_offset;
                if (this.AdvanceElement_CheckForChildBegin()) break;
                this.peek_offset = this.cur_offset;
                if (this.AdvanceElement_CheckForText()) break;
                this.ThrowError();
                break;
            }
            case 5: {
                if (this.AdvanceElement_CheckForChildEnd_NotInAttributes()) break;
                this.peek_offset = this.cur_offset;
                if (this.AdvanceElement_CheckForChildBegin()) break;
                this.ThrowError();
                break;
            }
        }
        if (this.element_type != 0) {
            this.GetSkipWhitespace();
        }
    }

    public void LeaveChild() {
        GS60_XmlReader gS60_XmlReader = new GS60_XmlReader();
        gS60_XmlReader.CopyFrom(this);
        int n = 1;
        int n2 = 0;
        int n3 = 0;
        do {
            gS60_XmlReader.AdvanceElement();
            switch (gS60_XmlReader.GetElementType()) {
                case 1: {
                    ++n;
                    break;
                }
                case 2: {
                    if (--n != 0) break;
                    this.CopyFrom(gS60_XmlReader);
                    this.offset_text_begin = n2;
                    this.offset_text_end = n3;
                    return;
                }
                case 5: {
                    if (n != 1) break;
                    n2 = gS60_XmlReader.offset_text_begin;
                    n3 = gS60_XmlReader.offset_text_end;
                    break;
                }
            }
        } while (gS60_XmlReader.GetElementType() != 0);
    }

    private boolean RangeEquals(int n, int n2, String string) {
        boolean bl = true;
        int n3 = 0;
        int n4 = string.length();
        int n5 = this.cur_offset;
        this.cur_offset = this.peek_offset = n;
        n3 = 0;
        while (this.cur_offset < n2) {
            if (n3 >= n4) {
                bl = false;
                break;
            }
            char c = this.GetChar();
            if (c != string.charAt(n3)) {
                bl = false;
                break;
            }
            ++n3;
        }
        this.cur_offset = this.peek_offset = n5;
        if (n3 != n4) {
            return false;
        }
        return bl;
    }

    public boolean ChildNameEquals(String string) {
        return this.RangeEquals(this.offset_name_begin, this.offset_name_end, string);
    }

    public boolean AttributeNameEquals(String string) {
        return this.RangeEquals(this.offset_attribute_tag_begin, this.offset_attribute_tag_end, string);
    }

    public void GetChildName(StringBuffer stringBuffer) {
        stringBuffer.setLength(0);
        int n = this.cur_offset;
        this.cur_offset = this.peek_offset = this.offset_name_begin;
        while (this.cur_offset < this.offset_name_end) {
            stringBuffer.append(this.GetChar());
        }
        this.cur_offset = this.peek_offset = n;
    }

    public void GetAttributeName(StringBuffer stringBuffer) {
        stringBuffer.setLength(0);
        int n = this.cur_offset;
        this.cur_offset = this.peek_offset = this.offset_attribute_tag_begin;
        while (this.cur_offset < this.offset_attribute_tag_end) {
            stringBuffer.append(this.GetChar());
        }
        this.cur_offset = this.peek_offset = n;
    }

    public void GetAttributeValue_AsSB(StringBuffer stringBuffer) {
        this.GetText_AsSB(stringBuffer);
    }

    public int GetAttributeValue_AsInt(int n) {
        return this.GetText_AsInt(n);
    }

    public String GetAttributeValue_AsFilename() {
        return this.GetText_AsFilename();
    }

    public boolean AttributeValueEquals(String string) {
        return this.TextEquals(string);
    }

    public void GetText_AsSB(StringBuffer stringBuffer) {
        stringBuffer.setLength(0);
        int n = this.cur_offset;
        this.cur_offset = this.peek_offset = this.offset_text_begin;
        while (this.cur_offset < this.offset_text_end) {
            stringBuffer.append(this.GetChar());
        }
        this.cur_offset = this.peek_offset = n;
    }

    public String GetText_AsFilename() {
        String string = new String();
        int n = this.cur_offset;
        this.cur_offset = this.peek_offset = this.offset_text_begin;
        while (this.cur_offset < this.offset_text_end) {
            string = string + this.GetChar();
        }
        this.cur_offset = this.peek_offset = n;
        return string;
    }

    public int GetText_AsInt(int n) {
        if (this.offset_text_end <= this.offset_text_begin) {
            return n;
        }
        int n2 = 0;
        int n3 = this.cur_offset;
        this.cur_offset = this.peek_offset = this.offset_text_begin;
        boolean bl = false;
        boolean bl2 = true;
        while (this.cur_offset < this.offset_text_end) {
            char c = this.GetChar();
            if (bl2 && c == '-') {
                bl = true;
                continue;
            }
            if (c < '0' || c > '9') {
                n2 = n;
                break;
            }
            bl2 = false;
            n2 = n2 * 10 + (c - 48);
        }
        this.cur_offset = this.peek_offset = n3;
        if (bl) {
            n2 = -n2;
        }
        return n2;
    }

    public int GetText_Len() {
        return this.offset_text_end - this.offset_text_begin;
    }

    public char GetText_Char(int n) {
        int n2 = this.cur_offset;
        this.cur_offset = this.peek_offset = this.offset_text_begin;
        while (n > 0) {
            this.GetChar();
            --n;
        }
        char c = this.GetChar();
        this.cur_offset = this.peek_offset = n2;
        return c;
    }

    public boolean TextEquals(String string) {
        return this.RangeEquals(this.offset_text_begin, this.offset_text_end, string);
    }

    public int CountChildrenNamed(String string) {
        int n = 0;
        GS60_XmlReader gS60_XmlReader = new GS60_XmlReader();
        gS60_XmlReader.CopyFrom(this);
        do {
            gS60_XmlReader.AdvanceElement();
            switch (gS60_XmlReader.GetElementType()) {
                case 1: {
                    if (gS60_XmlReader.ChildNameEquals(string)) {
                        ++n;
                    }
                    gS60_XmlReader.LeaveChild();
                    break;
                }
                case 2: {
                    return n;
                }
            }
        } while (gS60_XmlReader.GetElementType() != 0);
        return 0;
    }

    public boolean Error() {
        return this.error;
    }

    public int GetElementType() {
        return this.element_type;
    }
}

