/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class BmpFont {
    public short[] iSupChar;
    public short[] iSupCharXPos;
    public byte[] iSupCharWidth;
    public Image iImg;
    public int iHeight;
    public int iHSpacing;
    public int iMaxNumChrWidth;
    public int iMaxTxtChrWidth;
    public static final char KChrFormat = '\\';

    public static short[] SortArray(short[] aArray, boolean aCreateIndexTable) {
        int i2;
        short[] indexTable = null;
        if (aCreateIndexTable) {
            i2 = aArray.length;
            indexTable = new short[i2];
            while (i2-- != 0) {
                indexTable[i2] = (short)i2;
            }
        }
        for (i2 = 0; i2 < aArray.length - 1; ++i2) {
            int j2;
            int k2 = i2;
            for (j2 = i2 + 1; j2 < aArray.length; ++j2) {
                if (aArray[j2] >= aArray[k2]) continue;
                k2 = j2;
            }
            j2 = aArray[k2];
            aArray[k2] = aArray[i2];
            aArray[i2] = (short)j2;
            if (indexTable == null) continue;
            j2 = indexTable[k2];
            indexTable[k2] = indexTable[i2];
            indexTable[i2] = (short)j2;
        }
        return indexTable;
    }

    public BmpFont(Image aImg, short[] aSupChar, short[] aSupCharXPos, byte[] aSupCharWidth, int aHSpacing, boolean aFastNumFont) {
        this.iImg = aImg;
        this.iHeight = aImg.getHeight();
        this.iHSpacing = aHSpacing;
        this.iSupChar = aSupChar;
        this.iSupCharXPos = aSupCharXPos;
        this.iSupCharWidth = aSupCharWidth;
        this.iMaxTxtChrWidth = 0;
        this.iMaxNumChrWidth = 0;
        if (!aFastNumFont) {
            short[] indexTable = BmpFont.SortArray(aSupChar, true);
            int i2 = indexTable.length;
            short[] chrXPos = new short[i2];
            byte[] chrWidth = new byte[i2];
            System.arraycopy(aSupCharXPos, 0, chrXPos, 0, i2);
            System.arraycopy(aSupCharWidth, 0, chrWidth, 0, i2);
            while (i2-- != 0) {
                this.iSupCharXPos[i2] = chrXPos[indexTable[i2]];
                this.iSupCharWidth[i2] = chrWidth[indexTable[i2]];
            }
            i2 = this.iSupChar.length;
            while (i2-- != 0) {
                int chrW = this.iSupCharWidth[i2];
                short chr = this.iSupChar[i2];
                if (chr < 48 || chr > 57) {
                    if (chrW <= this.iMaxTxtChrWidth) continue;
                    this.iMaxTxtChrWidth = chrW;
                    continue;
                }
                if (chrW <= this.iMaxNumChrWidth) continue;
                this.iMaxNumChrWidth = chrW;
            }
        } else {
            int i3 = this.iSupCharWidth.length;
            while (i3-- != 0) {
                if (this.iSupCharWidth[i3] <= this.iMaxNumChrWidth) continue;
                this.iMaxNumChrWidth = this.iSupCharWidth[i3];
            }
        }
    }

    public static int BinarySearchA(short[] aArray, short aKey) {
        int off = 0;
        int hi = aArray.length - 1;
        while (off <= hi) {
            int m2 = off + hi >>> 1;
            short v2 = aArray[m2];
            if (v2 < aKey) {
                off = m2 + 1;
                continue;
            }
            if (v2 > aKey) {
                hi = m2 - 1;
                continue;
            }
            return m2;
        }
        return ~off;
    }

    public int GetCharWidth(char aChar) {
        int i2 = BmpFont.BinarySearchA(this.iSupChar, (short)aChar);
        if (i2 >= 0) {
            return this.iSupCharWidth[i2];
        }
        return 0;
    }

    public final int getHeight() {
        return this.iHeight;
    }

    public int GetTextWidth(String aText) {
        return this.GetTextWidth(aText, 0, aText.length());
    }

    public int GetTextWidth(String aText, int aFrom, int aLen) {
        int txtWidth = 0;
        while (aLen-- > 0) {
            short chr;
            if ((chr = (short)aText.charAt(aFrom++)) != 92) {
                int chrId = BmpFont.BinarySearchA(this.iSupChar, chr);
                if (chrId < 0) continue;
                txtWidth += this.iSupCharWidth[chrId] + this.iHSpacing;
                continue;
            }
            ++aFrom;
            --aLen;
        }
        return txtWidth - this.iHSpacing;
    }

    public int DrawText(Graphics aG, int aX, int aY, String aText) {
        return this.DrawText(aG, aX, aY, aText, 0, aText.length());
    }

    public static void BitBlt(Image aSrc, Graphics aDes, int aSrcX, int aSrcY, int aSrcW, int aSrcH, int aDesX, int aDesY) {
        aDes.setClip(aDesX, aDesY, aSrcW, aSrcH);
        aDes.drawImage(aSrc, aDesX - aSrcX, aDesY - aSrcY, 20);
    }

    public int DrawText(Graphics aG, int aX, int aY, String aText, int aFrom, int aLen) {
        int cY = aG.getClipY();
        int cH = aG.getClipHeight();
        int cX = aG.getClipX();
        int cW = aG.getClipWidth();
        int pos = aX;
        while (aLen-- > 0) {
            short chr;
            if ((chr = (short)aText.charAt(aFrom++)) != 92) {
                int chrId = BmpFont.BinarySearchA(this.iSupChar, chr);
                if (chrId < 0) continue;
                byte chrWidth = this.iSupCharWidth[chrId];
                if (chr != 32) {
                    BmpFont.BitBlt(this.iImg, aG, this.iSupCharXPos[chrId], 0, chrWidth, this.iHeight, pos, aY);
                }
                pos += chrWidth + this.iHSpacing;
                continue;
            }
            ++aFrom;
            --aLen;
        }
        aG.setClip(cX, cY, cW, cH);
        return pos;
    }

    public static void ConvertNum2FastNumFontArray(int aValue, byte[] aArray, int aOffset) {
        int pos = 1;
        do {
            aArray[aOffset + pos++] = (byte)(aValue % 10);
        } while ((aValue /= 10) != 0);
        aArray[0] = (byte)(aOffset + pos - 1);
    }

    public int GetFastNumFontArrayWidth(byte[] aArray) {
        int width = 0;
        int i2 = aArray[0];
        while (i2-- != 0) {
            width += this.iSupCharWidth[aArray[1 + i2]] + this.iHSpacing;
        }
        return width - this.iHSpacing;
    }
}

