/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;

public class ScreenGame
implements IScreen {
    private String[] playerNames = new String[]{"NICK", "JOE", "PAUL", "JOHN", "FRED", "CARL", "ADAM", "WILL", "VILMA", "LUCY", "EMMA", "EVA", "STACY", "JILL", "JANE", "PENNY"};
    private static final int SEX_SEPARATOR = 7;
    public static Game Game;
    public static GameHandling GameHandling;
    public static int playerPanelYOffset;
    public static int tableYOffset;
    public static boolean bSkipOn;
    public static boolean bPlusPressed;
    public static boolean bMinusPressed;
    public static int iKeyPressedDelay;
    public static int iWaitTime;
    public static int DEFAULT_WAIT_TIME;
    public static int iBlickTime;
    private static int iWinFrame;
    public static int iDealerIndex;
    public static int iSBIndex;
    public static int iBBIndex;
    public static int iPutBlinds;
    public static int actualPlayer;
    public static int step;
    public static int iDistributionRound;
    private static Canvas canvas;
    public static int mode;
    public static int old_mode;
    static final int MODE_LOADING_RES = 0;
    static final int MODE_NEW_ROUND = 1;
    static final int MODE_DISTRIBUTION = 2;
    static final int MODE_PLAYING = 3;
    static final int MODE_PLAYER_MOVE = 4;
    static final int MODE_ROUND_OVER = 5;
    static final int MODE_PAUSE = 6;
    static final int MODE_STATISTICS = 7;
    static final int MODE_GAME_OVER = 8;
    static final int MODE_PUT_BLINDS = 9;
    static final int MODE_MOVING_UP = 10;
    static final int MODE_MOVING_DOWN = 11;
    static final int MODE_WELCOME = 12;
    static final int MODE_REALLY_QUIT_GAME = 13;
    static final int MODE_FINAL_SCORE = 14;
    private static int iSelectedAction;
    static final int ACTION_1 = 0;
    static final int ACTION_2 = 1;
    static final int ACTION_3 = 2;
    private static int iDistributionX;
    private static int iDistributionY;
    private static String[] menuStrings;
    private static String[] actionStrings;
    private static String[] gameModeStrings;
    private static String sWins;
    private static String sPlayer;
    private static String sSplit;
    private static String sRound;
    private static String sStats;
    private static String sGameMenu;
    private static String sPot;
    private static String sBack;
    private static String sTotScore;
    private static String sScore;
    private static String[] sRewards;
    private static String sReallyQuit;
    private static String[] quitMessage;
    private static String sWelcome;
    private static String sCash;
    private static String sLose;
    private static String sCongrat;
    private static String[] buyMore;
    private static String[] playOnNext;
    private static String actTable;
    private static int iSelectedSubMenuItem;
    static final int ITEM_CONTINUE = 0;
    static final int ITEM_MAIN_MENU = 1;
    public static boolean bNextGameMode;
    private Card[] cardArray;
    int iShownCardsCount;
    public static int iPlayerBet;

    private void loadStrings() {
        ScreenGame.menuStrings[0] = XX.texts.getHashedString("CONTINUE").toUpperCase();
        ScreenGame.menuStrings[1] = XX.texts.getHashedString("MAIN_MENU").toUpperCase();
        ScreenGame.actionStrings[0] = XX.texts.getHashedString("CHECK").toUpperCase();
        ScreenGame.actionStrings[1] = XX.texts.getHashedString("CALL").toUpperCase();
        ScreenGame.actionStrings[2] = XX.texts.getHashedString("BET").toUpperCase();
        ScreenGame.actionStrings[3] = XX.texts.getHashedString("RAISE").toUpperCase();
        ScreenGame.actionStrings[4] = XX.texts.getHashedString("FOLD").toUpperCase();
        ScreenGame.actionStrings[5] = XX.texts.getHashedString("ALL_IN").toUpperCase();
        ScreenGame.gameModeStrings[0] = XX.texts.getHashedString("DISTRIBUTION").toUpperCase();
        ScreenGame.gameModeStrings[1] = XX.texts.getHashedString("SMALL_BLIND").toUpperCase();
        ScreenGame.gameModeStrings[2] = XX.texts.getHashedString("BIG_BLIND").toUpperCase();
        ScreenGame.gameModeStrings[3] = XX.texts.getHashedString("FLOP").toUpperCase();
        ScreenGame.gameModeStrings[4] = XX.texts.getHashedString("TURN").toUpperCase();
        ScreenGame.gameModeStrings[5] = XX.texts.getHashedString("RIVER").toUpperCase();
        ScreenGame.gameModeStrings[6] = XX.texts.getHashedString("END_OF_ROUND").toUpperCase();
        ScreenGame.gameModeStrings[7] = XX.texts.getHashedString("GAME_OVER").toUpperCase();
        ScreenGame.gameModeStrings[8] = XX.texts.getHashedString("YOU_WIN").toUpperCase();
        sWins = XX.texts.getHashedString("WINS").toUpperCase();
        sPlayer = XX.texts.getHashedString("PLAYER").toUpperCase();
        sSplit = XX.texts.getHashedString("SPLIT_POT").toUpperCase();
        sRound = XX.texts.getHashedString("ROUND").toUpperCase();
        sStats = XX.texts.getHashedString("STATS").toUpperCase();
        sGameMenu = XX.texts.getHashedString("GAME_MENU").toUpperCase();
        sPot = XX.texts.getHashedString("POT").toUpperCase();
        sBack = XX.texts.getHashedString("BACK").toUpperCase();
        sTotScore = XX.texts.getHashedString("TOTAL_SCORE").toUpperCase();
        sScore = XX.texts.getHashedString("SCORE").toUpperCase();
        ScreenGame.sRewards[0] = XX.texts.getHashedString("PLAYING_HAND").toUpperCase();
        ScreenGame.sRewards[1] = XX.texts.getHashedString("WINNING_HAND").toUpperCase();
        ScreenGame.sRewards[2] = XX.texts.getHashedString("WIN_CARDS").toUpperCase();
        ScreenGame.sRewards[3] = XX.texts.getHashedString("ALL_IN_WIN").toUpperCase();
        ScreenGame.sRewards[4] = XX.texts.getHashedString("WIN_TIMES").toUpperCase();
        ScreenGame.sRewards[5] = XX.texts.getHashedString("TOTAL").toUpperCase();
        sReallyQuit = XX.texts.getHashedString("REALLY_QUIT_GAME").toUpperCase();
        ScreenGame.quitMessage[0] = XX.texts.getHashedString("IF_QUIT_1").toUpperCase();
        ScreenGame.quitMessage[1] = XX.texts.getHashedString("IF_QUIT_2").toUpperCase();
        ScreenGame.quitMessage[2] = XX.texts.getHashedString("IF_QUIT_3").toUpperCase();
        ScreenGame.quitMessage[3] = XX.texts.getHashedString("IF_QUIT_4").toUpperCase();
        ScreenGame.quitMessage[4] = XX.texts.getHashedString("IF_QUIT_5").toUpperCase();
        ScreenGame.quitMessage[5] = XX.texts.getHashedString("IF_QUIT_6").toUpperCase();
        sWelcome = XX.texts.getHashedString("WELCOME").toUpperCase();
        sCash = XX.texts.getHashedString("CASH").toUpperCase();
        sLose = XX.texts.getHashedString("YOU_LOSE").toUpperCase();
        sCongrat = XX.texts.getHashedString("CONGRAT").toUpperCase();
        ScreenGame.buyMore[0] = XX.texts.getHashedString("BUY_MORE_1").toUpperCase();
        ScreenGame.buyMore[1] = XX.texts.getHashedString("BUY_MORE_2").toUpperCase();
        ScreenGame.buyMore[2] = XX.texts.getHashedString("BUY_MORE_3").toUpperCase();
        ScreenGame.playOnNext[0] = XX.texts.getHashedString("PLAY_ON_NEXT_1").toUpperCase();
        ScreenGame.playOnNext[1] = XX.texts.getHashedString("PLAY_ON_NEXT_2").toUpperCase();
        ScreenGame.playOnNext[2] = XX.texts.getHashedString("PLAY_ON_NEXT_3").toUpperCase();
        actTable = XX.texts.getHashedString("ACT_TABLE").toUpperCase();
    }

    ScreenGame(Canvas canvas, int level) {
        Debug.traceIn("> ScreenGame.ScreenGame()");
        System.out.println("screengame");
        ScreenGame.canvas = canvas;
        this.resetDistributionCoordinates();
        this.loadStrings();
        iWaitTime = DEFAULT_WAIT_TIME;
        bPlusPressed = false;
        bMinusPressed = false;
        iKeyPressedDelay = 0;
        GameHandling = new GameHandling(level);
        Game = new Game(GameHandling.iBigBlinds[GameHandling.iLevel]);
        this.createPlayers();
        mode = 0;
        old_mode = 1;
        iSelectedAction = 1;
    }

    ScreenGame(Canvas canvas, boolean newGame) {
        Debug.traceIn("> ScreenGame.ScreenGame()");
        System.out.println("screengame");
        ScreenGame.canvas = canvas;
        this.resetDistributionCoordinates();
        this.loadStrings();
        iWaitTime = DEFAULT_WAIT_TIME;
        bPlusPressed = false;
        bMinusPressed = false;
        iKeyPressedDelay = 0;
        GameHandling = new GameHandling(newGame);
        Game = newGame ? new Game(GameHandling.iBigBlinds[GameHandling.iLevel]) : new Game();
        this.createPlayers();
        if (newGame) {
            mode = 0;
            old_mode = 1;
        } else {
            this.loadGame();
        }
        playerPanelYOffset = 0;
        tableYOffset = 0;
        iSelectedAction = 1;
    }

    public void loadGame() {
        playerPanelYOffset = 0;
        tableYOffset = 0;
        Resources.loadGameResources();
        for (int i2 = 0; i2 < 5; ++i2) {
            Game.players[i2].cards[0] = new Card(0, 0);
            Game.players[i2].cards[0].setDistrib(true);
            Game.players[i2].cards[1] = new Card(0, 0);
            Game.players[i2].cards[1].setDistrib(true);
            Game.tableCards[i2] = new Card(0, 0);
            Game.tableCards[i2].setDistrib(true);
        }
        state.loadGame(this);
        char[] playerSex = new char[4];
        for (int i3 = 1; i3 < 5; ++i3) {
            playerSex[i3 - 1] = Game.players[i3].nameIndx <= 7 ? 109 : 119;
        }
        Resources.loadPlayerFaces(playerSex);
        if (mode == 2) {
            mode = 9;
        }
        if (mode == 13) {
            mode = 8;
        }
        if ((old_mode = mode) == 12) {
            old_mode = 1;
        }
        mode = 12;
        iSelectedAction = 0;
    }

    private void resetDistributionCoordinates() {
        iDistributionX = 0;
        iDistributionY = 0;
    }

    public boolean bojkoAlreadyIs(int ix) {
        boolean value = false;
        for (int i2 = 0; i2 < ix; ++i2) {
            if (Game.players[i2].iPlayingStyle != 4) continue;
            value = true;
        }
        return value;
    }

    public int createStyle(int i2) {
        int style = 0;
        int random = Common.getRandomUInt(10);
        switch (GameHandling.iLevel) {
            case 0: {
                if (this.bojkoAlreadyIs(i2)) {
                    random = 4;
                }
                if (random < 5) {
                    style = 0;
                    break;
                }
                style = 4;
                break;
            }
            case 1: {
                if (random < 3) {
                    style = 0;
                    break;
                }
                if (random < 5) {
                    style = 4;
                    break;
                }
                style = 1;
                break;
            }
            case 2: {
                if (random < 3) {
                    style = 0;
                    break;
                }
                if (random < 6) {
                    style = 1;
                    break;
                }
                if (random < 8) {
                    style = 4;
                    break;
                }
                style = 3;
                break;
            }
            case 3: {
                if (random < 2) {
                    style = 0;
                    break;
                }
                if (random < 4) {
                    style = 3;
                    break;
                }
                if (random < 6) {
                    style = 4;
                    break;
                }
                if (random < 8) {
                    style = 1;
                    break;
                }
                style = 2;
                break;
            }
            case 4: {
                if (random < 2) {
                    style = 4;
                    break;
                }
                if (random < 4) {
                    style = 3;
                    break;
                }
                if (random < 6) {
                    style = 2;
                    break;
                }
                if (random < 8) {
                    style = 1;
                    break;
                }
                style = 5;
                break;
            }
            case 5: {
                if (random < 5) {
                    style = 5;
                    break;
                }
                if (random < 7) {
                    style = 3;
                    break;
                }
                if (random < 8) {
                    style = 2;
                    break;
                }
                if (random < 9) {
                    style = 1;
                    break;
                }
                style = 4;
                break;
            }
            case 6: {
                if (random < 5) {
                    style = 5;
                    break;
                }
                if (random < 7) {
                    style = 3;
                    break;
                }
                if (random < 8) {
                    style = 2;
                    break;
                }
                style = 4;
                break;
            }
            case 7: {
                style = random < 4 ? 5 : (random < 7 ? 3 : 2);
            }
        }
        return style;
    }

    public void createPlayers() {
        char[] playerSex = new char[4];
        Game.players[0] = new PokerPlayer(GameHandling.iMoneyPerPlayer);
        for (int i2 = 1; i2 < 5; ++i2) {
            int style = this.createStyle(i2);
            int tmpPlayerNameIndex = Common.getRandomUInt(16);
            while (i2 > 0 && this.checkNames(i2, tmpPlayerNameIndex)) {
                tmpPlayerNameIndex = Common.getRandomUInt(16);
            }
            Game.players[i2] = new PokerPlayer(tmpPlayerNameIndex, GameHandling.iMoneyPerPlayer, style);
            playerSex[i2 - 1] = tmpPlayerNameIndex <= 7 ? 109 : 119;
        }
        Resources.loadPlayerFaces(playerSex);
        iDealerIndex = 0;
    }

    private boolean checkNames(int count, int value) {
        for (int i2 = 1; i2 < count; ++i2) {
            if (value != Game.players[i2].nameIndx) continue;
            return true;
        }
        return false;
    }

    public int getActualMode() {
        return mode;
    }

    public String getActualModeName() {
        return "Screen game";
    }

    public void invokeGameMenu() {
        state.saveGame(this);
        state.saveTable(this);
        iSelectedSubMenuItem = 0;
        old_mode = mode;
        if (old_mode == 2 || old_mode == 6) {
            old_mode = actualPlayer != 0 ? 3 : 10;
        }
        if (mode == 2) {
            this.skipCardDistribution();
        }
        mode = 6;
        XX.soundManager.Stop();
        canvas.repaint();
        canvas.serviceRepaints();
    }

    public void update(long tick) {
        if (Game.iRaise == 0) {
            if (iPlayerBet < Game.iBlind) {
                iPlayerBet = Game.iBlind;
            }
        } else if (iPlayerBet < Game.iRaise) {
            iPlayerBet = Game.iRaise;
        }
        switch (mode) {
            case 0: {
                Resources.loadGameResources();
                mode = 12;
                iSelectedAction = 1;
                canvas.repaint();
                canvas.serviceRepaints();
                if (Settings.bMusic) {
                    XX.soundManager.Stop();
                    XX.soundManager.SetSoundOn(true);
                    XX.soundManager.Play(XX.MUSIC_MENU_ID, -1);
                    break;
                }
                XX.soundManager.Stop();
                XX.soundManager.SetSoundOn(false);
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                canvas.repaint();
                canvas.serviceRepaints();
                break;
            }
            case 1: {
                if (!this.isEndOfGame()) {
                    iWaitTime = DEFAULT_WAIT_TIME;
                    Game.nextRound();
                    this.generateCards();
                    iPutBlinds = 0;
                    ScreenGame.setBlinds();
                    this.iShownCardsCount = 0;
                    canvas.repaint();
                    canvas.serviceRepaints();
                    actualPlayer = iDealerIndex < 4 ? iDealerIndex + 1 : 0;
                    while (true) {
                        if (Game.players[ScreenGame.actualPlayer].playing) break;
                        if (++actualPlayer != 5) continue;
                        actualPlayer = 0;
                    }
                    iDistributionRound = 0;
                    step = 0;
                    mode = 2;
                    break;
                }
                if (playerPanelYOffset != 0) {
                    mode = 11;
                }
                mode = 8;
                iSelectedAction = 0;
                if (Game.players[0].iChips == 0) {
                    state.saveGame(this);
                    state.saveTable(this);
                    break;
                }
                state.saveGame(this);
                state.saveTable(this);
                iSelectedAction = 0;
                break;
            }
            case 2: {
                iPutBlinds = 0;
                if (iDistributionRound == 3) {
                    iPutBlinds = 0;
                    mode = 9;
                    break;
                }
                canvas.repaint();
                canvas.serviceRepaints();
                if (!bSkipOn) break;
                this.skipCardDistribution();
                break;
            }
            case 9: {
                tableYOffset = 0;
                playerPanelYOffset = 0;
                if (iPutBlinds < 2) {
                    this.putBlinds();
                } else {
                    step = 0;
                    mode = 3;
                    if (actualPlayer == 0) {
                        mode = 10;
                        iSelectedAction = 0;
                    }
                }
                canvas.repaint();
                canvas.serviceRepaints();
                break;
            }
            case 3: {
                if (Game.game_mode < 4) {
                    ScreenGame.playingRound();
                }
                if (Game.game_mode == 4) {
                    Game.checkPlayersHands();
                    Game.evaluation();
                    mode = 5;
                    canvas.repaint();
                    canvas.serviceRepaints();
                }
                canvas.repaint();
                canvas.serviceRepaints();
                break;
            }
            case 4: {
                if (actualPlayer != 0) {
                    mode = 3;
                    return;
                }
                if (playerPanelYOffset == 0 || tableYOffset == 0) {
                    mode = 10;
                    return;
                }
                if (bPlusPressed) {
                    ++iKeyPressedDelay;
                    if (Game.players[0].iPlayerAction == 1) {
                        if (iPlayerBet + 100 < Game.players[0].iChips && iKeyPressedDelay == 5) {
                            iPlayerBet += 100;
                            iKeyPressedDelay = 0;
                        }
                    }
                    if (Game.players[0].iPlayerAction == 2) {
                        if (iPlayerBet + Game.iBetPerPlayer - Game.players[0].iActualBet + 100 < Game.players[0].iChips && iKeyPressedDelay == 5) {
                            iPlayerBet += 100;
                            iKeyPressedDelay = 0;
                        }
                    }
                }
                if (bMinusPressed) {
                    ++iKeyPressedDelay;
                    if (Game.players[0].iPlayerAction == 1) {
                        if (iPlayerBet - 100 > Game.iBlind && iKeyPressedDelay == 5) {
                            iPlayerBet -= 100;
                            iKeyPressedDelay = 0;
                        }
                    }
                    if (Game.players[0].iPlayerAction == 2) {
                        if (iPlayerBet - 100 > Game.iRaise && iKeyPressedDelay == 5) {
                            iPlayerBet -= 100;
                            iKeyPressedDelay = 0;
                        }
                    }
                }
                canvas.repaint();
                canvas.serviceRepaints();
            }
            case 5: 
            case 7: 
            case 8: {
                canvas.repaint();
                canvas.serviceRepaints();
                break;
            }
            case 6: {
                canvas.repaint();
                canvas.serviceRepaints();
                break;
            }
            case 10: {
                if (Game.players[0].fold) {
                    mode = 3;
                    return;
                }
                for (int i2 = 0; i2 < 5; ++i2) {
                    Game.players[i2].active = false;
                }
                int buttons = 3;
                playerPanelYOffset = playerPanelYOffset < buttons * Resources.iBorderOffH ? (playerPanelYOffset += Resources.imgPlayerPanel.getHeight() / 4) : buttons * Resources.iBorderOffH;
                tableYOffset = tableYOffset < (Defines.HEIGHT - Resources.iTableH) / 2 - Resources.iTableH / 3 - Resources.iUpperPanelH ? (tableYOffset += Resources.imgPlayerPanel.getHeight() / 4) : (Defines.HEIGHT - Resources.iTableH) / 2 - Resources.iTableH / 3 - Resources.iUpperPanelH;
                if (playerPanelYOffset == buttons * Resources.iBorderOffH && tableYOffset == (Defines.HEIGHT - Resources.iTableH) / 2 - Resources.iTableH / 3 - Resources.iUpperPanelH) {
                    mode = 4;
                    Game.players[0].active = true;
                    iSelectedAction = 0;
                }
                canvas.repaint();
                canvas.serviceRepaints();
                break;
            }
            case 11: {
                for (int i3 = 0; i3 < 5; ++i3) {
                    Game.players[i3].active = false;
                }
                playerPanelYOffset = playerPanelYOffset >= 0 ? (playerPanelYOffset -= Resources.imgPlayerPanel.getHeight() / 4) : 0;
                tableYOffset = tableYOffset > 0 ? (tableYOffset -= Resources.imgPlayerPanel.getHeight() / 4) : 0;
                if (playerPanelYOffset == 0 && tableYOffset == 0) {
                    this.continuePlaying();
                }
                canvas.repaint();
                canvas.serviceRepaints();
            }
        }
    }

    public boolean isEndOfGame() {
        int iPlayingCPUPlayers = 4;
        for (int i2 = 4; i2 > 0; --i2) {
            if (Game.players[i2].iChips != 0) continue;
            --iPlayingCPUPlayers;
        }
        return Game.players[0].iChips == 0 || iPlayingCPUPlayers == 0;
    }

    public static void setBlinds() {
        actualPlayer = iDealerIndex;
        ScreenGame.nextPlayer();
        iSBIndex = actualPlayer;
        ScreenGame.nextPlayer();
        iBBIndex = actualPlayer;
    }

    public void putBlinds() {
        Game.players[ScreenGame.actualPlayer].active = false;
        if (iPutBlinds == 0) {
            actualPlayer = iDealerIndex;
            ScreenGame.nextPlayer();
            Game.players[ScreenGame.actualPlayer].active = true;
            iSBIndex = actualPlayer;
            if (Game.players[ScreenGame.actualPlayer].iChips <= Game.iBlind / 2) {
                Game.addToPot(Game.players[ScreenGame.actualPlayer].iChips);
                Game.players[actualPlayer].addBet(Game.players[ScreenGame.actualPlayer].iChips);
                Game.players[ScreenGame.actualPlayer].iChips = 0;
                Game.players[ScreenGame.actualPlayer].bAllIn = true;
            } else {
                Game.players[actualPlayer].removeChips(Game.iBlind / 2);
                Game.addToPot(Game.iBlind / 2);
                Game.players[actualPlayer].addBet(Game.iBlind / 2);
            }
            canvas.repaint();
            canvas.serviceRepaints();
            ScreenGame.nextPlayer();
            if (!bSkipOn) {
                ScreenGame.waiter();
            }
        }
        if (iPutBlinds == 1) {
            Game.players[ScreenGame.actualPlayer].active = true;
            iBBIndex = actualPlayer;
            if (Game.players[ScreenGame.actualPlayer].iChips <= Game.iBlind) {
                Game.addToPot(Game.players[ScreenGame.actualPlayer].iChips);
                Game.players[actualPlayer].addBet(Game.players[ScreenGame.actualPlayer].iChips);
                Game.players[ScreenGame.actualPlayer].iChips = 0;
                Game.players[ScreenGame.actualPlayer].bAllIn = true;
            } else {
                Game.players[actualPlayer].removeChips(Game.iBlind);
                Game.addToPot(Game.iBlind);
                Game.players[actualPlayer].addBet(Game.iBlind);
            }
            canvas.repaint();
            canvas.serviceRepaints();
            ScreenGame.nextPlayer();
            if (!bSkipOn) {
                ScreenGame.waiter();
            }
        }
        ++iPutBlinds;
    }

    public static void waiter() {
        int start = (int)System.currentTimeMillis() / 1000;
        int end = (int)System.currentTimeMillis() / 1000;
        while (end - start < iWaitTime) {
            end = (int)System.currentTimeMillis() / 1000;
        }
    }

    public static void playingRound() {
        if (Game.compareBets() && step >= 5) {
            ScreenGame.nextGameMode();
            return;
        }
        System.out.println("aktivny hrac: " + actualPlayer);
        int i2 = 1;
        while (true) {
            if (i2 >= Game.players.length) break;
            Game.players[i2].active = actualPlayer == i2;
            ++i2;
        }
        Game.players[0].active = false;
        if (actualPlayer != 0 && mode != 3) {
            mode = 3;
        }
        if (step == 0) {
            Game.checkTable();
            Game.checkPlayersHands();
        }
        if (actualPlayer == 0) {
            if (!Game.players[0].fold) {
                System.out.println("****************************************\nplayer 0: ");
                mode = 10;
                iSelectedAction = 0;
                Game.players[0].iPlayerAction = 0;
                System.out.println("raise: " + Game.iRaise + " -------------------------------------------------------");
                iPlayerBet = Game.iRaise == 0 ? Game.iBlind : Game.iRaise;
                return;
            }
        }
        canvas.repaint();
        canvas.serviceRepaints();
        if (!bSkipOn) {
            ScreenGame.waiter();
        }
        if (actualPlayer == 0) {
            ScreenGame.playingRound();
            return;
        }
        Game.calculatePlayerMove(actualPlayer);
        canvas.repaint();
        canvas.serviceRepaints();
        ScreenGame.waiter();
        ScreenGame.nextPlayer();
        i2 = 1;
        while (true) {
            if (i2 >= Game.players.length) break;
            Game.players[i2].active = actualPlayer == i2;
            ++i2;
        }
        if (Game.compareBets() && step >= 5) {
            ScreenGame.nextGameMode();
            return;
        }
    }

    public static void nextGameMode() {
        if (Game.game_mode < 4) {
            ++Game.game_mode;
            actualPlayer = iDealerIndex;
            bNextGameMode = true;
            canvas.repaint();
            canvas.serviceRepaints();
            ScreenGame.waiter();
            ScreenGame.nextPlayer();
        } else if (mode == 3 || mode == 4) {
            mode = 5;
            int i2 = 0;
            while (true) {
                if (i2 < Game.players.length) {
                    Game.players[i2].active = false;
                    ++i2;
                    continue;
                }
                break;
            }
        } else if (mode == 5) {
            mode = 7;
        } else {
            mode = 1;
            ScreenGame.nextDealer();
            ScreenGame.setBlinds();
        }
        step = 0;
        Game.nextGameMode();
    }

    public static void nextDealer() {
        iDealerIndex = iDealerIndex < 4 ? ++iDealerIndex : 0;
        if (!Game.players[ScreenGame.iDealerIndex].playing) {
            ScreenGame.nextDealer();
        }
    }

    private void TESTgenerateCards() {
        int i2;
        this.cardArray = new Card[15];
        this.cardArray[0] = new Card(0, 1);
        this.cardArray[1] = new Card(0, 2);
        this.cardArray[2] = new Card(3, 1);
        this.cardArray[3] = new Card(2, 2);
        this.cardArray[4] = new Card(3, 3);
        this.cardArray[5] = new Card(2, 2);
        this.cardArray[6] = new Card(3, 0);
        this.cardArray[7] = new Card(2, 1);
        this.cardArray[8] = new Card(3, 2);
        this.cardArray[9] = new Card(2, 1);
        this.cardArray[10] = new Card(0, 3);
        this.cardArray[11] = new Card(0, 4);
        this.cardArray[12] = new Card(4, 1);
        this.cardArray[13] = new Card(10, 2);
        this.cardArray[14] = new Card(7, 2);
        int cardIndx = 0;
        for (i2 = 0; i2 < 5; ++i2) {
            if (Game.players[i2].isPlaying()) {
                Game.players[i2].setCards(this.cardArray[cardIndx], this.cardArray[cardIndx + 1]);
            }
            cardIndx += 2;
        }
        System.out.println("stol: ");
        for (i2 = 0; i2 < 5; ++i2) {
            Game.tableCards[i2] = this.cardArray[cardIndx + i2];
            System.out.print(this.cardArray[cardIndx + i2].getCardString() + ",  ");
        }
        this.cardArray = null;
        System.out.println("");
        System.gc();
    }

    private void generateCards() {
        int i2;
        int cardCount = 7;
        for (i2 = 0; i2 < 5; ++i2) {
            if (!Game.players[i2].isPlaying()) continue;
            cardCount += 2;
        }
        this.cardArray = new Card[cardCount];
        for (i2 = 0; i2 < cardCount; ++i2) {
            Card tmpCard = new Card(Common.getRandomUInt(13), Common.getRandomUInt(4));
            while (i2 > 0 && this.checkCards(i2, tmpCard)) {
                tmpCard = new Card(Common.getRandomUInt(13), Common.getRandomUInt(4));
            }
            this.cardArray[i2] = tmpCard;
        }
        int cardIndx = 0;
        for (i2 = 0; i2 < 5; ++i2) {
            if (!Game.players[i2].isPlaying()) continue;
            Game.players[i2].setCards(this.cardArray[cardIndx], this.cardArray[cardIndx + 1]);
            cardIndx += 2;
        }
        System.out.println("stol: ");
        for (i2 = 0; i2 < 5; ++i2) {
            Game.tableCards[i2] = this.cardArray[cardIndx + i2];
            System.out.print(this.cardArray[cardIndx + i2].getCardString() + ",  ");
        }
        this.cardArray = null;
        System.gc();
    }

    private boolean checkCards(int count, Card card) {
        for (int i2 = 0; i2 < count; ++i2) {
            if (!card.getCardString().equals(this.cardArray[i2].getCardString())) continue;
            return true;
        }
        return false;
    }

    public void paint(Graphics g2) {
        switch (mode) {
            case 0: {
                this.paintGameLoading(g2);
                break;
            }
            case 12: {
                Resources.paintBackground(g2);
                g2.drawImage(Resources.imgTable, (Defines.WIDTH - Resources.iTableW) / 2, (Defines.HEIGHT - Resources.iTableH) / 2 - tableYOffset, 0);
                this.paintPlayers(g2);
                this.paintRaster(g2);
                this.paintWelcomeScreen(g2);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this.paintGame(g2);
                Game.game_mode = 0;
                if (iDistributionRound >= 3) break;
                this.paintCardDistribution(g2);
                break;
            }
            case 9: {
                tableYOffset = 0;
                playerPanelYOffset = 0;
            }
            case 3: 
            case 4: 
            case 10: 
            case 11: {
                this.paintGame(g2);
                break;
            }
            case 5: {
                this.paintGame(g2);
                this.paintWin(g2);
                break;
            }
            case 6: {
                this.paintPause(g2);
                break;
            }
            case 7: {
                Resources.paintControls(g2, 2);
                this.paintStats(g2);
                this.paintUpperSheet(g2);
                break;
            }
            case 8: {
                this.paintGame(g2);
                this.paintGameOver(g2);
                break;
            }
            case 13: {
                this.paintGame(g2);
                this.paintReallyQuit(g2);
                Resources.paintControls(g2, 10);
                break;
            }
            case 14: {
                this.paintGame(g2);
                this.paintRaster(g2);
                this.paintFinalScore(g2);
            }
        }
        g2.setColor(0);
        g2.fillRect(0, Defines.HEIGHT, Defines.WIDTH, Defines.HEIGHT);
    }

    /*
     * Unable to fully structure code
     */
    public void paintFinalScore(Graphics g) {
        g.drawImage(Resources.imgUpperPanel, 0, 0, 0);
        count = Defines.WIDTH / Resources.iBorderOffW - 2;
        Resources.paintBorder(2, true, count, (Defines.WIDTH - count * Resources.iBorderOffW) / 2, (Resources.iUpperPanelH - Resources.iBorderOffH) / 2, g);
        iPosBordY = (Resources.iUpperPanelH - Resources.iBorderOffH) / 2;
        message = ScreenGame.sTotScore + ": " + (Game.iThisRoundScore + GameHandling.iScore);
        Fonts.drawStr(message, (Defines.WIDTH - Fonts.strWidth(message)) / 2, iPosBordY + (Resources.iBorderOffH - Resources.iFont1H) / 2, g);
        xParts = Defines.WIDTH / Resources.iInfoBarW - 2;
        yParts = 14;
        Resources.paintMenuBG(xParts, yParts, ScreenGame.sScore + ": ", g);
        iPosX = (Defines.WIDTH - Resources.iInfoBarW * xParts) / 2;
        iPosY = (Defines.HEIGHT - Resources.iInfoBarH * yParts) / 2;
        iWidth = Resources.iInfoBarW * 12;
        iHeight = Resources.iInfoBarH * 12;
        sValue = "";
        switchIndex = false;
        infoString = "";
        for (i = 0; i < 7; ++i) {
            block14: {
                block13: {
                    if (i == 0) {
                        infoString = ScreenGame.sRewards[0] + ":";
                        sValue = Game.bPointsForFold != false ? "+ 2" : "+ 0";
                    }
                    if (i == 1) {
                        infoString = ScreenGame.sRewards[1] + ":";
                        sValue = Game.players[0].bWin != false ? "+ 4" : "+ 0";
                    }
                    if (i != 2) break block13;
                    infoString = ScreenGame.sRewards[2] + ":";
                    if (!Game.players[0].bWin) ** GOTO lbl-1000
                    if (!Game.bWinByFold) {
                        sValue = "+ " + Game.players[0].getComb() + "";
                    } else lbl-1000:
                    // 2 sources

                    {
                        sValue = "+ 0";
                    }
                }
                if (i != 3) break block14;
                infoString = ScreenGame.sRewards[3] + ":";
                if (!Game.players[0].bWin) ** GOTO lbl-1000
                if (Game.bWasAllIn) {
                    sValue = "+ 10";
                } else lbl-1000:
                // 2 sources

                {
                    sValue = "+ 0";
                }
            }
            if (i == 4) {
                infoString = ScreenGame.sRewards[4] + ":";
                sValue = Game.iMultiplic == 1 ? "X " + Game.iMultiplic + "" : "X " + (Game.iMultiplic - 1) + "";
            }
            if (i == 5) {
                infoString = "FOLD";
                if (Game.players[0].fold) {
                    sValue = "- 1";
                } else {
                    sValue = "  ";
                    infoString = "";
                }
            }
            if (i == 6) {
                infoString = ScreenGame.sRewards[5] + ":";
                sValue = "= " + Game.iThisRoundScore + "";
            }
            if (i < 6) {
                Fonts.drawStr(infoString, iPosX + 15, iPosY + Resources.iFont1H * 2 + (i + 1) * iHeight / 10, g);
                Fonts.drawStr(sValue, iPosX + 15 + iWidth / 5 * 4, iPosY + Resources.iFont1H * 2 + (i + 1) * iHeight / 10, g);
                continue;
            }
            Fonts.drawStr(infoString, iPosX + 15, iPosY + Resources.iFont1H * 2 + (i + 1) * iHeight / 10 + 15, g);
            Fonts.drawStr(sValue, iPosX + 15 + iWidth / 5 * 4, iPosY + Resources.iFont1H * 2 + (i + 1) * iHeight / 10 + 15, g);
        }
    }

    public void paintReallyQuit(Graphics g2) {
        Resources.paintBackground(g2);
        g2.drawImage(Resources.imgUpperPanel, 0, 0, 0);
        int count = Defines.WIDTH / Resources.iBorderOffW - 2;
        Resources.paintBorder(2, true, count, (Defines.WIDTH - count * Resources.iBorderOffW) / 2, (Resources.iUpperPanelH - Resources.iBorderOffH) / 2, g2);
        int iPosBordY = (Resources.iUpperPanelH - Resources.iBorderOffH) / 2;
        String message = sTotScore + ": " + GameHandling.iScore;
        Fonts.drawStr(message, (Defines.WIDTH - Fonts.strWidth(message)) / 2, iPosBordY + (Resources.iBorderOffH - Resources.iFont1H) / 2, g2);
        int xParts = Defines.WIDTH / Resources.iInfoBarW - 2;
        int yParts = 13;
        Resources.paintMenuBG(xParts, yParts, sReallyQuit, g2);
        int iPosX = (Defines.WIDTH - Resources.iInfoBarW * xParts) / 2;
        int iPosY = (Defines.HEIGHT - Resources.iInfoBarH * yParts) / 2 + Resources.iFont1H;
        int iWidth = Resources.iInfoBarW * 12;
        int iHeight = Resources.iInfoBarH * 12;
        String sValue = "";
        boolean switchIndex = false;
        String infoString = "";
        for (int i2 = 0; i2 < 6; ++i2) {
            infoString = quitMessage[i2];
            Fonts.drawStr(infoString, (Defines.WIDTH - Fonts.strWidth(infoString)) / 2, iPosY + (i2 + 1) * iHeight / 8, g2);
        }
    }

    public void paintWelcomeScreen(Graphics g2) {
        g2.drawImage(Resources.imgUpperPanel, 0, 0, 0);
        int count = Defines.WIDTH / Resources.iBorderOffW - 2;
        Resources.paintBorder(2, true, count, (Defines.WIDTH - count * Resources.iBorderOffW) / 2, (Resources.iUpperPanelH - Resources.iBorderOffH) / 2, g2);
        int iPosBordY = (Resources.iUpperPanelH - Resources.iBorderOffH) / 2;
        String message = sTotScore + ": " + GameHandling.iScore;
        Fonts.drawStr(message, (Defines.WIDTH - Fonts.strWidth(message)) / 2, iPosBordY + (Resources.iBorderOffH - Resources.iFont1H) / 2, g2);
        int xParts = Defines.WIDTH / Resources.iInfoBarW - 2;
        int yParts = 15;
        Resources.paintMenuBG(xParts, yParts, sWelcome + " " + (GameHandling.iTableNr + 1), g2);
        int iPosX = (Defines.WIDTH - Resources.iInfoBarW * xParts) / 2;
        int iPosY = (Defines.HEIGHT - Resources.iInfoBarH * yParts) / 2;
        int iWidth = Resources.iInfoBarW * 12;
        int iHeight = Resources.iInfoBarH * 12;
        String sValue = "";
        boolean switchIndex = false;
        String infoString = "";
        for (int i2 = 0; i2 < 2; ++i2) {
            if (i2 == 0) {
                infoString = sCash + ":";
                sValue = GameHandling.iTableInputs[GameHandling.iLevel] + "$";
            } else {
                infoString = "BLIND:";
                sValue = GameHandling.iBigBlinds[GameHandling.iLevel] / 2 + "$, " + GameHandling.iBigBlinds[GameHandling.iLevel] + "$";
            }
            Fonts.drawStr(infoString, iPosX + 15, iPosY + (i2 + 1) * iHeight / 5 + 15, g2);
            Fonts.drawStr(sValue, iPosX + 15 + iWidth / 5 * 2, iPosY + (i2 + 1) * iHeight / 5 + 15, g2);
        }
        int iPosXButt = (Defines.WIDTH - Resources.iInfoBarW * xParts) / 2;
        int iPosYButt = (Defines.HEIGHT - Resources.iInfoBarH * yParts) / 2;
        if (iSelectedAction == 0) {
            iSelectedAction = 1;
        }
        if (iSelectedAction == 1) {
            Resources.sprIconsON.setFrame(0);
            Resources.sprIconsON.setPosition(iPosXButt + Resources.iIconsW / 4, Defines.HEIGHT - iPosYButt - Resources.iIconsH - Resources.iIconsW / 4);
            Resources.sprIconsON.paint(g2);
        } else {
            Resources.sprIconsOFF.setFrame(0);
            Resources.sprIconsOFF.setPosition(iPosXButt + Resources.iIconsW / 4, Defines.HEIGHT - iPosYButt - Resources.iIconsH - Resources.iIconsW / 4);
            Resources.sprIconsOFF.paint(g2);
        }
        if (iSelectedAction == 2) {
            Resources.sprIconsON.setFrame(3);
            Resources.sprIconsON.setPosition(Defines.WIDTH - iPosXButt - Resources.iIconsW - Resources.iIconsW / 4, Defines.HEIGHT - iPosYButt - Resources.iIconsH - Resources.iIconsW / 4);
            Resources.sprIconsON.paint(g2);
        } else {
            Resources.sprIconsOFF.setFrame(3);
            Resources.sprIconsOFF.setPosition(Defines.WIDTH - iPosXButt - Resources.iIconsW - Resources.iIconsW / 4, Defines.HEIGHT - iPosYButt - Resources.iIconsH - Resources.iIconsW / 4);
            Resources.sprIconsOFF.paint(g2);
        }
    }

    public void paintGameOver(Graphics g2) {
        Resources.paintBackground(g2);
        g2.drawImage(Resources.imgUpperPanel, 0, 0, 0);
        int count = Defines.WIDTH / Resources.iBorderOffW;
        Resources.paintBorder(2, true, count, (Defines.WIDTH - count * Resources.iBorderOffW) / 2, (Resources.iUpperPanelH - Resources.iBorderOffH) / 2, g2);
        int iPosBordY = (Resources.iUpperPanelH - Resources.iBorderOffH) / 2;
        String message = sTotScore + ": " + GameHandling.iScore;
        Fonts.drawStr(message, (Defines.WIDTH - Fonts.strWidth(message)) / 2, iPosBordY + (Resources.iBorderOffH - Resources.iFont1H) / 2, g2);
        int xParts = Defines.WIDTH / Resources.iInfoBarW - 2;
        int yParts = (Defines.HEIGHT - Resources.iBorderOffH - Resources.iIconsH) / Resources.iInfoBarH - 2;
        if (Defines.HEIGHT > 300) {
            yParts = 15;
        }
        if (Game.players[0].iChips == 0) {
            Resources.paintMenuBG(xParts, yParts, sLose, g2);
        } else {
            Resources.paintMenuBG(xParts, yParts, sCongrat, g2);
        }
        if (Defines.WIDTH > 130) {
            if (Game.players[0].iChips == 0) {
                g2.drawImage(Resources.imgGameOverLoos, (Defines.WIDTH - Resources.iGameOverLoosW) / 2, (Defines.HEIGHT - Resources.iGameOverLoosH) / 2 + Resources.iBorderOffH - Resources.iFont1H, 0);
            } else {
                g2.drawImage(Resources.imgGameOverWin, (Defines.WIDTH - Resources.iGameOverWinW) / 2, (Defines.HEIGHT - Resources.iGameOverWinH) / 2 + Resources.iBorderOffH - Resources.iFont1H, 0);
            }
        }
        int iPosX = (Defines.WIDTH - Resources.iInfoBarW * xParts) / 2;
        int iPosY = (Defines.HEIGHT - Resources.iInfoBarH * yParts) / 2;
        int iWidth = Resources.iInfoBarW * 12;
        int iHeight = Resources.iInfoBarH * 12;
        String sValue = "";
        boolean switchIndex = false;
        String infoString = "";
        for (int i2 = 0; i2 < 3; ++i2) {
            if (i2 == 0) {
                infoString = Game.players[0].iChips == 0 ? buyMore[0] : playOnNext[0];
            }
            if (i2 == 1) {
                infoString = Game.players[0].iChips == 0 ? buyMore[1] : playOnNext[1];
            }
            if (i2 == 2) {
                infoString = Game.players[0].iChips == 0 ? buyMore[2] : playOnNext[2];
            }
            Fonts.drawStr(infoString, (Defines.WIDTH - Fonts.strWidth(infoString)) / 2, iPosY + (i2 + 1) * Resources.iFont1H + Resources.LINE_OFFSET, g2);
        }
        int iPosXButt = (Defines.WIDTH - Resources.iInfoBarW * xParts) / 2;
        int iPosYButt = (Defines.HEIGHT - Resources.iInfoBarH * yParts) / 2;
        if (iSelectedAction == 0) {
            if (Game.players[0].iChips == 0) {
                Resources.sprIconsON.setFrame(9);
            } else {
                Resources.sprIconsON.setFrame(0);
            }
            Resources.sprIconsON.setPosition(iPosXButt + Resources.iIconsW / 4, Defines.HEIGHT - iPosYButt - Resources.iIconsH - Resources.iIconsW / 4);
            Resources.sprIconsON.paint(g2);
        } else {
            if (Game.players[0].iChips == 0) {
                Resources.sprIconsOFF.setFrame(9);
            } else {
                Resources.sprIconsOFF.setFrame(0);
            }
            Resources.sprIconsOFF.setPosition(iPosXButt + Resources.iIconsW / 4, Defines.HEIGHT - iPosYButt - Resources.iIconsH - Resources.iIconsW / 4);
            Resources.sprIconsOFF.paint(g2);
        }
        if (Game.players[0].iChips == 0) {
            if (iSelectedAction == 1) {
                Resources.sprIconsON.setFrame(4);
                Resources.sprIconsON.setPosition((Defines.WIDTH - Resources.iIconsW) / 2, Defines.HEIGHT - iPosYButt - Resources.iIconsH - Resources.iIconsW / 4);
                Resources.sprIconsON.paint(g2);
            } else {
                Resources.sprIconsOFF.setFrame(4);
                Resources.sprIconsOFF.setPosition((Defines.WIDTH - Resources.iIconsW) / 2, Defines.HEIGHT - iPosYButt - Resources.iIconsH - Resources.iIconsW / 4);
                Resources.sprIconsOFF.paint(g2);
            }
        }
        if (iSelectedAction == 2) {
            Resources.sprIconsON.setFrame(3);
            Resources.sprIconsON.setPosition(Defines.WIDTH - iPosXButt - Resources.iIconsW - Resources.iIconsW / 4, Defines.HEIGHT - iPosYButt - Resources.iIconsH - Resources.iIconsW / 4);
            Resources.sprIconsON.paint(g2);
        } else {
            Resources.sprIconsOFF.setFrame(3);
            Resources.sprIconsOFF.setPosition(Defines.WIDTH - iPosXButt - Resources.iIconsW - Resources.iIconsW / 4, Defines.HEIGHT - iPosYButt - Resources.iIconsH - Resources.iIconsW / 4);
            Resources.sprIconsOFF.paint(g2);
        }
    }

    public void paintWin(Graphics g2) {
        String sWinMessage = "";
        int[] iWinnerID = new int[5];
        int iWinnersCount = 0;
        if (Game.players[0].bWin) {
            Resources.sprWin.setFrame(iWinFrame >> 1);
            Resources.sprWin.setPosition((Defines.WIDTH - Resources.iWinW) / 2, (Defines.HEIGHT - Resources.iTableH + Resources.iUpperPanelH) / 2 / 2);
            Resources.sprWin.paint(g2);
            if (++iWinFrame > 19) {
                iWinFrame = 0;
            }
        }
        for (int i2 = 0; i2 < 5; ++i2) {
            if (!Game.players[i2].bWin) continue;
            iWinnerID[iWinnersCount] = i2;
            ++iWinnersCount;
        }
        sWinMessage = iWinnersCount == 1 ? (iWinnerID[0] > 0 ? this.playerNames[Game.players[iWinnerID[0]].nameIndx] + " " + sWins + " " + (Game.players[iWinnerID[0]].iRoundReward + Game.players[iWinnerID[0]].iActualBet) + " $" : sPlayer + " " + sWins + " " + (Game.players[iWinnerID[0]].iRoundReward + Game.players[iWinnerID[0]].iActualBet) + " $") : sSplit;
        Fonts.drawStr(sWinMessage, (Defines.WIDTH - Fonts.strWidth(sWinMessage)) / 2, (Defines.HEIGHT - Resources.iTableH + Resources.iUpperPanelH) / 2 + Resources.iFont1H / 2, g2);
    }

    public void paintStats(Graphics g2) {
        int i2;
        Resources.paintBackground(g2);
        this.paintTable(g2);
        this.paintPlayers(g2);
        if (!bSkipOn) {
            Resources.paintControls(g2, 2);
        } else {
            Resources.paintControls(g2, 3);
        }
        this.paintPlayerPanel(g2);
        this.paintBlinds(g2);
        Resources.paintMenuBG(15, 15, sRound + " " + Game.iRoundNr + ": " + sStats, g2);
        int iPosX = (Defines.WIDTH - Resources.iInfoBarW * 15) / 2;
        int iPosY = (Defines.HEIGHT - Resources.iInfoBarH * 15) / 2;
        int iWidth = Resources.iInfoBarW * 12;
        int iHeight = Resources.iInfoBarH * 12;
        int iChipsInRound = 0;
        int switchIndex = 0;
        int[] SortedPlayersByChips = new int[]{0, 1, 2, 3, 4};
        for (i2 = 1; i2 < 5; ++i2) {
            switchIndex = SortedPlayersByChips[i2];
            for (int j2 = i2; j2 > 0; --j2) {
                if (Game.players[SortedPlayersByChips[j2 - 1]].iChips >= Game.players[switchIndex].iChips) break;
                SortedPlayersByChips[j2] = SortedPlayersByChips[j2 - 1];
            }
            SortedPlayersByChips[j2] = switchIndex;
        }
        for (i2 = 0; i2 < 5; ++i2) {
            String playName = Game.players[SortedPlayersByChips[i2]].nameIndx == -1 ? sPlayer : this.playerNames[Game.players[SortedPlayersByChips[i2]].nameIndx];
            Fonts.drawStr(playName, iPosX + 15, iPosY + (i2 + 1) * iHeight / 5 + 15, g2);
            iChipsInRound = Game.players[SortedPlayersByChips[i2]].iRoundReward;
            String sChipsInRound = iChipsInRound < 0 ? iChipsInRound + "$" : "+" + iChipsInRound + "$";
            Fonts.drawStr(sChipsInRound, iPosX + 15 + iWidth / 5 * 2, iPosY + (i2 + 1) * iHeight / 5 + 15, g2);
            Fonts.drawStr(Game.players[SortedPlayersByChips[i2]].iChips + "$", iPosX + 15 + iWidth / 5 * 4, iPosY + (i2 + 1) * iHeight / 5 + 15, g2);
        }
    }

    public void paintRaster(Graphics g2) {
        int x2 = 0;
        for (int y2 = 0; y2 <= Defines.HEIGHT; y2 += Resources.iRasterH) {
            while (x2 <= Defines.WIDTH) {
                g2.drawImage(Resources.imgRaster, x2, y2, 0);
                x2 += Resources.iRasterW;
            }
            x2 = 0;
        }
    }

    public void paintPause(Graphics g2) {
        Resources.paintBackground(g2);
        this.paintTable(g2);
        this.paintPlayers(g2);
        this.paintPlayerPanel(g2);
        this.paintBlinds(g2);
        this.paintOptions(g2);
        Resources.paintControls(g2, 5);
        this.paintRaster(g2);
        this.paintUpperSheet(g2);
        Resources.paintMenuBG(12, 10, sGameMenu, g2);
        int iPosX = 0;
        int iPosY = 0;
        int x2 = (Defines.WIDTH - Resources.iBorderOnW * 8) / 2;
        int submenuPos = (Defines.HEIGHT - 1 * (Resources.iBorderOnH + Resources.MENU_BUTTONS_OFFSET)) / 2;
        for (int i2 = 0; i2 < 2; ++i2) {
            if (i2 == iSelectedSubMenuItem) {
                Resources.paintBorder(2, true, 8, x2, submenuPos + i2 * (Resources.iBorderOnH + Resources.MENU_BUTTONS_OFFSET), g2);
            } else {
                Resources.paintBorder(2, false, 8, x2, submenuPos + i2 * (Resources.iBorderOnH + Resources.MENU_BUTTONS_OFFSET), g2);
            }
            iPosX = (Defines.WIDTH - Fonts.strWidth(menuStrings[i2])) / 2;
            iPosY = submenuPos + i2 * (Resources.iBorderOnH + Resources.MENU_BUTTONS_OFFSET) + (Resources.iBorderOnH - Resources.iFont1H) / 2;
            Fonts.drawStr(menuStrings[i2], iPosX, iPosY, g2);
        }
    }

    public void paintGameLoading(Graphics g2) {
        g2.setColor(0);
        g2.fillRect(0, 0, Defines.WIDTH, Defines.HEIGHT);
        Resources.paintLoading(g2);
    }

    public void paintGame(Graphics g2) {
        Resources.paintBackground(g2);
        this.paintTable(g2);
        this.paintPlayers(g2);
        this.paintUpperSheet(g2);
        if (!bSkipOn) {
            Resources.paintControls(g2, 2);
        } else {
            Resources.paintControls(g2, 3);
        }
        this.paintPlayerPanel(g2);
        this.paintBlinds(g2);
        if (mode == 4 || mode == 11 || mode == 10) {
            this.paintOptions(g2);
        }
        g2.setColor(0);
        g2.fillRect(0, Defines.HEIGHT, Defines.WIDTH, Defines.HEIGHT);
    }

    public void paintOptions(Graphics g2) {
        int iPosY;
        int x2;
        int buttons;
        block21: {
            block20: {
                g2.setClip(0, 0, Defines.WIDTH, Defines.HEIGHT);
                buttons = 3;
                x2 = (Defines.WIDTH - Resources.iBorderOffW * 6) / 2;
                boolean iPosX = false;
                iPosY = Defines.HEIGHT - playerPanelYOffset;
                if (Game.players[0].iPlayerAction == 2) break block20;
                if (Game.players[0].iPlayerAction != 1) break block21;
            }
            if (iSelectedAction == 0) {
                Resources.sprPlusMinus.setFrame(1);
                Resources.sprPlusMinus.setPosition(x2 - Resources.iPlusMinusW + Resources.iPlusMinusW / 7, iPosY + Resources.iBorderOffH / 2);
                Resources.sprPlusMinus.paint(g2);
                Resources.sprPlusMinus.setFrame(0);
                Resources.sprPlusMinus.setPosition(x2 + Resources.iBorderOffW * 6 - Resources.iPlusMinusW / 7, iPosY + Resources.iBorderOffH / 2);
                Resources.sprPlusMinus.paint(g2);
            }
        }
        for (int i2 = 0; i2 < buttons; ++i2) {
            iPosY = Defines.HEIGHT - playerPanelYOffset;
            if (i2 == iSelectedAction) {
                Resources.paintBorder(2, true, 6, x2, iPosY + i2 * Resources.iBorderOffH, g2);
            } else {
                Resources.paintBorder(2, false, 6, x2, iPosY + i2 * Resources.iBorderOffH, g2);
            }
            iPosY = Defines.HEIGHT - playerPanelYOffset + i2 * Resources.iBorderOffH + (Resources.iBorderOffH - Resources.iFont1H) / 2;
            if (Game.players[0].iPlayerAction == 0) {
                if (Game.compareBets()) {
                    if (i2 == 0) {
                        Fonts.drawStr(actionStrings[0], (Defines.WIDTH - Fonts.strWidth(actionStrings[0])) / 2, iPosY, g2);
                    }
                    if (i2 == 1) {
                        Fonts.drawStr(actionStrings[2], (Defines.WIDTH - Fonts.strWidth(actionStrings[2])) / 2, iPosY, g2);
                    }
                    if (i2 == 2) {
                        Fonts.drawStr(actionStrings[4], (Defines.WIDTH - Fonts.strWidth(actionStrings[4])) / 2, iPosY, g2);
                    }
                } else {
                    if (i2 == 0) {
                        Fonts.drawStr(actionStrings[1], (Defines.WIDTH - Fonts.strWidth(actionStrings[1])) / 2, iPosY, g2);
                    }
                    if (i2 == 1) {
                        Fonts.drawStr(actionStrings[3], (Defines.WIDTH - Fonts.strWidth(actionStrings[3])) / 2, iPosY, g2);
                    }
                    if (i2 == 2) {
                        Fonts.drawStr(actionStrings[4], (Defines.WIDTH - Fonts.strWidth(actionStrings[4])) / 2, iPosY, g2);
                    }
                }
            }
            if (Game.players[0].iPlayerAction != 1) {
                if (Game.players[0].iPlayerAction != 2) continue;
            }
            if (i2 == 0) {
                Fonts.drawStr(iPlayerBet + " $", (Defines.WIDTH - Fonts.strWidth(iPlayerBet + " $")) / 2, iPosY, g2);
            }
            if (i2 == 1) {
                Fonts.drawStr(actionStrings[5], (Defines.WIDTH - Fonts.strWidth(actionStrings[5])) / 2, iPosY, g2);
            }
            if (i2 != 2) continue;
            Fonts.drawStr(sBack, (Defines.WIDTH - Fonts.strWidth(sBack)) / 2, iPosY, g2);
        }
        g2.setClip(0, 0, Defines.WIDTH * 2, Defines.HEIGHT * 2);
        g2.setColor(0);
        g2.fillRect(0, Defines.HEIGHT, Defines.WIDTH, Defines.HEIGHT);
    }

    public void paintTable(Graphics g2) {
        g2.drawImage(Resources.imgTable, (Defines.WIDTH - Resources.iTableW) / 2, (Defines.HEIGHT - Resources.iTableH) / 2 - tableYOffset, 0);
        int iTmpX = 0;
        Sprite sprTmpCards = null;
        if (Game.game_mode == 1) {
            this.iShownCardsCount = 3;
        }
        if (Game.game_mode == 2) {
            this.iShownCardsCount = 4;
        }
        if (Game.game_mode == 3) {
            this.iShownCardsCount = 5;
        }
        if (Game.game_mode == 4) {
            if (!Game.bWinByFold) {
                this.iShownCardsCount = 5;
            }
        }
        for (int i2 = 0; i2 <= 4; ++i2) {
            switch (i2) {
                case 0: {
                    iTmpX = Resources.TABLE_X1;
                    break;
                }
                case 1: {
                    iTmpX = Resources.TABLE_X2;
                    break;
                }
                case 2: {
                    iTmpX = Resources.TABLE_X3;
                    break;
                }
                case 3: {
                    iTmpX = Resources.TABLE_X4;
                    break;
                }
                case 4: {
                    iTmpX = Resources.TABLE_X5;
                }
            }
            if (this.iShownCardsCount <= i2) {
                if (!Game.tableCards[i2].isDistributed()) continue;
                Resources.sprCardRub.setFrame(1);
                Resources.sprCardRub.setPosition(iTmpX, (Defines.HEIGHT - Resources.iCardH) / 2 - tableYOffset);
                Resources.sprCardRub.paint(g2);
                continue;
            }
            switch (Game.tableCards[i2].getColNr()) {
                case 0: {
                    sprTmpCards = Resources.sprHearts;
                    break;
                }
                case 1: {
                    sprTmpCards = Resources.sprDiamonds;
                    break;
                }
                case 2: {
                    sprTmpCards = Resources.sprClubs;
                    break;
                }
                case 3: {
                    sprTmpCards = Resources.sprSpades;
                }
            }
            sprTmpCards.setFrame(Game.tableCards[i2].getValue() - 1);
            sprTmpCards.setPosition(iTmpX, (Defines.HEIGHT - Resources.iCardH) / 2 - tableYOffset);
            sprTmpCards.paint(g2);
            if (mode != 5) continue;
            if (Game.tableCards[i2].bWinCard) continue;
            if (Game.bWinByFold) continue;
            g2.drawImage(Resources.imgCardShade, iTmpX, (Defines.HEIGHT - Resources.iCardH) / 2 - tableYOffset, 0);
        }
    }

    public void paintPlayerPanel(Graphics g2) {
        int buttons = 0;
        if (mode == 4) {
            buttons = 3;
        }
        if (bNextGameMode && mode == 11 || mode == 5 || mode == 9) {
            int i2 = 0;
            while (true) {
                if (i2 >= Game.players.length) break;
                Game.players[i2].active = false;
                ++i2;
            }
            playerPanelYOffset = 0;
            tableYOffset = 0;
        }
        if (actualPlayer == 0 && mode == 9) {
            Game.players[0].active = true;
            buttons = 0;
        }
        int panelY = Defines.HEIGHT - Resources.iPlayerPanelH - playerPanelYOffset;
        int panelX = (Defines.WIDTH - Resources.iPlayerPanelW) / 2;
        if (Game.players[0].active) {
            panelY = Defines.HEIGHT - Resources.iPlayerPanelH - buttons * Resources.iBorderOffH;
            g2.drawImage(Resources.imgPlayerPanel, panelX, panelY, 0);
        } else {
            g2.drawImage(Resources.imgPlayerPanelOff, panelX, panelY, 0);
        }
        Fonts.drawStr(Game.players[0].getChipsString(), panelX + Resources.iPlayerPanelW - Fonts.strWidth(Game.players[0].getChipsString() + " "), panelY + (Resources.iPlayerPanelH / 2 - Resources.iFont1H) / 2, g2);
        Sprite sprTmpCards = null;
        int iTmpPosX = 0;
        for (int i3 = 0; i3 < 2; ++i3) {
            switch (Game.players[0].cards[i3].getColNr()) {
                case 0: {
                    sprTmpCards = Resources.sprHearts;
                    break;
                }
                case 1: {
                    sprTmpCards = Resources.sprDiamonds;
                    break;
                }
                case 2: {
                    sprTmpCards = Resources.sprClubs;
                    break;
                }
                case 3: {
                    sprTmpCards = Resources.sprSpades;
                }
            }
            if (i3 == 0) {
                iTmpPosX = Resources.PLAYER_X1;
            }
            if (i3 == 1) {
                iTmpPosX = Resources.PLAYER_X2;
            }
            if (!Game.players[0].fold) {
                if (Game.players[0].cards[i3].isDistributed()) {
                    sprTmpCards.setFrame(Game.players[0].cards[i3].getValue() - 1);
                    sprTmpCards.setPosition(iTmpPosX, panelY + Resources.PLAYER_Y);
                    sprTmpCards.paint(g2);
                }
                if (mode != 5) continue;
                if (Game.players[0].cards[i3].bWinCard) continue;
                if (Game.bWinByFold) continue;
                g2.drawImage(Resources.imgCardShade, iTmpPosX, panelY + Resources.PLAYER_Y, 0);
                continue;
            }
            Resources.sprCardRub.setFrame(0);
            Resources.sprCardRub.setPosition(iTmpPosX, panelY + Resources.PLAYER_Y);
            Resources.sprCardRub.paint(g2);
        }
        if (mode == 4 && iSelectedAction == 0) {
            if (Game.players[0].iPlayerAction == 0) {
                if (Game.iBetPerPlayer - Game.players[0].iActualBet >= Game.players[0].iChips) {
                    Fonts.drawStr(actionStrings[5], panelX + Resources.iPlayerPanelW - Fonts.strWidth(actionStrings[5] + " "), panelY + (Resources.iPlayerPanelH - Resources.iFont1H - Resources.BET_OFFSET), g2);
                } else {
                    Fonts.drawStr(Game.iBetPerPlayer - Game.players[0].iActualBet + " $", panelX + Resources.iPlayerPanelW - Fonts.strWidth(Game.iBetPerPlayer - Game.players[0].iActualBet + " $" + " "), panelY + (Resources.iPlayerPanelH - Resources.iFont1H - Resources.BET_OFFSET), g2);
                }
            }
        }
    }

    public void paintUpperSheet(Graphics g2) {
        int count;
        g2.drawImage(Resources.imgUpperPanel, 0, 0, 0);
        int iPosBordX = (Defines.WIDTH - Resources.iBorderOnW * (Resources.UPPER_PANEL1_PARTS + Resources.UPPER_PANEL2_PARTS)) / 2;
        int iPosBordY = (Resources.iUpperPanelH - Resources.iBorderOffH) / 2;
        Resources.paintBorder(2, true, Resources.UPPER_PANEL1_PARTS, iPosBordX, iPosBordY, g2);
        String message = "";
        String message2 = "";
        if (mode == 3 || mode == 4) {
            if (actualPlayer != 0) {
                message = this.playerNames[Game.players[ScreenGame.actualPlayer].nameIndx];
            }
            if (actualPlayer == 0) {
                message = sPlayer;
            }
            int color = 0;
            if (actualPlayer != 0) {
                switch (Game.players[ScreenGame.actualPlayer].iPlayerAction) {
                    case 1: {
                        message = this.playerNames[Game.players[ScreenGame.actualPlayer].nameIndx] + ": " + actionStrings[2] + " " + (Game.iBetPerPlayer - Game.players[ScreenGame.actualPlayer].iLastBet) + " $";
                        message2 = actionStrings[2];
                        color = 0;
                        break;
                    }
                    case 2: {
                        message = this.playerNames[Game.players[ScreenGame.actualPlayer].nameIndx] + ": " + actionStrings[3] + " " + Game.players[ScreenGame.actualPlayer].iRaise + " $";
                        message2 = actionStrings[3];
                        color = 0;
                        break;
                    }
                    case 4: {
                        message = this.playerNames[Game.players[ScreenGame.actualPlayer].nameIndx] + ": " + actionStrings[1] + " " + (Game.iBetPerPlayer - Game.players[ScreenGame.actualPlayer].iLastBet) + " $";
                        message2 = actionStrings[1];
                        color = 1;
                        break;
                    }
                    case 3: {
                        message = this.playerNames[Game.players[ScreenGame.actualPlayer].nameIndx] + ": " + actionStrings[0];
                        message2 = actionStrings[0];
                        color = 1;
                        break;
                    }
                    case 5: {
                        message = this.playerNames[Game.players[ScreenGame.actualPlayer].nameIndx] + ": " + actionStrings[4];
                        message2 = actionStrings[4];
                        color = 2;
                        break;
                    }
                    case 6: {
                        message = this.playerNames[Game.players[ScreenGame.actualPlayer].nameIndx] + ": " + actionStrings[5];
                        message2 = actionStrings[5];
                        color = 0;
                    }
                }
            }
            if (mode == 3 && !bNextGameMode) {
                if (Game.players[ScreenGame.actualPlayer].iPlayerAction != 0) {
                    this.paintPlayerActionMessage(actualPlayer, message2, g2, color);
                }
            }
            if (bNextGameMode) {
                int i2 = 0;
                while (true) {
                    if (i2 >= Game.players.length) break;
                    Game.players[i2].active = false;
                    ++i2;
                }
                switch (Game.game_mode) {
                    case 1: {
                        message = gameModeStrings[3];
                        if (Game.players[0].fold) break;
                        Game.iThisRoundScore += 2;
                        Game.bPointsForFold = true;
                        break;
                    }
                    case 2: {
                        message = gameModeStrings[4];
                        break;
                    }
                    case 3: {
                        message = gameModeStrings[5];
                        break;
                    }
                    default: {
                        message = "";
                    }
                }
                if (message != "") {
                    g2.fillRect(0, (Defines.HEIGHT - (Resources.iFont1H + Resources.iFont1H / 2)) / 2, Defines.WIDTH, Resources.iFont1H + Resources.iFont1H / 2);
                    Fonts.drawStr(message, (Defines.WIDTH - Fonts.strWidth(message)) / 2, (Defines.HEIGHT - Resources.iFont1H) / 2, g2);
                    System.out.println("                round part: " + message);
                }
                bNextGameMode = false;
            }
        }
        if (mode == 2) {
            message = gameModeStrings[0];
        }
        if (mode == 9) {
            if (iPutBlinds == 0) {
                this.paintPlayerActionMessage(actualPlayer, gameModeStrings[1], g2, 1);
                message = message.concat(" " + gameModeStrings[1]);
            }
            if (iPutBlinds == 1) {
                this.paintPlayerActionMessage(actualPlayer, gameModeStrings[2], g2, 1);
                message = message.concat(" " + gameModeStrings[2]);
            }
        }
        if (mode == 5) {
            message = gameModeStrings[6];
        }
        Fonts.drawStr(message, iPosBordX + (Resources.iBorderOnW * Resources.UPPER_PANEL1_PARTS - Fonts.strWidth(message)) / 2, iPosBordY + (Resources.iBorderOffH - Resources.iFont1H) / 2, g2);
        iPosBordY = (Resources.iUpperPanelH - Resources.iBorderOffH) / 2;
        Resources.paintBorder(2, false, Resources.UPPER_PANEL2_PARTS, iPosBordX += Resources.iBorderOnW * Resources.UPPER_PANEL1_PARTS, iPosBordY, g2);
        Fonts.drawStr(sPot + " " + Game.iPot + "$", iPosBordX + (Resources.iBorderOnW * Resources.UPPER_PANEL2_PARTS - Fonts.strWidth(sPot + " " + Game.iPot + "$")) / 2, iPosBordY + (Resources.iBorderOffH - Resources.iFont1H) / 2, g2);
        if (mode == 7 || mode == 6) {
            g2.drawImage(Resources.imgUpperPanel, 0, 0, 0);
            count = Defines.WIDTH / Resources.iBorderOffW - 2;
            Resources.paintBorder(2, true, count, (Defines.WIDTH - count * Resources.iBorderOffW) / 2, (Resources.iUpperPanelH - Resources.iBorderOffH) / 2, g2);
            iPosBordY = (Resources.iUpperPanelH - Resources.iBorderOffH) / 2;
            message = mode == 7 ? sTotScore + ": " + (GameHandling.iScore + Game.iThisRoundScore) : sTotScore + ": " + GameHandling.iScore;
            Fonts.drawStr(message, (Defines.WIDTH - Fonts.strWidth(message)) / 2, iPosBordY + (Resources.iBorderOffH - Resources.iFont1H) / 2, g2);
        }
        if (mode == 6) {
            g2.drawImage(Resources.imgUpperPanel, 0, Defines.HEIGHT - Resources.iUpperPanelH, 0);
            count = Defines.WIDTH / Resources.iBorderOffW - 2;
            Resources.paintBorder(2, true, count, (Defines.WIDTH - count * Resources.iBorderOffW) / 2, Defines.HEIGHT - Resources.iBorderOffH - (Resources.iUpperPanelH - Resources.iBorderOffH) / 2, g2);
            iPosBordY = (Resources.iUpperPanelH - Resources.iBorderOffH) / 2;
            message = actTable + ": " + (GameHandling.iTableNr + 1);
            Fonts.drawStr(message, (Defines.WIDTH - Fonts.strWidth(message)) / 2, Defines.HEIGHT - Resources.iFont1H - iPosBordY - (Resources.iBorderOffH - Resources.iFont1H) / 2, g2);
        }
    }

    public void paintPlayerActionMessage(int actualPlayer, String message2, Graphics g2, int color) {
        if (actualPlayer == 0) {
            return;
        }
        int iWidth = Resources.iPlayerBGW * Resources.PLAYER_BG_PARTS;
        int iHeight = Resources.iFont1H + Resources.iFont1H / 2;
        int iPosX = 0;
        int iPosY = (Resources.iPlayerBGH - iHeight) / 2;
        switch (actualPlayer) {
            case 1: {
                iPosX = 0;
                iPosY += (Defines.HEIGHT - Resources.iTableH) / 2 + Resources.iTableH - Resources.iTableH / 4 - Resources.DOWN_PLAYERS_OFFSET - tableYOffset;
                break;
            }
            case 2: {
                iPosX = 0;
                iPosY += (Defines.HEIGHT - Resources.iTableH) / 2 - Resources.iTableH / 3 - tableYOffset;
                break;
            }
            case 3: {
                iPosX = Defines.WIDTH - iWidth;
                iPosY += (Defines.HEIGHT - Resources.iTableH) / 2 - Resources.iTableH / 3 - tableYOffset;
                break;
            }
            case 4: {
                iPosX = Defines.WIDTH - iWidth;
                iPosY += (Defines.HEIGHT - Resources.iTableH) / 2 + Resources.iTableH - Resources.iTableH / 4 - Resources.DOWN_PLAYERS_OFFSET - tableYOffset;
            }
        }
        if (color == 0) {
            g2.setColor(0xFF0000);
        }
        if (color == 1) {
            g2.setColor(0x22FF22);
        }
        if (color == 2) {
            g2.setColor(255);
        }
        g2.fillRect(iPosX, iPosY, iWidth, iHeight);
        g2.setColor(0);
        g2.drawRect(iPosX, iPosY, iWidth, iHeight);
        Fonts.drawStr(message2, iPosX + (iWidth - Fonts.strWidth(message2)) / 2, iPosY + (iHeight - Resources.iFont1H) / 2, g2);
    }

    public void paintBlinds(Graphics g2) {
        int iPosXD = 0;
        int iPosYD = 0;
        int iPosXS = 0;
        int iPosYS = 0;
        int iPosXB = 0;
        int iPosYB = 0;
        switch (iDealerIndex) {
            case 0: {
                iPosXD = (Defines.WIDTH - Resources.iBlindW) / 2;
                iPosYD = Defines.HEIGHT - Resources.iPlayerPanelH - Resources.iBlindH - playerPanelYOffset;
                break;
            }
            case 1: {
                iPosXD = Resources.PLAYER_FOTO_X;
                iPosYD = (Defines.HEIGHT - Resources.iTableH) / 2 + Resources.iTableH - Resources.iTableH / 4 - Resources.iBlindH - Resources.DOWN_PLAYERS_OFFSET;
                break;
            }
            case 2: {
                iPosXD = Resources.PLAYER_FOTO_X;
                iPosYD = (Defines.HEIGHT - Resources.iTableH) / 2 - Resources.iTableH / 3 - Resources.iBlindH;
                break;
            }
            case 3: {
                iPosXD = Defines.WIDTH - Resources.PLAYER_FOTO_X - Resources.iBlindW;
                iPosYD = (Defines.HEIGHT - Resources.iTableH) / 2 - Resources.iTableH / 3 - Resources.iBlindH;
                break;
            }
            case 4: {
                iPosXD = Defines.WIDTH - Resources.PLAYER_FOTO_X - Resources.iBlindW;
                iPosYD = (Defines.HEIGHT - Resources.iTableH) / 2 + Resources.iTableH - Resources.iTableH / 4 - Resources.iBlindH - Resources.DOWN_PLAYERS_OFFSET;
            }
        }
        switch (iSBIndex) {
            case 1: {
                iPosXS = Resources.PLAYER_FOTO_X;
                iPosYS = (Defines.HEIGHT - Resources.iTableH) / 2 + Resources.iTableH - Resources.iTableH / 4 - Resources.iBlindH - Resources.DOWN_PLAYERS_OFFSET;
                break;
            }
            case 2: {
                iPosXS = Resources.PLAYER_FOTO_X;
                iPosYS = (Defines.HEIGHT - Resources.iTableH) / 2 - Resources.iTableH / 3 - Resources.iBlindH;
                break;
            }
            case 3: {
                iPosXS = Defines.WIDTH - Resources.PLAYER_FOTO_X - Resources.iBlindW;
                iPosYS = (Defines.HEIGHT - Resources.iTableH) / 2 - Resources.iTableH / 3 - Resources.iBlindH;
                break;
            }
            case 4: {
                iPosXS = Defines.WIDTH - Resources.PLAYER_FOTO_X - Resources.iBlindW;
                iPosYS = (Defines.HEIGHT - Resources.iTableH) / 2 + Resources.iTableH - Resources.iTableH / 4 - Resources.iBlindH - Resources.DOWN_PLAYERS_OFFSET;
                break;
            }
            case 0: {
                iPosXS = (Defines.WIDTH - Resources.iBlindW) / 2;
                iPosYS = Defines.HEIGHT - Resources.iPlayerPanelH - Resources.iBlindH - playerPanelYOffset;
            }
        }
        switch (iBBIndex) {
            case 2: {
                iPosXB = Resources.PLAYER_FOTO_X;
                iPosYB = (Defines.HEIGHT - Resources.iTableH) / 2 - Resources.iTableH / 3 - Resources.iBlindH;
                break;
            }
            case 3: {
                iPosXB = Defines.WIDTH - Resources.PLAYER_FOTO_X - Resources.iBlindW;
                iPosYB = (Defines.HEIGHT - Resources.iTableH) / 2 - Resources.iTableH / 3 - Resources.iBlindH;
                break;
            }
            case 4: {
                iPosXB = Defines.WIDTH - Resources.PLAYER_FOTO_X - Resources.iBlindW;
                iPosYB = (Defines.HEIGHT - Resources.iTableH) / 2 + Resources.iTableH - Resources.iTableH / 4 - Resources.iBlindH - Resources.DOWN_PLAYERS_OFFSET;
                break;
            }
            case 0: {
                iPosXB = (Defines.WIDTH - Resources.iBlindW) / 2;
                iPosYB = Defines.HEIGHT - Resources.iPlayerPanelH - Resources.iBlindH - playerPanelYOffset;
                break;
            }
            case 1: {
                iPosXB = Resources.PLAYER_FOTO_X;
                iPosYB = (Defines.HEIGHT - Resources.iTableH) / 2 + Resources.iTableH - Resources.iTableH / 4 - Resources.iBlindH - Resources.DOWN_PLAYERS_OFFSET;
            }
        }
        Resources.sprBlinds.setFrame(0);
        Resources.sprBlinds.setPosition(iPosXD, iPosYD);
        Resources.sprBlinds.paint(g2);
        Resources.sprBlinds.setFrame(1);
        Resources.sprBlinds.setPosition(iPosXS, iPosYS);
        Resources.sprBlinds.paint(g2);
        Resources.sprBlinds.setFrame(2);
        Resources.sprBlinds.setPosition(iPosXB, iPosYB);
        Resources.sprBlinds.paint(g2);
    }

    public void paintPlayers(Graphics g2) {
        int iPosY2;
        int iPosY1;
        block60: {
            block59: {
                block58: {
                    block57: {
                        String playName;
                        int iPosBordY;
                        int iPosBordX;
                        iPosY1 = (Defines.HEIGHT - Resources.iTableH) / 2 - Resources.iTableH / 3 - tableYOffset;
                        iPosY2 = (Defines.HEIGHT - Resources.iTableH) / 2 + Resources.iTableH - Resources.iTableH / 4 - Resources.DOWN_PLAYERS_OFFSET - tableYOffset;
                        if (bNextGameMode || mode == 5) {
                            int i2 = 0;
                            while (true) {
                                if (i2 >= Game.players.length) break;
                                Game.players[i2].active = false;
                                ++i2;
                            }
                            tableYOffset = 0;
                        }
                        if (Game.players[2].playing) {
                            if (!Game.players[2].active) {
                                Resources.paintPlayerBG(false, 0, iPosY1, g2);
                            } else {
                                Resources.paintPlayerBG(true, 0, iPosY1, g2);
                            }
                            iPosBordX = Resources.NAMES_OFFSET;
                            iPosBordY = iPosY1 + Resources.iPlayerBGH - Resources.iBorderOnH - Resources.NAMES_OFFSET;
                            g2.drawImage(Resources.imgPlFoto2, Resources.PLAYER_FOTO_X, iPosY1 + Resources.PLAYER_FOTO_Y, 0);
                            playName = this.playerNames[Game.players[2].nameIndx];
                            Fonts.drawStr(playName, Resources.PLAYER_FOTO_X + (Resources.iPlFotoW - Fonts.strWidth(playName)) / 2, iPosBordY + (Resources.iBorderOnH - Resources.iFont1H) / 2, g2);
                            Fonts.drawStr(Game.players[2].getChipsString(), Resources.iPlayerBGW * Resources.PLAYER_BG_PARTS - Fonts.strWidth(Game.players[2].getChipsString()) - Resources.NAMES_OFFSET, iPosY1 + Resources.NAMES_OFFSET, g2);
                            if (!Game.players[2].active && mode != 5) {
                                g2.drawImage(Resources.imgFaceShade, Resources.PLAYER_FOTO_X, iPosY1 + Resources.PLAYER_FOTO_Y, 0);
                            }
                        }
                        if (Game.players[1].playing) {
                            if (!Game.players[1].active) {
                                Resources.paintPlayerBG(false, 0, iPosY2, g2);
                            } else {
                                Resources.paintPlayerBG(true, 0, iPosY2, g2);
                            }
                            iPosBordX = Resources.NAMES_OFFSET;
                            iPosBordY = iPosY2 + Resources.iPlayerBGH - Resources.iBorderOnH - Resources.NAMES_OFFSET;
                            g2.drawImage(Resources.imgPlFoto1, Resources.PLAYER_FOTO_X, iPosY2 + Resources.PLAYER_FOTO_Y, 0);
                            if (!Game.players[1].active && mode != 5) {
                                g2.drawImage(Resources.imgFaceShade, Resources.PLAYER_FOTO_X, iPosY2 + Resources.PLAYER_FOTO_Y, 0);
                            }
                            playName = this.playerNames[Game.players[1].nameIndx];
                            Fonts.drawStr(playName, Resources.PLAYER_FOTO_X + (Resources.iPlFotoW - Fonts.strWidth(playName)) / 2, iPosBordY + (Resources.iBorderOnH - Resources.iFont1H) / 2, g2);
                            Fonts.drawStr(Game.players[1].getChipsString(), Resources.iPlayerBGW * Resources.PLAYER_BG_PARTS - Fonts.strWidth(Game.players[1].getChipsString()) - Resources.NAMES_OFFSET, iPosY2 + Resources.NAMES_OFFSET, g2);
                        }
                        if (Game.players[3].playing) {
                            if (!Game.players[3].active) {
                                Resources.paintPlayerBG(false, Defines.WIDTH - Resources.iPlayerBGW * Resources.PLAYER_BG_PARTS, iPosY1, g2);
                            } else {
                                Resources.paintPlayerBG(true, Defines.WIDTH - Resources.iPlayerBGW * Resources.PLAYER_BG_PARTS, iPosY1, g2);
                            }
                            iPosBordX = Defines.WIDTH - Resources.iPlFotoW - Resources.NAMES_OFFSET;
                            iPosBordY = iPosY1 + Resources.iPlayerBGH - Resources.iBorderOnH - Resources.NAMES_OFFSET;
                            g2.drawImage(Resources.imgPlFoto3, Defines.WIDTH - Resources.PLAYER_FOTO_X - Resources.iPlFotoW, iPosY1 + Resources.PLAYER_FOTO_Y, 0);
                            if (!Game.players[3].active && mode != 5) {
                                g2.drawImage(Resources.imgFaceShade, Defines.WIDTH - Resources.PLAYER_FOTO_X - Resources.iPlFotoW, iPosY1 + Resources.PLAYER_FOTO_Y, 0);
                            }
                            playName = this.playerNames[Game.players[3].nameIndx];
                            Fonts.drawStr(playName, iPosBordX + (Resources.iPlFotoW - Fonts.strWidth(playName)) / 2, iPosBordY + (Resources.iBorderOnH - Resources.iFont1H) / 2, g2);
                            Fonts.drawStr(Game.players[3].getChipsString(), Defines.WIDTH - Resources.iPlayerBGW * Resources.PLAYER_BG_PARTS + Resources.NAMES_OFFSET, iPosY1 + Resources.NAMES_OFFSET, g2);
                        }
                        if (Game.players[4].playing) {
                            if (!Game.players[4].active) {
                                Resources.paintPlayerBG(false, Defines.WIDTH - Resources.iPlayerBGW * Resources.PLAYER_BG_PARTS, iPosY2, g2);
                            } else {
                                Resources.paintPlayerBG(true, Defines.WIDTH - Resources.iPlayerBGW * Resources.PLAYER_BG_PARTS, iPosY2, g2);
                            }
                            iPosBordX = Defines.WIDTH - Resources.iPlFotoW - Resources.NAMES_OFFSET;
                            iPosBordY = iPosY2 + Resources.iPlayerBGH - Resources.iBorderOnH - Resources.NAMES_OFFSET;
                            g2.drawImage(Resources.imgPlFoto4, Defines.WIDTH - Resources.PLAYER_FOTO_X - Resources.iPlFotoW, iPosY2 + Resources.PLAYER_FOTO_Y, 0);
                            if (!Game.players[4].active && mode != 5) {
                                g2.drawImage(Resources.imgFaceShade, Defines.WIDTH - Resources.PLAYER_FOTO_X - Resources.iPlFotoW, iPosY2 + Resources.PLAYER_FOTO_Y, 0);
                            }
                            playName = this.playerNames[Game.players[4].nameIndx];
                            Fonts.drawStr(playName, iPosBordX + (Resources.iPlFotoW - Fonts.strWidth(playName)) / 2, iPosBordY + (Resources.iBorderOnH - Resources.iFont1H) / 2, g2);
                            Fonts.drawStr(Game.players[4].getChipsString(), Defines.WIDTH - Resources.iPlayerBGW * Resources.PLAYER_BG_PARTS + Resources.NAMES_OFFSET, iPosY2 + Resources.NAMES_OFFSET, g2);
                        }
                        if (mode == 12) {
                            return;
                        }
                        if (Game.players[0].cards[0] == null) break block57;
                        if (Game.players[1].cards[0] == null) break block57;
                        if (Game.players[2].cards[0] == null) break block57;
                        if (Game.players[3].cards[0] == null) break block57;
                        if (Game.players[4].cards[0] != null) break block58;
                    }
                    if (mode == 8) {
                        return;
                    }
                }
                if (Game.players[0].cards[0] == null) break block59;
                if (Game.players[1].cards[0] == null) break block59;
                if (Game.players[2].cards[0] == null) break block59;
                if (Game.players[3].cards[0] == null) break block59;
                if (Game.players[4].cards[0] != null) break block60;
            }
            if (mode != 8) {
                mode = 8;
                return;
            }
        }
        int iTmpX = 0;
        int iTmpY = 0;
        Sprite sprTmpCards = null;
        for (int i3 = 1; i3 <= 4; ++i3) {
            switch (i3) {
                case 1: {
                    iTmpY = iPosY2 + Resources.CARD_Y;
                    break;
                }
                case 2: {
                    iTmpY = iPosY1 + Resources.CARD_Y;
                    break;
                }
                case 3: {
                    iTmpY = iPosY1 + Resources.CARD_Y;
                    break;
                }
                case 4: {
                    iTmpY = iPosY2 + Resources.CARD_Y;
                }
            }
            for (int j2 = 0; j2 <= 1; ++j2) {
                if (i3 == 1 && j2 == 0) {
                    iTmpX = Resources.CARD_X1;
                }
                if (i3 == 1 && j2 == 1) {
                    iTmpX = Resources.CARD_X2;
                }
                if (i3 == 2 && j2 == 0) {
                    iTmpX = Resources.CARD_X1;
                }
                if (i3 == 2 && j2 == 1) {
                    iTmpX = Resources.CARD_X2;
                }
                if (i3 == 3 && j2 == 0) {
                    iTmpX = Defines.WIDTH - Resources.CARD_X2 - Resources.iCardW;
                }
                if (i3 == 3 && j2 == 1) {
                    iTmpX = Defines.WIDTH - Resources.CARD_X1 - Resources.iCardW;
                }
                if (i3 == 4 && j2 == 0) {
                    iTmpX = Defines.WIDTH - Resources.CARD_X2 - Resources.iCardW;
                }
                if (i3 == 4 && j2 == 1) {
                    iTmpX = Defines.WIDTH - Resources.CARD_X1 - Resources.iCardW;
                }
                if (Game.game_mode != 4) {
                    if (!Game.players[i3].playing) continue;
                    if (!Game.players[i3].cards[j2].isDistributed()) continue;
                    if (!Game.players[i3].fold) {
                        Resources.sprCardRub.setFrame(1);
                    } else {
                        Resources.sprCardRub.setFrame(0);
                    }
                    Resources.sprCardRub.setPosition(iTmpX, iTmpY);
                    Resources.sprCardRub.paint(g2);
                    continue;
                }
                if (!Game.players[i3].playing) continue;
                if (!Game.players[i3].fold) {
                    if (!Game.bWinByFold) {
                        switch (Game.players[i3].cards[j2].getColNr()) {
                            case 0: {
                                sprTmpCards = Resources.sprHearts;
                                break;
                            }
                            case 1: {
                                sprTmpCards = Resources.sprDiamonds;
                                break;
                            }
                            case 2: {
                                sprTmpCards = Resources.sprClubs;
                                break;
                            }
                            case 3: {
                                sprTmpCards = Resources.sprSpades;
                            }
                        }
                        sprTmpCards.setFrame(Game.players[i3].cards[j2].getValue() - 1);
                    }
                }
                if (!Game.players[i3].fold) {
                    if (Game.bWinByFold) {
                        sprTmpCards = Resources.sprCardRub;
                        sprTmpCards.setFrame(1);
                    }
                }
                if (Game.players[i3].fold) {
                    sprTmpCards = Resources.sprCardRub;
                    sprTmpCards.setFrame(0);
                }
                sprTmpCards.setPosition(iTmpX, iTmpY);
                sprTmpCards.paint(g2);
                if (mode != 5) continue;
                if (Game.players[i3].cards[j2].bWinCard) continue;
                if (Game.players[i3].fold) continue;
                if (!Game.players[i3].playing) continue;
                if (Game.bWinByFold) continue;
                g2.drawImage(Resources.imgCardShade, iTmpX, iTmpY, 0);
            }
        }
    }

    public void paintCardDistribution(Graphics g2) {
        int tmpX = 0;
        int tmpY = 0;
        int deltaX = 0;
        int deltaY = 0;
        int iPosY1 = (Defines.HEIGHT - Resources.iTableH) / 2 - Resources.iTableH / 3;
        int iPosY2 = (Defines.HEIGHT - Resources.iTableH) / 2 + Resources.iTableH - Resources.iTableH / 4;
        if (iDistributionRound < 2) {
            switch (actualPlayer) {
                case 0: {
                    if (iDistributionRound == 0) {
                        tmpX = Resources.PLAYER_X1;
                    }
                    if (iDistributionRound == 1) {
                        tmpX = Resources.PLAYER_X2;
                    }
                    tmpY = Defines.HEIGHT - Resources.iPlayerPanelH + Resources.PLAYER_Y;
                    deltaX = Resources.iCardH / 3;
                    deltaY = Resources.iCardH;
                    break;
                }
                case 1: {
                    if (iDistributionRound == 0) {
                        tmpX = Resources.CARD_X1;
                    }
                    if (iDistributionRound == 1) {
                        tmpX = Resources.CARD_X2;
                    }
                    tmpY = iPosY2 + Resources.CARD_Y;
                    deltaX = Resources.iCardW;
                    deltaY = Resources.iCardH;
                    break;
                }
                case 2: {
                    if (iDistributionRound == 0) {
                        tmpX = Resources.CARD_X1;
                    }
                    if (iDistributionRound == 1) {
                        tmpX = Resources.CARD_X2;
                    }
                    tmpY = iPosY1 + Resources.CARD_Y;
                    deltaX = Resources.iCardH;
                    deltaY = Resources.iCardH;
                    break;
                }
                case 3: {
                    if (iDistributionRound == 0) {
                        tmpX = Defines.WIDTH - Resources.CARD_X2 - Resources.iCardW;
                    }
                    if (iDistributionRound == 1) {
                        tmpX = Defines.WIDTH - Resources.CARD_X1 - Resources.iCardW;
                    }
                    tmpY = iPosY1 + Resources.CARD_Y;
                    deltaX = Resources.iCardH;
                    deltaY = Resources.iCardW / 2;
                    break;
                }
                case 4: {
                    if (iDistributionRound == 0) {
                        tmpX = Defines.WIDTH - Resources.CARD_X2 - Resources.iCardW;
                    }
                    if (iDistributionRound == 1) {
                        tmpX = Defines.WIDTH - Resources.CARD_X1 - Resources.iCardW;
                    }
                    tmpY = iPosY2 + Resources.CARD_Y;
                    deltaX = Resources.iCardH;
                    deltaY = Resources.iCardH;
                }
            }
        } else {
            int i2 = 0;
            while (true) {
                if (i2 >= Game.tableCards.length) break;
                if (!Game.tableCards[i2].isDistributed()) {
                    step = i2;
                    break;
                }
                if (i2 == Game.tableCards.length - 1) {
                    ++iDistributionRound;
                }
                ++i2;
            }
            tmpY = (Defines.HEIGHT - Resources.iCardH) / 2;
            switch (step) {
                case 0: {
                    tmpX = Resources.TABLE_X1;
                    deltaX = 30;
                    deltaY = 30;
                    break;
                }
                case 1: {
                    tmpX = Resources.TABLE_X2;
                    deltaX = 30;
                    deltaY = 30;
                    break;
                }
                case 2: {
                    tmpX = Resources.TABLE_X3;
                    deltaX = 35;
                    deltaY = 30;
                    break;
                }
                case 3: {
                    tmpX = Resources.TABLE_X4;
                    deltaX = 40;
                    deltaY = 30;
                    break;
                }
                case 4: {
                    tmpX = Resources.TABLE_X5;
                    deltaX = 45;
                    deltaY = 30;
                }
            }
        }
        boolean bHelp1 = false;
        boolean bHelp2 = false;
        Resources.sprCardRub.setFrame(1);
        Resources.sprCardRub.setPosition(iDistributionX, iDistributionY);
        Resources.sprCardRub.paint(g2);
        if (iDistributionX < tmpX) {
            iDistributionX += deltaX;
        }
        if (iDistributionX >= tmpX) {
            bHelp1 = true;
            iDistributionX = tmpX;
        }
        if (iDistributionY < tmpY) {
            iDistributionY += deltaY;
        }
        if (iDistributionY >= tmpY) {
            bHelp2 = true;
            iDistributionY = tmpY;
        }
        if (bHelp1 && bHelp2 && step < 5) {
            if (iDistributionRound == 0) {
                Game.players[ScreenGame.actualPlayer].cards[0].setDistrib(true);
                ScreenGame.nextPlayer();
            }
            if (iDistributionRound == 1) {
                Game.players[ScreenGame.actualPlayer].cards[1].setDistrib(true);
                ScreenGame.nextPlayer();
            }
            if (iDistributionRound == 2) {
                Game.tableCards[step].setDistrib(true);
                ++step;
            }
            this.resetDistributionCoordinates();
            bHelp1 = false;
            bHelp2 = false;
        }
        if (step >= 5) {
            step = 0;
            ++iDistributionRound;
            actualPlayer = iDealerIndex < 4 ? iDealerIndex + 1 : 0;
            while (true) {
                if (Game.players[ScreenGame.actualPlayer].playing) break;
                if (++actualPlayer != 5) continue;
                actualPlayer = 0;
            }
            step = 0;
            this.resetDistributionCoordinates();
        }
        this.paintUpperSheet(g2);
    }

    public static void nextPlayer() {
        block7: {
            block6: {
                actualPlayer = actualPlayer < 4 ? ++actualPlayer : 0;
                Game.players[ScreenGame.actualPlayer].iPlayerAction = 0;
                ++step;
                if (Game.players[ScreenGame.actualPlayer].fold) break block6;
                if (Game.players[ScreenGame.actualPlayer].bAllIn) break block6;
                if (Game.players[ScreenGame.actualPlayer].playing) break block7;
            }
            if (Game.game_mode != 4) {
                ScreenGame.nextPlayer();
                return;
            }
        }
        if (actualPlayer == 0 && mode == 3) {
            for (int i2 = 0; i2 < 5; ++i2) {
                Game.players[i2].active = false;
            }
        }
    }

    public void keyPressed(int keyCode) {
        if (Keys.key_num0) {
            for (int i2 = 0; i2 < 5; ++i2) {
                System.out.println("player " + i2 + " actualBet: " + Game.players[i2].iActualBet);
                System.out.println("player style: " + Game.players[i2].iPlayingStyle);
            }
            System.out.println("bet per player: " + Game.iBetPerPlayer);
        }
        if (Keys.key_fn2 && mode != 13 && mode != 8 && mode != 6 && mode != 14 && mode != 12) {
            old_mode = mode;
            if (mode == 2) {
                this.skipCardDistribution();
            }
            state.saveGame(this);
            state.saveTable(this);
            mode = 6;
            XX.soundManager.Stop();
            iSelectedSubMenuItem = 0;
            return;
        }
        if (Keys.key_fn1 && mode != 13 && mode != 8 && mode != 6) {
            bSkipOn = !bSkipOn;
            canvas.repaint();
            canvas.serviceRepaints();
        }
        switch (mode) {
            case 12: {
                this.keyPrWelcome(keyCode);
                break;
            }
            case 6: {
                this.keyPrPause(keyCode);
                break;
            }
            case 4: {
                this.keyPrPlayerMove(keyCode);
                break;
            }
            case 5: {
                ScreenGame.nextGameMode();
                break;
            }
            case 7: {
                if (!Keys.key_fire && !Keys.key_num5) break;
                mode = 14;
                break;
            }
            case 14: {
                if (!Keys.key_fire && !Keys.key_num5) break;
                GameHandling.newRound(Game.iThisRoundScore);
                Game.iThisRoundScore = 0;
                state.saveTable(this);
                ScreenGame.nextGameMode();
                break;
            }
            case 8: {
                this.keyPrGameOver(keyCode);
                break;
            }
            case 13: {
                this.keyPrReallyQuit(keyCode);
            }
        }
        canvas.repaint();
        canvas.serviceRepaints();
    }

    public void keyPrReallyQuit(int keyCode) {
        if (Keys.key_fn1) {
            mode = 8;
            return;
        }
        if (Keys.key_fn2) {
            state.deleteTable();
            GameHandling.iScore = 0;
            state.deleteGame();
            Resources.releaseGameResources();
            MainCanvas.scrMenu = new ScreenMenu(canvas);
            MainCanvas.activeScreen = MainCanvas.scrMenu;
            MainCanvas.scrGame = null;
            return;
        }
    }

    public void keyPrGameOver(int keyCode) {
        if (Keys.key_up || Keys.key_num2 || Keys.key_left || Keys.key_num4) {
            --iSelectedAction;
            if (Game.players[0].iChips != 0) {
                --iSelectedAction;
            }
            if (iSelectedAction < 0) {
                iSelectedAction = 2;
            }
        }
        if (Keys.key_down || Keys.key_num8 || Keys.key_right || Keys.key_num6) {
            ++iSelectedAction;
            if (Game.players[0].iChips != 0) {
                ++iSelectedAction;
            }
            if (iSelectedAction > 2) {
                iSelectedAction = 0;
            }
        }
        if (Keys.key_fire || Keys.key_num5) {
            switch (iSelectedAction) {
                case 0: {
                    if (Game.players[0].iChips == 0) {
                        Resources.releaseGameResources();
                        MainCanvas.scrShop = new ScreenShop(canvas);
                        MainCanvas.activeScreen = MainCanvas.scrShop;
                        MainCanvas.scrGame = null;
                        break;
                    }
                    mode = -1;
                    GameHandling.newTable();
                    state.saveTable(this);
                    state.deleteGame();
                    Game = new Game(GameHandling.iBigBlinds[GameHandling.iLevel]);
                    Game.iRoundNr = 0;
                    playerPanelYOffset = 0;
                    tableYOffset = 0;
                    this.createPlayers();
                    this.generateCards();
                    iPutBlinds = 0;
                    mode = 0;
                    old_mode = 1;
                    break;
                }
                case 1: {
                    System.out.println("odosielam skore");
                    if (Game.players[0].iChips != 0) break;
                    XX.game.enterNameAndSendScore();
                    break;
                }
                case 2: {
                    if (Game.players[0].iChips == 0) {
                        mode = 13;
                        break;
                    }
                    Resources.releaseGameResources();
                    MainCanvas.scrMenu = new ScreenMenu(canvas);
                    MainCanvas.activeScreen = MainCanvas.scrMenu;
                    MainCanvas.scrGame = null;
                    return;
                }
            }
        }
    }

    public void keyPrWelcome(int keyCode) {
        if ((Keys.key_up || Keys.key_num2 || Keys.key_left || Keys.key_num4) && --iSelectedAction < 1) {
            iSelectedAction = 2;
        }
        if ((Keys.key_down || Keys.key_num8 || Keys.key_right || Keys.key_num6) && ++iSelectedAction > 2) {
            iSelectedAction = 1;
        }
        if (Keys.key_fire || Keys.key_num5) {
            switch (iSelectedAction) {
                case 0: {
                    Resources.releaseGameResources();
                    MainCanvas.scrShop = new ScreenShop(canvas);
                    MainCanvas.activeScreen = MainCanvas.scrShop;
                    MainCanvas.scrGame = null;
                    break;
                }
                case 1: {
                    mode = old_mode;
                    break;
                }
                case 2: {
                    Resources.releaseGameResources();
                    MainCanvas.scrMenu = new ScreenMenu(canvas);
                    MainCanvas.activeScreen = MainCanvas.scrMenu;
                    MainCanvas.scrGame = null;
                }
            }
        }
    }

    public void keyPrPlayerMove(int keyCode) {
        if (Keys.key_up || Keys.key_num2) {
            --iSelectedAction;
            if (Game.players[0].iChips <= Game.iBetPerPlayer - Game.players[0].iActualBet) {
                --iSelectedAction;
            }
            if (iSelectedAction < 0) {
                iSelectedAction = 2;
            }
        }
        if (Keys.key_down || Keys.key_num8) {
            ++iSelectedAction;
            if (Game.players[0].iChips <= Game.iBetPerPlayer - Game.players[0].iActualBet) {
                ++iSelectedAction;
            }
            if (iSelectedAction > 2) {
                iSelectedAction = 0;
            }
        }
        if (Game.players[0].iPlayerAction == 0) {
            if (Keys.key_fire || Keys.key_num5) {
                switch (iSelectedAction) {
                    case 0: {
                        if (Game.compareBets()) {
                            mode = 11;
                            break;
                        }
                        Game.checkOrCall(0);
                        mode = 11;
                        break;
                    }
                    case 1: {
                        if (Game.compareBets()) {
                            iPlayerBet = Game.iBlind;
                            Game.players[0].iPlayerAction = 1;
                        } else {
                            iPlayerBet = Game.iRaise;
                            Game.players[0].iPlayerAction = 2;
                        }
                        iSelectedAction = 0;
                        break;
                    }
                    case 2: {
                        Game.fold(0);
                        mode = 11;
                    }
                }
            }
        } else if (Game.players[0].iPlayerAction == 1) {
            if ((Keys.key_right || Keys.key_num6) && iSelectedAction == 0) {
                bPlusPressed = true;
                if (iPlayerBet != Game.players[0].iChips) {
                    iPlayerBet += 10;
                }
            }
            if ((Keys.key_left || Keys.key_num4) && iSelectedAction == 0) {
                bMinusPressed = true;
                if (iPlayerBet != Game.iBlind) {
                    iPlayerBet -= 10;
                }
            }
            if ((Keys.key_fire || Keys.key_num5) && iSelectedAction == 0) {
                System.out.println("Bet :" + iPlayerBet);
                Game.players[0].removeChips(iPlayerBet);
                Game.addToPot(iPlayerBet);
                Game.bRaise = true;
                Game.iBetPerPlayer += iPlayerBet;
                Game.players[0].addBet(iPlayerBet);
                Game.iRaise = iPlayerBet;
                if (iPlayerBet == Game.players[0].iChips) {
                    Game.players[0].bAllIn = true;
                }
                mode = 11;
            }
            if ((Keys.key_fire || Keys.key_num5) && iSelectedAction == 1) {
                Game.AllIn(0);
                mode = 11;
            }
            if ((Keys.key_fire || Keys.key_num5) && iSelectedAction == 2) {
                Game.players[0].iPlayerAction = 0;
                iSelectedAction = 0;
            }
        } else if (Game.players[0].iPlayerAction == 2) {
            if ((Keys.key_right || Keys.key_num6) && iSelectedAction == 0) {
                bPlusPressed = true;
                if (iPlayerBet + Game.iBetPerPlayer - Game.players[0].iActualBet < Game.players[0].iChips) {
                    iPlayerBet += 10;
                }
            }
            if ((Keys.key_left || Keys.key_num4) && iSelectedAction == 0) {
                bMinusPressed = true;
                if (iPlayerBet != Game.iRaise) {
                    iPlayerBet -= 10;
                }
            }
            if ((Keys.key_fire || Keys.key_num5) && iSelectedAction == 0) {
                System.out.println("call: " + (Game.iBetPerPlayer - Game.players[0].iActualBet) + " + raise:" + iPlayerBet);
                Game.players[0].removeChips(iPlayerBet + Game.iBetPerPlayer - Game.players[0].iActualBet);
                Game.addToPot(iPlayerBet + Game.iBetPerPlayer - Game.players[0].iActualBet);
                Game.bRaise = true;
                Game.players[0].addBet(iPlayerBet + (Game.iBetPerPlayer - Game.players[0].iActualBet));
                Game.iBetPerPlayer += iPlayerBet;
                Game.iRaise += iPlayerBet;
                if (iPlayerBet + Game.iBetPerPlayer - Game.players[0].iActualBet == Game.players[0].iChips) {
                    Game.players[0].bAllIn = true;
                }
                mode = 11;
            }
            if ((Keys.key_fire || Keys.key_num5) && iSelectedAction == 1) {
                Game.AllIn(0);
                mode = 11;
            }
            if ((Keys.key_fire || Keys.key_num5) && iSelectedAction == 2) {
                Game.players[0].iPlayerAction = 0;
                iSelectedAction = 0;
            }
        }
    }

    public void keyPrPause(int keyCode) {
        if (Keys.key_right || Keys.key_up || Keys.key_num6 || Keys.key_num2) {
            iSelectedSubMenuItem = iSelectedSubMenuItem - 1 < 0 ? 1 : --iSelectedSubMenuItem;
        }
        if (Keys.key_left || Keys.key_down || Keys.key_num4 || Keys.key_num8) {
            iSelectedSubMenuItem = iSelectedSubMenuItem + 1 > 1 ? 0 : ++iSelectedSubMenuItem;
        }
        if (Keys.key_fire || Keys.key_num5) {
            if (iSelectedSubMenuItem == 0) {
                mode = iPutBlinds < 2 ? 9 : old_mode;
                if (Settings.bMusic) {
                    XX.soundManager.Stop();
                    XX.soundManager.SetSoundOn(true);
                    XX.soundManager.Play(XX.MUSIC_MENU_ID, -1);
                } else {
                    XX.soundManager.Stop();
                    XX.soundManager.SetSoundOn(false);
                }
            }
            if (iSelectedSubMenuItem == 1) {
                Resources.releaseGameResources();
                MainCanvas.scrMenu = new ScreenMenu(canvas);
                MainCanvas.activeScreen = MainCanvas.scrMenu;
                MainCanvas.scrGame = null;
                return;
            }
        }
    }

    public void continuePlaying() {
        mode = 3;
        Game.players[0].active = false;
        canvas.repaint();
        canvas.serviceRepaints();
        if (step == 0) {
            Game.checkPlayersHands();
        }
        if (Game.compareBets() && step >= 5) {
            ScreenGame.nextGameMode();
        } else {
            ScreenGame.nextPlayer();
        }
        int i2 = 0;
        while (true) {
            if (i2 >= Game.players.length) break;
            Game.players[i2].active = actualPlayer == i2;
            ++i2;
        }
        mode = 3;
    }

    public void skipCardDistribution() {
        for (int i2 = 0; i2 < 5; ++i2) {
            Game.players[i2].cards[0].setDistrib(true);
            Game.players[i2].cards[1].setDistrib(true);
            Game.tableCards[i2].setDistrib(true);
        }
        iWaitTime = 0;
        iPutBlinds = 0;
        mode = 9;
        step = 0;
        iWaitTime = DEFAULT_WAIT_TIME;
        canvas.repaint();
        canvas.serviceRepaints();
    }

    public void keyReleased(int keyCode) {
        bPlusPressed = false;
        bMinusPressed = false;
        iKeyPressedDelay = 0;
    }

    public void pointerPressed(int x2, int y2) {
        if (Resources.isInLeftButton(x2, y2)) {
            Keys.key_fn1 = true;
            this.keyPressed(Keys.iLeftKey);
            Keys.key_fn1 = false;
        }
        if (Resources.isInRightButton(x2, y2)) {
            Keys.key_fn2 = true;
            this.keyPressed(Keys.iRightKey);
            Keys.key_fn2 = false;
        }
        if (mode == 6) {
            int buttonPressed = Resources.whichSubMenuButton(x2, y2);
            switch (buttonPressed) {
                case 1: {
                    iSelectedSubMenuItem = 0;
                    break;
                }
                case 2: {
                    iSelectedSubMenuItem = 1;
                    break;
                }
                default: {
                    iSelectedSubMenuItem = -1;
                }
            }
        }
        switch (mode) {
            case 5: 
            case 12: {
                iSelectedAction = Resources.WhichWelcomeButton(x2, y2);
                if (iSelectedAction == 0) {
                    iSelectedAction = 1;
                }
                Keys.key_fire = true;
                this.keyPressed(Keys.iEnterKey);
                Keys.key_fire = false;
                break;
            }
            case 4: {
                int button = Resources.whichGameControlButton(x2, y2, playerPanelYOffset);
                if (button < 0 || button > 2) {
                    iSelectedAction = 0;
                } else {
                    iSelectedAction = button;
                    Keys.key_fire = true;
                    this.keyPressed(Keys.iEnterKey);
                    Keys.key_fire = false;
                }
                if (button == 3) {
                    iSelectedAction = 0;
                    Keys.key_left = true;
                    this.keyPressed(Keys.iLeftKey);
                    Keys.key_left = false;
                }
                if (button != 4) break;
                iSelectedAction = 0;
                Keys.key_right = true;
                this.keyPressed(Keys.iRightKey);
                Keys.key_right = false;
                break;
            }
            case 8: {
                iSelectedAction = Resources.WhichWelcomeButton(x2, y2);
                Keys.key_fire = true;
                this.keyPressed(Keys.iEnterKey);
                Keys.key_fire = false;
                break;
            }
            default: {
                Keys.key_fire = true;
                this.keyPressed(Keys.iEnterKey);
                Keys.key_fire = false;
            }
        }
    }

    public void pointerReleased(int x2, int y2) {
        bPlusPressed = false;
        bMinusPressed = false;
        iKeyPressedDelay = 0;
        if (mode == 6) {
            Keys.key_fire = true;
            this.keyPressed(Keys.iEnterKey);
            Keys.key_fire = false;
            iSelectedSubMenuItem = -1;
            canvas.repaint();
            canvas.serviceRepaints();
        }
        if (mode != 4) {
            // empty if block
        }
    }

    static {
        playerPanelYOffset = 0;
        tableYOffset = 0;
        DEFAULT_WAIT_TIME = 1;
        iBlickTime = 500;
        actualPlayer = 0;
        step = 0;
        iDistributionRound = 0;
        menuStrings = new String[2];
        actionStrings = new String[6];
        gameModeStrings = new String[9];
        sRewards = new String[6];
        quitMessage = new String[6];
        buyMore = new String[3];
        playOnNext = new String[3];
        iSelectedSubMenuItem = -1;
        bNextGameMode = false;
    }
}

