/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;

public class ScreenSplash
implements IScreen {
    static final int MODE_LANG_SETUP = 0;
    static final int MODE_SOUNDS_SETUP = 1;
    static final int MODE_COMPANY_LOGO = 2;
    static final int MODE_TEQ = 5;
    static final int MODE_SPLASH = 3;
    static final int MODE_TEST = 4;
    Canvas canvas;
    public static int mode;
    long modeDelay;
    String sMusic;
    int testicek = 0;
    int iSelectedItem = -1;
    public String[] menuStrings;

    ScreenSplash(Canvas canvas) {
        this.canvas = canvas;
        mode = 0;
        this.iSelectedItem = 0;
        Resources.imgBackground = null;
        Resources.imgBackground = Common.createImage("/bg.png");
        System.out.println("screenSplash");
        Resources.loadMenuResources();
        this.loadStrings();
    }

    public void loadStrings() {
        this.menuStrings = new String[]{"ENGLISH", "ESPA\u00d1OL", "DEUTSCH", "ITALIANO", "FRAN\u00c7AIS", "PORTUGU\u00caS"};
    }

    public int getActualMode() {
        return mode;
    }

    public String getActualModeName() {
        return "Screen splash";
    }

    public void invokeGameMenu() {
    }

    public void update(long tick) {
        switch (mode) {
            case 5: {
                XX.game.startTequila();
                break;
            }
            case 2: 
            case 3: {
                if (this.modeDelay > 0L) {
                    this.modeDelay -= tick;
                    return;
                }
                this.nextMode();
            }
        }
        this.canvas.repaint();
        this.canvas.serviceRepaints();
    }

    public void keyReleased(int keyCode) {
        this.canvas.repaint();
        this.canvas.serviceRepaints();
    }

    public void setMusic() {
        try {
            if (Settings.bMusic) {
                XX.soundManager.Stop();
                XX.soundManager.SetSoundOn(true);
                XX.soundManager.Play(XX.MUSIC_MENU_ID, -1);
            } else {
                XX.soundManager.SetSoundOn(false);
                XX.soundManager.Stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void nextMode() {
        switch (mode) {
            case 0: {
                mode = 5;
                this.sMusic = XX.texts.getHashedString("MUSIC").toUpperCase();
                this.canvas.repaint();
                this.canvas.serviceRepaints();
                break;
            }
            case 1: {
                Settings.saveSettings();
                Resources.imgBackground = Common.createImage("/inl.png");
                this.modeDelay = 3000L;
                mode = 2;
                this.canvas.repaint();
                this.canvas.serviceRepaints();
                break;
            }
            case 2: {
                Resources.imgBackground = Common.createImage("/bg.png");
                this.modeDelay = 0L;
                mode = 3;
                this.canvas.repaint();
                this.canvas.serviceRepaints();
                break;
            }
            case 3: {
                MainCanvas.scrMenu = new ScreenMenu(this.canvas);
                MainCanvas.activeScreen = MainCanvas.scrMenu;
                MainCanvas.scrSplash = null;
                this.canvas.repaint();
                this.canvas.serviceRepaints();
            }
        }
    }

    public void keyPressed(int keyCode) {
        this.canvas.repaint();
        this.canvas.serviceRepaints();
        if (XX.game.bTequilaActive) {
            int iTQPKeyCode = -1;
            if (Keys.key_num2 || Keys.key_up) {
                iTQPKeyCode = 64;
            }
            if (Keys.key_num4 || Keys.key_left) {
                iTQPKeyCode = 66;
            }
            if (Keys.key_num6 || Keys.key_right) {
                iTQPKeyCode = 67;
            }
            if (Keys.key_num8 || Keys.key_down) {
                iTQPKeyCode = 65;
            }
            if (Keys.key_num5 || Keys.key_fire) {
                iTQPKeyCode = 68;
            }
            if (Keys.key_fn1) {
                iTQPKeyCode = 69;
            }
            if (Keys.key_fn2) {
                iTQPKeyCode = 70;
            }
            if (MainCanvas.tequila != null) {
                MainCanvas.tequila.keyActionPressed(iTQPKeyCode);
                this.canvas.repaint();
                this.canvas.serviceRepaints();
                return;
            }
        }
        switch (mode) {
            case 0: {
                if (Keys.key_right || Keys.key_down || Keys.key_num6 || Keys.key_num8) {
                    ++this.iSelectedItem;
                    if (this.iSelectedItem > 5) {
                        this.iSelectedItem = 0;
                    }
                }
                if (Keys.key_left || Keys.key_up || Keys.key_num4 || Keys.key_num2) {
                    --this.iSelectedItem;
                    if (this.iSelectedItem < 0) {
                        this.iSelectedItem = 5;
                    }
                }
                if (!Keys.key_fire && !Keys.key_num5) break;
                switch (this.iSelectedItem) {
                    case 0: {
                        Texts.STRING_BIN = "/lang/en/text.csr";
                        break;
                    }
                    case 1: {
                        Texts.STRING_BIN = "/lang/es/text.csr";
                        break;
                    }
                    case 2: {
                        Texts.STRING_BIN = "/lang/de/text.csr";
                        break;
                    }
                    case 3: {
                        Texts.STRING_BIN = "/lang/it/text.csr";
                        break;
                    }
                    case 4: {
                        Texts.STRING_BIN = "/lang/fr/text.csr";
                        break;
                    }
                    case 5: {
                        Texts.STRING_BIN = "/lang/pt/text.csr";
                    }
                }
                this.nextMode();
                break;
            }
            case 1: {
                if (Keys.key_fn1) {
                    Settings.bMusic = true;
                    Settings.saveSettings();
                    XX.soundManager.SetSoundOn(true);
                    this.nextMode();
                    break;
                }
                if (!Keys.key_fn2) break;
                Settings.bMusic = false;
                Settings.saveSettings();
                XX.soundManager.SetSoundOn(false);
                this.nextMode();
                break;
            }
            case 2: 
            case 3: {
                if (!Keys.key_fire) break;
                this.nextMode();
            }
        }
    }

    public void paint(Graphics g2) {
        g2.setColor(0);
        g2.fillRect(0, Defines.HEIGHT, Defines.WIDTH, Defines.HEIGHT);
        if (MainCanvas.bSyncing) {
            return;
        }
        if (XX.game.bTequilaActive) {
            MainCanvas.tequila.paint(g2);
            return;
        }
        switch (mode) {
            case 4: {
                g2.setClip(0, 0, Defines.WIDTH, Defines.HEIGHT);
                g2.setColor(0xFF0000);
                g2.fillRect(0, 0, Defines.WIDTH, Defines.HEIGHT);
                break;
            }
            case 0: {
                g2.setClip(0, 0, Defines.WIDTH, Defines.HEIGHT);
                Resources.paintBackground(g2);
                this.paintMenu(g2);
                break;
            }
            case 1: {
                g2.setClip(0, 0, Defines.WIDTH, Defines.HEIGHT);
                Resources.imgBackground = Common.createImage("/s.png");
                Resources.paintBackground(g2);
                Resources.paintControls(g2, 0);
                break;
            }
            case 2: 
            case 3: {
                g2.setColor(0);
                g2.fillRect(0, 0, Defines.WIDTH, Defines.HEIGHT);
                Resources.paintBackground(g2);
            }
        }
    }

    public void paintMenu(Graphics g2) {
        int iPosX = 0;
        int iPosY = 0;
        int x2 = (Defines.WIDTH - Resources.iMenuButtonOffW * 8) / 2;
        int buttons = 6;
        int MENU_POS_Y = (Defines.HEIGHT - 6 * (Resources.iMenuButtonOffH + Resources.MENU_BUTTONS_OFFSET)) / 2;
        for (int i2 = 0; i2 < buttons; ++i2) {
            if (i2 == this.iSelectedItem) {
                Resources.paintBorder(1, true, 8, x2, MENU_POS_Y + i2 * (Resources.iMenuButtonOffH + Resources.MENU_BUTTONS_OFFSET), g2);
            } else {
                Resources.paintBorder(1, false, 8, x2, MENU_POS_Y + i2 * (Resources.iMenuButtonOffH + Resources.MENU_BUTTONS_OFFSET), g2);
            }
            iPosY = MENU_POS_Y + i2 * (Resources.iMenuButtonOffH + Resources.MENU_BUTTONS_OFFSET) + (Resources.iMenuButtonOffH - Resources.iFont1H) / 2;
            iPosX = (Defines.WIDTH - Fonts.strWidth(this.menuStrings[i2])) / 2;
            Fonts.drawStr(this.menuStrings[i2], iPosX, iPosY, g2);
        }
    }

    public void pointerPressed(int x2, int y2) {
        this.iSelectedItem = Resources.whichLanguageButton(x2, y2);
        System.out.println("sel item: " + this.iSelectedItem);
        if (mode == 0) {
            Keys.key_fire = true;
            this.keyPressed(Keys.iEnterKey);
            Keys.key_fire = false;
        }
        switch (mode) {
            case 1: {
                if (Resources.isInLeftButton(x2, y2)) {
                    Keys.key_fn1 = true;
                    this.keyPressed(Keys.iLeftKey);
                    Keys.key_fn1 = false;
                }
                if (!Resources.isInRightButton(x2, y2)) break;
                Keys.key_fn2 = true;
                this.keyPressed(Keys.iRightKey);
                Keys.key_fn2 = false;
                break;
            }
            case 2: 
            case 3: {
                Keys.key_fire = true;
                this.keyPressed(8);
                Keys.key_fire = false;
            }
        }
    }

    public void pointerReleased(int x2, int y2) {
    }
}

