/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

public class AstralEffects
extends MIDlet
implements Runnable {
    static final String EFFECT_LIST = "/res/visuals.txt";
    static final String OPTION_LIST = "/res/options.txt";
    static Image source2;
    private static AstralEffects effectHandler;
    static Display display;
    static Font LIST_FONT;
    static Font HEADER_FONT;
    static Vector visuals;
    static Vector options;
    static int currentVisualNumber;
    static int currentOptionNumber;
    static int frameStart;
    static int frameStartO;
    static int size;
    static int numvisualNames;
    static int headerHeight;
    static Font instrFont;
    static Visual currentVisual;
    static boolean keepRunning;
    static boolean drawOptions;
    static boolean drawAbout;
    static boolean drawInstr;
    static boolean showDebug;
    static long lastFrame;
    static int loopDelay;
    static int imageW;
    static int imageH;
    static int imageW2;
    static int imageH2;
    static boolean keyPressHandled;
    static int adjust;
    static int speedCounter;
    int times;
    int id;
    int loopTime;
    static boolean drawMenu;

    public AstralEffects() {
        effectHandler = this;
        drawOptions = false;
        drawAbout = false;
        drawInstr = false;
        AstralEffects.createImages();
    }

    public void startApp() {
        display = Display.getDisplay((MIDlet)this);
        currentOptionNumber = 3;
        LIST_FONT = Font.getFont((int)64, (int)1, (int)8);
        HEADER_FONT = Font.getFont((int)32, (int)1, (int)16);
        instrFont = Font.getFont((int)64, (int)0, (int)8);
        this.loadTextFile();
        display.setCurrent((Displayable)AstralCanvas.getInstance());
        this.loadOptions();
        new Thread(this).start();
    }

    public static boolean getKeepRunning() {
        return keepRunning;
    }

    public void pauseApp() {
    }

    public static void setDisplayable(Displayable d) {
        display.setCurrent(d);
    }

    public void destroyApp(boolean unconditional) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update(Graphics g) {
        if (AstralCanvas.getInstance().back || currentVisual == null && !drawOptions && !drawAbout && !drawInstr) {
            if (AstralCanvas.getInstance().back) {
                currentVisual = null;
            }
            AstralEffects.drawMenu(g);
        } else if (drawAbout) {
            AstralEffects.drawAbout(g);
        } else if (drawInstr) {
            AstralEffects.drawInstr(g);
        } else if (drawOptions) {
            AstralEffects.drawOptions(g);
        } else {
            try {
                Image image = null;
                Visual visual = currentVisual;
                synchronized (visual) {
                    image = currentVisual.getImage();
                }
                g.drawImage(image, 0, AstralCanvas.getCanvasHeight(), 36);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected static void paintCommands(Graphics g) {
        int screenWidth = AstralCanvas.getCanvasWidth();
        int screenHeight = AstralCanvas.getCanvasHeight();
        int cp1 = 90 * screenHeight / 100 - LIST_FONT.getHeight();
        int cp2 = currentVisualNumber * LIST_FONT.getHeight() + HEADER_FONT.getHeight();
        g.setColor(255, 255, 255);
        g.fillRect(27 * screenWidth / 40, 97 * screenHeight / 100 - LIST_FONT.getHeight(), 37 * screenWidth / 30, 4 * screenHeight / 3);
        if (cp1 > cp2 && !drawAbout && !drawInstr) {
            g.fillRect(0, 97 * screenHeight / 100 - LIST_FONT.getHeight(), g.getClipWidth() / 4, g.getClipHeight());
        }
        g.setFont(LIST_FONT);
        g.setColor(0, 0, 0);
        if (cp1 > cp2 && !drawAbout && !drawInstr) {
            g.drawLine(g.getClipWidth() / 4, 97 * screenHeight / 100 - LIST_FONT.getHeight(), 0, 97 * screenHeight / 100 - LIST_FONT.getHeight());
            g.drawLine(g.getClipWidth() / 4, 97 * screenHeight / 100 - LIST_FONT.getHeight(), g.getClipWidth() / 4, screenHeight);
        }
        g.drawLine(27 * screenWidth / 40, 97 * screenHeight / 100 - LIST_FONT.getHeight(), 27 * screenWidth / 40, screenHeight);
        g.drawLine(27 * screenWidth / 40, 97 * screenHeight / 100 - LIST_FONT.getHeight(), screenWidth, 97 * screenHeight / 100 - LIST_FONT.getHeight());
        g.drawString("Options", 70 * screenWidth / 100, 94 * screenHeight / 100, 20);
        if (cp1 > cp2 && !drawAbout && !drawInstr) {
            g.drawString("Select", 0, 94 * g.getClipHeight() / 100, 20);
        }
    }

    public static void setloopDelay(int _loopDelay) {
        loopDelay = _loopDelay;
    }

    public static void drawMenu(Graphics g) {
        int headerHeight = HEADER_FONT.getHeight();
        int screenWidth = AstralCanvas.getCanvasWidth();
        int screenHeight = AstralCanvas.getCanvasHeight();
        for (int i = 0; i < screenWidth * 24 / 10; i += imageW2) {
            for (int j = 0; j < screenHeight * 24 / 10; j += imageH2) {
                g.drawImage(source2, imageW2 / 2 + i, imageH2 / 2 + j, 3);
            }
        }
        g.setFont(LIST_FONT);
        int Ypos = headerHeight;
        int pointIndex = 0;
        int visualPosition = frameStart;
        for (int i = 0; i < size; ++i) {
            String visualName = (String)visuals.elementAt(visualPosition);
            if (visualPosition == currentVisualNumber) {
                g.setColor(0x777777);
                g.fillRect(0, Ypos, g.getClipWidth(), LIST_FONT.getHeight());
            }
            pointIndex = (pointIndex = visualName.lastIndexOf(46)) == -1 ? 0 : ++pointIndex;
            g.setColor(0x111155);
            g.drawSubstring(visualName, pointIndex, visualName.length() - pointIndex, 2, Ypos, 20);
            ++visualPosition;
            Ypos += LIST_FONT.getHeight();
            g.setFont(LIST_FONT);
        }
        AstralEffects.paintCommands(g);
        AstralEffects.paintHeader(g);
        g.setFont(LIST_FONT);
        keepRunning = false;
    }

    public static void drawOptions(Graphics g) {
        int screenWidth = AstralCanvas.getCanvasWidth();
        int screenHeight = AstralCanvas.getCanvasHeight();
        headerHeight = HEADER_FONT.getHeight();
        int Ypos = 97 * screenHeight / 100 - 2 * HEADER_FONT.getHeight();
        boolean pointIndex = false;
        int optionPosition = 0;
        g.setFont(HEADER_FONT);
        g.setColor(255, 255, 255);
        g.fillRect(0, Ypos, screenWidth, screenHeight);
        for (int i = 0; i < 4; ++i) {
            String optionName = (String)options.elementAt(optionPosition);
            if (optionPosition == currentOptionNumber) {
                g.setColor(255, 255, 255);
                g.fillRect(0, Ypos - 3, screenWidth, HEADER_FONT.getHeight());
                g.setColor(66, 157, 215);
                g.fillRect(3, Ypos, screenWidth - 6, HEADER_FONT.getHeight());
            } else {
                g.setColor(255, 255, 255);
                g.fillRect(0, Ypos - 3, screenWidth, HEADER_FONT.getHeight());
                g.setColor(255, 255, 255);
                g.fillRect(0, Ypos, screenWidth, HEADER_FONT.getHeight());
            }
            g.setColor(0x111155);
            g.drawSubstring(optionName, 0, optionName.length(), 5, Ypos, 20);
            ++optionPosition;
            Ypos -= HEADER_FONT.getHeight();
            g.setFont(HEADER_FONT);
        }
        g.setColor(105, 105, 105);
        g.drawLine(3, Ypos += HEADER_FONT.getHeight(), screenWidth - 3, Ypos);
        g.drawLine(3, Ypos, 3, screenHeight);
        g.drawLine(screenWidth - 3, Ypos, screenWidth - 3, screenHeight);
        AstralEffects.paintHeader(g);
        AstralEffects.paintCommands(g);
        g.setFont(LIST_FONT);
    }

    protected static void paintHeaderOptions(Graphics g) {
        g.setFont(HEADER_FONT);
        g.setColor(0, 0, 0);
        g.drawString("Options", 0, 0, 20);
    }

    public static void drawAbout(Graphics g) {
        int screenWidth = AstralCanvas.getCanvasWidth();
        int screenHeight = AstralCanvas.getCanvasHeight();
        g.setColor(0xAAAAAA);
        g.fillRect(0, 0, screenWidth, screenHeight);
        g.setFont(LIST_FONT);
        g.setColor(0, 0, 0);
        g.drawString("Visit mobilevisuals.com", 0, adjust + HEADER_FONT.getHeight() + 0 * LIST_FONT.getHeight(), 20);
        g.drawString("to download mobile", 0, adjust + HEADER_FONT.getHeight() + 1 * LIST_FONT.getHeight(), 20);
        g.drawString("screensavers and wallpaper.", 0, adjust + HEADER_FONT.getHeight() + 2 * LIST_FONT.getHeight(), 20);
        g.drawString("Try our visuals and", 0, adjust + 3 * LIST_FONT.getHeight() + HEADER_FONT.getHeight(), 20);
        g.drawString("screensavers for PC's", 0, adjust + 4 * LIST_FONT.getHeight() + HEADER_FONT.getHeight(), 20);
        g.drawString("on astralvisuals.com!", 0, adjust + HEADER_FONT.getHeight() + 5 * LIST_FONT.getHeight(), 20);
        g.drawString("Contact us on", 0, adjust + HEADER_FONT.getHeight() + 6 * LIST_FONT.getHeight(), 20);
        g.drawString("ae@astralvisuals.com", 0, adjust + HEADER_FONT.getHeight() + 7 * LIST_FONT.getHeight(), 20);
        g.drawString("AstralEffects 2.2 ", 0, adjust + HEADER_FONT.getHeight() + 8 * LIST_FONT.getHeight(), 20);
        g.drawString("\u00a9 Mobile Visuals 2010", 0, adjust + HEADER_FONT.getHeight() + 9 * LIST_FONT.getHeight(), 20);
        if (drawOptions) {
            AstralEffects.drawOptions(g);
        }
        AstralEffects.paintHeader(g);
        AstralEffects.paintCommands(g);
    }

    public static void drawInstr(Graphics g) {
        int screenWidth = AstralCanvas.getCanvasWidth();
        int screenHeight = AstralCanvas.getCanvasHeight();
        g.setColor(0xAAAAAA);
        g.fillRect(0, 0, screenWidth, screenHeight);
        g.setFont(LIST_FONT);
        g.setColor(0, 0, 0);
        g.drawString("Use the up and down ", 0, adjust + HEADER_FONT.getHeight() + 0 * LIST_FONT.getHeight(), 20);
        g.drawString("scroll keys to choose ", 0, adjust + HEADER_FONT.getHeight() + 1 * LIST_FONT.getHeight(), 20);
        g.drawString("between the effects. ", 0, adjust + HEADER_FONT.getHeight() + 2 * LIST_FONT.getHeight(), 20);
        g.drawString("Press select to ", 0, adjust + HEADER_FONT.getHeight() + 3 * LIST_FONT.getHeight(), 20);
        g.drawString("start the chosen effect.", 0, adjust + HEADER_FONT.getHeight() + 4 * LIST_FONT.getHeight(), 20);
        g.drawString("When a visual is ", 0, adjust + HEADER_FONT.getHeight() + 5 * LIST_FONT.getHeight(), 20);
        g.drawString("playing, you can change ", 0, adjust + HEADER_FONT.getHeight() + 6 * LIST_FONT.getHeight(), 20);
        g.drawString("the speed with the up ", 0, adjust + HEADER_FONT.getHeight() + 7 * LIST_FONT.getHeight(), 20);
        g.drawString("and down scroll keys.", 0, adjust + HEADER_FONT.getHeight() + 8 * LIST_FONT.getHeight(), 20);
        g.drawString("Press the # key to  ", 0, adjust + HEADER_FONT.getHeight() + 9 * LIST_FONT.getHeight(), 20);
        g.drawString("remove the Menu-button", 0, adjust + HEADER_FONT.getHeight() + 10 * LIST_FONT.getHeight(), 20);
        g.drawString("when a visual is playing.", 0, adjust + HEADER_FONT.getHeight() + 11 * LIST_FONT.getHeight(), 20);
        if (drawOptions) {
            AstralEffects.drawOptions(g);
        }
        AstralEffects.paintCommands(g);
        AstralEffects.paintHeader(g);
    }

    protected static void paintCommands2(Graphics g, int screenWidth, int screenHeight) {
        g.setColor(255, 255, 255);
        g.fillRect(27 * screenWidth / 40, 9 * screenHeight / 10, screenWidth, screenHeight);
        g.setFont(LIST_FONT);
        g.setColor(0, 0, 0);
        g.drawLine(27 * screenWidth / 40, 9 * screenHeight / 10, 27 * g.getClipWidth() / 40, g.getClipHeight());
        g.drawLine(27 * screenWidth / 40, 9 * screenHeight / 10, g.getClipWidth(), 9 * screenHeight / 10);
        g.drawString("Menu", 72 * screenWidth / 100, 90 * screenHeight / 100, 20);
    }

    protected static void paintHeader(Graphics g) {
        int screenWidth = AstralCanvas.getCanvasWidth();
        int screenHeight = AstralCanvas.getCanvasHeight();
        g.setColor(155, 155, 155);
        g.fillRect(0, 0, screenWidth, HEADER_FONT.getHeight());
        g.setFont(HEADER_FONT);
        g.setColor(0, 0, 0);
        g.drawString("     ASTRAL EFFECTS", 0, 0, 20);
    }

    public static void menuNavigation(int navigation) {
        switch (navigation) {
            case 0: {
                if (currentVisualNumber <= 0 || --currentVisualNumber >= frameStart) break;
                frameStart = currentVisualNumber;
                break;
            }
            case 1: {
                if (currentVisualNumber >= visuals.size() - 1 || ++currentVisualNumber < frameStart + size) break;
                ++frameStart;
                break;
            }
            default: {
                keyPressHandled = false;
            }
        }
    }

    public static void optionNavigation(int navigation) {
        switch (navigation) {
            case 0: {
                if (currentOptionNumber >= 3) break;
                ++currentOptionNumber;
                break;
            }
            case 1: {
                if (currentOptionNumber <= 0) break;
                --currentOptionNumber;
                break;
            }
            default: {
                keyPressHandled = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void manageKeyInteraction(int key, int navigation) {
        keyPressHandled = false;
        if (currentVisual == null) {
            keyPressHandled = true;
            if (!drawOptions) {
                AstralEffects.menuNavigation(navigation);
            } else {
                AstralEffects.optionNavigation(navigation);
            }
            if (keyPressHandled) {
                AstralCanvas.requestRepaint();
                return;
            }
            keyPressHandled = true;
            switch (key) {
                case 333: {
                    if (currentVisual != null) break;
                    AstralEffects.loadEffect();
                    break;
                }
                default: {
                    keyPressHandled = false;
                }
            }
            if (keyPressHandled) {
                AstralCanvas.requestRepaint();
                return;
            }
        } else {
            keyPressHandled = true;
            switch (key) {
                case 334: {
                    if (currentVisual != null) break;
                    effectHandler.notifyDestroyed();
                    break;
                }
                case 333: {
                    if (currentVisual == null) {
                        boolean bl = keepRunning = !keepRunning;
                        if (keepRunning) {
                            effectHandler.run();
                        }
                    } else {
                        keepRunning = false;
                        currentVisual.garbageCollect();
                    }
                    Visual visual = currentVisual;
                    synchronized (visual) {
                        currentVisual = null;
                        break;
                    }
                }
                default: {
                    keyPressHandled = false;
                }
            }
            if (keyPressHandled) {
                AstralCanvas.requestRepaint();
                return;
            }
            keyPressHandled = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tick() {
        if (currentVisual != null) {
            if (speedCounter > 0) {
                --speedCounter;
            }
            Visual visual = currentVisual;
            synchronized (visual) {
                currentVisual.paintVisual();
            }
        }
        AstralCanvas.repaintCanvas();
        if (keepRunning) {
            display.callSerially((Runnable)this);
        }
    }

    public void run() {
        long loopStartTime = System.currentTimeMillis();
        this.tick();
        long loopEndTime = System.currentTimeMillis();
        this.loopTime = (int)(loopEndTime - loopStartTime);
        if (this.loopTime < loopDelay) {
            try {
                display.flashBacklight(loopDelay);
                Thread.sleep(loopDelay - this.loopTime);
            }
            catch (Exception e) {}
        } else {
            display.flashBacklight(this.loopTime);
        }
    }

    private static void loadEffect() {
        String effectName = (String)visuals.elementAt(currentVisualNumber);
        try {
            currentVisual = (Visual)Class.forName(effectName).newInstance();
            currentVisual.init("");
            keepRunning = true;
            effectHandler.run();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadTextFile() {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            InputStream inputStream = this.getClass().getResourceAsStream(EFFECT_LIST);
            int ch = inputStream.read();
            while (ch != -1) {
                if (ch == 44) {
                    visuals.addElement(stringBuffer.toString());
                    stringBuffer.setLength(0);
                } else if (ch != 13 && ch != 10 && ch != 32) {
                    stringBuffer.append((char)ch);
                }
                ch = inputStream.read();
            }
            if (stringBuffer.length() > 0) {
                visuals.addElement(stringBuffer.toString().trim());
            }
            if ((size = (numvisualNames = visuals.size())) * LIST_FONT.getHeight() > AstralCanvas.getCanvasHeight()) {
                size = AstralCanvas.getCanvasHeight() / LIST_FONT.getHeight();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadOptions() {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            InputStream inputStream = this.getClass().getResourceAsStream(OPTION_LIST);
            int ch = inputStream.read();
            while (ch != -1) {
                if (ch == 44) {
                    options.addElement(stringBuffer.toString());
                    stringBuffer.setLength(0);
                } else if (ch != 13 && ch != 10 && ch != 32) {
                    stringBuffer.append((char)ch);
                }
                ch = inputStream.read();
            }
            if (stringBuffer.length() > 0) {
                options.addElement(stringBuffer.toString().trim());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void createImages() {
        try {
            source2 = Image.createImage((String)"/res/spiralm.png");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        imageW2 = source2.getWidth();
        imageH2 = source2.getHeight();
    }

    public static void destroy() {
        effectHandler.notifyDestroyed();
    }

    static {
        visuals = new Vector();
        options = new Vector();
        currentVisualNumber = 0;
        currentOptionNumber = 1;
        frameStart = 0;
        frameStartO = 0;
        size = 0;
        numvisualNames = 0;
        currentVisual = null;
        keepRunning = false;
        drawOptions = false;
        drawAbout = false;
        drawInstr = false;
        showDebug = false;
        lastFrame = 0L;
        loopDelay = 0;
        adjust = 0;
        drawMenu = true;
    }
}

