/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jmicropolygon;

public abstract class GeomUtils {
    static boolean withinBounds(int px, int py, int ax, int ay, int bx, int by, int cx, int cy) {
        if (px < GeomUtils.min(ax, bx, cx) || px > GeomUtils.max(ax, bx, cx) || py < GeomUtils.min(ay, by, cy) || py > GeomUtils.max(ay, by, cy)) {
            return false;
        }
        boolean sameabc = GeomUtils.sameSide(px, py, ax, ay, bx, by, cx, cy);
        boolean samebac = GeomUtils.sameSide(px, py, bx, by, ax, ay, cx, cy);
        boolean samecab = GeomUtils.sameSide(px, py, cx, cy, ax, ay, bx, by);
        return sameabc && samebac && samecab;
    }

    static int[][][] split(int[] xPoints, int[] yPoints, int aIndex, int bIndex) {
        int index;
        int firstLen = bIndex < aIndex ? xPoints.length - aIndex + bIndex + 1 : bIndex - aIndex + 1;
        int secondLen = xPoints.length - firstLen + 2;
        int[][] first = new int[2][firstLen];
        int[][] second = new int[2][secondLen];
        int i = 0;
        while (i < firstLen) {
            index = (aIndex + i) % xPoints.length;
            first[0][i] = xPoints[index];
            first[1][i] = yPoints[index];
            ++i;
        }
        i = 0;
        while (i < secondLen) {
            index = (bIndex + i) % xPoints.length;
            second[0][i] = xPoints[index];
            second[1][i] = yPoints[index];
            ++i;
        }
        int[][][] result = new int[][][]{first, second};
        return result;
    }

    static int[][] trimEar(int[] xPoints, int[] yPoints, int earIndex) {
        int[] newXPoints = new int[xPoints.length - 1];
        int[] newYPoints = new int[yPoints.length - 1];
        int[][] newPoly = new int[][]{newXPoints, newYPoints};
        int p = 0;
        int i = 0;
        while (i < xPoints.length) {
            if (i != earIndex) {
                newXPoints[p] = xPoints[i];
                newYPoints[p] = yPoints[i];
                ++p;
            }
            ++i;
        }
        return newPoly;
    }

    static int indexOfLeast(int[] elements) {
        int index = 0;
        int least = elements[0];
        int i = 1;
        while (i < elements.length) {
            if (elements[i] < least) {
                index = i;
                least = elements[i];
            }
            ++i;
        }
        return index;
    }

    private static boolean sameSide(int p1x, int p1y, int p2x, int p2y, int l1x, int l1y, int l2x, int l2y) {
        long lhs = (p1x - l1x) * (l2y - l1y) - (l2x - l1x) * (p1y - l1y);
        long rhs = (p2x - l1x) * (l2y - l1y) - (l2x - l1x) * (p2y - l1y);
        long product = lhs * rhs;
        boolean result = product >= 0L;
        return result;
    }

    private static int min(int a, int b, int c) {
        return Math.min(Math.min(a, b), c);
    }

    private static int max(int a, int b, int c) {
        return Math.max(Math.max(a, b), c);
    }
}

