/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;

public class AstralCanvas
extends Canvas {
    public static final int BUTTON_WRONG = -1;
    public static final int button_UP = 6;
    public static final int button_DOWN = 7;
    public static final int LEFT_SOFT_KEY = 333;
    public static final int RIGHT_SOFT_KEY = 334;
    public static final int NAV_INVALID = -1;
    public static final int NAVIGATION_UP = 0;
    public static final int NAVIGATION_DOWN = 1;
    public static final int NAV_BACK = 5;
    private static AstralCanvas canvas;
    private static Graphics g2;
    private AstralEffects astralEffectsManager = null;
    public boolean back;

    private AstralCanvas() {
        this.setFullScreenMode(true);
    }

    public void keyPressed(int gameActionCode) {
        this.back = false;
        int button = AstralCanvas.getButton(gameActionCode);
        int navigation = AstralCanvas.determineNavigation(gameActionCode);
        if (gameActionCode == -6) {
            button = 333;
            navigation = 333;
            if (AstralEffects.drawOptions) {
                this.back = this.handleOptions();
                AstralEffects.drawOptions = false;
            }
        } else if (gameActionCode == -7) {
            System.out.println("1");
            if (AstralEffects.getKeepRunning()) {
                if (AstralEffects.drawAbout) {
                    AstralEffects.drawOptions = true;
                    AstralEffects.keepRunning = false;
                    AstralEffects.currentVisual = null;
                    AstralEffects.drawAbout = false;
                    AstralEffects.currentOptionNumber = 1;
                }
                if (AstralEffects.drawInstr) {
                    AstralEffects.drawOptions = true;
                    AstralEffects.keepRunning = false;
                    AstralEffects.currentVisual = null;
                    AstralEffects.drawInstr = false;
                    AstralEffects.currentOptionNumber = 1;
                } else {
                    button = 334;
                    navigation = 334;
                }
            } else {
                if (!this.back) {
                    AstralEffects.currentOptionNumber = 3;
                    AstralEffects.drawOptions = true;
                }
                AstralCanvas.requestRepaint();
            }
        } else if (gameActionCode == 35) {
            AstralEffects.drawMenu = false;
        }
        if (button == -1 && navigation == -1) {
            return;
        }
        AstralEffects.manageKeyInteraction(button, navigation);
    }

    protected boolean handleOptions() {
        boolean back = false;
        if (AstralEffects.drawOptions) {
            if (AstralEffects.currentOptionNumber == 3) {
                System.out.println("1");
                AstralEffects.drawInstr = true;
            } else if (AstralEffects.currentOptionNumber == 2) {
                AstralEffects.drawAbout = true;
            } else if (AstralEffects.currentOptionNumber == 1) {
                AstralEffects.drawOptions = false;
                back = true;
                AstralEffects.currentVisual = null;
                AstralEffects.display.setCurrent((Displayable)AstralCanvas.getInstance());
                AstralCanvas.requestRepaint();
            } else if (AstralEffects.currentOptionNumber == 0) {
                AstralEffects.destroy();
            }
        }
        return back;
    }

    public void paint(Graphics g) {
        g2 = g;
        try {
            AstralEffects.update(g2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        g2 = null;
    }

    public static final AstralCanvas getInstance() {
        if (canvas == null) {
            canvas = new AstralCanvas();
        }
        return canvas;
    }

    public static final int getCanvasHeight() {
        AstralCanvas.getInstance();
        return canvas.getHeight();
    }

    public static final int getCanvasWidth() {
        AstralCanvas.getInstance();
        return canvas.getWidth();
    }

    public static final boolean canvasIsShown() {
        return AstralCanvas.getInstance().isShown();
    }

    public static final int getButton(int gameActionCode) {
        int button = -1;
        if (button != -1) {
            return button;
        }
        AstralCanvas.getInstance();
        gameActionCode = canvas.getGameAction(gameActionCode);
        switch (gameActionCode) {
            case 1: {
                button = 6;
                break;
            }
            case 6: {
                button = 7;
                break;
            }
            case 8: {
                if (AstralEffects.drawOptions) break;
                button = 333;
            }
        }
        return button;
    }

    public static final int determineNavigation(int gameActionCode) {
        int navigation = -1;
        switch (gameActionCode) {
            case 50: {
                navigation = 0;
                break;
            }
            case 56: {
                navigation = 1;
            }
        }
        if (navigation != -1) {
            return navigation;
        }
        AstralCanvas.getInstance();
        gameActionCode = canvas.getGameAction(gameActionCode);
        switch (gameActionCode) {
            case 1: {
                if (AstralEffects.currentVisual != null) {
                    AstralEffects.speedCounter = 40;
                    if (AstralEffects.loopDelay > 10) {
                        AstralEffects.loopDelay -= 5;
                        break;
                    }
                    if (AstralEffects.loopDelay <= 0 || AstralEffects.loopDelay > 10) break;
                    --AstralEffects.loopDelay;
                    break;
                }
                navigation = 0;
                break;
            }
            case 6: {
                if (AstralEffects.currentVisual != null) {
                    AstralEffects.speedCounter = 40;
                    if (AstralEffects.loopDelay < 95) {
                        AstralEffects.loopDelay += 5;
                        break;
                    }
                    if (AstralEffects.loopDelay < 95 || AstralEffects.loopDelay >= 100) break;
                    ++AstralEffects.loopDelay;
                    break;
                }
                navigation = 1;
                break;
            }
            case 8: {
                if (AstralEffects.drawOptions) break;
                navigation = 333;
            }
        }
        return navigation;
    }

    public static final void requestRepaint() {
        AstralCanvas.getInstance();
        if (!canvas.isShown()) {
            return;
        }
        canvas.repaint();
    }

    public static final void repaintCanvas() {
        AstralCanvas.getInstance();
        if (!canvas.isShown()) {
            return;
        }
        canvas.repaint();
        canvas.serviceRepaints();
    }

    static {
        g2 = null;
    }
}

