/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Crystalizer
extends Visual {
    private Image m_fireImg;
    Graphics g;
    ColorCreaterSmooth rb1;
    Random rand;
    int realtime = 0;
    int ColorIncr;
    int[] simp1;
    int frameCenterX;
    int frameCenterY;
    boolean appletStarted = true;
    int counter = 0;
    int[] sinTable;
    int[] cosTable;
    int polyRadius;
    int maxPolyRadius;
    int maxCircDiam;
    boolean drawBkgd = true;
    int nextBkgdRedraw = 0;
    boolean isStopped = false;
    int xStart;
    int yStart;
    int hFactor;
    int minCircDiam;
    int colour;
    int[][] palette;
    int numClrs = 256;
    int curClr = 0;
    int startClr = 0;

    public void init(String args) {
        this.m_fireImg = Image.createImage((int)s_screenWidth, (int)s_screenHeight);
        this.g = this.m_fireImg.getGraphics();
        if (s_screenWidth < 160) {
            AstralEffects.setloopDelay(70);
        } else if (s_screenWidth < 220 && s_screenWidth >= 160) {
            AstralEffects.setloopDelay(70);
        } else {
            AstralEffects.setloopDelay(40);
        }
        this.rand = new Random(System.currentTimeMillis());
        this.simp1 = new int[3];
        this.sinTable = new int[360];
        this.cosTable = new int[360];
        int maxr = RandomLibrary.Intervall(this.rand, 0, 255);
        int maxg = RandomLibrary.Intervall(this.rand, 0, 255);
        int maxb = RandomLibrary.Intervall(this.rand, 0, 255);
        this.ColorIncr = 40;
        this.rb1 = new ColorCreaterSmooth(this, maxr / 2, maxg / 2, maxb / 2, maxr, maxg, maxb, this.ColorIncr, 55);
        this.setTables();
        this.frameCenterX = s_screenWidth / 2;
        this.frameCenterY = s_screenHeight / 2;
        this.maxPolyRadius = s_screenHeight * 42 / 100;
        this.maxCircDiam = s_screenHeight * 5 / 2;
        this.minCircDiam = s_screenHeight / 3;
        this.hFactor = 1;
        this.SetUpPalette();
    }

    public void randomize2() {
        this.rb1.reset(55 + RandomLibrary.Intervall(this.rand, 0, 200), 55 + RandomLibrary.Intervall(this.rand, 0, 200), 55 + RandomLibrary.Intervall(this.rand, 0, 200));
    }

    public void setTables() {
        for (int i = 0; i < 360; ++i) {
            this.sinTable[i] = TrigLookupTable.getSinus(i);
            this.cosTable[i] = TrigLookupTable.getCosinus(i);
        }
    }

    public void garbageCollect() {
        this.m_fireImg = null;
        this.rand = null;
        this.simp1 = null;
        this.sinTable = null;
        this.cosTable = null;
        this.rb1.garbageCollect();
        this.rb1 = null;
    }

    protected void paint() {
        ++this.realtime;
        boolean nextFigure = true;
        boolean drawDir = false;
        int numSides = 0;
        int z = 0;
        int step = 0;
        if (RandomLibrary.Intervall(this.rand, 0, 1000) < 80) {
            this.randomize2();
        }
        if (!this.appletStarted) {
            int xPos = this.xStart;
            int yPos = this.yStart;
        }
        if (this.appletStarted) {
            if (this.counter == this.nextBkgdRedraw || this.realtime < 5) {
                this.counter = 0;
                this.nextBkgdRedraw = RandomLibrary.Intervall(this.rand, 0, 10) + 8;
                int circX = this.frameCenterX - this.maxCircDiam / 2;
                int circY = this.frameCenterY - this.maxCircDiam / 2;
                for (int circDiam = this.maxCircDiam; circDiam >= this.minCircDiam; circDiam -= 10) {
                    this.curClr += 15;
                    if (this.curClr >= 256) {
                        this.curClr -= 256;
                    } else if (this.curClr < 0) {
                        this.curClr += 256;
                    }
                    this.g.setColor(this.palette[this.curClr][0], this.palette[this.curClr][1], this.palette[this.curClr][2]);
                    this.g.fillArc(circX, circY, circDiam, circDiam, 0, 360);
                    circX += 5;
                    circY += 5;
                }
                this.drawBkgd = false;
            }
            this.draw(numSides, z, step, this.g);
            ++this.counter;
        }
        this.paintCommands(this.g);
    }

    protected void draw(int numSides, int z, int step, Graphics g) {
        int oldx = 0;
        int oldy = 0;
        int choice = RandomLibrary.Intervall(this.rand, 0, 20);
        numSides = RandomLibrary.Intervall(this.rand, 0, 20);
        z = RandomLibrary.Intervall(this.rand, 0, 15) + 15;
        if (numSides < 3) {
            numSides = 3;
        }
        if (z < 2) {
            z = 2;
        }
        step = 1;
        if (choice < 11) {
            this.polyRadius = 1;
            while (this.polyRadius < this.maxPolyRadius) {
                ++this.curClr;
                if (this.curClr >= 256) {
                    this.curClr -= 256;
                } else if (this.curClr < 0) {
                    this.curClr += 256;
                }
                g.setColor(this.palette[this.curClr][0], this.palette[this.curClr][1], this.palette[this.curClr][2]);
                for (int curSide = 0; curSide <= numSides; ++curSide) {
                    int angle = 360 * curSide * z / numSides % 360;
                    int x = (int)((long)this.cosTable[angle] * (long)this.polyRadius / 100000L);
                    int y = (int)((long)this.sinTable[angle] * (long)this.polyRadius / 100000L);
                    x += this.frameCenterX;
                    y += this.frameCenterY;
                    if (curSide > 0) {
                        if (curSide == 1 && y == oldy) break;
                        g.drawLine(x, y, oldx, oldy);
                    }
                    oldx = x;
                    oldy = y;
                }
                this.polyRadius += step;
            }
        } else {
            this.polyRadius = this.maxPolyRadius;
            while (this.polyRadius > 1) {
                ++this.curClr;
                if (this.curClr >= 256) {
                    this.curClr -= 256;
                } else if (this.curClr < 0) {
                    this.curClr += 256;
                }
                g.setColor(this.palette[this.curClr][0], this.palette[this.curClr][1], this.palette[this.curClr][2]);
                for (int curSide = 0; curSide <= numSides; ++curSide) {
                    int angle = 360 * curSide * z / numSides % 360;
                    int x = (int)((long)this.cosTable[angle] * (long)this.polyRadius / 100000L);
                    int y = (int)((long)this.sinTable[angle] * (long)this.polyRadius / 100000L);
                    x += this.frameCenterX;
                    y += this.frameCenterY;
                    if (curSide > 0) {
                        if (curSide == 1 && y == oldy) break;
                        g.drawLine(x, y, oldx, oldy);
                    }
                    oldx = x;
                    oldy = y;
                }
                this.polyRadius -= step;
            }
        }
    }

    public void manageKeyPress(int keyCode) {
        boolean handled = true;
    }

    public void paintVisual() {
        this.paint();
    }

    private void SetUpPalette() {
        int i;
        this.palette = new int[this.numClrs][3];
        int r = 255;
        int g = 0;
        int b = 0;
        for (i = 0; i <= 50; ++i) {
            this.palette[i][0] = r;
            this.palette[i][1] = g;
            this.palette[i][2] = b;
            g += 5;
        }
        r = 255;
        g = 255;
        b = 0;
        for (i = 51; i <= 101; ++i) {
            this.palette[i][0] = r;
            this.palette[i][1] = g;
            this.palette[i][2] = b;
            r -= 5;
        }
        r = 0;
        g = 255;
        b = 0;
        for (i = 102; i <= 152; ++i) {
            this.palette[i][0] = r;
            this.palette[i][1] = g;
            this.palette[i][2] = b;
            g -= 5;
            b += 5;
        }
        r = 0;
        g = 0;
        b = 255;
        for (i = 153; i <= 203; ++i) {
            this.palette[i][0] = r;
            this.palette[i][1] = g;
            this.palette[i][2] = b;
            r += 5;
        }
        r = 255;
        g = 0;
        b = 255;
        for (i = 204; i <= 255; ++i) {
            this.palette[i][0] = r;
            this.palette[i][1] = g;
            this.palette[i][2] = b;
            b -= 5;
        }
    }

    public Image getImage() {
        return this.m_fireImg;
    }
}

