/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class CurveGenerator
extends Visual {
    private ColorCreaterSmooth rb1;
    private Random rand;
    private int maxR;
    private int maxG;
    private int maxB;
    private int minG;
    private int minB;
    private int minR;
    private int rMiniAdjuster;
    private int gMiniAdjuster;
    private int bMiniAdjuster;
    private int emptySpaceAvoider;
    private int cos;
    private int sin;
    private int angle;
    private int interferens;
    private int cosValueFromCurve1;
    private int sinValueFromCurve1;
    private int curve1 = 0;
    private int curve2 = 0;
    private int cosValueFromCurve2;
    private int sinValueFromCurve2;
    private int curve3 = 0;
    private int curve4 = 0;
    private int pulse;
    private int max;
    private int incr;
    private int valleyMin;
    private int ColorIncr;
    private int idivitionAdjuster;
    private boolean paintBlack = true;
    private int valleyMax;
    private int pulseIncr;
    private int adjuster;
    private int fixedPointY;
    private int fixedPointX;
    private int[] colorValues;
    private int x = 0;
    private int y = 0;
    private int oldx;
    private int oldy;
    private Image m_fireImg;
    Graphics g;
    int[] simp1;

    public void init(String args) {
        this.m_fireImg = Image.createImage((int)s_screenWidth, (int)s_screenHeight);
        this.g = this.m_fireImg.getGraphics();
        this.rand = new Random(System.currentTimeMillis());
        this.setValues();
        this.simp1 = new int[3];
        int maxr = RandomLibrary.Intervall(this.rand, 0, 255);
        int maxg = RandomLibrary.Intervall(this.rand, 0, 255);
        int maxb = RandomLibrary.Intervall(this.rand, 0, 255);
        this.rb1 = new ColorCreaterSmooth(this, maxr / 2, maxg / 2, maxb / 2, maxr, maxg, maxb, this.ColorIncr, 5);
        this.pulseIncr = 15 * s_screenWidth / 240;
        this.max = s_screenWidth * 10 / 10;
        this.emptySpaceAvoider = 130;
        this.incr = 2;
        this.adjuster = 1;
        if (s_screenWidth >= 220) {
            AstralEffects.setloopDelay(0);
        } else if (s_screenWidth < 220 && s_screenWidth >= 160) {
            AstralEffects.setloopDelay(14);
        } else {
            AstralEffects.setloopDelay(20);
        }
        this.fixedPointY = s_screenHeight * 5 / 10;
        this.fixedPointX = s_screenWidth * 5 / 10;
        this.createCurve();
    }

    public void paintVisual() {
        this.iterate();
        this.paint();
    }

    public void manageKeyPress(int keyCode) {
        boolean handled = true;
    }

    public void randomize() {
        this.ColorIncr = 1;
        this.maxR = 105 + RandomLibrary.Intervall(this.rand, 0, 150);
        this.maxG = 105 + RandomLibrary.Intervall(this.rand, 0, 150);
        this.maxB = 105 + RandomLibrary.Intervall(this.rand, 0, 150);
        this.rMiniAdjuster = RandomLibrary.Intervall(this.rand, 0, 10);
        this.gMiniAdjuster = RandomLibrary.Intervall(this.rand, 0, 100) / 10;
        this.bMiniAdjuster = RandomLibrary.Intervall(this.rand, 0, 100) / 10;
        this.minR = this.rMiniAdjuster * this.maxR / 10;
        this.minG = this.gMiniAdjuster * this.maxG / 10;
        this.minB = this.bMiniAdjuster * this.maxB / 10;
        try {
            this.rb1.reset(this.maxR, this.maxG, this.maxB, this.minR, this.minG, this.minB);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void setValues() {
        this.valleyMax = 9;
        this.valleyMin = 1;
        this.ColorIncr = 1;
    }

    public void garbageCollect() {
        this.m_fireImg = null;
    }

    public String getUsage() {
        return " ";
    }

    public void handleKeyPress(int keyCode) {
        boolean handled = true;
    }

    public void iterate() {
        if (this.pulse < this.max * 2) {
            this.pulse += this.pulseIncr;
        } else {
            this.pulse = 0;
            this.createCurve();
            this.randomize();
            this.paintBlack = true;
        }
        this.paint();
    }

    private void createCurve() {
        int chooser1 = RandomLibrary.Intervall(this.rand, 0, this.valleyMax) + this.valleyMin;
        this.curve1 = RandomLibrary.Intervall(this.rand, 0, this.valleyMax) + this.valleyMin;
        this.curve2 = RandomLibrary.Intervall(this.rand, 0, this.valleyMax) + this.valleyMin;
        int chooser2 = RandomLibrary.Intervall(this.rand, 0, 15) + 2;
        int chooser3 = RandomLibrary.Intervall(this.rand, 0, 15) + 2;
        this.curve3 = this.curve1 * chooser3;
        this.curve4 = this.curve2 * chooser2;
    }

    protected void paint() {
        int MiniAdjuster = 36000000 / (s_screenWidth * 50);
        if (this.paintBlack) {
            this.g.setColor(0);
            this.g.fillRect(0, 0, s_screenWidth, s_screenHeight);
        }
        this.paintBlack = false;
        this.colorValues = this.rb1.createColor();
        this.simp1 = this.rb1.createColor();
        this.g.setColor(this.simp1[0], this.simp1[1], this.simp1[2]);
        for (int i = 0; i < s_screenWidth - 1; i += this.incr) {
            this.angle = i * MiniAdjuster / 1000 % 360;
            this.cosValueFromCurve1 = TrigLookupTable.getCosinus(this.angle * this.curve1);
            this.sinValueFromCurve1 = TrigLookupTable.getSinus(this.angle * this.curve2);
            this.cosValueFromCurve2 = TrigLookupTable.getCosinus(this.angle * this.curve3);
            this.sinValueFromCurve2 = TrigLookupTable.getSinus(this.angle * this.curve4);
            this.cos = TrigLookupTable.getCosinus(this.angle);
            this.sin = TrigLookupTable.getSinus(this.angle);
            this.interferens = (8 * this.cosValueFromCurve1 + 8 * this.sinValueFromCurve1 + 2 * this.cosValueFromCurve2 + 2 * this.sinValueFromCurve2) / 8;
            long x2 = (3L * (long)this.pulse * ((long)this.adjuster * (long)this.cos / 10000L) * (long)this.interferens + (long)this.emptySpaceAvoider * (long)this.pulse * (long)this.adjuster * (long)this.cos) / (100000L * (long)this.max);
            this.x = this.fixedPointX - (int)x2;
            long y2 = (3L * (long)this.pulse * ((long)this.adjuster * (long)this.sin / 10000L) * (long)this.interferens + (long)this.emptySpaceAvoider * (long)this.pulse * (long)this.adjuster * (long)this.sin) / (100000L * (long)this.max);
            this.y = this.fixedPointY - (int)y2;
            if (i != 0 || i == s_screenWidth - 1) {
                this.g.drawLine(this.x, this.y, this.oldx, this.oldy);
            }
            this.oldx = this.x;
            this.oldy = this.y;
        }
        this.paintCommands(this.g);
    }

    public Image getImage() {
        return this.m_fireImg;
    }
}

