/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import net.sourceforge.jmicropolygon.PolygonGraphics;

public class HypnoticMandala
extends Visual {
    private Image image;
    Graphics g;
    Random rand;
    int count;
    int Arraysize;
    int[] simp1;
    int centerX;
    int centerY;
    int oldx;
    int oldy;
    int argb;
    int[][] palette;
    int numClrs = 256;
    int clr1;
    int clr2;
    int r;
    int size;
    int maxSize;
    int sizeIncr;
    int colorIncr;
    int minIncr;
    int maxIncr;
    int minPetals;
    int maxPetals;
    int numPetals;
    int angleDegs;
    int x;
    int y;
    int[] xs;
    int[] ys;
    boolean drawOut = true;
    boolean chooseDrawDir = true;
    boolean rotOn = false;
    boolean mixModeOn = true;
    long scale = 0L;
    int spinRate = 1;
    int angleDegIncr = 30;
    int which;
    boolean firstPalPass = true;
    int rr;
    int gg;
    int b;
    long firstFrame;
    long frames;
    long fps;
    long elapsedTime;
    int chooser;

    public void init(String args) {
        if (s_screenWidth >= 220) {
            AstralEffects.setloopDelay(0);
        } else if (s_screenWidth < 220 && s_screenWidth >= 160) {
            AstralEffects.setloopDelay(14);
        } else {
            AstralEffects.setloopDelay(18);
        }
        this.image = Image.createImage((int)s_screenWidth, (int)s_screenHeight);
        this.g = this.image.getGraphics();
        this.rand = new Random(System.currentTimeMillis());
        this.centerX = s_screenWidth / 2;
        this.centerY = s_screenHeight / 2;
        this.palette = new int[this.numClrs][3];
        this.CreateRandomPalette();
        this.size = 1;
        this.maxSize = s_screenWidth >= s_screenHeight ? s_screenHeight / 2 * 4 / 3 : s_screenWidth / 2;
        this.which = 0;
        this.minPetals = 2;
        this.maxPetals = 8;
        this.maxIncr = 10;
        this.minIncr = 1;
        this.Arraysize = 360 / this.angleDegIncr;
        this.xs = new int[this.size];
        this.ys = new int[this.size];
    }

    protected void paint() {
        int counter = 0;
        ++this.count;
        if (this.count < 2) {
            this.g.setColor(0, 125, 0);
            this.g.fillRect(0, 0, s_screenWidth, s_screenHeight);
        }
        if (this.scale == 0L) {
            this.scale = 10L;
        }
        this.Arraysize = 360 / this.angleDegIncr;
        this.xs = new int[this.Arraysize];
        this.ys = new int[this.Arraysize];
        this.angleDegs = 0;
        while (this.angleDegs < 360) {
            switch (this.which) {
                case 0: {
                    int toTrig = this.numPetals * (this.angleDegs + 180000 * this.size / (this.spinRate * 3145));
                    if (toTrig < 0) {
                        toTrig = 0 - toTrig;
                    }
                    this.r = (int)((long)this.size * (this.scale + (long)TrigLookupTable.getCosinus(toTrig % 360)) / 100000L);
                }
            }
            int c = TrigLookupTable.getCosinus(this.angleDegs % 360);
            int s = TrigLookupTable.getSinus(this.angleDegs % 360);
            this.x = (int)((long)this.r * (long)c / 100000L);
            this.y = (int)((long)this.r * (long)s / 100000L);
            if (this.rotOn) {
                int tempX = (int)(((long)this.x * (long)c - (long)this.y * (long)s) / 100000L);
                int tempY = (int)(((long)this.x * (long)s + (long)this.y * (long)c) / 100000L);
                this.x = tempX;
                this.y = tempY;
            }
            this.x += this.centerX;
            this.y += this.centerY;
            if (counter < this.xs.length) {
                this.xs[counter] = this.x;
                this.ys[counter] = this.y;
            }
            ++counter;
            this.angleDegs += this.angleDegIncr;
        }
        this.g.setColor(this.palette[this.clr2][0], this.palette[this.clr2][1], this.palette[this.clr2][2]);
        PolygonGraphics.fillPolygon(this.g, this.xs, this.ys);
        this.chooseColorsAndPulse();
        if (this.chooseDrawDir) {
            this.selectNewParameters();
            this.CreateRandomPalette();
            if (RandomLibrary.Intervall(this.rand, 0, 12) == 1) {
                this.g.setColor(0, 125, 0);
                this.g.fillRect(0, 0, s_screenWidth, s_screenHeight);
            }
        }
        this.paintCommands(this.g);
    }

    protected void chooseColorsAndPulse() {
        if (this.drawOut) {
            this.clr1 += this.colorIncr;
            if (this.clr1 > 255) {
                this.clr1 -= 255;
            }
            this.clr2 += this.colorIncr;
            if (this.clr2 > 255) {
                this.clr2 -= 255;
            }
            if (this.size < this.maxSize) {
                this.size += this.sizeIncr;
            } else {
                this.chooseDrawDir = true;
            }
        } else {
            this.clr1 -= this.colorIncr;
            if (this.clr1 < 0) {
                this.clr1 += 255;
            }
            this.clr2 -= this.colorIncr;
            if (this.clr2 < 0) {
                this.clr2 += 255;
            }
            this.size -= this.sizeIncr;
            if (this.size < 1) {
                this.chooseDrawDir = true;
            }
        }
    }

    protected void selectNewParameters() {
        int choice = RandomLibrary.Intervall(this.rand, 0, 10);
        if (choice < 5) {
            this.drawOut = true;
            this.size = 1;
        } else {
            this.drawOut = false;
            this.size = this.maxSize;
        }
        this.colorIncr = RandomLibrary.Intervall(this.rand, 0, 10 * this.maxIncr) / 10 + this.minIncr;
        this.clr1 = RandomLibrary.Intervall(this.rand, 0, 255);
        this.clr2 = RandomLibrary.Intervall(this.rand, 0, 255);
        this.scale = RandomLibrary.Intervall(this.rand, 0, 90000) + 10000;
        this.angleDegIncr = 5;
        this.chooseDrawDir = false;
        this.scale = 77000L;
        this.rotOn = false;
        this.fixedValues();
    }

    protected void fixedValues() {
        this.chooser = RandomLibrary.Intervall(this.rand, 0, 440) / 10;
        switch (this.chooser) {
            case 0: {
                this.numPetals = 7;
                this.sizeIncr = 2;
                this.spinRate = -20;
                break;
            }
            case 1: {
                this.numPetals = 5;
                this.sizeIncr = 2;
                this.spinRate = -47;
                break;
            }
            case 2: {
                this.numPetals = 4;
                this.sizeIncr = 2;
                this.spinRate = -19;
                break;
            }
            case 3: {
                this.numPetals = 4;
                this.sizeIncr = 2;
                this.spinRate = -20;
                break;
            }
            case 4: {
                this.numPetals = 3;
                this.sizeIncr = 2;
                this.spinRate = 34;
                break;
            }
            case 5: {
                this.numPetals = 7;
                this.sizeIncr = 2;
                this.spinRate = -32;
                break;
            }
            case 6: {
                this.numPetals = 7;
                this.sizeIncr = 2;
                this.spinRate = -18;
                break;
            }
            case 7: {
                this.numPetals = 7;
                this.sizeIncr = 2;
                this.spinRate = 23;
                break;
            }
            case 8: {
                this.numPetals = 8;
                this.sizeIncr = 2;
                this.spinRate = 20;
                break;
            }
            case 9: {
                this.numPetals = 9;
                this.sizeIncr = 2;
                this.spinRate = 24;
                break;
            }
            case 10: {
                this.numPetals = 7;
                this.sizeIncr = 2;
                this.spinRate = 43;
                break;
            }
            case 11: {
                this.numPetals = 4;
                this.sizeIncr = 2;
                this.spinRate = -12;
                break;
            }
            case 12: {
                this.numPetals = 3;
                this.sizeIncr = 2;
                this.spinRate = -26;
                break;
            }
            case 13: {
                this.numPetals = 5;
                this.sizeIncr = 2;
                this.spinRate = 19;
                break;
            }
            case 14: {
                this.numPetals = 6;
                this.sizeIncr = 2;
                this.spinRate = -40;
                break;
            }
            case 15: {
                this.numPetals = 4;
                this.sizeIncr = 2;
                this.spinRate = 17;
                break;
            }
            case 16: {
                this.numPetals = 4;
                this.sizeIncr = 2;
                this.spinRate = 27;
                break;
            }
            case 17: {
                this.numPetals = 9;
                this.sizeIncr = 2;
                this.spinRate = 43;
                break;
            }
            case 18: {
                this.numPetals = 4;
                this.sizeIncr = 2;
                this.spinRate = 45;
                break;
            }
            case 19: {
                this.numPetals = 9;
                this.sizeIncr = 2;
                this.spinRate = 35;
                break;
            }
            case 20: {
                this.numPetals = 8;
                this.sizeIncr = 2;
                this.spinRate = 47;
                break;
            }
            case 21: {
                this.numPetals = 5;
                this.sizeIncr = 2;
                this.spinRate = 46;
                break;
            }
            case 22: {
                this.numPetals = 6;
                this.sizeIncr = 2;
                this.spinRate = 30;
                break;
            }
            case 23: {
                this.numPetals = 7;
                this.sizeIncr = 2;
                this.spinRate = -21;
                break;
            }
            case 24: {
                this.numPetals = 7;
                this.sizeIncr = 2;
                this.spinRate = -34;
                break;
            }
            case 25: {
                this.numPetals = 6;
                this.sizeIncr = 2;
                this.spinRate = 4;
                break;
            }
            case 26: {
                this.numPetals = 7;
                this.sizeIncr = 2;
                this.spinRate = 31;
                break;
            }
            case 27: {
                this.numPetals = 6;
                this.sizeIncr = 2;
                this.spinRate = -43;
                break;
            }
            case 28: {
                this.numPetals = 9;
                this.sizeIncr = 2;
                this.spinRate = 39;
                break;
            }
            case 29: {
                this.numPetals = 6;
                this.sizeIncr = 2;
                this.spinRate = 24;
                break;
            }
            case 30: {
                this.numPetals = 5;
                this.sizeIncr = 2;
                this.spinRate = -37;
                break;
            }
            case 31: {
                this.numPetals = 5;
                this.sizeIncr = 2;
                this.spinRate = 39;
                break;
            }
            case 32: {
                this.numPetals = 4;
                this.sizeIncr = 2;
                this.spinRate = -46;
                break;
            }
            case 33: {
                this.numPetals = 6;
                this.sizeIncr = 2;
                this.spinRate = 1;
                break;
            }
            case 34: {
                this.numPetals = 4;
                this.sizeIncr = 2;
                this.spinRate = -47;
                break;
            }
            case 35: {
                this.numPetals = 7;
                this.sizeIncr = 2;
                this.spinRate = 48;
                break;
            }
            case 36: {
                this.numPetals = 6;
                this.sizeIncr = 2;
                this.spinRate = -14;
                break;
            }
            case 37: {
                this.numPetals = 5;
                this.sizeIncr = 2;
                this.spinRate = 31;
                break;
            }
            case 38: {
                this.numPetals = 9;
                this.sizeIncr = 2;
                this.spinRate = -26;
                break;
            }
            case 39: {
                this.numPetals = 6;
                this.sizeIncr = 2;
                this.spinRate = 39;
                break;
            }
            case 40: {
                this.numPetals = 4;
                this.sizeIncr = 2;
                this.spinRate = -35;
                break;
            }
            case 41: {
                this.numPetals = 6;
                this.sizeIncr = 2;
                this.spinRate = -33;
                break;
            }
            case 42: {
                this.numPetals = 5;
                this.sizeIncr = 2;
                this.spinRate = 51;
                break;
            }
            case 43: {
                this.numPetals = 4;
                this.sizeIncr = 2;
                this.spinRate = 23;
            }
        }
    }

    public void garbageCollect() {
        this.image = null;
        this.rand = null;
        this.palette = null;
        this.xs = null;
        this.ys = null;
    }

    public void manageKeyPress(int keyCode) {
        boolean handled = true;
    }

    public void paintVisual() {
        this.paint();
    }

    private void CreateRandomPalette() {
        int bIncr;
        int gIncr;
        int rIncr;
        if (this.firstPalPass) {
            int redStart = RandomLibrary.Intervall(this.rand, 0, 256);
            int greenStart = RandomLibrary.Intervall(this.rand, 0, 256);
            int blueStart = RandomLibrary.Intervall(this.rand, 0, 256);
            this.rr = redStart;
            this.gg = greenStart;
            this.b = blueStart;
            this.firstPalPass = false;
        }
        int c = 5;
        int d = (c - 1) / 2;
        while ((rIncr = RandomLibrary.Intervall(this.rand, 0, c) - d) == 0) {
        }
        while ((gIncr = RandomLibrary.Intervall(this.rand, 0, c) - d) == 0) {
        }
        while ((bIncr = RandomLibrary.Intervall(this.rand, 0, c) - d) == 0) {
        }
        for (int index = 0; index < 256; ++index) {
            int red = this.rr;
            do {
                if (red > 255) {
                    red = 255 - (red - 255);
                }
                if (red >= 0) continue;
                red = -red;
            } while (red > 255 || red < 0);
            int green = this.gg;
            do {
                if (green > 255) {
                    green = 255 - (green - 255);
                }
                if (green >= 0) continue;
                green = -green;
            } while (green > 255 || green < 0);
            int blue = this.b;
            do {
                if (blue > 255) {
                    blue = 255 - (blue - 255);
                }
                if (blue >= 0) continue;
                blue = -blue;
            } while (blue > 255 || blue < 0);
            this.palette[index][0] = red;
            this.palette[index][1] = green;
            this.palette[index][2] = blue;
            this.rr += rIncr;
            this.gg += gIncr;
            this.b += bIncr;
        }
    }

    public Image getImage() {
        return this.image;
    }
}

