/*
 * Decompiled with CFR 0.152.
 */
package movilib;

import com.movilenio.game.Kernel;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import movilib.SpriteImage;

public class SPRManager {
    public static final int INV_H = 1;
    public static final int INV_V = 2;
    private static int[] crc_table = new int[256];
    public SpriteImage[] sprites;
    private int offset;
    private byte[] buffer;

    private final int calcCRC32(int off, int len) {
        int c = -1;
        while (--len >= 0) {
            c = crc_table[(c ^ this.buffer[off++]) & 0xFF] ^ c >>> 8;
        }
        return ~c;
    }

    private final void writeInt(int off, int value) {
        this.buffer[off] = (byte)(value >>> 24);
        this.buffer[off + 1] = (byte)(value >>> 16);
        this.buffer[off + 2] = (byte)(value >>> 8);
        this.buffer[off + 3] = (byte)value;
    }

    private void makeChunk(String name, int size) {
        this.writeInt(this.offset, size);
        System.arraycopy(name.getBytes(), 0, this.buffer, this.offset + 4, 4);
        this.writeInt(this.offset + size + 8, this.calcCRC32(this.offset + 4, size + 4));
        this.offset += size + 12;
    }

    public Image createImage(int width, int height, byte[] palette, int keyColor, DataInputStream dis, int idatSize) {
        boolean bNewBuffer = false;
        if (this.buffer == null) {
            this.buffer = new byte[10240];
            this.offset = 0;
            bNewBuffer = true;
        }
        this.writeInt(0, -1991225785);
        this.writeInt(4, 218765834);
        this.offset = 8;
        this.writeInt(this.offset + 8, width);
        this.writeInt(this.offset + 12, height);
        this.buffer[this.offset + 16] = 8;
        this.buffer[this.offset + 17] = 3;
        this.buffer[this.offset + 18] = 0;
        this.buffer[this.offset + 19] = 0;
        this.buffer[this.offset + 20] = 0;
        this.makeChunk("IHDR", 13);
        System.arraycopy(palette, 0, this.buffer, this.offset + 8, palette.length);
        this.makeChunk("PLTE", palette.length);
        if (keyColor != -1) {
            for (int k = 0; k < keyColor; ++k) {
                this.buffer[this.offset + 8 + k] = -1;
            }
            this.buffer[this.offset + 8 + k] = 0;
            this.makeChunk("tRNS", keyColor + 1);
        }
        if (this.offset + idatSize + 24 > this.buffer.length) {
            byte[] b = this.buffer;
            this.buffer = new byte[this.offset + idatSize + 24];
            System.arraycopy(b, 0, this.buffer, 0, this.offset);
            b = null;
            System.gc();
        }
        try {
            Kernel.readStreamData(dis, this.buffer, this.offset + 8, idatSize);
        }
        catch (IOException e) {
            // empty catch block
        }
        this.makeChunk("IDAT", idatSize);
        this.makeChunk("IEND", 0);
        Image img = Image.createImage((byte[])this.buffer, (int)0, (int)this.offset);
        if (bNewBuffer) {
            this.buffer = null;
            System.gc();
        }
        return img;
    }

    public Image loadIndexedImage(String imageName, String paletteName) throws IOException {
        InputStream is;
        Image img = null;
        if (imageName.charAt(0) != '/') {
            imageName = '/' + imageName;
        }
        if (paletteName.charAt(0) != '/') {
            paletteName = '/' + paletteName;
        }
        if ((is = this.getClass().getResourceAsStream(paletteName)) != null) {
            DataInputStream dis = new DataInputStream(is);
            short keyColor = dis.readShort();
            int numColors = dis.readByte() & 0xFF;
            if (numColors == 0) {
                numColors = 256;
            }
            byte[] palette = new byte[numColors * 3];
            Kernel.readStreamData(dis, palette, 0, palette.length);
            dis.close();
            is = this.getClass().getResourceAsStream(imageName);
            if (is != null) {
                dis = new DataInputStream(is);
                short width = dis.readShort();
                short height = dis.readShort();
                int idatSize = dis.readInt();
                img = this.createImage(width, height, palette, keyColor, dis, idatSize);
                dis.close();
            }
        }
        return img;
    }

    public SPRManager load(String fileName) throws IOException {
        return this.load(fileName, null, -1, -1);
    }

    public SPRManager load(String fileName, int id0, int id1) throws IOException {
        return this.load(fileName, null, id0, id1);
    }

    public SPRManager load(String fileName, String customPalette, int id0, int id1) throws IOException {
        short[] imageCopyID = null;
        this.offset = 0;
        this.buffer = new byte[10240];
        InputStream is = this.getClass().getResourceAsStream(fileName);
        if (is != null) {
            int i;
            DataInputStream dis = new DataInputStream(is);
            byte headerSize = dis.readByte();
            int numPalettes = dis.readByte();
            int numSprites = dis.readShort();
            int clsnGroups = dis.readByte();
            if (headerSize > 4) {
                dis.skipBytes(headerSize - 4);
            }
            this.sprites = new SpriteImage[numSprites];
            imageCopyID = new short[numSprites];
            Object palette = null;
            short[] keyColor = null;
            if (customPalette == null) {
                palette = new byte[numPalettes][];
                keyColor = new short[numPalettes];
                for (i = 0; i < numPalettes; ++i) {
                    int numColors = (dis.readByte() & 0xFF) + 1;
                    palette[i] = new byte[numColors * 3];
                    Kernel.readStreamData(dis, palette[i], 0, palette[i].length);
                    keyColor[i] = dis.readShort();
                }
            } else {
                for (int i2 = 0; i2 < numPalettes; ++i2) {
                    int numColors = (dis.readByte() & 0xFF) + 1;
                    dis.skipBytes(numColors * 3 + 2);
                }
                palette = new byte[1][];
                keyColor = new short[1];
                InputStream p_is = this.getClass().getResourceAsStream(customPalette);
                if (p_is != null) {
                    DataInputStream p_dis = new DataInputStream(p_is);
                    keyColor[0] = p_dis.readShort();
                    int numColors = p_dis.readByte() & 0xFF;
                    if (numColors == 0) {
                        numColors = 256;
                    }
                    palette[0] = new byte[numColors * 3];
                    Kernel.readStreamData(p_dis, palette[0], 0, palette[0].length);
                    p_dis.close();
                }
            }
            i = 0;
            for (int ns = 0; ns < numSprites; ++ns) {
                int n;
                int g;
                SpriteImage spr = new SpriteImage();
                spr.id = dis.readShort();
                spr.axisX = dis.readShort();
                spr.axisY = dis.readShort();
                imageCopyID[i] = dis.readShort();
                byte paletteID = dis.readByte();
                if (customPalette != null) {
                    paletteID = 0;
                }
                boolean bLoad = id0 == -1 || spr.id >= id0 && spr.id <= id1;
                spr.isCopy = imageCopyID[i] != -1;
                if (!spr.isCopy) {
                    spr.copyY = 0;
                    spr.copyX = 0;
                    spr.width = dis.readShort();
                    spr.height = dis.readShort();
                    int idatSize = dis.readInt();
                    if (bLoad) {
                        spr.image = this.createImage(spr.width, spr.height, palette[paletteID], keyColor[paletteID], dis, idatSize);
                    } else {
                        dis.skipBytes(idatSize);
                    }
                } else {
                    spr.copyX = dis.readShort();
                    spr.copyY = dis.readShort();
                    spr.width = dis.readShort();
                    spr.height = dis.readShort();
                }
                if (bLoad) {
                    spr.clsnList = new short[clsnGroups][];
                    for (g = 0; g < clsnGroups; ++g) {
                        n = dis.readByte();
                        if (n <= 0) continue;
                        short[] list = new short[n << 2];
                        int _c = n;
                        int _i = 0;
                        while (_c > 0) {
                            list[_i] = dis.readShort();
                            list[_i + 1] = dis.readShort();
                            list[_i + 2] = dis.readShort();
                            list[_i + 3] = dis.readShort();
                            --_c;
                            _i += 4;
                        }
                        spr.clsnList[g] = list;
                    }
                } else {
                    for (g = 0; g < clsnGroups; ++g) {
                        n = dis.readByte();
                        dis.skipBytes(n << 3);
                    }
                }
                dis.readByte();
                byte extraInfoSize = dis.readByte();
                dis.skipBytes(extraInfoSize);
                if (!bLoad) continue;
                this.sprites[i++] = spr;
            }
            if (id0 != -1) {
                SpriteImage[] aux = new SpriteImage[i];
                System.arraycopy(this.sprites, 0, aux, 0, i);
                this.sprites = aux;
                aux = null;
            }
            for (int j = this.sprites.length - 1; j >= 0; --j) {
                if (this.sprites[j] == null || imageCopyID[j] == -1) continue;
                SpriteImage s = this.sprites[this.findSprite(imageCopyID[j])];
                this.sprites[j].image = s.image;
            }
            imageCopyID = null;
            palette = null;
            keyColor = null;
            dis.close();
        }
        this.buffer = null;
        System.gc();
        return this;
    }

    public void unload() {
        if (this.sprites != null) {
            for (int i = this.sprites.length - 1; i >= 0; --i) {
                this.sprites[i].image = null;
                if (this.sprites[i].clsnList == null) continue;
                for (int g = this.sprites[i].clsnList.length - 1; g >= 0; --g) {
                    this.sprites[i].clsnList[g] = null;
                }
                this.sprites[i].clsnList = null;
            }
            this.sprites = null;
        }
    }

    public int findSprite(int id) {
        int i;
        for (i = this.sprites.length - 1; i >= 0 && this.sprites[i].id != id; --i) {
        }
        return i;
    }

    public void drawSprite(Graphics g, int ind, int x, int y, int flags) {
        if (ind >= 0 && ind < this.sprites.length) {
            SpriteImage spr = this.sprites[ind];
            int transform = 0;
            if ((flags & 1) == 0) {
                x -= spr.axisX;
            } else {
                x -= spr.width - spr.axisX - 1;
                transform |= 2;
            }
            if ((flags & 2) == 0) {
                y -= spr.axisY;
            } else {
                y -= spr.height - spr.axisY - 1;
                transform |= 1;
            }
            g.drawRegion(spr.image, (int)spr.copyX, (int)spr.copyY, (int)spr.width, (int)spr.height, transform, x, y, 0);
        }
    }

    public static void getClsn(short[] clsn, int i, int x, int y, int flags, short[] clsnOut) {
        clsnOut[0] = clsnOut[2] = (short)x;
        clsnOut[1] = (short)(y + clsn[i + 1]);
        clsnOut[3] = (short)(y + clsn[i + 3]);
        if ((flags & 1) == 0) {
            clsnOut[0] = (short)(clsnOut[0] + clsn[i]);
            clsnOut[2] = (short)(clsnOut[2] + clsn[i + 2]);
        } else {
            clsnOut[0] = (short)(clsnOut[0] - clsn[i + 2]);
            clsnOut[2] = (short)(clsnOut[2] - clsn[i]);
        }
    }

    static {
        for (int n = 0; n < 256; ++n) {
            int c = n;
            int k = 8;
            while (--k >= 0) {
                if ((c & 1) != 0) {
                    c = 0xEDB88320 ^ c >>> 1;
                    continue;
                }
                c >>>= 1;
            }
            SPRManager.crc_table[n] = c;
        }
    }
}

