/*
 * Decompiled with CFR 0.152.
 */
package dogada.me.test;

import dogada.me.test.TestCanvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ColorTest
extends TestCanvas {
    private Image view;
    private int viewX;
    private int viewY;
    private int viewWidth;
    private int viewHeight;
    private int minColorHeight = 8;
    private int[] steps = new int[]{1, 2, 4, 8, 16, 32, 48, 64, 128};
    private int stepIndex = 2;
    private boolean delimColor;
    private Font font;

    public void init(Display display, Displayable previous) {
        super.init(display, previous);
        this.font = Font.getFont((int)64, (int)0, (int)8);
        this.updateView();
    }

    protected void paint(Graphics g) {
        g.setColor(0xFFFFFF);
        g.fillRect(0, 0, this.width, this.height);
        g.drawImage(this.view, this.viewX, this.viewY, 20);
        int shades = 256 / this.steps[this.stepIndex];
        String info = shades + " \u043e\u0442\u0442\u0435\u043d\u043a\u0438";
        int infoWidth = this.font.stringWidth(info);
        int infoHeight = this.font.getHeight();
        g.setColor(0xFFFFFF);
        g.fillRect((this.width - infoWidth - 1) / 2, this.height - infoHeight - 2, infoWidth + 2, infoHeight + 2);
        g.setColor(0);
        g.setFont(this.font);
        g.drawString(info, this.width / 2, this.height - infoHeight - 1, 17);
    }

    private void updateView() {
        int step = this.steps[this.stepIndex];
        int colorCount = 256 / step;
        int colorWidth = this.width / colorCount + 1;
        int markHeight = this.font.getHeight();
        int unitHeight = 2;
        int freeSpaceHeight = 4;
        int freeSpaceWidth = 2;
        int infoHeight = markHeight + unitHeight + 1 + 2 + freeSpaceHeight;
        int colorHeight = (this.height - 4 * infoHeight) / 4;
        if (colorHeight < this.minColorHeight) {
            colorHeight = this.minColorHeight;
        }
        this.viewWidth = colorWidth * colorCount + 2 + 2 * freeSpaceWidth;
        if (this.delimColor) {
            this.viewWidth += colorCount - 1;
        }
        this.viewHeight = 4 * (colorHeight + infoHeight) + 2 * this.font.getHeight();
        this.view = Image.createImage((int)this.viewWidth, (int)this.viewHeight);
        System.out.println("step=" + step + " colorCount=" + colorCount + " colorWidth=" + colorWidth);
        Graphics g = this.view.getGraphics();
        g.setColor(0xFFFFFF);
        g.fillRect(0, 0, this.viewWidth, this.viewHeight);
        int[] offsets = new int[]{16, 8, 0, -1};
        int x = 0;
        int y = 0;
        int i = 0;
        while (i < 4) {
            x = freeSpaceWidth;
            y += freeSpaceHeight;
            int lastMarkEndX = -1995;
            g.setColor(0);
            int borderWidth = colorCount * colorWidth + 1;
            if (this.delimColor) {
                borderWidth += colorCount - 1;
            }
            g.drawRect(x++, y++, borderWidth, colorHeight + 1);
            int j = 0;
            while (j < colorCount) {
                int colorIndex = j * step;
                if (colorIndex > 255) {
                    colorIndex = 255;
                }
                int color = colorIndex;
                if (offsets[i] >= 0) {
                    g.setColor(color <<= offsets[i]);
                } else {
                    g.setGrayScale(color);
                }
                g.fillRect(x, y, colorWidth, colorHeight);
                if (this.delimColor && j > colorCount - 1) {
                    g.setColor(0xFFFFFF);
                    g.drawLine(x + colorWidth, y, x + colorWidth, y + colorHeight - 1);
                }
                if ((colorIndex & 0xF) == 0) {
                    g.setColor(0);
                    int unitY = y + colorHeight + 1;
                    g.drawLine(x, unitY, x, unitY + unitHeight);
                    String mark = Integer.toHexString(colorIndex);
                    int markWidth = this.font.stringWidth(mark);
                    if (lastMarkEndX + 2 < x - markWidth / 2) {
                        g.setFont(this.font);
                        g.drawString(mark, x - markWidth / 2, unitY + unitHeight + 1, 20);
                        lastMarkEndX = x + markWidth / 2;
                    }
                }
                x += colorWidth;
                if (this.delimColor) {
                    ++x;
                }
                ++j;
            }
            y += colorHeight + 2 + unitHeight + 1 + markHeight;
            ++i;
        }
        System.out.println("\u041e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043e " + step + " colorCount=" + colorCount);
    }

    public String getHelp() {
        String helpStr = "\u0412\u0432\u0435\u0440\u0445/\u0412\u043d\u0438\u0437 - \u043f\u043e \u0432\u0435\u0440\u0442\u0438\u043a\u0430\u043b\u0435\n\u0412\u043b\u0435\u0432\u043e/\u0412\u043f\u0440\u0430\u0432\u043e - \u043f\u043e \u0433\u043e\u0440\u0438\u0437\u043e\u043d\u0442\u0430\u043b\u0435\n\u0412\u044b\u0431\u043e\u0440 - \u0448\u0430\u0433 \u0446\u0432\u0435\u0442\u0430\n1 - \u043f\u043e\u043a\u0430\u0437\u0430\u0442\u044c/\u0441\u043a\u0440\u044b\u0442\u044c \u0440\u0430\u0437\u0434\u0435\u043b\u0438\u0442\u0435\u043b\u0438.";
        return helpStr;
    }

    protected void handleKey(int keyCode) {
        int action = this.getGameAction(keyCode);
        switch (action) {
            case 1: {
                this.viewY += this.height / 2;
                if (this.viewY <= 0) break;
                this.viewY = 0;
                break;
            }
            case 6: {
                this.viewY -= this.height / 2;
                if (this.viewY >= this.height - this.viewHeight) break;
                this.viewY = this.height - this.viewHeight;
                break;
            }
            case 2: {
                this.viewX += this.width / 2;
                if (this.viewX <= 0) break;
                this.viewX = 0;
                break;
            }
            case 5: {
                this.viewX -= this.width / 2;
                if (this.viewX >= this.width - this.viewWidth) break;
                this.viewX = this.width - this.viewWidth;
                break;
            }
            case 8: {
                ++this.stepIndex;
                if (this.stepIndex >= this.steps.length) {
                    this.stepIndex = 0;
                }
                this.updateView();
                this.viewY = 0;
                this.viewX = 0;
                break;
            }
            case 9: {
                this.delimColor = !this.delimColor;
                this.updateView();
                this.viewY = 0;
                this.viewX = 0;
            }
        }
        this.repaint();
    }
}

