/*
 * Decompiled with CFR 0.152.
 */
package dogada.me.test;

import dogada.me.test.TestCanvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public abstract class FPSTest
extends TestCanvas
implements Runnable {
    public static final int ZERO_INFO = 0;
    public static final int FPS_INFO = 1;
    public static final int PAINT_INFO = 2;
    public static final int MIN_INFO = 0;
    public static final int MAX_INFO = 2;
    protected Command toggleCmd;
    protected long fps = 0L;
    protected String fpsStr;
    protected long defaultDelay = 50L;
    protected long startTime;
    protected int frameCount;
    protected int speedX = 0;
    protected boolean showFPS = true;
    protected int infoLevel = 2;
    protected Font font;
    protected int infoHeight;
    private Thread renderThread;

    public void init(Display display, Displayable next) {
        super.init(display, next);
        this.font = Font.getFont((int)0, (int)0, (int)0);
        this.infoHeight = this.font.getHeight() + 2;
    }

    public void showNotify() {
        this.start();
    }

    public void hideNotify() {
        this.pause();
    }

    public void killTest() {
        this.pause();
    }

    protected void handleKey(int keyCode) {
        if (this.getGameAction(keyCode) == 8) {
            ++this.infoLevel;
            if (this.infoLevel > 2) {
                this.infoLevel = 0;
            }
            this.reset();
        }
    }

    protected void paint(Graphics g) {
        ++this.frameCount;
        if (this.infoLevel >= 1) {
            this.updateFPS();
            int w = this.font.stringWidth(this.fpsStr) + 2;
            int h = this.font.getHeight() + 2;
            int x = this.width / 2 - w / 2;
            int y = this.height / 2 - h / 2;
            g.setColor(0xFFFFFF);
            g.fillRect(x, y, w, h);
            g.setColor(0);
            g.setFont(this.font);
            g.drawString(this.fpsStr, x + 1, y, 20);
        }
    }

    public void run() {
        Thread currentThread = Thread.currentThread();
        while (currentThread == this.renderThread) {
            this.repaint();
            this.serviceRepaints();
        }
    }

    protected void updateFPS() {
        long p = 0L;
        long time = System.currentTimeMillis() - this.startTime;
        if (time > 0L) {
            long fpsX100 = (long)(this.frameCount * 1000 * 100) / time;
            this.fps = fpsX100 / 100L;
            p = fpsX100 % 100L;
        }
        this.fpsStr = this.fps + "." + (p < 10L ? "0" : "") + p + "fps";
    }

    protected void drawInfo(String mes, Graphics g, int x, int y, int x2, int y2) {
        if (this.infoLevel >= 2) {
            g.setColor(0);
            g.drawRect(x - 1, y, x2 - x + 1, this.infoHeight);
            g.setColor(0xFFFFFF);
            g.fillRect(x, y + 1, x2 - x, this.infoHeight - 1);
            g.setColor(0);
            g.setFont(this.font);
            g.drawString(mes, x + 1, y + 1, 20);
            if (++this.speedX >= x2) {
                this.speedX = x;
            }
            g.setColor(0xFF0000);
            g.fillRect(this.speedX, y + this.infoHeight, 5, 7);
        }
    }

    public synchronized void start() {
        this.reset();
        this.renderThread = new Thread(this);
        this.renderThread.start();
    }

    public synchronized void pause() {
        this.renderThread = null;
    }

    public synchronized boolean isPaused() {
        return this.renderThread == null;
    }

    public void destroy() {
        this.pause();
    }

    void reset() {
        this.startTime = System.currentTimeMillis();
        this.frameCount = 0;
    }
}

