/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Image2;
import game.MultiOutPut;
import game.Opponent;
import game.Sound;
import game.game;
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.rms.RecordStore;

class GameScreen
extends GameCanvas
implements Runnable {
    static final byte ADVENTURE = 1;
    static final byte AGRESSIVE = 2;
    static final byte ARROWS = 38;
    static final byte ARROW_L = 4;
    static final byte ARROW_R = 5;
    static final byte AVAILABLE = 0;
    static final short[] BACK_X = new short[]{85, 85, 100, 95, 75, 85};
    static final short BACK_Y = 118;
    static final byte BG_1 = 18;
    static final byte BG_2 = 19;
    static final byte BOOST1 = 31;
    static final byte BOOST2 = 32;
    static final byte BOOST3 = 33;
    static final byte[] BRIEFING;
    static final byte BRONARIS = 2;
    static final byte CALIMARI = 28;
    static final byte[] DEBRIEFING;
    static final byte DECOR_1 = 20;
    static final byte DECOR_2 = 21;
    static final byte DINZERA = 1;
    static final byte DIR_LEFT = 0;
    static final byte DIR_RIGHT = 1;
    static final byte ENEMY_1 = 12;
    static final byte ENEMY_2 = 13;
    static final byte ENEMY_3 = 14;
    static final byte EXPLOSION = 15;
    static final byte FINAL = 3;
    static final byte FLAGS = 6;
    static final byte FONT_1 = 7;
    static final byte FREE_RACE = 0;
    static final byte GALAK = 37;
    static final byte GALAXY = 2;
    static final byte GEEK = 3;
    static final byte GEENOM = 0;
    static final byte G_END = 4;
    static final byte G_INIT = 0;
    static final byte G_LOOSE = 5;
    static final byte G_PAUSE = 3;
    static final byte G_PLAYING = 2;
    static final byte G_START = 1;
    static final byte INTRO = 0;
    static final byte KART_1 = 8;
    static final byte KART_2 = 9;
    static final byte KEY_DOWN = 3;
    static final byte KEY_LEFT = 4;
    static final byte KEY_NUM0 = 6;
    static final byte KEY_NUM1 = 7;
    static final byte KEY_NUM2 = 8;
    static final byte KEY_NUM3 = 9;
    static final byte KEY_NUM4 = 10;
    static final byte KEY_NUM5 = 11;
    static final byte KEY_NUM6 = 12;
    static final byte KEY_NUM7 = 13;
    static final byte KEY_NUM8 = 14;
    static final byte KEY_NUM9 = 15;
    static final byte KEY_OK = 18;
    static final byte KEY_POUND = 17;
    static final byte KEY_RIGHT = 5;
    static final byte KEY_SOFT1 = 0;
    static final byte KEY_SOFT2 = 1;
    static final byte KEY_STAR = 16;
    static final byte KEY_UP = 2;
    static final byte LAP_ICO = 40;
    static final byte LEVEL = 3;
    static final short LOAD_Y = 60;
    static final byte LOCKED = 1;
    static final byte LOGO = 10;
    static final int MAIN_X = 20;
    static final int MAIN_Y = 45;
    static final byte MAX_OPPONENT = 5;
    static final byte MECANO = 27;
    static final byte MENU = 1;
    static final byte MIS1 = 34;
    static final byte MIS2 = 35;
    static final byte MIS3 = 36;
    static final byte MISSILE = 42;
    static final byte MISSILE_CAPACITY = 1;
    static final byte MIS_ICO = 41;
    static final byte[][] MODE_SIZE;
    static final byte MONEY = 2;
    static final byte MUSIC_OFF = 1;
    static final byte MUSIC_ON = 0;
    static final byte M_BRIEFING = 9;
    static final byte M_CHOOSE_KART = 8;
    static final byte M_CHOOSE_LANG = 5;
    static final byte M_CHOOSE_LVL = 7;
    static final byte M_CHOOSE_MODE = 6;
    static final byte M_CREDITS = 4;
    static final byte M_DEBRIEFING = 10;
    static final byte M_GARAGE = 12;
    static final byte M_HELP = 1;
    static final byte M_MAIN = 0;
    static final byte M_OPTIONS = 3;
    static final byte M_RESTART = 11;
    static final byte M_SCORES = 2;
    static final byte NAGHRI = 30;
    static final byte NAYOS = 4;
    static final byte NB_DATA = 4;
    static final byte NB_IMG = 46;
    static final byte NB_KEY = 19;
    static final byte NEKAMA = 5;
    static final byte NICE = 0;
    static final byte NONE = -1;
    static final byte NORMAL = 1;
    static final byte NUMBERS = 39;
    static final int OPTION = 150;
    static final byte OPTION_MISSILE = 1;
    static final byte OPTION_MONEY = 0;
    static final byte OPTION_TURBO = 2;
    static final byte OP_MISSILE = 44;
    static final byte OP_MONEY = 43;
    static final byte OP_TURBO = 45;
    static final byte[][] PAUSE_SIZE;
    static final short PAUSE_X = 1;
    static final short PAUSE_Y = 118;
    static final int[][] PLANETS;
    static final byte PLAYER = 11;
    static final short RECORD_SIZE = 43;
    static final int ROAD_LEFT = 49;
    static final int ROAD_MAX = 5;
    static final int ROAD_TOP = 76;
    static final int ROAD_WIDTH = 30;
    static final int SCR_H = 128;
    static final int SCR_W = 128;
    static final byte SHADOW = 23;
    static final byte SKY = 17;
    static final byte SMOKE = 25;
    static final byte SND_RACE = 1;
    static final byte SND_TITLE = 0;
    static final byte SND_VICTORY = 2;
    int SPEEDX_MAX = 5;
    static final byte START = 16;
    static final byte S_EXIT = 6;
    static final byte S_GAME = 5;
    static final byte S_INTRO = 0;
    static final byte S_LOAD_BEGIN = 1;
    static final byte S_LOAD_GAME = 2;
    static final byte S_LOAD_MENU = 3;
    static final byte S_MENU = 4;
    static final byte TALINN = 3;
    static final short TITLE_Y = 5;
    static final byte TURBO = 22;
    static final byte TURBO_MAX = 40;
    static final byte TURBO_STYLE = 0;
    static final byte TWILOK = 29;
    static final byte VORTEX = 6;
    static final byte V_MENU = 24;
    static final byte XILM = 26;
    static final int X_INIT = 64;
    static final int X_MAX = 115;
    static final int X_MIN = 10;
    static final int Y1 = 0;
    static final int Y2 = 25;
    static final int Y_INIT = 122;
    int _X;
    int _Y;
    int _acc;
    byte _animBG;
    boolean _back;
    long _begin;
    boolean _bend;
    int _bendReduction;
    int _bendX;
    int _bendY;
    int _bordColor1;
    int _bordColor2;
    byte _briefing;
    int[] _cap;
    byte _colOpp;
    boolean _continue;
    int _cptArrowLeft;
    int _cptArrowRight;
    int _cptBend;
    int _cptBoost;
    int _cptCol;
    int _cptEnd;
    int _cptEscape;
    int _cptExplosion;
    int _cptFps;
    int _cptLetter;
    int _cptLoad;
    int _cptMain;
    int _cptMsg;
    int _cptName;
    int _cptOption;
    int _cptRace;
    int _cptRoad;
    int _cptStart;
    int _cptStripe;
    byte _curMusic;
    byte _curs;
    int[] _data;
    byte _debriefing;
    int[] _decalX;
    byte _difficulty;
    boolean _enterScore;
    byte _escape;
    boolean _explosion;
    boolean _finishLine;
    int _finishY;
    byte _firstHelp;
    int _fps;
    int _frame;
    byte _gCurs;
    int _gameState;
    byte _garage;
    int _groundColor;
    byte _help;
    int[] _highScores;
    Image2[] _img;
    boolean _inBend;
    boolean _instructions1;
    boolean _instructions2;
    byte _isMusic;
    byte _isVibro;
    byte _kart;
    boolean _kartMove;
    int _kartX;
    byte[] _keyMap;
    byte _lang;
    byte _lap;
    boolean _leftCol;
    byte _level;
    byte[] _locked = new byte[]{0, 1, 1, 1, 1, 1, 1};
    boolean _loose;
    int _mY;
    int _mainState = 0;
    Image2 _media;
    byte _menuDir;
    int _menuState;
    byte _misMax;
    int _misX;
    int _misY;
    int _misZ;
    boolean _missile;
    byte _mode;
    int _moneyRab;
    MultiOutPut _mu0 = null;
    byte _nbLap;
    byte _nbMis;
    byte _nbOpponent;
    byte _object;
    byte _objectSize1;
    byte _objectSize2;
    int _objectX1;
    int _objectX2;
    int _objectX3;
    int _objectX4;
    int _objectY1;
    int _objectY2;
    boolean _ok;
    Opponent[] _opp;
    boolean _option;
    boolean _optionCatched;
    int _optionPos;
    byte _optionType;
    int _optionX;
    int _optionY;
    int _optionZoom;
    boolean _paint;
    int _planetX;
    boolean _plus;
    byte _position;
    static final int[] _prize;
    static final byte[] _races;
    Random _rand = null;
    static final int[] _reward;
    boolean _rightCol;
    static final byte[][] _road;
    int _roadColor1;
    int _roadColor2;
    int _roadX;
    int _score;
    int _scroll;
    long _sec;
    int _shadowY;
    boolean _showFPS = false;
    Sound _snd;
    int _speed;
    int _speedMax;
    int _speedX;
    boolean _startBoost;
    long _startTime;
    String[] _strBoost = new String[]{"Standard", "Super", "Extra"};
    static final byte[][] _stripes;
    long _t;
    int _time;
    boolean _turbo;
    byte _turboSize;
    byte _vX;
    byte _vY;
    int _xLeft;
    int _xRight;
    boolean _z;
    long last_paint = 0L;
    game midlet;

    static {
        MODE_SIZE = new byte[][]{{114, 80}, {124, 87}, {88, 90}, {123, 80}, {105, 90}, {98, 80}};
        PAUSE_SIZE = new byte[][]{{52, 45}, {71, 45}, {64, 45}, {80, 45}, {55, 45}, {53, 45}};
        PLANETS = new int[][]{{45, 22, 20, 18}, {87, 41, 23, 22}, {78, -6, 32, 33}, {13, 7, 21, 18}, {10, 45, 22, 22}, {51, 63, 30, 29}, {51, 48, 20, 16}};
        BRIEFING = new byte[]{5, 1, 1, 1, 1, 2, 2};
        DEBRIEFING = new byte[]{1, 0, 0, 0, 0, 1, 2};
        _prize = new int[]{1000, 2000, 5000, 3000, 6000, 8000};
        _reward = new int[]{1000, 2500, 3500, 4500, 5500, 7500, 10000};
        _races = new byte[]{3, 3, 3, 2, 3, 2, 4, 5, 3, 2, 1, 0, 0, 1};
        _road = new byte[][]{{3, 1, 2, 2, 1, 1, 2, 2, 4, 1, 2, 2, 1, 1, 2, 2, 1, 0}, {4, -2, 2, -1, 2, -2, 3, -1, 3, -2, 1, 0}, {3, 2, 1, 2, 3, 1, 1, 2, 1, -2, 1, -1, 1, 2, 1, 2, 3, 1, 1, 0}, {2, -2, 5, -1, 1, -2, 3, -2, 2, 1, 1, -2, 1, -2, 1, -1, 1, 0}, {3, 2, 1, 2, 1, -1, 1, -1, 6, 2, 2, 2, 2, 1, 5, -2, 2, 2, 2, 2, 2, 1, 2, 0}, {10, 2, 2, 1, 20, 2, 4, 2, 6, -1, 10, 2, 2, 0}, {5, 1, 5, -1, 5, 2, 5, -2, 5, 3, 5, -3, 1, 0}};
        _stripes = new byte[][]{{0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1}, {1, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0}};
    }

    public GameScreen(game game2) {
        super(false);
        this._cap = new int[]{2, 4, 8};
        this.setFullScreenMode(true);
        this.midlet = game2;
        this.GameInit();
        new Thread(this).start();
    }

    int Abs(int n) {
        int n2 = n >= 0 ? n : 0 - n;
        return n2;
    }

    void Draw_Arrows(Graphics graphics) {
        if (this._cptArrowLeft == 0) {
            this._img[4].drawFrame(graphics, 2, 30, 1 + this._cptMain % 6 / 2, 16 + 4);
        } else {
            this._img[4].drawFrame(graphics, 2, 30, 0, 16 + 4);
        }
        if (this._cptArrowRight == 0) {
            this._img[5].drawFrame(graphics, 126, 30, 2 - this._cptMain % 6 / 2, 16 + 8);
        } else {
            this._img[5].drawFrame(graphics, 126, 30, 3, 16 + 8);
        }
    }

    void Draw_Character(Graphics graphics, int n) {
        this._img[n].draw(graphics, 0, 128, 4 + 32);
        if (n == 3) {
            this._mu0.print(graphics, 50, 116, "Dr Geek");
        } else if (n == 26) {
            this._mu0.print(graphics, 50, 116, "Xilm");
        } else if (n == 27) {
            this._mu0.print(graphics, 50, 116, "Meca");
        } else if (n == 28) {
            this._mu0.print(graphics, 50, 116, "Calimari");
        } else if (n == 29) {
            this._mu0.print(graphics, 50, 116, "Twilok");
        } else if (n == 30) {
            this._mu0.print(graphics, 50, 116, "Naghri");
        }
    }

    void Draw_Game(Graphics graphics) {
        graphics.setClip(0, 0, 128, 128);
        this._img[17].draw(graphics, 0, 76, 32 + 4);
        if (this._level != 6) {
            this._img[18].draw(graphics, this._scroll, 76, 32 + 4);
            this._img[18].draw(graphics, this._scroll + 128, 76, 32 + 4);
        } else {
            this._img[18].drawFrame(graphics, 47, 62, this._cptMain % 3, 32 + 4);
        }
        graphics.setClip(0, 0, 128, 128);
        graphics.setColor(this._groundColor);
        graphics.fillRect(0, 76, 128, 52);
        int n = 0;
        while (n < 52) {
            this._decalX[n] = this._bend && this._bendY >= n ? (this._bendX > 0 ? (this._bendX * 3 - this._bendReduction) * (this._bendY - n) / 4 : (this._bendX * 3 + this._bendReduction) * (this._bendY - n) / 4) : 0;
            if (n % 2 == 0) {
                int n2 = 49 - n - this._roadX * n / 6 + this._decalX[n];
                int n3 = 79 + n - this._roadX * n / 6 + this._decalX[n];
                int n4 = 76 + n;
                if (n4 == this._Y - 10) {
                    this._xLeft = n2;
                    this._xRight = n3;
                }
                if (this._finishLine && n >= this._finishY && n <= this._finishY * 4 / 3) {
                    graphics.setColor(-1);
                } else if (_stripes[this._cptStripe][n] == 0) {
                    graphics.setColor(this._roadColor1);
                } else {
                    graphics.setColor(this._roadColor2);
                }
                graphics.fillRect(n2, n4, 30 + 2 * n, 2);
                if (_stripes[this._cptStripe][n] == 0) {
                    graphics.setColor(this._bordColor1);
                } else {
                    graphics.setColor(this._bordColor2);
                }
                graphics.fillRect(n2 - 2 - n / 3, n4, 1 + n / 3, 2);
                graphics.fillRect(n3 + 1, n4, 1 + n / 3, 2);
            }
            ++n;
        }
        this.Draw_Objects(graphics);
        if (this._option || this._optionCatched) {
            this._img[43 + this._optionType].drawFrame(graphics, this._optionX, this._optionY + 76, this._optionZoom, 32 + 2);
        }
        if (!this._z) {
            this.Draw_Opponent(graphics);
        }
        if (this._missile) {
            this._img[42].drawFrame(graphics, this._misX, this._misY, this._misZ, 2 + 32);
        }
        if (this._speed > 400) {
            this._vY = this._cptMain % 4 == 0 ? (byte)0 : (this._cptMain % 4 == 1 || this._cptMain % 4 == 3 ? (byte)1 : (byte)2);
        } else if (this._speed > 200) {
            this._vY = this._cptMain % 4 <= 1 ? (byte)1 : 0;
        }
        if (!this._explosion) {
            graphics.setClip(0, 0, 128, 128);
            this._img[23].draw(graphics, this._X - 1 + this._vX, this._shadowY, 16 + 2);
            this._img[11].drawFrame(graphics, this._X + this._vX, this._Y + this._vY, this._frame, 32 + 2);
        } else {
            this._img[15].drawFrame(graphics, this._X + this._vX, this._Y + this._vY, 16 + this._cptExplosion, 32 + 2);
        }
        if (this._turbo || this._startBoost) {
            this._img[25].drawFrame(graphics, this._X, this._Y - 1, this._cptMain % 3, 16 + 2);
        }
        if (this._z) {
            this.Draw_Opponent(graphics);
        }
        if (this._turboSize > 0) {
            graphics.setClip(0, 0, 128, 128);
            graphics.setColor(-16777216);
            graphics.fillRect(126 - this._turboSize, 12, this._turboSize + 2, 6);
            graphics.setColor(-65536);
            graphics.fillRect(127 - this._turboSize, 13, (int)this._turboSize, 4);
            this._mY = 20;
        } else if (this._mY > 10) {
            this._mY -= 2;
        }
        this.Draw_Number(graphics, this._position, 54, 2);
        this._img[39].drawFrame(graphics, 60, 2, 10, 16 + 4);
        this.Draw_Number(graphics, this._nbOpponent + 1, 66, 2);
        if (this._mode == 0 || this._level != 6) {
            this.Draw_Number(graphics, this._lap, 2, 13);
            this._img[39].drawFrame(graphics, 7, 13, 10, 16 + 4);
            this.Draw_Number(graphics, this._nbLap, 12, 13);
            this._img[40].draw(graphics, 20, 12, 16 + 4);
            this.Draw_Time(graphics, this._time, 2, 2);
            this._img[41].draw(graphics, 98, this._mY, 16 + 4);
            this.Draw_Number(graphics, this._nbMis, 123, this._mY);
        }
        this.Draw_Number(graphics, this._speed, 105, 2);
        if (this._bend) {
            if (this._bendX < 0) {
                this._img[38].drawFrame(graphics, 64, 30, 3, 2);
            } else {
                this._img[38].drawFrame(graphics, 64, 30, 1, 2);
            }
        }
        if (this._gameState == 2 || this._gameState == 1) {
            this._mu0.print(graphics, 1, 118, 18);
        }
    }

    void Draw_Number(Graphics graphics, int n, int n2, int n3) {
        if (n / 100 > 0) {
            this._img[39].drawFrame(graphics, n2, n3, n / 100, 16 + 4);
            this._img[39].drawFrame(graphics, n2 + 6, n3, n % 100 / 10, 16 + 4);
            this._img[39].drawFrame(graphics, n2 + 12, n3, n % 10, 16 + 4);
        } else if (n / 10 > 0) {
            this._img[39].drawFrame(graphics, n2, n3, n % 100 / 10, 16 + 4);
            this._img[39].drawFrame(graphics, n2 + 6, n3, n % 10, 16 + 4);
        } else {
            this._img[39].drawFrame(graphics, n2, n3, n, 16 + 4);
        }
    }

    void Draw_Objects(Graphics graphics) {
        if (this._gameState == 2 || this._gameState == 1) {
            if (this._speed >= 550) {
                this._objectY1 += 4;
                this._objectY2 += 12;
                if (this._finishLine) {
                    this._finishY += this._finishY + 1;
                }
            } else if (this._speed >= 450) {
                this._objectY1 += 3;
                this._objectY2 += 9;
                if (this._finishLine) {
                    this._finishY += this._finishY;
                }
            } else if (this._speed >= 300) {
                this._objectY1 += 2;
                this._objectY2 += 6;
                if (this._finishLine) {
                    this._finishY += this._finishY;
                }
            } else if (this._speed >= 100) {
                ++this._objectY1;
                this._objectY2 += 3;
                if (this._finishLine) {
                    this._finishY += this._finishY / 2;
                }
            } else if (this._speed > 0 && this._cptMain % 2 == 0) {
                ++this._objectY1;
                this._objectY2 += 3;
                if (this._finishLine) {
                    this._finishY += this._finishY / 2;
                }
            }
            if (this._objectY2 >= 90) {
                this._objectY1 = 0;
                this._objectY2 = 25;
                this._object = (byte)(1 - this._object);
            }
        }
        this._objectSize1 = (byte)(this._objectY1 / 12);
        this._objectSize2 = (byte)(this._objectY2 / 12);
        if (this._objectSize1 > 4) {
            this._objectSize1 = (byte)4;
        }
        if (this._objectSize2 > 4) {
            this._objectSize2 = (byte)4;
        }
        this._objectX1 = 49 - this._objectY1 - this._roadX * this._objectY1 / 6 - 5 - this._objectY1 / 3 + this._decalX[this._objectY1];
        this._objectX2 = 49 - this._objectY2 - this._roadX * this._objectY2 / 6 - 5 - this._objectY2 / 3 + this._decalX[this._objectY2];
        if (this._level != 6) {
            this._img[20 + this._object].drawFrame(graphics, this._objectX1, this._objectY1 + 76, this._objectSize1, 32 + 2);
            this._img[21 - this._object].drawFrame(graphics, this._objectX2, this._objectY2 + 76, this._objectSize2, 32 + 2);
        }
        this._objectX3 = 79 + this._objectY1 - this._roadX * this._objectY1 / 6 + 5 + this._objectY1 / 3 + this._decalX[this._objectY1];
        this._objectX4 = 79 + this._objectY2 - this._roadX * this._objectY2 / 6 + 5 + this._objectY2 / 3 + this._decalX[this._objectY2];
        if (this._level != 6) {
            this._img[20 + this._object].drawFrame(graphics, this._objectX3, this._objectY1 + 76, this._objectSize1, 32 + 2);
            this._img[21 - this._object].drawFrame(graphics, this._objectX4, this._objectY2 + 76, this._objectSize2, 32 + 2);
        }
    }

    void Draw_Opponent(Graphics graphics) {
        byte by = 0;
        while (by < this._nbOpponent) {
            if (this._opp[by]._onScreen) {
                if (!this._opp[by]._boom) {
                    this._img[12 + this._opp[by]._sprite].drawFrame(graphics, this._opp[by]._posX, this._opp[by]._posY + 76, this._opp[by]._zoom * 3 + this._opp[by]._anim, 32 + 2);
                } else {
                    this._img[15].drawFrame(graphics, this._opp[by]._posX, this._opp[by]._posY + 76, this._opp[by]._zoom * 4 + this._opp[by]._cptBoom, 32 + 2);
                }
            }
            by = (byte)(by + 1);
        }
    }

    void Draw_Time(Graphics graphics, int n, int n2, int n3) {
        this.Draw_Number(graphics, n / 60, n2, n3);
        this._img[39].drawFrame(graphics, n2 + 5, n3, 12, 16 + 4);
        int n4 = n % 60;
        if (n4 >= 10) {
            this.Draw_Number(graphics, n4, n2 + 8, n3);
        } else {
            this.Draw_Number(graphics, 0, n2 + 8, n3);
            this.Draw_Number(graphics, n4, n2 + 14, n3);
        }
    }

    void GameExit() {
        int n = 0;
        n = 0;
        while (n < 46) {
            if (this._img[n] != null) {
                this._img[n] = null;
            }
            n = (byte)(n + 1);
        }
        this._mu0 = null;
        this._snd.Stop_Music();
        this._snd = null;
    }

    void GameInit() {
        this._rand = new Random();
        this._keyMap = new byte[19];
        this._img = new Image2[46];
        this._highScores = new int[7];
        this._data = new int[4];
        this._decalX = new int[128];
        this._opp = new Opponent[5];
        byte by = 0;
        while (by < 5) {
            this._opp[by] = new Opponent(this, by);
            by = (byte)(by + 1);
        }
        this.Load_Records();
        this._begin = System.currentTimeMillis();
    }

    void Init_Adventure() {
        this._data[1] = 0;
        this._data[0] = 0;
        this._data[2] = 0;
        this._data[3] = 0;
    }

    void Init_Data() {
        this.Reset_Data();
        if (this._mode == 1) {
            this._nbLap = _races[this._level * 2];
            this._nbOpponent = _races[this._level * 2 + 1];
            this._nbMis = (byte)this._data[1];
            this._turboSize = this._data[0] > 0 || this._level == 6 ? (byte)40 : (byte)0;
        } else if (this._mode == 0) {
            this._nbLap = (byte)3;
            this._nbOpponent = (byte)3;
            this._turboSize = (byte)40;
            this._nbMis = (byte)(3 - this._kart);
        }
        byte by = 0;
        while (by < this._nbOpponent) {
            this._opp[by].Init();
            by = (byte)(by + 1);
        }
        this._position = (byte)(this._nbOpponent + 1);
        this._cptRoad = 0;
        this._cptRace = 0;
        this._lap = 1;
        this._finishLine = false;
        this._startBoost = false;
        this._loose = false;
        this._cptStart = 0;
        this._cptBoost = 0;
        this._startTime = System.currentTimeMillis();
        this._sec = System.currentTimeMillis();
        this._time = 0;
        this._escape = 0;
        this._cptEscape = 0;
        this._cptOption = 0;
        this._option = false;
        this._optionCatched = false;
        this._moneyRab = 0;
        if (this._mode == 1 && this._level == 5) {
            this._time = 70;
        }
        this._mY = this._turboSize > 0 ? 20 : 10;
        this._difficulty = this._level < 2 ? (byte)0 : (this._level < 4 ? (byte)1 : (this._level < 6 ? (byte)1 : (this._mode == 1 ? (byte)3 : (byte)2)));
    }

    void Load_Garage() {
        this._img[31] = new Image2("/gfx/ekoboost1.png", 1, 2);
        this._img[32] = new Image2("/gfx/ekoboost2.png", 1, 2);
        this._img[33] = new Image2("/gfx/ekoboost3.png", 1, 2);
        this._img[34] = new Image2("/gfx/chargemissile_x2.png", 1, 2);
        this._img[35] = new Image2("/gfx/chargemissile_x4.png", 1, 2);
        this._img[36] = new Image2("/gfx/chargemissile_x8.png", 1, 2);
        this._img[37] = new Image2("/gfx/galak.png", 1, 1);
    }

    void Load_Level() {
        if (this._level == 0) {
            this._img[17] = new Image2("/gfx/ciel_A.png", 1, 1);
            this._img[18] = new Image2("/gfx/BG_A1.png", 1, 1);
            this._img[20] = new Image2("/gfx/element_A1.png", 1, 5);
            this._img[21] = new Image2("/gfx/element_A2.png", 1, 5);
            this._groundColor = -9791079;
            this._roadColor1 = -4531751;
            this._roadColor2 = -7226947;
            this._bordColor1 = -8388608;
            this._bordColor2 = -13456;
        } else if (this._level == 1) {
            this._img[17] = new Image2("/gfx/ciel_B.png", 1, 1);
            this._img[18] = new Image2("/gfx/BG_B1.png", 1, 1);
            this._img[20] = new Image2("/gfx/element_B1.png", 1, 5);
            this._img[21] = new Image2("/gfx/element_B2.png", 1, 5);
            this._groundColor = -4355741;
            this._roadColor1 = -1984136;
            this._roadColor2 = -1254511;
            this._bordColor1 = -9240576;
            this._bordColor2 = -1984136;
        } else if (this._level == 2) {
            this._img[17] = new Image2("/gfx/ciel_C.png", 1, 1);
            this._img[18] = new Image2("/gfx/BG_C1.png", 1, 1);
            this._img[20] = new Image2("/gfx/element_C1.png", 1, 5);
            this._img[21] = new Image2("/gfx/element_C2.png", 1, 5);
            this._groundColor = -7926272;
            this._roadColor1 = -2387694;
            this._roadColor2 = -349440;
            this._bordColor1 = -12906496;
            this._bordColor2 = -6912;
        } else if (this._level == 3) {
            this._img[17] = new Image2("/gfx/ciel_D.png", 1, 1);
            this._img[18] = new Image2("/gfx/BG_D1.png", 1, 1);
            this._img[20] = new Image2("/gfx/element_D1.png", 1, 5);
            this._img[21] = new Image2("/gfx/element_D2.png", 1, 5);
            this._groundColor = -13794037;
            this._roadColor1 = -5330274;
            this._roadColor2 = -3292734;
            this._bordColor1 = -7907840;
            this._bordColor2 = -6912;
        } else if (this._level == 4) {
            this._img[17] = new Image2("/gfx/ciel_E.png", 1, 1);
            this._img[18] = new Image2("/gfx/BG_E1.png", 1, 1);
            this._img[20] = new Image2("/gfx/element_E1.png", 1, 5);
            this._img[21] = new Image2("/gfx/element_E2.png", 1, 5);
            this._groundColor = -5057281;
            this._roadColor1 = -8344623;
            this._roadColor2 = -9857089;
            this._bordColor1 = -11380085;
            this._bordColor2 = -7340091;
        } else if (this._level == 5) {
            this._img[17] = new Image2("/gfx/ciel_F.png", 1, 1);
            this._img[18] = new Image2("/gfx/BG_F1.png", 1, 1);
            this._img[20] = new Image2("/gfx/element_F1.png", 1, 5);
            this._img[21] = new Image2("/gfx/element_F2.png", 1, 5);
            this._groundColor = -8156785;
            this._roadColor1 = -5521199;
            this._roadColor2 = -3811364;
            this._bordColor1 = -12696727;
            this._bordColor2 = -3997737;
        } else if (this._level == 6) {
            this._img[17] = new Image2("/gfx/ciel_G.png", 1, 1);
            this._img[18] = new Image2("/gfx/vortex_anim.png", 3, 1);
            this._groundColor = -14930372;
            this._roadColor1 = -12390401;
            this._roadColor2 = -13186561;
            this._bordColor1 = -12696727;
            this._bordColor2 = -3997737;
        }
    }

    void Load_Menu() {
        this._img[1] = new Image2("/gfx/menuscreen.png", 1, 1);
        this._img[10] = new Image2("/gfx/logo_menu.png", 1, 1);
        this._img[2] = new Image2("/gfx/galaxymap.png", 1, 1);
        this._img[8] = new Image2("/gfx/spatiokart_01_menu.png", 1, 1);
        this._img[9] = new Image2("/gfx/spatiokart_02_menu.png", 1, 1);
        this._img[4] = new Image2("/gfx/arrow_L_menu.png", 4, 1);
        this._img[5] = new Image2("/gfx/arrow_R_menu.png", 4, 1);
        this._img[24] = new Image2("/gfx/v_anim.png", 6, 1);
        this._img[3] = new Image2("/gfx/vignette_02.png", 1, 1);
        this._img[26] = new Image2("/gfx/vignette_03.png", 1, 1);
        this._img[28] = new Image2("/gfx/vignette_06.png", 1, 1);
        this._img[27] = new Image2("/gfx/vignette_01.png", 1, 1);
        this._img[29] = new Image2("/gfx/vignette_05.png", 1, 1);
        this._img[30] = new Image2("/gfx/vignette_04.png", 1, 1);
    }

    void Load_Records() {
        try {
            byte[] byArray = new byte[43];
            int n = 0;
            while (n < 7) {
                this._highScores[n] = 240;
                n = (byte)(n + 1);
            }
            this._lang = (byte)-1;
            this._isMusic = 0;
            this._firstHelp = 0;
            RecordStore recordStore = RecordStore.openRecordStore((String)"VortexRecord", (boolean)true);
            if (recordStore.getNumRecords() > 0) {
                recordStore.getRecord(1, byArray, 0);
                int n2 = 0;
                while (n2 < 7) {
                    this._highScores[n2] = byArray[n2 * 4] * 1000 + byArray[n2 * 4 + 1] * 100 + byArray[n2 * 4 + 2] * 10 + byArray[n2 * 4 + 3];
                    n2 = (byte)(n2 + 1);
                }
                int n3 = 0;
                while (n3 < 5) {
                    this._locked[n3] = byArray[28 + n3];
                    n3 = (byte)(n3 + 1);
                }
                this._isMusic = byArray[33];
                this._lang = byArray[34];
                this._data[0] = byArray[35];
                this._data[1] = byArray[36];
                this._data[2] = byArray[37] * 1000 + byArray[38] * 100 + byArray[39] * 10 + byArray[40];
                this._data[3] = byArray[41];
                this._firstHelp = byArray[42];
            } else {
                recordStore.addRecord(byArray, 0, 43);
            }
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.gc();
    }

    void Reset_Data() {
        this._X = 64;
        this._Y = 122;
        this._vX = 0;
        this._vY = 0;
        this._frame = 3;
        this._shadowY = 121;
        this._roadX = 0;
        this._speed = 0;
        this._acc = 10;
        this._speedX = 0;
        this._xLeft = -6;
        this._xRight = 134;
        this._leftCol = false;
        this._rightCol = false;
        this._turbo = false;
        this._object = 0;
        this._objectY1 = 0;
        this._objectY2 = 25;
        this._bend = false;
        this._inBend = false;
        this._cptBend = 0;
        this._bendX = 0;
        this._bendY = 0;
        this._explosion = false;
        this._cptExplosion = 0;
        this._cptCol = 0;
        this._option = false;
        this._optionCatched = false;
        this._cptOption = 0;
    }

    void Reset_Direction_Keys() {
        this._keyMap[2] = -1;
        this._keyMap[3] = -1;
        this._keyMap[4] = -1;
        this._keyMap[5] = -1;
        this._keyMap[8] = -1;
        this._keyMap[14] = -1;
        this._keyMap[10] = -1;
        this._keyMap[12] = -1;
    }

    void Save_Records() {
        byte[] byArray = new byte[43];
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)"VortexRecord", (boolean)false);
            if (recordStore.getNumRecords() > 0) {
                int n;
                int n2 = 0;
                while (n2 < 7) {
                    n = (byte)(this._highScores[n2] / 1000);
                    byte by = (byte)((this._highScores[n2] - 1000 * n) / 100);
                    byte by2 = (byte)((this._highScores[n2] - 1000 * n - 100 * by) / 10);
                    byte by3 = (byte)(this._highScores[n2] % 10);
                    byArray[n2 * 4] = n;
                    byArray[n2 * 4 + 1] = by;
                    byArray[n2 * 4 + 2] = by2;
                    byArray[n2 * 4 + 3] = by3;
                    n2 = (byte)(n2 + 1);
                }
                n = 0;
                while (n < 5) {
                    byArray[28 + n] = this._locked[n];
                    n = (byte)(n + 1);
                }
                byArray[33] = this._isMusic;
                byArray[34] = this._lang;
                byArray[35] = (byte)this._data[0];
                byArray[36] = (byte)this._data[1];
                byArray[37] = (byte)(this._data[2] / 1000);
                byArray[38] = (byte)((this._data[2] - 1000 * byArray[37]) / 100);
                byArray[39] = (byte)((this._data[2] - 1000 * byArray[37] - 100 * byArray[38]) / 10);
                byArray[40] = (byte)(this._data[2] % 10);
                byArray[41] = (byte)this._data[3];
                byArray[42] = this._firstHelp;
                recordStore.setRecord(1, byArray, 0, 43);
            }
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.gc();
    }

    int Sqrt(int n) {
        int n2 = 0;
        int n3 = 65536;
        while (n3 != 0) {
            int n4 = n2 + n3;
            n2 >>= 1;
            if (n4 <= n) {
                n -= n4;
                n2 += n3;
            }
            n3 >>= 2;
        }
        return n2;
    }

    void Update_Game(Graphics graphics) {
        this.keyUpdate();
        switch (this._gameState) {
            case 0: {
                this._gameState = 1;
                this._curMusic = 1;
                this.Init_Data();
            }
            case 1: {
                if (this._keyMap[11] > 0) {
                    if (this._keyMap[11] == 2 && this._cptStart == 2 && System.currentTimeMillis() - this._startTime > 500L) {
                        this._startBoost = true;
                    }
                } else {
                    this._startBoost = false;
                }
                this.Draw_Game(graphics);
                this._img[16].drawFrame(graphics, 64, 30, this._cptStart, 2);
                if (this._instructions1) {
                    graphics.setClip(0, 0, 128, 128);
                    graphics.setColor(-11289468);
                    graphics.fillRect(5, 20, 118, 88);
                    graphics.setColor(-12883335);
                    graphics.fillRect(10, 25, 108, 78);
                    this._mu0.print(graphics, 5, 30, 195, 2);
                    int n = 0;
                    while (n < 4) {
                        this._mu0.print(graphics, 5, 50 + 10 * n, 175 + n, 2);
                        n = (byte)(n + 1);
                    }
                    if (this._keyMap[11] > 0 || this._keyMap[18] > 0 || this._keyMap[0] > 0) {
                        this._keyMap[11] = 0;
                        this._keyMap[18] = 0;
                        this._keyMap[0] = 0;
                        this._instructions1 = false;
                        this._startTime = System.currentTimeMillis();
                    }
                    return;
                }
                if (this._instructions2) {
                    graphics.setClip(0, 0, 128, 128);
                    graphics.setColor(-11289468);
                    graphics.fillRect(5, 20, 118, 88);
                    graphics.setColor(-12883335);
                    graphics.fillRect(10, 25, 108, 78);
                    int n = 0;
                    while (n < 5) {
                        this._mu0.print(graphics, 30, 35 + 10 * n, 170 + n);
                        n = (byte)(n + 1);
                    }
                    if (this._keyMap[11] > 0 || this._keyMap[18] > 0 || this._keyMap[0] > 0) {
                        this._keyMap[11] = 0;
                        this._keyMap[18] = 0;
                        this._keyMap[0] = 0;
                        this._instructions2 = false;
                        this._firstHelp = (byte)(this._firstHelp + 1);
                        this._startTime = System.currentTimeMillis();
                    }
                    return;
                }
                if (System.currentTimeMillis() - this._startTime <= 1000L) break;
                ++this._cptStart;
                this._startTime = System.currentTimeMillis();
                if (this._cptStart != 3) break;
                this._gameState = 2;
                this._keyMap[11] = 0;
                if (!this._startBoost) break;
                this._cptBoost = 15;
                this._speed = 100;
                break;
            }
            case 2: {
                byte by;
                if (this._keyMap[0] > 0 || this._keyMap[1] > 0) {
                    this._keyMap[0] = -1;
                    this._keyMap[1] = -1;
                    this._gameState = 3;
                    this._curs = 0;
                    return;
                }
                this._turbo = this._keyMap[11] > 0 && this._turboSize > 0;
                if (!(this._keyMap[13] <= 0 || this._missile || this._nbMis <= 0 || this._mode == 1 && this._level == 6)) {
                    this._missile = true;
                    this._misX = this._X;
                    this._misY = this._Y - 10;
                    this._misZ = 4;
                    this._nbMis = (byte)(this._nbMis - 1);
                }
                if (this._startBoost) {
                    this._speedMax = 600;
                    this._acc = 30;
                    --this._cptBoost;
                    if (this._cptBoost == 0) {
                        this._startBoost = false;
                    }
                } else if (this._turbo) {
                    this._speedMax = 600;
                    this._acc = 30;
                    if (this._mode == 0) {
                        if (this._kart == 0 && this._cptMain % 3 == 0) {
                            this._turboSize = (byte)(this._turboSize - 1);
                        } else if (this._kart == 1 && this._cptMain % 4 == 0) {
                            this._turboSize = (byte)(this._turboSize - 1);
                        }
                    } else if (this._level != 6) {
                        if (this._data[0] == 1) {
                            if (this._cptMain % 3 == 0) {
                                this._turboSize = (byte)(this._turboSize - 1);
                            }
                        } else if (this._data[0] == 2) {
                            if (this._cptMain % 4 == 0) {
                                this._turboSize = (byte)(this._turboSize - 1);
                            }
                        } else if (this._data[0] == 3 && this._cptMain % 5 == 0) {
                            this._turboSize = (byte)(this._turboSize - 1);
                        }
                    }
                    if (this._turboSize == 0) {
                        this._turbo = false;
                    }
                } else {
                    this._speedMax = 500;
                    this._acc = 10;
                }
                this.Update_Option();
                if (!this._explosion) {
                    this.Update_Player();
                } else if (this._cptMain % 2 == 0) {
                    ++this._cptExplosion;
                    if (this._cptExplosion > 3) {
                        this.Reset_Data();
                    }
                }
                if (this._speed < 0) {
                    this._speed = 0;
                }
                if (this._missile) {
                    this._misY -= 3;
                    this._misZ = 4 - (this._Y - this._misY) / 15;
                    if (this._misZ < 0 || this._misY < 81) {
                        this._missile = false;
                    }
                    by = 0;
                    while (by < this._nbOpponent) {
                        if (this._opp[by]._onScreen && !this._opp[by]._boom && !this._opp[by]._repair && this._misY <= this._opp[by]._posY + 76 && this._misY > this._opp[by]._posY + 76 - 9 - this._opp[by]._zoom * 2 && this._misX > this._opp[by]._posX - 12 - this._opp[by]._zoom * 2 && this._misX < this._opp[by]._posX + 9 + this._opp[by]._zoom * 2) {
                            this._opp[by]._boom = true;
                            this._opp[by]._cptBoom = 0;
                            this._missile = false;
                        }
                        by = (byte)(by + 1);
                    }
                }
                this._z = false;
                this._position = (byte)(this._nbOpponent + 1);
                by = 0;
                while (by < this._nbOpponent) {
                    this._opp[by].Update();
                    if (this._opp[by]._posY + 76 >= this._Y) {
                        this._position = (byte)(this._position - 1);
                    }
                    by = (byte)(by + 1);
                }
                if (this._mode == 1 && this._level == 6 && this._position == 1) {
                    this._gameState = 4;
                    this._cptEnd = 0;
                    this._enterScore = false;
                    this._keyMap[11] = -1;
                }
                if (this._speed > 0) {
                    this.Update_Road();
                }
                if (System.currentTimeMillis() - this._sec >= 1000L) {
                    if (this._mode == 1 && this._level == 5) {
                        --this._time;
                        if (this._time == 0) {
                            this._gameState = 4;
                            this._cptEnd = 0;
                            this._enterScore = false;
                            this._loose = true;
                            this._keyMap[11] = -1;
                        }
                    } else {
                        ++this._time;
                    }
                    this._sec = System.currentTimeMillis();
                }
                if (this._scroll > 0) {
                    this._scroll -= 128;
                } else if (this._scroll < -128) {
                    this._scroll += 128;
                }
                this.Draw_Game(graphics);
                break;
            }
            case 3: {
                graphics.setColor(-11289468);
                graphics.fillRect(15, 15, 98, 98);
                graphics.setColor(-12883335);
                graphics.fillRect(20, 20, 88, 88);
                graphics.setColor(-9176164);
                int n = 38;
                if (this._curs == 1) {
                    n = 53;
                } else if (this._curs == 2) {
                    n = 78;
                }
                graphics.fillRect(30, n, 60, 13);
                graphics.setColor(-16777216);
                graphics.fillRect(31, n + 1, 58, 11);
                this._mu0.print(graphics, 32, 40, 19);
                this._mu0.print(graphics, 32, 55, 7);
                this._mu0.print(graphics, 37, 65, 9 + this._isMusic);
                this._mu0.print(graphics, 32, 80, 20);
                if (this._keyMap[2] > 0 || this._keyMap[8] > 0) {
                    this.Reset_Direction_Keys();
                    this._curs = (byte)(this._curs - 1);
                    if (this._curs < 0) {
                        this._curs = (byte)2;
                    }
                } else if (this._keyMap[3] > 0 || this._keyMap[14] > 0) {
                    this.Reset_Direction_Keys();
                    this._curs = (byte)(this._curs + 1);
                    if (this._curs > 2) {
                        this._curs = 0;
                    }
                }
                if (this._keyMap[11] <= 0 && this._keyMap[18] <= 0 && this._keyMap[0] <= 0) break;
                this._keyMap[11] = -1;
                this._keyMap[18] = -1;
                this._keyMap[0] = -1;
                if (this._curs == 0) {
                    this._gameState = 2;
                    break;
                }
                if (this._curs == 1) {
                    if (this._isMusic == 0) {
                        this._isMusic = 1;
                        this._snd.Stop_Music();
                        break;
                    }
                    this._isMusic = 0;
                    this._curMusic = 1;
                    break;
                }
                this._mainState = 3;
                this._cptLoad = 0;
                this._continue = false;
                break;
            }
            case 4: {
                graphics.setColor(-11289468);
                graphics.fillRect(15, 20, 98, 88);
                graphics.setColor(-12883335);
                graphics.fillRect(20, 25, 88, 78);
                if (this._cptEnd == 0) {
                    this.Draw_Number(graphics, this._position, 54, 55);
                    this._img[39].drawFrame(graphics, 60, 55, 10, 16 + 4);
                    this.Draw_Number(graphics, this._nbOpponent + 1, 66, 55);
                    if (this._position == 1 && !this._loose) {
                        this._mu0.print(graphics, 0, 70, 187, 16 + 2);
                    } else {
                        this._mu0.print(graphics, 5, 70, 188, 16 + 2);
                    }
                } else if (this._cptEnd == 1) {
                    this.Draw_Time(graphics, this._time, 54, 55);
                    if (this._mode == 0 && this._time < this._highScores[this._level]) {
                        this._mu0.print(graphics, 5, 70, 23, 16 + 2);
                        this._enterScore = true;
                    }
                } else if (this._cptEnd == 2) {
                    int n = this._moneyRab;
                    if (this._position <= 1 && !this._loose) {
                        n += _reward[this._level];
                    }
                    this._mu0.print(graphics, 0, 55, 196, 16 + 2);
                    this._mu0.printValue(graphics, 40, 70, n);
                }
                if (this._keyMap[0] <= 0 && this._keyMap[18] <= 0 && this._keyMap[11] <= 0) break;
                this._keyMap[18] = -1;
                this._keyMap[11] = -1;
                this._keyMap[0] = -1;
                if (this._cptEnd == 0 && this._mode == 0 || this._cptEnd <= 1 && this._mode == 1) {
                    ++this._cptEnd;
                    break;
                }
                this._mainState = 3;
                this._cptLoad = 0;
                this._continue = true;
                if (this._loose) {
                    this._position = (byte)2;
                }
                if (!this._enterScore) break;
                this._highScores[this._level] = this._time;
            }
        }
    }

    void Update_Menu(Graphics graphics) {
        this.keyUpdate();
        this._ok = false;
        this._back = false;
        if (this._keyMap[0] > 0 || this._keyMap[11] > 0 || this._keyMap[18] > 0) {
            this._keyMap[0] = -1;
            this._keyMap[11] = -1;
            this._keyMap[18] = -1;
            this._ok = true;
        } else if (this._keyMap[1] > 0) {
            this._keyMap[1] = -1;
            this._back = true;
        }
        this._img[1].draw(graphics, 0, 0, 16 + 4);
        switch (this._menuState) {
            case 0: {
                if (this._keyMap[2] > 0 || this._keyMap[8] > 0) {
                    this._curs = (byte)(this._curs - 1);
                    if (this._curs < 0) {
                        this._curs = (byte)5;
                    }
                } else if (this._keyMap[3] > 0 || this._keyMap[14] > 0) {
                    this._curs = (byte)(this._curs + 1);
                    if (this._curs > 5) {
                        this._curs = 0;
                    }
                }
                this.Reset_Direction_Keys();
                graphics.setColor(-9176164);
                graphics.fillRect(20, 43 + 13 * this._curs, 80, 13);
                graphics.setColor(-16777216);
                graphics.fillRect(21, 44 + 13 * this._curs, 78, 11);
                this._img[10].draw(graphics, 20, 5, 16 + 4);
                this._img[24].drawFrame(graphics, 20, 5, this._cptMain % 12 / 2, 16 + 4);
                int n = 0;
                while (n < 6) {
                    this._mu0.print(graphics, 22, 45 + 13 * n, n);
                    n = (byte)(n + 1);
                }
                switch (this._curs) {
                    case 0: {
                        if (!this._ok) break;
                        this._menuState = 6;
                        break;
                    }
                    case 1: {
                        if (!this._ok) break;
                        this._menuState = 1;
                        this._help = 0;
                        break;
                    }
                    case 2: {
                        if (!this._ok) break;
                        this._menuState = 3;
                        this._curs = 0;
                        break;
                    }
                    case 3: {
                        if (!this._ok) break;
                        this._menuState = 2;
                        break;
                    }
                    case 4: {
                        if (!this._ok) break;
                        this._menuState = 4;
                        break;
                    }
                    case 5: {
                        if (!this._ok) break;
                        this._mainState = 6;
                    }
                }
                break;
            }
            case 6: {
                this._img[10].draw(graphics, 20, 5, 16 + 4);
                this._img[24].drawFrame(graphics, 20, 5, this._cptMain % 12 / 2, 16 + 4);
                this._mu0.print(graphics, (int)BACK_X[this._lang], 118, 6);
                if (this._keyMap[2] > 0 || this._keyMap[8] > 0 || this._keyMap[3] > 0 || this._keyMap[14] > 0) {
                    this.Reset_Direction_Keys();
                    this._curs = (byte)(1 - this._curs);
                }
                graphics.setClip(0, 0, 128, 128);
                graphics.setColor(-9176164);
                graphics.fillRect(20, 55 + this._curs * 20, 80, 13);
                graphics.setColor(-16777216);
                graphics.fillRect(21, 56 + this._curs * 20, 78, 11);
                this._mu0.print(graphics, 22, 57, 25);
                this._mu0.print(graphics, 22, 77, 26);
                if (this._ok) {
                    this._mode = this._curs;
                    this._kart = 0;
                    if (this._mode == 0) {
                        this._menuState = 8;
                        this._kartX = 64;
                        this._kartMove = false;
                        break;
                    }
                    if (this._mode != 1) break;
                    this._curs = 0;
                    if (this._data[3] > 0) {
                        this._menuState = 11;
                        break;
                    }
                    this._menuState = 7;
                    this._planetX = 0;
                    this._plus = true;
                    this._curs = 0;
                    this._cptName = 0;
                    break;
                }
                if (!this._back) break;
                this._menuState = 0;
                this._curs = 0;
                break;
            }
            case 11: {
                this._img[10].draw(graphics, 20, 5, 16 + 4);
                this._img[24].drawFrame(graphics, 20, 5, this._cptMain % 12 / 2, 16 + 4);
                this._mu0.print(graphics, (int)BACK_X[this._lang], 118, 6);
                if (this._keyMap[2] > 0 || this._keyMap[8] > 0 || this._keyMap[3] > 0 || this._keyMap[14] > 0) {
                    this.Reset_Direction_Keys();
                    this._curs = (byte)(1 - this._curs);
                }
                graphics.setClip(0, 0, 128, 128);
                graphics.setColor(-9176164);
                graphics.fillRect(20, 50 + 25 * this._curs, 80, 13);
                graphics.setColor(-16777216);
                graphics.fillRect(21, 51 + 25 * this._curs, 78, 11);
                this._mu0.print(graphics, 22, 52, 189);
                this._mu0.print(graphics, 22, 77, 190);
                if (this._ok) {
                    if (this._curs == 1) {
                        this.Init_Adventure();
                    }
                    this._menuState = 7;
                    this._curs = (byte)this._data[3];
                    this._cptName = 0;
                    this._planetX = 0;
                    this._plus = true;
                    break;
                }
                if (!this._back) break;
                this._curs = 0;
                this._menuState = 6;
                break;
            }
            case 8: {
                this._img[8 + this._kart].draw(graphics, this._kartX, 10, 2);
                this.Draw_Arrows(graphics);
                graphics.setClip(0, 0, 128, 128);
                graphics.setColor(-9671988);
                graphics.fillRect(2, 85, 124, 39);
                graphics.setColor(-16777216);
                graphics.fillRect(3, 86, 122, 37);
                graphics.setColor(-16777216);
                graphics.drawRect(60, 95, 50, 6);
                graphics.drawRect(60, 110, 50, 6);
                graphics.setColor(-1);
                graphics.fillRect(61, 96, 48, 4);
                graphics.fillRect(61, 111, 48, 4);
                graphics.setColor(-11289468);
                graphics.fillRect(61, 96, 25 + this._kart * 10, 4);
                graphics.fillRect(61, 111, 35 - this._kart * 10, 4);
                this._mu0.print(graphics, 6, 93, 184);
                this._mu0.print(graphics, 6, 108, 185);
                if (!(this._kartMove || this._keyMap[4] <= 0 && this._keyMap[10] <= 0)) {
                    this._kartMove = true;
                    this._menuDir = 0;
                    this._cptArrowLeft = 1;
                } else if (!(this._kartMove || this._keyMap[5] <= 0 && this._keyMap[12] <= 0)) {
                    this._kartMove = true;
                    this._menuDir = 1;
                    this._cptArrowRight = 1;
                } else if (!this._kartMove) {
                    this._menuDir = (byte)-1;
                }
                if (this._menuDir == 0) {
                    this._kartX -= 20;
                    if (this._kartX < -50) {
                        this._kartX = 204;
                        this._kart = (byte)(1 - this._kart);
                    }
                    if (this._kartX == 64) {
                        this._kartMove = false;
                    }
                } else if (this._menuDir == 1) {
                    this._kartX += 20;
                    if (this._kartX > 178) {
                        this._kartX = -76;
                        this._kart = (byte)(1 - this._kart);
                    }
                    if (this._kartX == 64) {
                        this._kartMove = false;
                    }
                }
                if (this._cptArrowLeft > 0) {
                    ++this._cptArrowLeft;
                    if (this._cptArrowLeft > 10) {
                        this._cptArrowLeft = 0;
                    }
                }
                if (this._cptArrowRight > 0) {
                    ++this._cptArrowRight;
                    if (this._cptArrowRight > 10) {
                        this._cptArrowRight = 0;
                    }
                }
                if (this._back) {
                    this._curs = 0;
                    this._menuState = 6;
                    break;
                }
                if (!this._ok) break;
                this._menuState = 7;
                this._curs = 0;
                this._cptName = 0;
                this._planetX = 0;
                this._plus = true;
                break;
            }
            case 7: {
                this._img[2].draw(graphics, 0, 0, 16 + 4);
                if (this._mode == 0) {
                    if (this._keyMap[4] > 0 || this._keyMap[10] > 0 || this._keyMap[2] > 0 || this._keyMap[8] > 0) {
                        this._curs = (byte)(this._curs - 1);
                        if (this._curs < 0) {
                            this._curs = (byte)6;
                        }
                        this._cptName = 0;
                    } else if (this._keyMap[5] > 0 || this._keyMap[12] > 0 || this._keyMap[3] > 0 || this._keyMap[14] > 0) {
                        this._curs = (byte)(this._curs + 1);
                        if (this._curs > 6) {
                            this._curs = 0;
                        }
                        this._cptName = 0;
                    }
                }
                this.Reset_Direction_Keys();
                if (this._plus) {
                    ++this._planetX;
                    if (this._planetX > 5) {
                        this._plus = false;
                    }
                } else {
                    --this._planetX;
                    if (this._planetX < -2) {
                        this._plus = true;
                    }
                }
                graphics.setColor(-65536);
                graphics.drawRect(PLANETS[this._curs][0] - this._planetX, PLANETS[this._curs][1] - this._planetX, PLANETS[this._curs][2] + this._planetX * 2, PLANETS[this._curs][3] + this._planetX * 2);
                if (this._cptName < 25) {
                    ++this._cptName;
                }
                this._mu0.printLen(graphics, 3, 104, 29 + this._curs, this._cptName);
                if (this._cptName >= 10 && this._mode == 0) {
                    this._mu0.printLen(graphics, 3, 116, 27 + this._locked[this._curs], this._cptName - 10);
                }
                if (this._back) {
                    if (this._mode == 0) {
                        this._menuState = 8;
                        this._kartX = 64;
                        this._kart = 0;
                        this._kartMove = false;
                        break;
                    }
                    if (this._mode != 1) break;
                    this._menuState = 6;
                    this._curs = 0;
                    break;
                }
                if (!this._ok) break;
                if (this._mode == 0 && this._locked[this._curs] == 0) {
                    this._mainState = 2;
                    this._cptLoad = 0;
                } else if (this._mode == 1) {
                    this._menuState = 9;
                    this._briefing = 0;
                }
                this._level = this._curs;
                break;
            }
            case 9: {
                this._img[2].draw(graphics, 0, 0, 16 + 4);
                graphics.setColor(-9671988);
                graphics.fillRect(0, 2, 128, 80);
                graphics.setColor(-16777216);
                graphics.fillRect(2, 4, 124, 76);
                if (this._level == 0) {
                    if (this._briefing <= 1) {
                        if (this._briefing == 0) {
                            int n = 0;
                            while (n < 7) {
                                this._mu0.print(graphics, 8, 5 + 10 * n, 38 + n, 2);
                                n = (byte)(n + 1);
                            }
                        } else {
                            int n = 0;
                            while (n < 6) {
                                this._mu0.print(graphics, 8, 10 + 10 * n, 45 + n, 2);
                                n = (byte)(n + 1);
                            }
                        }
                        this.Draw_Character(graphics, 3);
                    } else if (this._briefing == 2) {
                        int n = 0;
                        while (n < 5) {
                            this._mu0.print(graphics, 8, 15 + 10 * n, 51 + n, 2);
                            n = (byte)(n + 1);
                        }
                        this.Draw_Character(graphics, 26);
                    } else if (this._briefing == 3) {
                        int n = 0;
                        while (n < 3) {
                            this._mu0.print(graphics, 8, 25 + 10 * n, 56 + n, 2);
                            n = (byte)(n + 1);
                        }
                        this.Draw_Character(graphics, 28);
                    } else if (this._briefing == 4) {
                        int n = 0;
                        while (n < 5) {
                            this._mu0.print(graphics, 8, 15 + 10 * n, 59 + n, 2);
                            n = (byte)(n + 1);
                        }
                        this.Draw_Character(graphics, 29);
                    } else if (this._briefing == 5) {
                        int n = 0;
                        while (n < 4) {
                            this._mu0.print(graphics, 8, 20 + 10 * n, 64 + n, 2);
                            n = (byte)(n + 1);
                        }
                        this.Draw_Character(graphics, 30);
                    }
                } else if (this._level == 1) {
                    if (this._briefing == 0) {
                        int n = 0;
                        while (n < 6) {
                            this._mu0.print(graphics, 8, 10 + 10 * n, 78 + n, 2);
                            n = (byte)(n + 1);
                        }
                        this.Draw_Character(graphics, 3);
                    } else if (this._briefing == 1) {
                        int n = 0;
                        while (n < 4) {
                            this._mu0.print(graphics, 8, 20 + 10 * n, 84 + n, 2);
                            n = (byte)(n + 1);
                        }
                        this.Draw_Character(graphics, 28);
                    }
                } else if (this._level == 2) {
                    if (this._briefing == 0) {
                        int n = 0;
                        while (n < 7) {
                            this._mu0.print(graphics, 8, 5 + 10 * n, 88 + n, 2);
                            n = (byte)(n + 1);
                        }
                        this.Draw_Character(graphics, 3);
                    } else if (this._briefing == 1) {
                        int n = 0;
                        while (n < 3) {
                            this._mu0.print(graphics, 8, 25 + 10 * n, 95 + n, 2);
                            n = (byte)(n + 1);
                        }
                        this.Draw_Character(graphics, 26);
                    }
                } else if (this._level == 3) {
                    if (this._briefing == 0) {
                        int n = 0;
                        while (n < 7) {
                            this._mu0.print(graphics, 8, 5 + 10 * n, 98 + n, 2);
                            n = (byte)(n + 1);
                        }
                        this.Draw_Character(graphics, 3);
                    } else if (this._briefing == 1) {
                        int n = 0;
                        while (n < 4) {
                            this._mu0.print(graphics, 8, 20 + 10 * n, 105 + n, 2);
                            n = (byte)(n + 1);
                        }
                        this.Draw_Character(graphics, 29);
                    }
                } else if (this._level == 4) {
                    if (this._briefing == 0) {
                        int n = 0;
                        while (n < 7) {
                            this._mu0.print(graphics, 8, 5 + 10 * n, 109 + n, 2);
                            n = (byte)(n + 1);
                        }
                        this.Draw_Character(graphics, 3);
                    } else if (this._briefing == 1) {
                        int n = 0;
                        while (n < 4) {
                            this._mu0.print(graphics, 8, 20 + 10 * n, 116 + n, 2);
                            n = (byte)(n + 1);
                        }
                        this.Draw_Character(graphics, 26);
                    }
                } else if (this._level == 5) {
                    if (this._briefing <= 1) {
                        int n = 0;
                        while (n < 5) {
                            this._mu0.print(graphics, 8, 15 + 10 * n, 120 + n + this._briefing * 5, 2);
                            n = (byte)(n + 1);
                        }
                        this.Draw_Character(graphics, 3);
                    } else if (this._briefing == 2) {
                        int n = 0;
                        while (n < 3) {
                            this._mu0.print(graphics, 8, 25 + 10 * n, 130 + n, 2);
                            n = (byte)(n + 1);
                        }
                        this.Draw_Character(graphics, 28);
                    }
                } else if (this._level == 6) {
                    if (this._briefing <= 1) {
                        int n = 0;
                        while (n < 5) {
                            this._mu0.print(graphics, 8, 15 + 10 * n, 139 + n + this._briefing * 5, 2);
                            n = (byte)(n + 1);
                        }
                        this.Draw_Character(graphics, 3);
                    } else if (this._briefing == 2) {
                        int n = 0;
                        while (n < 5) {
                            this._mu0.print(graphics, 8, 15 + 10 * n, 149 + n, 2);
                            n = (byte)(n + 1);
                        }
                        this.Draw_Character(graphics, 26);
                    }
                }
                if (this._ok) {
                    if (this._briefing < BRIEFING[this._level]) {
                        this._briefing = (byte)(this._briefing + 1);
                        break;
                    }
                    if (this._level == 6) {
                        this._mainState = 2;
                        this._cptLoad = 0;
                        break;
                    }
                    this._menuState = 12;
                    this._garage = 0;
                    this._gCurs = 0;
                    this.Load_Garage();
                    break;
                }
                if (!this._back) break;
                this._menuState = 7;
                this._cptName = 0;
                this._planetX = 0;
                this._plus = true;
                break;
            }
            case 10: {
                this._img[2].draw(graphics, 0, 0, 16 + 4);
                graphics.setColor(-9671988);
                graphics.fillRect(0, 2, 128, 80);
                graphics.setColor(-16777216);
                graphics.fillRect(2, 4, 124, 76);
                if (this._level == 0) {
                    if (this._debriefing == 0) {
                        int n = 0;
                        while (n < 6) {
                            this._mu0.print(graphics, 8, 10 + 10 * n, 68 + n, 2);
                            n = (byte)(n + 1);
                        }
                    } else if (this._debriefing == 1) {
                        int n = 0;
                        while (n < 4) {
                            this._mu0.print(graphics, 8, 20 + 10 * n, 74 + n, 2);
                            n = (byte)(n + 1);
                        }
                    }
                    this.Draw_Character(graphics, 3);
                } else if (this._level == 5) {
                    int n = 0;
                    while (n < 6) {
                        this._mu0.print(graphics, 8, 10 + 10 * n, 133 + n, 2);
                        n = (byte)(n + 1);
                    }
                    this.Draw_Character(graphics, 3);
                } else if (this._level == 6) {
                    int n = 0;
                    while (n < 5) {
                        this._mu0.print(graphics, 8, 15 + 10 * n, 154 + n + this._debriefing * 5, 2);
                        n = (byte)(n + 1);
                    }
                    if (this._debriefing == 0) {
                        this.Draw_Character(graphics, 3);
                    } else if (this._debriefing == 1) {
                        this.Draw_Character(graphics, 30);
                    } else if (this._debriefing == 2) {
                        this.Draw_Character(graphics, 26);
                    }
                }
                if (this._ok && this._debriefing < DEBRIEFING[this._level]) {
                    this._debriefing = (byte)(this._debriefing + 1);
                    break;
                }
                if (!this._ok && !this._back) break;
                if (this._level < 6) {
                    this._curs = (byte)(this._level + 1);
                    this._menuState = 7;
                    this._cptName = 0;
                    this._planetX = 0;
                    this._plus = true;
                    break;
                }
                if (this._level != 6) break;
                this._menuState = 0;
                this._curs = 0;
                this.Init_Adventure();
                break;
            }
            case 12: {
                graphics.setColor(-9671988);
                graphics.fillRect(40, 83, 86, 40);
                graphics.setColor(-16777216);
                graphics.fillRect(41, 84, 84, 38);
                this._img[27].draw(graphics, 0, 128, 4 + 32);
                if (this._garage == 0) {
                    graphics.setColor(-9176164);
                    graphics.fillRect(28, 33 + 14 * (this._gCurs % 2) + 35 * (this._gCurs / 2), 70, 13);
                    graphics.setColor(-16777216);
                    graphics.fillRect(29, 34 + 14 * (this._gCurs % 2) + 35 * (this._gCurs / 2), 68, 11);
                    this._mu0.print(graphics, 5, 2, 179, 2);
                    this._mu0.print(graphics, 20, 20, 182);
                    this._mu0.print(graphics, 30, 35, 184);
                    this._mu0.print(graphics, 30, 49, 185);
                    this._mu0.print(graphics, 30, 70, 180);
                    this._mu0.print(graphics, 55, 98, 181);
                    this._mu0.print(graphics, (int)BACK_X[this._lang], 118, 6);
                    if (this._keyMap[2] > 0 || this._keyMap[8] > 0) {
                        this._gCurs = (byte)(this._gCurs - 1);
                        if (this._gCurs < 0) {
                            this._gCurs = (byte)2;
                        }
                    } else if (this._keyMap[3] > 0 || this._keyMap[14] > 0) {
                        this._gCurs = (byte)(this._gCurs + 1);
                        if (this._gCurs > 2) {
                            this._gCurs = 0;
                        }
                    }
                    this.Reset_Direction_Keys();
                    if (this._ok) {
                        if (this._gCurs < 2) {
                            this._garage = (byte)(this._gCurs + 1);
                            this._gCurs = 0;
                        } else {
                            this._img[31] = null;
                            this._img[32] = null;
                            this._img[33] = null;
                            this._img[34] = null;
                            this._img[35] = null;
                            this._img[36] = null;
                            this._img[37] = null;
                            this._mainState = 2;
                            this._cptLoad = 0;
                        }
                    } else if (this._back) {
                        this._curs = 0;
                        this._menuState = 6;
                    }
                } else if (this._garage == 1) {
                    if (this._gCurs == 0) {
                        this._img[31].drawFrame(graphics, 60, 20, 0, 1 + 2);
                    } else {
                        this._img[31].drawFrame(graphics, 60, 20, 1, 1 + 2);
                    }
                    if (this._gCurs == 1) {
                        this._img[32].drawFrame(graphics, 90, 55, 0, 1 + 2);
                    } else {
                        this._img[32].drawFrame(graphics, 90, 55, 1, 1 + 2);
                    }
                    if (this._gCurs == 2) {
                        this._img[33].drawFrame(graphics, 30, 55, 0, 1 + 2);
                    } else {
                        this._img[33].drawFrame(graphics, 30, 55, 1, 1 + 2);
                    }
                    this._mu0.print(graphics, 55, 88, this._strBoost[this._gCurs]);
                    graphics.setClip(0, 0, 128, 128);
                    this._img[37].draw(graphics, 55, 100, 16 + 4);
                    this._mu0.printValue(graphics, 70, 102, _prize[this._gCurs]);
                    this._mu0.print(graphics, (int)BACK_X[this._lang], 118, 6);
                    if (this._keyMap[4] > 0 || this._keyMap[10] > 0) {
                        this._gCurs = (byte)(this._gCurs - 1);
                        if (this._gCurs < 0) {
                            this._gCurs = (byte)2;
                        }
                    } else if (this._keyMap[5] > 0 || this._keyMap[12] > 0) {
                        this._gCurs = (byte)(this._gCurs + 1);
                        if (this._gCurs > 2) {
                            this._gCurs = 0;
                        }
                    } else if (this._ok) {
                        if (this._cptMsg > 0) {
                            this._cptMsg = 0;
                            return;
                        }
                        if (this._gCurs <= this._data[0] - 1) {
                            this._cptMsg = 2;
                        } else if (this._data[2] < _prize[this._gCurs]) {
                            this._cptMsg = 1;
                        } else {
                            this._data[0] = this._gCurs + 1;
                            this._data[2] = this._data[2] - _prize[this._gCurs];
                        }
                    }
                    this.Reset_Direction_Keys();
                } else if (this._garage == 2) {
                    if (this._gCurs == 0) {
                        this._img[34].drawFrame(graphics, 60, 20, 0, 1 + 2);
                    } else {
                        this._img[34].drawFrame(graphics, 60, 20, 1, 1 + 2);
                    }
                    if (this._gCurs == 1) {
                        this._img[35].drawFrame(graphics, 90, 55, 0, 1 + 2);
                    } else {
                        this._img[35].drawFrame(graphics, 90, 55, 1, 1 + 2);
                    }
                    if (this._gCurs == 2) {
                        this._img[36].drawFrame(graphics, 30, 55, 0, 1 + 2);
                    } else {
                        this._img[36].drawFrame(graphics, 30, 55, 1, 1 + 2);
                    }
                    this._mu0.print(graphics, 52, 88, 186);
                    this._mu0.print(graphics, 105, 88, "x " + this._cap[this._gCurs]);
                    graphics.setClip(0, 0, 128, 128);
                    this._img[37].draw(graphics, 55, 100, 16 + 4);
                    this._mu0.printValue(graphics, 70, 102, _prize[this._gCurs + 3]);
                    this._mu0.print(graphics, (int)BACK_X[this._lang], 118, 6);
                    if (this._keyMap[4] > 0 || this._keyMap[10] > 0) {
                        this._gCurs = (byte)(this._gCurs - 1);
                        if (this._gCurs < 0) {
                            this._gCurs = (byte)2;
                        }
                    } else if (this._keyMap[5] > 0 || this._keyMap[12] > 0) {
                        this._gCurs = (byte)(this._gCurs + 1);
                        if (this._gCurs > 2) {
                            this._gCurs = 0;
                        }
                    } else if (this._ok) {
                        if (this._cptMsg > 0) {
                            this._cptMsg = 0;
                            return;
                        }
                        if (this._gCurs <= this._data[1] - 1) {
                            this._cptMsg = 2;
                        } else if (this._data[2] < _prize[this._gCurs + 3]) {
                            this._cptMsg = 1;
                        } else {
                            this._data[1] = this._cap[this._gCurs];
                            this._data[2] = this._data[2] - _prize[this._gCurs + 3];
                        }
                    }
                    this.Reset_Direction_Keys();
                }
                if (this._garage > 0) {
                    this._img[37].draw(graphics, 70, 0, 16 + 4);
                    this._mu0.printValue(graphics, 85, 4, this._data[2]);
                }
                if (this._cptMsg > 0) {
                    graphics.setClip(0, 0, 128, 128);
                    graphics.setColor(-11289468);
                    graphics.fillRect(15, 25, 98, 60);
                    graphics.setColor(-12883335);
                    graphics.fillRect(20, 30, 88, 50);
                    if (this._cptMsg == 1) {
                        this._mu0.print(graphics, 5, 40, 191, 2);
                        this._mu0.print(graphics, 5, 60, 192, 2);
                    } else if (this._cptMsg == 2) {
                        this._mu0.print(graphics, 5, 40, 193, 2);
                        this._mu0.print(graphics, 5, 60, 194, 2);
                    }
                }
                if (this._garage <= 0 || !this._back) break;
                this._garage = 0;
                this._gCurs = 0;
                this._cptMsg = 0;
                break;
            }
            case 1: {
                this._mu0.print(graphics, (int)BACK_X[this._lang], 118, 6);
                int n = 0;
                while (n < 5) {
                    this._mu0.print(graphics, 25, 5 + 11 * n, 170 + n);
                    n = (byte)(n + 1);
                }
                int n2 = 0;
                while (n2 < 4) {
                    this._mu0.print(graphics, 5, 65 + 11 * n2, 175 + n2, 2);
                    n2 = (byte)(n2 + 1);
                }
                if (!this._back && !this._ok) break;
                this._menuState = 0;
                this._curs = 0;
                break;
            }
            case 2: {
                this._mu0.print(graphics, (int)BACK_X[this._lang], 118, 6);
                int n = 0;
                while (n < 7) {
                    this._mu0.print(graphics, 10, 20 + 13 * n, 29 + n, 16 + 4);
                    this.Draw_Time(graphics, this._highScores[n], 75, 21 + 13 * n);
                    n = (byte)(n + 1);
                }
                if (!this._ok && !this._back) break;
                this._menuState = 0;
                this._curs = 0;
                break;
            }
            case 3: {
                this._mu0.print(graphics, (int)BACK_X[this._lang], 118, 6);
                this._mu0.print(graphics, 5, 5, 3, 2);
                if (this._keyMap[2] > 0 || this._keyMap[8] > 0 || this._keyMap[3] > 0 || this._keyMap[14] > 0) {
                    this.Reset_Direction_Keys();
                    this._curs = (byte)(1 - this._curs);
                }
                graphics.setClip(0, 0, 128, 128);
                graphics.setColor(-9176164);
                graphics.fillRect(20, 50 + 30 * this._curs, 80, 13);
                graphics.setColor(-16777216);
                graphics.fillRect(21, 51 + 30 * this._curs, 78, 11);
                this._mu0.print(graphics, 22, 52, 7);
                this._mu0.print(graphics, 22, 65, 9 + this._isMusic);
                this._mu0.print(graphics, 22, 82, 11);
                this._img[10].draw(graphics, 20, 5, 16 + 4);
                this._img[24].drawFrame(graphics, 20, 5, this._cptMain % 12 / 2, 16 + 4);
                if (this._ok) {
                    if (this._curs == 0) {
                        if (this._isMusic == 0) {
                            this._isMusic = 1;
                            this._snd.Stop_Music();
                            break;
                        }
                        this._isMusic = 0;
                        this._curMusic = 0;
                        break;
                    }
                    this._img[6] = new Image2("/gfx/flags.png", 2, 6);
                    this._menuState = 5;
                    break;
                }
                if (!this._back) break;
                this._menuState = 0;
                this._curs = 0;
                break;
            }
            case 4: {
                this._img[10].draw(graphics, 32, 5, 16 + 4);
                this._img[24].drawFrame(graphics, 32, 5, this._cptMain % 12 / 2, 16 + 4);
                this._mu0.print(graphics, (int)BACK_X[this._lang], 118, 6);
                int n = 0;
                while (n < 3) {
                    this._mu0.print(graphics, 20, 40 + 26 * n, 12 + n * 2);
                    this._mu0.print(graphics, 20, 52 + 26 * n, 13 + n * 2);
                    n = (byte)(n + 1);
                }
                if (!this._ok && !this._back) break;
                this._menuState = 0;
                this._curs = 0;
                break;
            }
            case 5: {
                if (this._keyMap[2] > 0 || this._keyMap[8] > 0) {
                    this._lang = (byte)(this._lang - 1);
                    if (this._lang < 0) {
                        this._lang = (byte)5;
                    }
                } else if (this._keyMap[3] > 0 || this._keyMap[14] > 0) {
                    this._lang = (byte)(this._lang + 1);
                    if (this._lang > 5) {
                        this._lang = 0;
                    }
                }
                this.Reset_Direction_Keys();
                byte by = 0;
                while (by < 6) {
                    if (this._lang == by) {
                        this._img[6].drawFrame(graphics, 64, 15 + by * 18, by * 2, 2);
                    } else {
                        this._img[6].drawFrame(graphics, 64, 15 + by * 18, 1 + by * 2, 2);
                    }
                    by = (byte)(by + 1);
                }
                if (!this._ok && !this._back) break;
                if (this._mu0 != null) {
                    this._mu0 = null;
                    this._menuState = 3;
                } else {
                    this._menuState = 0;
                }
                this._mu0 = new MultiOutPut(128, 128, 1, -2, this._lang);
                this._img[6] = null;
            }
        }
    }

    void Update_Option() {
        int n;
        if (this._cptOption >= 150) {
            this._option = true;
            this._optionY = 0;
            this._cptOption = 0;
            this._optionPos = 2;
            n = this.Abs(this._rand.nextInt() % 10);
            if (this._mode == 0) {
                this._optionType = n < 7 ? (byte)2 : (byte)1;
            } else if (this._mode == 1) {
                this._optionType = n < 2 && this._nbMis < this._data[1] ? (byte)1 : (n < 6 && this._data[0] > 0 ? (byte)2 : (byte)0);
            }
        }
        if (this._option) {
            n = (30 + this._optionY * 2) * this._optionPos / 4;
            this._optionX = 49 - this._optionY - this._roadX * this._optionY / 6 + this._decalX[this._optionY] + n;
            int n2 = 0;
            if (this._speed >= 550) {
                n2 = 8;
            } else if (this._speed >= 450) {
                n2 = 6;
            } else if (this._speed >= 300) {
                n2 = 4;
            } else if (this._speed >= 100) {
                n2 = 2;
            } else if (this._speed > 0) {
                n2 = 1;
            }
            this._optionY = this._optionY < 45 ? (this._optionY += n2) : (this._optionY += n2 * 2);
            if (this._optionY + 76 > 148) {
                this._option = false;
            }
            this._optionZoom = this._optionY / 16;
            if (this._optionZoom > 4) {
                this._optionZoom = 4;
            }
        } else if (this._optionCatched) {
            this._optionY -= 15;
            if (this._optionY + 76 < 0) {
                this._optionCatched = false;
            }
        }
    }

    void Update_Player() {
        if (this._keyMap[3] > 0 || this._keyMap[14] > 0) {
            this._speed -= 50;
        } else if (this._speed < this._speedMax) {
            this._speed += this._acc;
        } else if (this._speed > this._speedMax) {
            this._speed -= 10;
        }
        if (!this._leftCol && !this._rightCol) {
            if (this._keyMap[4] > 0 || this._keyMap[10] > 0) {
                --this._speedX;
                if (this._speedX < -this.SPEEDX_MAX) {
                    this._speedX = -this.SPEEDX_MAX;
                }
                if (this._inBend && this._bendX < 0) {
                    ++this._bendReduction;
                    this._scroll -= this._speedX;
                }
            } else if (this._keyMap[5] > 0 || this._keyMap[12] > 0) {
                ++this._speedX;
                if (this._speedX > this.SPEEDX_MAX) {
                    this._speedX = this.SPEEDX_MAX;
                }
                if (this._inBend && this._bendX > 0) {
                    ++this._bendReduction;
                    this._scroll -= this._speedX;
                }
            } else {
                this._speedX = this._speedX > 1 ? (this._speedX -= 2) : (this._speedX < -1 ? (this._speedX += 2) : 0);
                if (this._bendReduction > 0 && this._bendReduction < 4) {
                    ++this._bendReduction;
                    this._scroll -= this._speedX;
                }
            }
            if (this._bendReduction == 4) {
                this._bendReduction = 0;
                this._bendX = this._bendX > 0 ? --this._bendX : ++this._bendX;
                if (this._bendX == 0) {
                    this._bend = false;
                    this._inBend = false;
                    this._speedX = 0;
                    this.Reset_Direction_Keys();
                }
            }
            if (!this._inBend) {
                this._X += this._speedX / 2;
                if (this._X < 10) {
                    this._X = 10;
                } else if (this._X > 115) {
                    this._X = 115;
                }
                this._roadX += this._speedX / 2;
                if (this._roadX < -5) {
                    this._roadX = -5;
                } else if (this._roadX > 5) {
                    this._roadX = 5;
                }
            }
            this._frame = 3 + this._speedX / 3;
            if (this._X - 10 < this._xLeft) {
                this._leftCol = true;
            } else if (this._X + 10 > this._xRight) {
                this._rightCol = true;
            }
            byte by = 0;
            while (by < this._nbOpponent) {
                if (this._opp[by]._onScreen && !this._opp[by]._boom && this._cptCol == 0) {
                    Opponent cfr_ignored_0 = this._opp[by];
                    if (this._opp[by]._zoom == 4) {
                        if (this._opp[by]._posX - 10 >= this._X && this._opp[by]._posX - 10 <= this._X + 10) {
                            this._opp[by]._decalX = 20;
                            this._speedX = -4;
                            this._cptCol = 1;
                        } else if (this._opp[by]._posX + 10 <= this._X && this._opp[by]._posX + 10 >= this._X - 10) {
                            this._opp[by]._decalX = -20;
                            this._speedX = 4;
                            this._cptCol = 1;
                        }
                    } else {
                        Opponent cfr_ignored_1 = this._opp[by];
                        if (this._opp[by]._zoom == 4 - 1 && (this._opp[by]._posX - 10 >= this._X - 10 && this._opp[by]._posX - 10 <= this._X + 10 || this._opp[by]._posX + 10 >= this._X - 10 && this._opp[by]._posX + 10 <= this._X + 10)) {
                            this._speed -= 200;
                        }
                    }
                }
                by = (byte)(by + 1);
            }
            if (this._option && this._optionY + 76 < this._Y && this._optionY + 76 > this._Y - 20 && this._optionX > this._X - 10 && this._optionX < this._X + 10) {
                this._option = false;
                this._optionCatched = true;
                if (this._optionType == 0) {
                    this._moneyRab += 100;
                } else if (this._optionType == 2) {
                    this._turboSize = (byte)(this._turboSize + 5);
                } else if (this._optionType == 1) {
                    this._nbMis = (byte)(this._nbMis + 1);
                }
            }
        } else if (this._leftCol) {
            this._leftCol = false;
            this._X = this._xLeft + 10;
            this._speedX = 1 + this._speedX / 2;
            this._speed -= 100;
        } else if (this._rightCol) {
            this._rightCol = false;
            this._X = this._xRight - 10;
            this._speedX = -1 - this._speedX / 2;
            this._speed -= 100;
        }
        if (this._speed < 0) {
            this._speed = 0;
        }
        if (this._cptCol > 0) {
            ++this._cptCol;
            if (this._cptCol > 5) {
                this._cptCol = 0;
            }
        }
        if (this._bend && !this._inBend) {
            if (this._bendY >= this._Y - 25 - 76) {
                this._inBend = true;
                this._bendReduction = 0;
            }
        } else if (this._inBend && (this._bendX < 0 && this._rightCol || this._bendX > 0 && this._leftCol)) {
            this._explosion = true;
            this._cptExplosion = 0;
            this._speed = 0;
            this._turbo = false;
        }
    }

    void Update_Road() {
        if (!this._bend && !this._finishLine) {
            this._cptRoad += this._speed / 25;
            if (this._cptRoad > _road[this._level][this._cptRace * 2] * 300) {
                this._cptRoad = 0;
                if (_road[this._level][this._cptRace * 2 + 1] != 0) {
                    this._bend = true;
                    this._bendX = _road[this._level][this._cptRace * 2 + 1];
                    this._bendY = 5;
                    ++this._cptRace;
                } else if (this._mode == 1 && this._level == 6) {
                    this._cptRace = 0;
                } else {
                    this._finishLine = true;
                    this._finishY = 2;
                }
            }
        } else if (this._finishLine && this._finishY + 76 > 123) {
            this._finishLine = false;
            this._lap = (byte)(this._lap + 1);
            this._cptRace = 0;
            if (this._lap > this._nbLap) {
                this._lap = this._nbLap;
                this._gameState = 4;
                this._cptEnd = 0;
                this._enterScore = false;
                this._keyMap[11] = -1;
            }
        }
        if (this._speed <= 50) {
            if (this._cptMain % 2 == 0) {
                ++this._cptStripe;
                ++this._cptOption;
            }
            if (this._bend && this._cptMain % 4 == 0) {
                ++this._bendY;
            }
            if (this._inBend && this._cptMain % 2 == 0) {
                ++this._bendY;
            }
        } else if (this._speed <= 250) {
            ++this._cptStripe;
            ++this._cptOption;
            if (this._bend) {
                ++this._bendY;
            }
            if (this._inBend) {
                this._bendY += 2;
            }
        } else if (this._speed <= 450) {
            ++this._cptStripe;
            ++this._cptOption;
            if (this._bend) {
                this._bendY += 2;
            }
            if (this._inBend) {
                this._bendY += 3;
            }
        } else if (this._speed <= 520) {
            this._cptStripe += 2;
            this._cptOption += 2;
            if (this._bend) {
                this._bendY += 3;
            }
            if (this._inBend) {
                this._bendY += 4;
            }
        } else {
            this._cptStripe += 3;
            this._cptOption += 3;
            if (this._bend) {
                this._bendY += 4;
            }
            if (this._inBend) {
                this._bendY += 5;
            }
        }
        this._cptStripe %= 5;
    }

    void Vibrate(int n, int n2) {
    }

    protected void hideNotify() {
        this.Save_Records();
        this.GameExit();
        System.gc();
        this.midlet.destroyApp(false);
    }

    protected void keyPressed(int n) {
        if (this._mainState != 4 && this._mainState != 5) {
            return;
        }
        switch (n) {
            case -1: {
                this._keyMap[0] = 1;
                break;
            }
            case -4: {
                this._keyMap[1] = 1;
                break;
            }
            case -26: {
                this._keyMap[18] = 1;
                break;
            }
            case -59: {
                this._keyMap[2] = 1;
                break;
            }
            case -60: {
                this._keyMap[3] = 1;
                break;
            }
            case -61: {
                this._keyMap[4] = 1;
                break;
            }
            case -62: {
                this._keyMap[5] = 1;
                break;
            }
            case 48: {
                this._keyMap[6] = 1;
                break;
            }
            case 49: {
                this._keyMap[7] = 1;
                break;
            }
            case 50: {
                this._keyMap[8] = 1;
                break;
            }
            case 51: {
                this._keyMap[9] = 1;
                break;
            }
            case 52: {
                this._keyMap[10] = 1;
                break;
            }
            case 53: {
                this._keyMap[11] = 1;
                break;
            }
            case 54: {
                this._keyMap[12] = 1;
                break;
            }
            case 55: {
                this._keyMap[13] = 1;
                break;
            }
            case 56: {
                this._keyMap[14] = 1;
                break;
            }
            case 57: {
                this._keyMap[15] = 1;
                break;
            }
            case 42: {
                this._keyMap[16] = 1;
                break;
            }
            case 35: {
                this._keyMap[17] = 1;
            }
        }
    }

    protected void keyReleased(int n) {
        if (this._mainState != 4 && this._mainState != 5) {
            return;
        }
        switch (n) {
            case -1: {
                this._keyMap[0] = -1;
                break;
            }
            case -4: {
                this._keyMap[1] = -1;
                break;
            }
            case -26: {
                this._keyMap[18] = -1;
                break;
            }
            case -59: {
                this._keyMap[2] = -1;
                break;
            }
            case -60: {
                this._keyMap[3] = -1;
                break;
            }
            case -61: {
                this._keyMap[4] = -1;
                break;
            }
            case -62: {
                this._keyMap[5] = -1;
                break;
            }
            case 48: {
                this._keyMap[6] = -1;
                break;
            }
            case 49: {
                this._keyMap[7] = -1;
                break;
            }
            case 50: {
                this._keyMap[8] = -1;
                break;
            }
            case 51: {
                this._keyMap[9] = -1;
                break;
            }
            case 52: {
                this._keyMap[10] = -1;
                break;
            }
            case 53: {
                this._keyMap[11] = -1;
                break;
            }
            case 54: {
                this._keyMap[12] = -1;
                break;
            }
            case 55: {
                this._keyMap[13] = -1;
                break;
            }
            case 56: {
                this._keyMap[14] = -1;
                break;
            }
            case 57: {
                this._keyMap[15] = -1;
                break;
            }
            case 42: {
                this._keyMap[16] = -1;
                break;
            }
            case 35: {
                this._keyMap[17] = -1;
            }
        }
    }

    void keyUpdate() {
        int n = 0;
        n = 0;
        while (n < 19) {
            if (this._keyMap[n] > 0 && this._keyMap[n] < 21) {
                int n2 = n;
                this._keyMap[n2] = (byte)(this._keyMap[n2] + 1);
            } else if (this._keyMap[n] == -1) {
                this._keyMap[n] = -2;
            } else if (this._keyMap[n] == -2) {
                this._keyMap[n] = 0;
            }
            n = (byte)(n + 1);
        }
    }

    public void paint(Graphics graphics) {
        if (this._paint) {
            return;
        }
        this._paint = true;
        this._curMusic = (byte)-1;
        graphics.setClip(0, 128, 128, 2);
        graphics.setColor(0, 0, 0);
        graphics.fillRect(0, 128, 128, 2);
        graphics.setClip(128, 0, 2, 128);
        graphics.fillRect(128, 0, 2, 128);
        graphics.setClip(0, 0, 128, 128);
        switch (this._mainState) {
            case 0: {
                graphics.setClip(0, 0, 128, 128);
                graphics.setColor(-1);
                graphics.fillRect(0, 0, 128, 128);
                if (this._media == null) {
                    this._media = new Image2("/gfx/mediaplazza.png", 1, 1);
                }
                if (System.currentTimeMillis() - this._begin < 2000L) {
                    this._media.draw(graphics, 64, 64, 1 + 2);
                    break;
                }
                this._mainState = 1;
                this._cptLoad = 0;
                break;
            }
            case 1: {
                if (this._cptLoad == 0) {
                    this._cptLoad = 1;
                    this._media = null;
                    this._img[0] = new Image2("/gfx/introscreen.png", 1, 1);
                    System.gc();
                } else {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.Load_Menu();
                    this._snd = new Sound(this);
                    this._snd.Load("/level/titre.mid", true, true, 0);
                    this._snd.Load("/level/course.mid", true, true, 1);
                    this._snd.Load("/level/victoire.mid", true, false, 2);
                    this._img[39] = new Image2("/gfx/numbers_race.png", 13, 1);
                    this._mainState = 4;
                    if (this._lang == -1) {
                        this._img[6] = new Image2("/gfx/flags.png", 2, 6);
                        this._lang = 0;
                        this._menuState = 5;
                    } else {
                        this._mu0 = new MultiOutPut(128, 128, 1, -2, this._lang);
                        this._menuState = 0;
                    }
                    this._curMusic = 0;
                    System.gc();
                }
                this._img[0].draw(graphics, 0, 0, 16 + 4);
                break;
            }
            case 2: {
                if (this._cptLoad == 0) {
                    this._img[0] = null;
                    this._snd.Stop_Music();
                    System.gc();
                    this._cptLoad = 1;
                } else {
                    this._img[1] = null;
                    this._img[8] = null;
                    this._img[9] = null;
                    this._img[4] = null;
                    this._img[5] = null;
                    this._img[7] = null;
                    this._img[2] = null;
                    this._img[24] = null;
                    this._img[10] = null;
                    System.gc();
                    this._img[11] = this._kart == 0 ? new Image2("/gfx/hovercraft_1_set.png", 7, 1) : new Image2("/gfx/hovercraft_2_set.png", 7, 1);
                    this._img[12] = new Image2("/gfx/enemi_01_set.png", 3, 5);
                    this._img[13] = new Image2("/gfx/enemi_02_set.png", 3, 5);
                    this._img[14] = new Image2("/gfx/enemi_03_set.png", 3, 5);
                    this._img[15] = new Image2("/gfx/explosion_kart.png", 4, 5);
                    this._img[16] = new Image2("/gfx/depart.png", 3, 1);
                    this._img[23] = new Image2("/gfx/ombre.png", 1, 1);
                    this._img[25] = new Image2("/gfx/smoke_turbo.png", 1, 3);
                    this._img[38] = new Image2("/gfx/arrow_road.png", 2, 2);
                    this._img[40] = new Image2("/gfx/lap_ico.png", 1, 1);
                    this._img[41] = new Image2("/gfx/missile_ico.png", 1, 1);
                    this._img[42] = new Image2("/gfx/missile_set.png", 1, 5);
                    this._img[45] = new Image2("/gfx/option_turbo.png", 1, 5);
                    this._img[44] = new Image2("/gfx/option_missile.png", 1, 5);
                    this._img[43] = new Image2("/gfx/option_argent.png", 1, 5);
                    this.Load_Level();
                    this._mainState = 5;
                    this._gameState = 0;
                    this._instructions1 = false;
                    this._instructions2 = false;
                    int n = 0;
                    while (n < 7) {
                        if (this._locked[n] == 1 && this._mode == 0) {
                            this._instructions1 = true;
                        }
                        n = (byte)(n + 1);
                    }
                    if (this._firstHelp <= 4) {
                        this._instructions2 = true;
                    }
                    System.gc();
                }
                graphics.setClip(0, 0, 128, 128);
                graphics.setColor(-11289468);
                graphics.fillRect(0, 0, 128, 128);
                graphics.setColor(-12883335);
                graphics.fillRect(10, 10, 108, 108);
                this._mu0.print(graphics, 5, 60, 24, 2);
                break;
            }
            case 3: {
                if (this._cptLoad == 0) {
                    ++this._cptLoad;
                    this._snd.Stop_Music();
                    System.gc();
                } else {
                    this._img[12] = null;
                    this._img[13] = null;
                    this._img[14] = null;
                    this._img[15] = null;
                    this._img[16] = null;
                    this._img[41] = null;
                    this._img[23] = null;
                    this._img[17] = null;
                    this._img[18] = null;
                    this._img[40] = null;
                    this._img[20] = null;
                    this._img[21] = null;
                    this._img[25] = null;
                    this._img[38] = null;
                    this.Load_Menu();
                    this._curMusic = 0;
                    this._mainState = 4;
                    if (this._continue) {
                        if (this._mode == 1) {
                            this._data[2] = this._data[2] + this._moneyRab;
                            if (this._position > 1) {
                                this._curs = this._level;
                                this._menuState = 7;
                                this._cptName = 0;
                                this._planetX = 0;
                                this._plus = true;
                            } else {
                                this._data[3] = this._level + 1;
                                this._data[2] = this._data[2] + _reward[this._level];
                                if (this._level < 6) {
                                    this._locked[this._level + 1] = 0;
                                }
                                if (this._level == 0 || this._level == 5 || this._level == 6) {
                                    this._menuState = 10;
                                } else {
                                    this._curs = (byte)(this._level + 1);
                                    this._menuState = 7;
                                    this._planetX = 0;
                                    this._plus = true;
                                    this._cptName = 0;
                                }
                            }
                        } else {
                            this._curs = this._position == 1 && this._level < 6 && this._locked[this._level + 1] == 0 ? (byte)(this._level + 1) : this._level;
                            this._menuState = 7;
                            this._planetX = 0;
                            this._plus = true;
                            this._cptName = 0;
                        }
                    } else {
                        this._menuState = 0;
                        this._curs = 0;
                    }
                }
                graphics.setClip(0, 0, 128, 128);
                graphics.setColor(-11289468);
                graphics.fillRect(0, 0, 128, 128);
                graphics.setColor(-12883335);
                graphics.fillRect(10, 10, 108, 108);
                this._mu0.print(graphics, 5, 60, 24, 2);
                break;
            }
            case 4: {
                this.Update_Menu(graphics);
                break;
            }
            case 5: {
                this.Update_Game(graphics);
            }
        }
        if (this._curMusic != -1) {
            this._snd.Start_Music(this._curMusic);
        }
        if (this._mu0 != null) {
            ++this._cptFps;
            if (this._showFPS) {
                graphics.setColor(-16777216);
                this._mu0.printValue(graphics, 1, 100, this._fps, 16 + 4);
            }
            if (System.currentTimeMillis() - this._t >= 1000L) {
                this._fps = this._cptFps;
                this._cptFps = 0;
                this._t = System.currentTimeMillis();
            }
        }
        if (System.currentTimeMillis() - this.last_paint < 50L) {
            try {
                Thread.sleep(50L - (System.currentTimeMillis() - this.last_paint));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this._paint = false;
    }

    public void run() {
        while (this._mainState != 6) {
            this.last_paint = System.currentTimeMillis();
            this.repaint();
            this.serviceRepaints();
            ++this._cptMain;
        }
        this.Save_Records();
        this.GameExit();
        System.gc();
        this.midlet.destroyApp(false);
    }
}

