/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.GameScreen;

public class Opponent {
    static final byte AGRESSIVE = 2;
    static final byte FINAL = 3;
    static final byte NICE = 0;
    static final byte NORMAL = 1;
    static final byte ZOOM_MAX = 6;
    int _acc;
    static final int[] _accel;
    byte _anim;
    boolean _boom;
    byte _cptBoom;
    byte _cptRepair;
    int _decalX;
    static final int[] _delay;
    GameScreen _gs;
    byte _num;
    boolean _onScreen;
    int _pos;
    int _posX;
    int _posY;
    boolean _repair;
    int _speed;
    static final int[] _speedM;
    int _speedMax;
    int _speedX;
    byte _sprite;
    byte _zoom;

    static {
        _delay = new int[]{500, 350, 450, 450, 600, 600, 400};
        _speedM = new int[]{460, 460, 460, 460, 460, 500, 500};
        _accel = new int[]{10, 10, 20, 20, 30, 30, 40};
    }

    public Opponent(GameScreen gameScreen, byte by) {
        this._gs = gameScreen;
        this._num = by;
        this._sprite = (byte)(by % 3);
    }

    void Init() {
        if (this._gs._mode == 0) {
            this._posY = -10 - this._num * _delay[this._gs._level];
            this._speedMax = 460;
            this._acc = 20;
        } else {
            this._speedMax = _speedM[this._gs._level];
            this._acc = _accel[this._gs._level];
            switch (this._gs._level) {
                case 0: {
                    this._posY = -10 - this._num * 300;
                    break;
                }
                case 1: {
                    this._posY = -100 - this._num * 600;
                    break;
                }
                case 2: {
                    this._posY = -10 - this._num * 400;
                    break;
                }
                case 3: {
                    this._posY = -10 - this._num * 300;
                    break;
                }
                case 4: {
                    this._posY = -120 - this._num * 800;
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    this._posY = -150;
                }
            }
        }
        this._pos = this._gs.Abs(this._gs._rand.nextInt() % 3) + 1;
        this._decalX = 0;
        this._speed = 0;
        this._speedX = 0;
        this._zoom = 0;
        this._boom = false;
        this._cptBoom = 0;
        this._repair = false;
        this._cptRepair = 0;
    }

    void Update() {
        int n = this._gs._speed - this._speed;
        if (this._speed < this._speedMax) {
            this._speed += this._acc;
        } else if (this._speed > this._speedMax) {
            this._speed = this._speedMax;
        }
        this._onScreen = true;
        if (this._posY <= 5) {
            this._onScreen = false;
        } else if (this._posY > 130) {
            this._onScreen = false;
        }
        if (!this._boom && !this._repair) {
            this._posY += n / 40;
            if (this._posY > 0) {
                if (this._posY < 370 - 200) {
                    if (this._decalX < 0) {
                        ++this._decalX;
                    } else if (this._decalX > 0) {
                        --this._decalX;
                    }
                    int n2 = (60 + this._posY * 2) * this._pos / 4;
                    this._posX = 90 - this._posY + this._decalX - this._gs._roadX * this._posY / 6 + this._gs._decalX[this._posY] + n2;
                }
            }
            switch (this._gs._difficulty) {
                case 0: {
                    break;
                }
                case 1: {
                    if (this._posY > 85 && this._posY < 130) {
                        this._speedMax = 500;
                        break;
                    }
                    this._speedMax = _speedM[this._gs._level];
                    break;
                }
                case 2: {
                    if (this._posY > 130 || this._posY < 95) {
                        this._speedMax = _speedM[this._gs._level];
                        break;
                    }
                    this._speedMax = 540;
                    break;
                }
                case 3: {
                    if (this._posY > 65 && this._gs._escape == 0) {
                        this._gs._escape = 1;
                        this._gs._cptEscape = 1;
                    } else if (this._posY > 65 && this._gs._escape == 2) {
                        this._gs._escape = (byte)3;
                        this._gs._cptEscape = 1;
                    }
                    if (this._gs._cptEscape > 0) {
                        ++this._gs._cptEscape;
                        if (this._gs._cptEscape > 100) {
                            this._gs._cptEscape = 0;
                            this._gs._escape = (byte)(this._gs._escape + 1);
                        }
                        this._speedMax = 680;
                        break;
                    }
                    this._speedMax = this._gs._escape == 0 ? 560 : 520;
                }
            }
            this._anim = this._speedX < 0 ? (byte)0 : (this._speedX > 0 ? (byte)2 : (byte)1);
        } else if (this._boom) {
            this._speed = 0;
            if (this._gs._speed > 350) {
                this._posY += 6;
            } else if (this._gs._speed > 200) {
                this._posY += 4;
            } else if (this._gs._speed > 100) {
                this._posY += 2;
            }
            if (this._gs._cptMain % 2 == 0) {
                this._cptBoom = (byte)(this._cptBoom + 1);
            }
            if (this._cptBoom > 5) {
                this._onScreen = false;
                this._boom = false;
                this._repair = true;
                this._cptRepair = 0;
            }
        } else if (this._repair) {
            if (this._gs._speed > 350) {
                this._posY += 6;
            } else if (this._gs._speed > 200) {
                this._posY += 4;
            } else if (this._gs._speed > 100) {
                this._posY += 2;
            }
            this._cptRepair = (byte)(this._cptRepair + 1);
            if (this._cptRepair > 50) {
                this._repair = false;
            }
        }
        this._zoom = (byte)(this._posY / 13);
        if (this._zoom < 0) {
            this._zoom = 0;
        }
        if (this._zoom > 6) {
            this._zoom = (byte)6;
        }
        this._speedX = 0;
        if ((this._gs._bend || this._gs._inBend) && this._gs._bendY >= this._posY - 20 && this._gs._bendY <= this._posY + 10) {
            if (this._gs._bendX < 0) {
                this._speedX = -1;
            } else if (this._gs._bendX > 0) {
                this._speedX = 1;
            }
        }
        if (this._posY > this._gs._Y + this._gs._vY) {
            this._gs._z = true;
        }
    }
}

