/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class CBack
implements CDef {
    private boolean CAMERA_IS_DOWN = false;
    private boolean TRICK_AT_START_DONE = false;
    public static final int ROAD_LINE_THICKNESS = 4;
    public static final int MAX_PRIMITIVES_COUNT = 200;
    public static final int ROAD_HALF_WIDTH = 830;
    public static final int orig_x = 66;
    public static final int orig_y = 88;
    public static final int ASPECT_X = 40960;
    public static final int ASPECT_Y = 15360;
    public static int CAMERA_ELEVATION = 600;
    public static final int ROAD_POINTS = 16;
    public static final int ROAD_DRAW_START_POINT_IDX = 1;
    public static final int ROAD_DRAW_END_POINT_IDX = 15;
    public static final int ROAD_STEP_SIZE = 512;
    public static final int CAR_SCREEN_POS_Y = 153;
    private static final int BIKE_HEIGHT = 62;
    public static final int BIKE_LENGTH = 40;
    public static final int CAR_MAX_FRONT_SPEED = 200;
    public static final int CAR_MAX_LATERAL_SPEED = 255;
    public static final int CAR_MAX_STEER_ANGLE = 768;
    public static final int CAR_MAX_STEER_SPEED = 40;
    public static final int CAR_MAX_ANGLE = 6400;
    public static final int CAR_F_LATERAL_ACCEL = 8;
    public static final int CAR_F_FRONT_ACCEL = 8;
    public static final int CAR_F_BRAKE = 10;
    public static final int CAR_GRAVITY = 1;
    public static final int CAR_F_DEFAULT_STEER = 128;
    public static final int CAR_F_USER_STEER_MULTIPLIER = 128;
    public static final int TAP_TIMER_VALUE = 8;
    public int fAcceleration = 125;
    public int tires = 0;
    public int fSuspension = 125;
    public int fBrakes = 125;
    int fTopSpeed = 255;
    int fSteering = 255;
    int camera_elevation_plus = 600;
    int aspect_y_elevation_plus = 12800;
    int car_road_x = 0;
    int f_car_road_angle = 0;
    int f_car_steer_speed = 0;
    int f_car_y = 0;
    int f_car_vz = 0;
    int f_car_vx = 0;
    int f_car_vy = 0;
    int f_car_angle = 0;
    int effective_speed = 0;
    int f_cardir_x;
    int f_cardir_z;
    int f_carright_x;
    int f_carright_z;
    int f_car_road_height = 0;
    public int car_segm;
    public int car_z;
    public static final int NUM_GEARS = 6;
    short[] car_gearLimits = new short[]{50, 4, 100, 4, 160, 3, 190, 2, 220, 1, 256, 1};
    short[] car_gearDrawLimits = new short[]{0, 64, 32, 100, 84, 160, 100, 200, 140, 230, 170, 255};
    short car_gear = 0;
    public int fRev;
    int[] revs = new int[]{125, 145, 180, 205, 230, 255};
    long revStart = -1L;
    long revTime;
    boolean end_time_not_set;
    long finish_time;
    CSpriteManager carSprMan = null;
    CActor carActor = new CActor();
    CActor pilotAuxActor = new CActor();
    public long last_animation_time = 0L;
    public int last_animation = -1;
    int currentHandFrame = 0;
    CSpriteManager semSprMan = null;
    CActor semActor = new CActor();
    public static boolean useParticles = false;
    CSpriteManager partSprMan = null;
    CActor partActor = new CActor();
    public int position = 0;
    public int lastPos = -1;
    public long time = 0L;
    public long camera_goes_down_time = 0L;
    public long semaphore_time = 0L;
    public static long crash_time = 0L;
    public long trick_time = 0L;
    public long trick_time_up = 0L;
    public long trick_time_down = 0L;
    public long end_trick_time = 0L;
    public long last_time_down = 0L;
    int nr_paints_skipped = 0;
    private static final long TIMP_COBORARE_FRAMEURI = 50L;
    private static final long TIMP_URCARE_FRAMEURI = 300L;
    public boolean endTrickSet = false;
    public boolean DONE_THIS = false;
    boolean on_the_road = false;
    boolean bTrick = false;
    boolean bShakeIt = false;
    boolean urcare = false;
    boolean coborare = false;
    static boolean game_crashed = false;
    static boolean after_crash = false;
    static int show_player = 0;
    public boolean animationSet = false;
    public boolean directionSet = false;
    int directionCrash = 1;
    static int coollisionType;
    public static int dy_crash;
    public static int dx_crash;
    public int numOpps = 22;
    public static boolean hasOpponents;
    public CEnemy[] enemy;
    CSpriteManager oppSprite;
    CActor oppActor = new CActor();
    int[] positions = new int[this.numOpps];
    int[] positions2 = new int[this.numOpps];
    public static final int PRE_START = -1;
    public static final int START = 0;
    public static final int STARTED = 1;
    public static final int FINISHED = 2;
    public static final int POST_FINISHED = 3;
    static int raceStatus;
    int curveCursor = 0;
    int heightCursor = 0;
    int[] roadObjects = null;
    int[] backObjects = null;
    int[][] backPrimitives = new int[16][2];
    int[][] primitives = new int[16][200];
    int nearestObjectCursor;
    int circuitLength = 0;
    int[] roadAngleHW = null;
    long frameCount = 0L;
    int roadCursor = 0;
    int[] roadHeight = null;
    int[] roadCollision = null;
    int[][] objects_vb = null;
    int[] back_vb = null;
    int[] road_signe = null;
    public static final int ROAD_SPRITE_NEAR_WIDTH = 200;
    public static final int ROAD_TEX_NEAR_WIDTH = 500;
    public static final int ROAD_TEX_FAR_WIDTH = 48;
    public static final int ROAD_TEX_LEVELS = 64;
    public static final int SPRITES_FRAMES_COUNT = 7;
    public static final int SPRITES_FAR_SCALE = 54;
    public static final int[] SCALING_FACTORS;
    Image[][] spriteImgs = null;
    int[][] spriteImgSize = null;
    public int[][] roadColors = null;
    public short[] roadImgs_hw = null;
    public static final int ROAD_TEX_DEPTH_STEP = 64;
    public static int SKY_COLOR;
    public static int BG_COLOR_NEAR;
    public static int BG_COLOR_FAR;
    public static int FOG_COLOR;
    public static int ROAD_COLOR_NEAR;
    public static int ROAD_COLOR_FAR;
    public static int BG_COLOR_NEAR_R;
    public static int BG_COLOR_NEAR_G;
    public static int BG_COLOR_NEAR_B;
    public static int BG_COLOR_FAR_R;
    public static int BG_COLOR_FAR_G;
    public static int BG_COLOR_FAR_B;
    public static int FOG_COLOR_R;
    public static int FOG_COLOR_G;
    public static int FOG_COLOR_B;
    public static int ROAD_COLOR_NEAR_R;
    public static int ROAD_COLOR_NEAR_G;
    public static int ROAD_COLOR_NEAR_B;
    public static int ROAD_COLOR_FAR_R;
    public static int ROAD_COLOR_FAR_G;
    public static int ROAD_COLOR_FAR_B;
    public Image bg = null;
    public static final int[][] bg_sets;
    int bg_x = 0;
    int bg_y = 0;
    int bg_w = 0;
    int bg_h = 0;
    public static final int BG_SCROLL_SPEED = 10;
    public Image signs;
    public int startingPos = 0;
    public static int maxLaps;
    int laps = 0;
    int f_cam_road_height = 0;
    int f_cam_x = 0;
    int f_cam_y = 30;
    int f_cam_z = 0;
    int f_camdir_z = 0;
    int f_camdir_x = 0;
    int f_camright_z = 0;
    int f_camright_x = 0;
    int f_cam_yaw = 0;
    int f_cam_pitch = 0;
    int cam_dot = 0;
    public int[] f_road_x = new int[16];
    int[] f_road_y = new int[16];
    public int[] f_road_z = new int[16];
    int[] road_angle_hw = new int[16];
    int[] road_draw_x = new int[16];
    int[] road_draw_y = new int[16];
    int[] road_draw_hw = new int[16];
    int cameraSegmentCursor = 0;
    int angScale = 170;
    public static final int tsmin = 200;
    public static final int tsmax = 255;
    public static final int stmin = 256;
    public static final int stmax = 1024;
    public static final int SOFT_TIRES = 0;
    public static final int HARD_TIRES = 1;
    public int transformPipeX;
    public int transformPipeY;
    public int transformPipeZ;
    public static final int EVENT_NONE = 0;
    public static final int EVENT_RACE_STARTED = 1;
    public static final int EVENT_RESIGN = 2;
    public static final int EVENT_RACE_OVER = 3;
    public static final int EVENT_LEAD = 4;
    public static final int EVENT_ACCIDENT = 5;
    public static final int EVENT_LAPTIME = 6;
    public static final int EVENT_RACE_OVER_TRICK = 7;
    int[] accident_idx;
    public static final int QUEUE_SIZE = 20;
    int[] eventQueue = new int[20];
    public static int writeCursor;
    public static int readCursor;
    public static long lastEvent;
    long lastRadio;
    public static int currEvent;
    public int last_opp_resigned;
    boolean radioOn = false;
    public long startTime;
    public long finishTime;
    public static final int CONSUMPTION = 7;
    int acc = 0;
    int speedPenalty = 1;
    int tirePenalty = 1;
    int suspPenalty = 1;
    int sand = 0;
    int segm = 0;
    long lapTime;
    long lapStart;
    long messagelapTime;
    long bestLapTime = 0xFFFFFFL;
    boolean lapTimed = false;
    boolean newLapRecord = false;
    int speedGain = 0;
    int startDrawPt = 0;
    int updateCounter = 0;
    boolean updateRaceFinished = true;
    boolean autoPilot = false;
    boolean firstRace = true;
    int x1;
    int y1;
    int w1;
    int x2;
    int y2;
    int w2;
    int ystep;
    int xstep;
    int wstep;

    void loadSprite(int id, int img_index) {
        try {
            this.loadSprite(id, Image.createImage((byte[])CGlobals.getBuffer(img_index), (int)0, (int)CGlobals.getBuffer(img_index).length));
            CGlobals.closeFile(img_index);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void loadSprite(int id, Image source) {
        try {
            this.spriteImgs[id][6] = source;
            int origw = this.spriteImgs[id][6].getWidth();
            int origh = this.spriteImgs[id][6].getHeight();
            this.spriteImgSize[id][6] = origw / 2 << 8 | origh;
            int[] rgbData = new int[origw * origh];
            this.spriteImgs[id][6].getRGB(rgbData, 0, origw, 0, 0, origw, origh);
            for (int ii = 0; ii < 6; ++ii) {
                int currentW = origw * SCALING_FACTORS[ii] >> 8;
                int currentH = origh * SCALING_FACTORS[ii] >> 8;
                if (currentW == 0) {
                    currentW = 1;
                }
                if (currentH == 0) {
                    currentH = 1;
                }
                this.spriteImgSize[id][ii] = currentW / 2 << 8 | currentH;
                int[] newImgData = new int[currentW * currentH];
                int wstep = (origw << 8) / currentW;
                int hstep = (origh << 8) / currentH;
                int curw = 0;
                int curh = 0;
                for (int kk = 0; kk < currentH; ++kk) {
                    for (int jj = 0; jj < currentW; ++jj) {
                        newImgData[kk * currentW + jj] = rgbData[(curh >> 8) * origw + (curw >> 8)];
                        curw += wstep;
                    }
                    curh += hstep;
                    curw = 0;
                }
                this.spriteImgs[id][ii] = Image.createRGBImage((int[])newImgData, (int)currentW, (int)currentH, (boolean)true);
                if (this.spriteImgs[id][ii] == null) {
                    System.out.println("null la" + ii + "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
                }
                newImgData = null;
                System.gc();
            }
            rgbData = null;
            System.gc();
        }
        catch (Exception e) {
            System.err.println("!!!! ---- error loading sprite images !\n" + e.toString());
        }
    }

    void startGrid() {
        if (hasOpponents) {
            CEnemy.setDifficulty();
            if (CGame.gameType != 0) {
                int xOffset = -160;
                this.numOpps = 22;
                this.enemy = new CEnemy[this.numOpps];
                if (CGame.gameType != 3 && CGame.gameType != 2) {
                    this.startingPos = this.numOpps;
                }
                this.position = this.startingPos + 1;
                int row = this.startingPos / 3;
                if (this.startingPos % 3 == 0) {
                    this.f_cam_x = -300;
                } else if (this.startingPos % 3 == 1) {
                    this.f_cam_x = 0;
                } else if (this.startingPos % 3 == 2) {
                    this.f_cam_x = 300;
                }
                int k = 0;
                for (int i = 0; i < this.numOpps + 1; ++i) {
                    if (i == this.startingPos) {
                        if ((xOffset += 160) <= 160) continue;
                        xOffset = -160;
                        continue;
                    }
                    this.enemy[k] = new CEnemy();
                    int eRow = row - i / 3;
                    int collumn = i % 3;
                    this.enemy[k].sameRowWithMe = eRow == 0;
                    int offset = 585;
                    if (eRow == 0) {
                        this.enemy[k].init(xOffset, eRow * 512 * 2 - offset);
                    } else {
                        this.enemy[k].init(xOffset, eRow * 512 * 2);
                    }
                    if ((xOffset += 160) > 160) {
                        xOffset = -160;
                    }
                    ++k;
                }
            } else {
                this.numOpps = 1;
                this.enemy = new CEnemy[1];
                this.enemy[0] = new CEnemy();
                this.enemy[0].init(0, -1024);
            }
        } else {
            this.numOpps = 0;
            this.enemy = new CEnemy[0];
            this.f_cam_x = 0;
        }
    }

    void loadGameLib() {
        CGlobals.loadLib("/game.lib", false);
        try {
            CGame.imgInterface = Image.createImage((byte[])CGlobals.getBuffer(0), (int)0, (int)CGlobals.getBuffer(0).length);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.loadObjects(1, 2);
        this.semSprMan = new CSpriteManager();
        this.semSprMan.load(3, true, true);
        this.semActor.initActor(0, 66, 88);
        this.partSprMan = new CSpriteManager();
        this.partSprMan.load(5, true, true);
        this.partActor.initActor(6, 66, 153);
        this.carSprMan = new CSpriteManager();
        this.carSprMan.load(9, true, true);
        this.carActor.initActor(2, 66, 153);
        this.pilotAuxActor.initActor(13, 66, 153);
        this.oppSprite = new CSpriteManager();
        this.oppSprite.load(11, true, true);
        this.oppActor.initActor(0, 0, 0);
        this.spriteImgs = new Image[9][7];
        this.spriteImgSize = new int[9][7];
        this.loadSprite(7, 13);
        this.loadSprite(8, 14);
        CGame.pGame.debugString = "loadGame";
        CGlobals.closeAll();
    }

    void initRoadImages() {
        CGlobals.loadLib("/levels.lib", false);
        try {
            this.bg = Image.createImage((byte[])CGlobals.getBuffer(0 + bg_sets[CGame.currentTrack][7]), (int)0, (int)CGlobals.getBuffer(0 + bg_sets[CGame.currentTrack][7]).length);
            CGlobals.closeFile(0 + bg_sets[CGame.currentTrack][7]);
            this.bg_w = this.bg.getWidth();
            this.bg_h = this.bg.getHeight();
            SKY_COLOR = bg_sets[CGame.currentTrack][0];
            BG_COLOR_FAR = bg_sets[CGame.currentTrack][1];
            BG_COLOR_NEAR = bg_sets[CGame.currentTrack][2];
            FOG_COLOR = bg_sets[CGame.currentTrack][3];
            BG_COLOR_NEAR_R = (BG_COLOR_NEAR & 0xFF0000) >> 16;
            BG_COLOR_NEAR_G = (BG_COLOR_NEAR & 0xFF00) >> 8;
            BG_COLOR_NEAR_B = BG_COLOR_NEAR & 0xFF;
            BG_COLOR_FAR_R = (BG_COLOR_FAR & 0xFF0000) >> 16;
            BG_COLOR_FAR_G = (BG_COLOR_FAR & 0xFF00) >> 8;
            BG_COLOR_FAR_B = BG_COLOR_FAR & 0xFF;
            FOG_COLOR_R = (FOG_COLOR & 0xFF0000) >> 16;
            FOG_COLOR_G = (FOG_COLOR & 0xFF00) >> 8;
            FOG_COLOR_B = FOG_COLOR & 0xFF;
            ROAD_COLOR_NEAR_R = (ROAD_COLOR_NEAR & 0xFF0000) >> 16;
            ROAD_COLOR_NEAR_G = (ROAD_COLOR_NEAR & 0xFF00) >> 8;
            ROAD_COLOR_NEAR_B = ROAD_COLOR_NEAR & 0xFF;
            ROAD_COLOR_FAR_R = (ROAD_COLOR_FAR & 0xFF0000) >> 16;
            ROAD_COLOR_FAR_G = (ROAD_COLOR_FAR & 0xFF00) >> 8;
            ROAD_COLOR_FAR_B = ROAD_COLOR_FAR & 0xFF;
        }
        catch (Exception ex) {
            System.err.println("eroare la incarcarea fundalului!\n" + ex.toString());
        }
        this.roadImgs_hw = new short[64];
        this.roadColors = new int[2][64];
        for (int jj = 0; jj < 2; ++jj) {
            int size_step = 1808;
            for (int ii = 0; ii < 64; ++ii) {
                int g;
                int inv_ii = 64 - ii - 1;
                int color = ROAD_COLOR_NEAR;
                int percent = 0;
                if (inv_ii > 48) {
                    color = ROAD_COLOR_FAR;
                    percent = (inv_ii - 48 << 8) / 16;
                }
                this.roadImgs_hw[ii] = (short)((48 + (size_step * ii >> 8)) / 2);
                int r = ROAD_COLOR_NEAR_R - 16 * jj;
                if (r < 0) {
                    r = 0;
                }
                if ((g = ROAD_COLOR_NEAR_G - 16 * jj) < 0) {
                    g = 0;
                }
                int b = ROAD_COLOR_NEAR_B - 16 * jj;
                if (g < 0) {
                    g = 0;
                }
                int cr = (color & 0xFF0000) >> 16;
                int cg = (color & 0xFF00) >> 8;
                int cb = color & 0xFF;
                r = (r * (255 - percent) >> 8) + (cr * percent >> 8);
                g = (g * (255 - percent) >> 8) + (cg * percent >> 8);
                b = (b * (255 - percent) >> 8) + (cb * percent >> 8);
                this.roadColors[jj][ii] = 0xFF000000 | r << 16 | g << 8 | b;
            }
        }
    }

    Image resizeLine(int[] src_lineRGBData, int src_width, int new_width, int color, int colorPercent) {
        int curs = 0;
        int step = (src_width << 8) / new_width;
        int[] dest_imgdata = new int[new_width];
        int lastcurs = 0;
        for (int ii = 0; ii < new_width; ++ii) {
            if ((curs += step) >> 8 >= src_width - 1) {
                curs = src_width - 1 << 8;
            }
            int b = 0;
            int g = 0;
            int r = 0;
            for (int kk = 0; kk <= (curs >> 8) - (lastcurs >> 8); ++kk) {
                r += (src_lineRGBData[(lastcurs >> 8) + kk] & 0xFF0000) >> 16;
                g += (src_lineRGBData[(lastcurs >> 8) + kk] & 0xFF00) >> 8;
                b += src_lineRGBData[(lastcurs >> 8) + kk] & 0xFF;
            }
            r /= (curs >> 8) - (lastcurs >> 8) + 1;
            g /= (curs >> 8) - (lastcurs >> 8) + 1;
            b /= (curs >> 8) - (lastcurs >> 8) + 1;
            int cr = (color & 0xFF0000) >> 16;
            int cg = (color & 0xFF00) >> 8;
            int cb = color & 0xFF;
            r = (r * (255 - colorPercent) >> 8) + (cr * colorPercent >> 8);
            g = (g * (255 - colorPercent) >> 8) + (cg * colorPercent >> 8);
            b = (b * (255 - colorPercent) >> 8) + (cb * colorPercent >> 8);
            dest_imgdata[ii] = 0xFF000000 | r << 16 | g << 8 | b;
            lastcurs = curs;
        }
        Image retimg = null;
        try {
            retimg = Image.createRGBImage((int[])dest_imgdata, (int)new_width, (int)1, (boolean)false);
        }
        catch (Exception ex) {
            CGame.DBG("could not scale image(createRGBImage failed):\n" + ex.toString());
        }
        return retimg;
    }

    void updateRoad() {
        ++this.frameCount;
        int x1 = this.f_road_x[15] - this.f_cam_x;
        int z1 = this.f_road_z[15] - this.f_cam_z;
        this.cam_dot = (x1 * this.f_camdir_x >> 8) + (z1 * this.f_camdir_z >> 8);
        if (this.cam_dot < 0) {
            int backMapIdx;
            int newang = ((this.road_angle_hw[0] & 0xFFFFFF00) >> 8) + (this.roadAngleHW[this.roadCursor % this.circuitLength] >> 8);
            System.arraycopy(this.f_road_x, 0, this.f_road_x, 1, 15);
            System.arraycopy(this.f_road_y, 0, this.f_road_y, 1, 15);
            System.arraycopy(this.f_road_z, 0, this.f_road_z, 1, 15);
            System.arraycopy(this.road_angle_hw, 0, this.road_angle_hw, 1, 15);
            this.f_road_x[0] = this.f_road_x[1] + (this.sin(newang) * 512 >> 8);
            this.f_road_z[0] = this.f_road_z[1] + (this.cos(newang) * 512 >> 8);
            this.f_road_y[0] = this.f_road_y[1] + this.roadHeight[this.heightCursor++];
            this.road_angle_hw[0] = newang << 8 | this.roadAngleHW[this.roadCursor % this.circuitLength] & 0xFF;
            if (this.heightCursor == this.circuitLength) {
                this.heightCursor = 0;
            }
            ++this.roadCursor;
            this.laps = (this.roadCursor - 16) / this.circuitLength;
            if (this.laps >= maxLaps && CGame.gameType != 0 && !this.endTrickSet) {
                raceStatus = 2;
                this.autoPilot = true;
                this.carActor.setAnimation(3);
                this.pilotAuxActor.initActor(15, 66, 153);
                if (!this.endTrickSet) {
                    this.end_trick_time = CGame.frame_time;
                    this.endTrickSet = true;
                }
            } else if (raceStatus == 2 && CGame.frame_time - this.end_trick_time < 1000L && this.bShakeIt) {
                this.pilotAuxActor.setAnimation(15);
            } else if (raceStatus == 2 && this.bShakeIt) {
                this.pilotAuxActor.setAnimation(16);
                this.pilotAuxActor.currentFrame = this.currentHandFrame = (this.currentHandFrame + 1) % 4;
            }
            if (raceStatus == 2 && System.currentTimeMillis() - this.finish_time > 15000L && !this.end_time_not_set) {
                if (this.f_car_vz > 0) {
                    this.f_car_vz -= 20;
                }
                if (this.f_car_vz < 0) {
                    this.f_car_vz = 0;
                }
            }
            if (this.backObjects[backMapIdx = this.cameraSegmentCursor % this.circuitLength] >= 0) {
                int bkobjid = this.backObjects[backMapIdx];
                this.backPrimitives[this.nearestObjectCursor][0] = this.back_vb[bkobjid * 2];
                this.backPrimitives[this.nearestObjectCursor][1] = this.back_vb[bkobjid * 2 + 1];
            } else {
                this.backPrimitives[this.nearestObjectCursor][0] = -1;
            }
            int objMapIdx = this.cameraSegmentCursor % this.circuitLength;
            if (this.roadObjects[objMapIdx] >= 0) {
                int objid = this.roadObjects[objMapIdx];
                if (objid == 0) {
                    // empty if block
                }
                int tmpArraySize = 0;
                this.primitives[this.nearestObjectCursor][tmpArraySize++] = this.objects_vb[objid][0];
                int cursor = 1;
                for (int ii = 0; ii < this.objects_vb[objid][0]; ++ii) {
                    if (this.objects_vb[objid][cursor] == 1) {
                        System.arraycopy(this.objects_vb[objid], tmpArraySize, this.primitives[this.nearestObjectCursor], tmpArraySize, 7);
                        tmpArraySize += 7;
                        cursor += 7;
                        continue;
                    }
                    if (this.objects_vb[objid][cursor] == 0) {
                        System.arraycopy(this.objects_vb[objid], tmpArraySize, this.primitives[this.nearestObjectCursor], tmpArraySize, 11);
                        tmpArraySize += 11;
                        cursor += 11;
                        continue;
                    }
                    if (this.objects_vb[objid][cursor] == 2) {
                        System.arraycopy(this.objects_vb[objid], tmpArraySize, this.primitives[this.nearestObjectCursor], tmpArraySize, 8);
                        tmpArraySize += 8;
                        cursor += 8;
                        continue;
                    }
                    if (this.objects_vb[objid][cursor] != 3) continue;
                    System.arraycopy(this.objects_vb[objid], tmpArraySize, this.primitives[this.nearestObjectCursor], tmpArraySize, 5);
                    tmpArraySize += 5;
                    cursor += 5;
                }
            } else {
                this.primitives[this.nearestObjectCursor][0] = 0;
            }
            --this.nearestObjectCursor;
            if (this.nearestObjectCursor < 0) {
                this.nearestObjectCursor = 15;
            }
            ++this.cameraSegmentCursor;
            this.cam_dot += 512;
        }
        this.f_cam_road_height = this.f_road_y[14] + (this.f_road_y[15] - this.f_road_y[14]) * this.cam_dot / 512;
        this.f_car_road_height = this.f_road_y[13] + (this.f_road_y[14] - this.f_road_y[13]) * this.cam_dot / 512;
        ++this.f_car_vy;
        this.f_car_y += this.f_car_vy;
        if (this.f_car_y > this.f_car_road_height) {
            this.f_car_y = this.f_car_road_height;
            this.f_car_vy = 0;
        }
    }

    int abs(int val) {
        if (val > 0) {
            return val;
        }
        return -val;
    }

    int cos(int angle) {
        int lang = this.abs(angle + 90) % 360;
        if (angle + 90 < 0) {
            return -CDef.f_sin[lang];
        }
        return CDef.f_sin[lang];
    }

    int sin(int angle) {
        int lang = this.abs(angle) % 360;
        if (angle < 0) {
            return -CDef.f_sin[lang];
        }
        return CDef.f_sin[lang];
    }

    void loadObjects(int mainObjects, int backObjects) {
        InputStream is = null;
        try {
            Class<?> c = this.getClass();
            is = CGlobals.getFile(mainObjects);
            CGlobals.closeFile(mainObjects);
            if (is == null) {
                System.err.println("obj file: " + mainObjects);
                throw new Exception("File Does Not Exist");
            }
        }
        catch (Exception ex) {
            System.err.println("CBack::loadObjects\n" + ex.toString());
            return;
        }
        int objCount = CGlobals.readUnsignedByte(is);
        this.objects_vb = new int[objCount][];
        for (int ii = 0; ii < objCount; ++ii) {
            short arrsize = CGlobals.readUnsignedByte(is);
            this.objects_vb[ii] = new int[arrsize];
            int cursor = 0;
            this.objects_vb[ii][cursor++] = CGlobals.readUnsignedByte(is);
            block15: for (int jj = 0; jj < this.objects_vb[ii][0]; ++jj) {
                short primtype = CGlobals.readUnsignedByte(is);
                this.objects_vb[ii][cursor++] = primtype;
                short b = CGlobals.readUnsignedByte(is);
                short g = CGlobals.readUnsignedByte(is);
                short r = CGlobals.readUnsignedByte(is);
                short a = CGlobals.readUnsignedByte(is);
                this.objects_vb[ii][cursor++] = a << 24 | r << 16 | g << 8 | b;
                switch (primtype) {
                    case 2: {
                        int kk;
                        for (kk = 0; kk < 6; ++kk) {
                            this.objects_vb[ii][cursor++] = CGlobals.readUnsignedByte(is) | CGlobals.readByte(is) << 8;
                        }
                        continue block15;
                    }
                    case 0: {
                        int kk;
                        for (kk = 0; kk < 9; ++kk) {
                            this.objects_vb[ii][cursor++] = CGlobals.readUnsignedByte(is) | CGlobals.readByte(is) << 8;
                        }
                        continue block15;
                    }
                    case 1: {
                        int kk;
                        for (kk = 0; kk < 5; ++kk) {
                            this.objects_vb[ii][cursor++] = CGlobals.readUnsignedByte(is) | CGlobals.readByte(is) << 8;
                        }
                        continue block15;
                    }
                    case 3: {
                        int kk;
                        for (kk = 0; kk < 3; ++kk) {
                            this.objects_vb[ii][cursor++] = CGlobals.readUnsignedByte(is) | CGlobals.readByte(is) << 8;
                        }
                        continue block15;
                    }
                }
            }
        }
        try {
            is.close();
        }
        catch (Exception ex) {
            CGame.DBG("could not close objects InputStream");
        }
        try {
            Class<?> c = this.getClass();
            is = CGlobals.getFile(backObjects);
            CGlobals.closeFile(backObjects);
            if (is == null) {
                System.err.println("obj file: " + backObjects);
                throw new Exception("File Does Not Exist");
            }
        }
        catch (Exception ex) {
            System.err.println("CBack::loadObjects\n" + ex.toString());
            return;
        }
        int bobjCount = CGlobals.readUnsignedByte(is);
        this.back_vb = new int[bobjCount * 2];
        int bcursor = 0;
        for (int ii = 0; ii < bobjCount; ++ii) {
            this.back_vb[bcursor++] = CGlobals.readUnsignedByte(is);
            short b = CGlobals.readUnsignedByte(is);
            short g = CGlobals.readUnsignedByte(is);
            short r = CGlobals.readUnsignedByte(is);
            short a = CGlobals.readUnsignedByte(is);
            this.back_vb[bcursor++] = a << 24 | r << 16 | g << 8 | b;
        }
        try {
            is.close();
        }
        catch (Exception ex) {
            CGame.DBG("could not close objects InputStream");
        }
    }

    void loadCircuit(String filename, InputStream in) {
        this.semActor.framelock = true;
        this.pilotAuxActor.currentFrame = -1;
        InputStream is = null;
        try {
            if (in != null) {
                is = in;
            } else {
                Class<?> c = this.getClass();
                is = c.getResourceAsStream(filename);
            }
            if (is == null) {
                System.err.println("circuit: " + filename);
                throw new Exception("File Does Not Exist");
            }
        }
        catch (Exception ex) {
            System.err.println("CBack::loadCircuit\n" + ex.toString());
            return;
        }
        for (int i = 0; i < this.eventQueue.length; ++i) {
            this.eventQueue[i] = -1;
        }
        this.circuitLength = CGlobals.readShort(is);
        this.roadAngleHW = new int[this.circuitLength];
        this.roadHeight = new int[this.circuitLength];
        this.roadCollision = new int[this.circuitLength];
        this.roadObjects = new int[this.circuitLength];
        this.backObjects = new int[this.circuitLength];
        this.road_signe = new int[this.circuitLength];
        for (int ii = 0; ii < this.circuitLength; ++ii) {
            int ang = CGlobals.readByte(is);
            ang = ang * this.angScale >> 8;
            short hght = CGlobals.readShort(is);
            short narr = CGlobals.readUnsignedByte(is);
            this.roadAngleHW[ii] = ang << 8 | narr;
            this.roadHeight[ii] = hght;
            this.roadObjects[ii] = CGlobals.readUnsignedByte(is);
            if (this.roadObjects[ii] == 255) {
                this.roadObjects[ii] = -1;
            }
            this.backObjects[ii] = CGlobals.readUnsignedByte(is);
            if (this.backObjects[ii] == 255) {
                this.backObjects[ii] = -1;
            }
            short typeL = CGlobals.readUnsignedByte(is);
            short limitL = CGlobals.readUnsignedByte(is);
            short typeR = CGlobals.readUnsignedByte(is);
            short limitR = CGlobals.readUnsignedByte(is);
            this.roadCollision[ii] = typeL << 24 | limitL << 16 | typeR << 8 | limitR;
        }
        this.backObjects[0] = 0;
        int signe = 0;
        int startpos = 0;
        int angle = 0;
        for (int i = 0; i < this.road_signe.length; ++i) {
            if (this.roadAngleHW[i] == 0 && signe == 0) {
                this.road_signe[i] = 0;
                signe = 0;
                angle = 0;
                continue;
            }
            if (signe == 0) {
                signe = CGlobals.signe(this.roadAngleHW[i]);
                angle = this.roadAngleHW[i];
                startpos = i;
                continue;
            }
            if (signe == CGlobals.signe(this.roadAngleHW[i])) {
                angle += this.roadAngleHW[i];
                continue;
            }
            angle = angle * 3 >> 9;
            int med = angle / (i - startpos);
            for (int j = startpos; j < i; ++j) {
                if (angle > 30 && angle < 70) {
                    this.road_signe[j] = med > 10 ? 2 : 1;
                }
                if (angle > 70 && angle < 120) {
                    this.road_signe[j] = med < 7 ? 1 : 2;
                }
                if (angle > 120) {
                    this.road_signe[j] = med > 10 ? 3 : (med > 5 ? 2 : 1);
                }
                if (angle < -30 && angle > -70) {
                    this.road_signe[j] = med < -10 ? -2 : -1;
                }
                if (angle < -70 && angle > -120) {
                    this.road_signe[j] = med > -7 ? -1 : -2;
                }
                if (angle >= -120) continue;
                this.road_signe[j] = med < -8 ? -3 : (med < -5 ? -2 : -1);
            }
            signe = CGlobals.signe(this.roadAngleHW[i]);
            if (signe != 0) {
                signe = CGlobals.signe(this.roadAngleHW[i]);
                angle = this.roadAngleHW[i];
                startpos = i;
                continue;
            }
            this.road_signe[i] = 0;
            signe = 0;
            angle = 0;
        }
        try {
            is.close();
        }
        catch (Exception ex) {
            CGame.DBG("could not close circuit InputStream");
        }
    }

    public void calcPhysics() {
        if (this.tires == 0) {
            this.fTopSpeed = 255;
        } else if (this.tires == 1) {
            this.fTopSpeed = 255;
        }
        this.fSteering = 512;
    }

    void resetVars() {
        raceStatus = -1;
        this.roadCursor = 0;
        this.car_gear = 0;
        this.curveCursor = 0;
        this.endTrickSet = false;
        this.bShakeIt = false;
        this.autoPilot = false;
        game_crashed = false;
        after_crash = false;
        this.end_time_not_set = true;
        this.bg_x = 0;
        this.bg_w = 0;
        this.bg_h = 0;
        this.cam_dot = 0;
        this.cameraSegmentCursor = 0;
        this.camera_elevation_plus = 600;
        this.carActor.posY = 153 + this.camera_elevation_plus * 62 / 600;
        this.heightCursor = 0;
        this.nearestObjectCursor = 0;
        this.car_road_x = 0;
        this.f_cam_pitch = 0;
        this.f_cam_road_height = 0;
        this.f_cam_x = 0;
        this.f_cam_y = 0;
        this.f_cam_yaw = 0;
        this.f_cam_z = 0;
        this.f_camdir_x = 0;
        this.f_camdir_z = 0;
        this.f_camright_x = 0;
        this.f_camright_z = 0;
        this.f_car_angle = 0;
        this.f_car_road_angle = 0;
        this.f_car_road_height = 0;
        this.f_car_steer_speed = 0;
        this.f_car_vx = 0;
        this.f_car_vy = 0;
        this.f_car_y = 0;
        this.f_cardir_x = 0;
        this.f_cardir_z = 0;
        this.f_carright_x = 0;
        this.f_carright_z = 0;
        this.f_car_vz = 0;
        this.frameCount = 0L;
        this.nr_paints_skipped = 0;
        this.semActor.framelock = true;
        this.time = 0L;
        this.radioOn = false;
        this.speedGain = 0;
        this.lapTimed = false;
        this.newLapRecord = false;
        this.lapTime = 0L;
        this.updateRaceFinished = false;
        this.resetRadio();
        for (int ii = 0; ii < 16; ++ii) {
            this.f_road_x[ii] = 0;
            this.f_road_y[ii] = 0;
            this.f_road_z[ii] = (16 - ii - 1) * 512;
            this.road_angle_hw[ii] = 0;
            this.primitives[ii][0] = 0;
            this.backPrimitives[ii][0] = -1;
        }
        this.nearestObjectCursor = 15;
    }

    public void freeGame() {
        System.out.println("freegame !!!");
        try {
            CGame.imgInterface = null;
            this.semSprMan = null;
            this.partSprMan = null;
            this.carSprMan = null;
            this.oppSprite = null;
            this.signs = null;
            this.spriteImgs = null;
            this.spriteImgSize = null;
            this.bg = null;
            System.gc();
            CGame.pGame.debugString = "freeGame";
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println("freegame end !");
    }

    public boolean loadGP(int step) {
        switch (step) {
            case 0: {
                if (CGame.pGame.menuImages) {
                    CGame.pGame.freeMenu();
                }
                this.resetVars();
                break;
            }
            case 1: {
                this.loadGameLib();
                this.semActor.initActor(0, 66, 44);
                this.initRoadImages();
                break;
            }
            case 2: {
                this.loadCircuit(CDef.trackLoadingNames[CGame.currentTrack], CGlobals.getFile(5 + CGame.currentTrack));
                CGlobals.closeFile(5 + CGame.currentTrack);
                break;
            }
            case 3: {
                this.autoPilot = false;
                this.startGrid();
                this.f_car_vz = 256;
                this.bg_w = this.bg.getWidth();
                this.bg_h = this.bg.getHeight();
                for (int jj = 0; jj < 32; ++jj) {
                    this.update();
                }
                this.f_car_vz = 0;
                this.bg_w = this.bg.getWidth();
                this.bg_h = this.bg.getHeight();
                break;
            }
            case 4: {
                this.calcPhysics();
                break;
            }
            default: {
                CGlobals.closeAll();
                return true;
            }
        }
        System.gc();
        return false;
    }

    public void cameraTransformPipe(int inpX, int inpY, int inpZ) {
        int xt = inpX - this.f_cam_x;
        int yt = inpY - this.f_cam_road_height;
        int zt = inpZ - this.f_cam_z;
        int xtn = (zt * this.sin(this.f_cam_yaw >> 8) >> 8) + (xt * this.cos(this.f_cam_yaw >> 8) >> 8);
        int ztn = (zt * this.cos(this.f_cam_yaw >> 8) >> 8) - (xt * this.sin(this.f_cam_yaw >> 8) >> 8);
        int ytn = yt;
        this.transformPipeY = (ytn * this.cos(this.f_cam_pitch >> 8) >> 8) - (ztn * this.sin(this.f_cam_pitch >> 8) >> 8);
        this.transformPipeZ = (ytn * this.sin(this.f_cam_pitch >> 8) >> 8) + (ztn * this.cos(this.f_cam_pitch >> 8) >> 8);
        this.transformPipeX = xtn;
        this.transformPipeY += CAMERA_ELEVATION + this.camera_elevation_plus;
    }

    public void postMessage(int id) {
        if (id == 0) {
            return;
        }
        block0 : switch (id) {
            case 2: {
                boolean test = true;
                do {
                    int i;
                    if ((i = CGlobals.randInt(22)) <= 2 || this.enemy[i].resigned || this.enemy[i].idx >= 0 && this.enemy[i].idx <= 16) continue;
                    this.enemy[i].resigned = true;
                    this.last_opp_resigned = i;
                    test = false;
                    break block0;
                } while (test);
                break;
            }
            case 5: {
                int count = 1 + CGlobals.randInt(3);
                this.accident_idx = new int[count];
                int pos = 0;
                for (int i = 3; i < this.enemy.length && count > 0; ++i) {
                    if (this.enemy[i].resigned || this.enemy[i].idx >= 0 && this.enemy[i].idx <= 16) continue;
                    this.enemy[i].resigned = true;
                    this.accident_idx[pos] = i;
                    ++pos;
                    --count;
                }
                break;
            }
        }
        if (writeCursor > 0 && id == this.eventQueue[writeCursor] && id != 2) {
            return;
        }
        if (++writeCursor == 20) {
            writeCursor = 0;
        }
        this.eventQueue[CBack.writeCursor] = id;
        lastEvent = CGame.frame_time;
    }

    public int getMessage() {
        int event = this.eventQueue[readCursor];
        if (event == -1) {
            return -1;
        }
        this.eventQueue[CBack.readCursor] = -1;
        ++readCursor;
        readCursor %= 20;
        return event;
    }

    void resetRadio() {
        writeCursor = -1;
        readCursor = 0;
        lastEvent = -1L;
        this.lastRadio = -1L;
        currEvent = -1;
    }

    void updateRadio() {
        if (raceStatus == 1 && CGame.frame_time - lastEvent > 15000L) {
            int n = CGlobals.randInt(10000);
            int event = 0;
            if (CGame.gameType != 0 && hasOpponents) {
                if (n < 2) {
                    event = 5;
                } else if (n < 10) {
                    event = 2;
                }
            }
            this.postMessage(event);
        }
    }

    void paintRadio(Graphics g) {
        if (currEvent == -1 || CGame.frame_time - this.lastRadio > 2500L) {
            this.lastRadio = CGame.frame_time;
            currEvent = this.getMessage();
            this.radioOn = false;
        } else {
            switch (currEvent) {
                case 2: {
                    this.messageBox(g, CGame.strings[176 + this.last_opp_resigned] + CGame.strings[158 + currEvent]);
                    break;
                }
                case 5: {
                    String s = "";
                    s = s + CGame.strings[158 + currEvent] + ". ";
                    for (int i = 0; i < this.accident_idx.length - 1; ++i) {
                        s = s + CGame.strings[176 + this.accident_idx[i]] + ", ";
                    }
                    s = s + CGame.strings[176 + this.accident_idx[this.accident_idx.length - 1]] + " " + CGame.strings[172];
                    this.messageBox(g, s);
                    break;
                }
                case 6: {
                    if (this.newLapRecord) {
                        this.messageBox(g, CGame.strings[164] + " " + CGame.time2String(this.lapTime) + "|" + CGame.strings[165]);
                        break;
                    }
                    this.messageBox(g, CGame.strings[164] + " " + CGame.time2String(this.lapTime));
                    break;
                }
                default: {
                    this.messageBox(g, CGame.strings[158 + currEvent]);
                }
            }
            this.radioOn = true;
        }
    }

    public void messageBox(Graphics g, String str) {
        int height = 33;
        String[] tmp = null;
        tmp = CGame.fontb.getTextFragment(str, 116, " .!", '|');
        if (tmp.length == 3) {
            height += 16;
        }
        if (tmp.length > 3) {
            height += 33;
        }
        g.setColor(527919);
        g.fillRect(6, 5, 119, height);
        g.setColor(16743217);
        g.drawRect(6, 5, 119, height);
        if (tmp.length == 1) {
            CGame.fontmic.drawText(g, tmp, 66, 5 + (height - CGame.fontmic.LETTER_A_HEIGHT) / 2, CGame.fontmic.LETTER_A_HEIGHT + 3, 1);
        } else {
            CGame.fontmic.drawText(g, tmp, 66, 12, CGame.fontmic.LETTER_A_HEIGHT + 3, 1);
        }
    }

    public void update() {
        int limit;
        boolean bRight;
        boolean bTrickNow;
        if (raceStatus == 2 && !this.updateRaceFinished) {
            this.finishTime = CGame.frame_time;
            this.time = (int)(this.finishTime - this.startTime);
            this.updateRaceFinished = true;
            if (CGame.qualify) {
                int k = 0;
                for (long limit2 = (long)(CDef.QUALIFY_TIME[CGame.currentTrack] - CEnemy.difficulty * 2000); this.time > limit2 && k < 22; ++k, limit2 += 3000L) {
                }
                this.startingPos = k;
                if (k == 0) {
                    int n = CGame.currentTrack;
                    CGame.trkPoles[n] = CGame.trkPoles[n] + 1;
                }
                return;
            }
        }
        if (raceStatus == 3 || raceStatus == 2) {
            if ((CGame._keyPressed & 0x80010) != 0 && !this.radioOn) {
                if (CGame.gameType == 0) {
                    CGame.gameState = 2;
                    CGame.pGame.reloadMenu(true);
                    CGame.pGame.prevSelected = 0;
                    CGame.pGame.setMenu(0);
                    this.freeGame();
                } else if (CGame.qualify) {
                    CGame.pGame.RMS(false);
                    CGame.gameState = 4;
                    CGame.pGame.freeMenu();
                    CGame.loadingStep = 0;
                    maxLaps = CGame.maxLaps;
                    CGame.qualify = false;
                    hasOpponents = true;
                    this.freeGame();
                } else {
                    CGame.pGame.generateResults();
                    CGame.gameState = 6;
                    CGame.pGame.resultsUpdated = false;
                }
                CGame.resScroll = 0;
                CGame.pGame.clearKeys();
            }
            if (raceStatus == 3) {
                return;
            }
        }
        for (int kk = 0; kk < 6; ++kk) {
            if (this.f_car_vz >= this.car_gearLimits[kk * 2]) continue;
            this.car_gear = (short)kk;
            break;
        }
        int gearSp = this.f_car_vz - this.car_gearDrawLimits[this.car_gear * 2];
        int gearLim = this.car_gear == 5 ? this.fTopSpeed + this.speedGain - this.car_gearDrawLimits[this.car_gear * 2] : this.car_gearDrawLimits[this.car_gear * 2 + 1] - this.car_gearDrawLimits[this.car_gear * 2];
        this.fRev = (gearSp << 8) / gearLim;
        int u1 = -(this.road_angle_hw[15] & 0xFFFFFF00);
        int u2 = -(this.road_angle_hw[14] & 0xFFFFFF00);
        this.f_car_road_angle = u1 + (u2 - u1) * (512 - this.cam_dot) / 512;
        int old_angle = this.f_car_angle;
        boolean bTrickNowAux = false;
        if (!this.bTrick) {
            bTrickNow = (CGame._keyCurrent & 0x80010) != 0 && this.effective_speed < 170 && this.carActor.animationID == 3 && this.on_the_road;
        } else {
            boolean bl = bTrickNow = (CGame._keyCurrent & 0x80010) == 0 && this.on_the_road;
        }
        if (this.bTrick && !this.on_the_road) {
            bTrickNowAux = true;
        }
        if (raceStatus == 2) {
            if (this.end_time_not_set) {
                this.end_time_not_set = false;
                this.finish_time = System.currentTimeMillis();
            }
            if (this.position == 1) {
                bTrickNow = true;
            } else if (this.position == 3 || this.position == 2) {
                bTrickNow = false;
                this.bShakeIt = true;
            } else {
                bTrickNow = false;
                this.bTrick = false;
                this.carActor.setAnimation(3);
            }
        }
        if (!this.bTrick && bTrickNow && CGame.frame_time - this.last_time_down > 500L) {
            if (this.TRICK_AT_START_DONE) {
                this.trick_time_up = CGame.frame_time;
                this.bTrick = true;
                this.urcare = true;
                this.coborare = false;
            }
        } else if (bTrickNow && this.bTrick && CGame.frame_time - this.trick_time_up > 300L && CGame.frame_time - this.last_time_down > 300L && raceStatus < 2) {
            this.last_time_down = CGame.frame_time;
            this.trick_time_down = CGame.frame_time;
            this.urcare = false;
            this.coborare = true;
        } else if (bTrickNowAux && CGame.frame_time - this.trick_time_up > 300L && CGame.frame_time - this.last_time_down > 300L && raceStatus < 2) {
            this.last_time_down = CGame.frame_time;
            this.trick_time_down = CGame.frame_time;
            this.urcare = false;
            this.coborare = true;
        }
        boolean bLeft = (CGame._key & 0x1008) != 0 && raceStatus == 1 && !this.bTrick && this.carActor.animationID != 7 && this.carActor.animationID != 8;
        boolean bl = bRight = (CGame._key & 0x2020) != 0 && raceStatus == 1 && (CGame._key & 0x80010) == 0 && !this.bTrick && this.carActor.animationID != 7 && this.carActor.animationID != 8;
        if (this.f_car_vz > 0) {
            int ratio = 256;
            if (this.f_car_vz < 50) {
                ratio = this.f_car_vz;
            }
            if (this.autoPilot) {
                this.f_car_angle = this.f_car_road_angle;
            } else {
                int localSteerSpeed = 40;
                if (this.tires == 1) {
                    localSteerSpeed = 2 * localSteerSpeed / 3;
                }
                if (bLeft) {
                    if (this.f_car_steer_speed > -100) {
                        this.f_car_angle += ratio * this.fSteering >> 8;
                        if (this.f_car_angle > this.f_car_road_angle + 6400) {
                            this.f_car_angle = this.f_car_road_angle + 6400;
                        }
                    } else {
                        this.f_car_steer_speed /= 2;
                    }
                    this.f_car_steer_speed += 2 * ratio * localSteerSpeed / 5 >> 8;
                } else if (bRight) {
                    if (this.f_car_steer_speed < 100) {
                        this.f_car_angle -= ratio * this.fSteering >> 8;
                        if (this.f_car_angle < this.f_car_road_angle - 6400) {
                            this.f_car_angle = this.f_car_road_angle - 6400;
                        }
                    } else {
                        this.f_car_steer_speed /= 2;
                    }
                    this.f_car_steer_speed -= 2 * ratio * localSteerSpeed / 5 >> 8;
                } else {
                    this.f_car_steer_speed /= 2;
                }
            }
        }
        int partID = -1;
        useParticles = false;
        if ((CGame._key & 0x880) != 0 && !this.bTrick) {
            useParticles = true;
            partID = 6;
            this.f_car_vz -= 10 * this.fBrakes >> 8;
            if (this.f_car_vz < 0) {
                this.f_car_vz = 0;
            }
        } else if (raceStatus == 1) {
            int reduce_speed_coeficient = 0;
            int REDUCE_SPEED_QUANT = 1;
            if (this.abs(this.f_car_steer_speed) > 600) {
                reduce_speed_coeficient = 1;
            }
            this.f_car_vz -= REDUCE_SPEED_QUANT * reduce_speed_coeficient;
            if (this.f_car_vz < 0) {
                this.f_car_vz = 0;
            }
            this.acc += this.fAcceleration * this.car_gearLimits[this.car_gear * 2 + 1];
            int iAcc = this.acc & 0xFFFFFF00;
            this.acc -= iAcc;
            if (!((this.carActor.animationID != 3 && this.carActor.animationID != 10 && this.carActor.animationID != 4 && this.carActor.animationID != 2 && this.carActor.animationID != 7 && this.carActor.animationID != 9 || raceStatus != 1 && raceStatus != 2) && this.on_the_road)) {
                this.f_car_vz += iAcc >> 8;
            } else if (this.bTrick && this.urcare) {
                this.f_car_vz += 2 * (iAcc >> 8);
            }
            if (this.f_car_vz > this.fTopSpeed) {
                this.f_car_vz = this.fTopSpeed;
            }
            if (after_crash || game_crashed) {
                this.f_car_vz = 0;
            }
        }
        this.f_cardir_x = -this.sin(this.f_car_angle >> 8);
        this.f_cardir_z = this.cos(this.f_car_angle >> 8);
        this.f_carright_x = -this.sin((this.f_car_angle >> 8) + 90);
        this.f_carright_z = this.cos((this.f_car_angle >> 8) + 90);
        int incz = (this.f_cardir_z * (this.f_car_vz * 200 >> 8) >> 8) + (-this.f_carright_z * (this.f_car_vx * 255 >> 8) >> 8);
        int incx = (this.f_cardir_x * (this.f_car_vz * 200 >> 8) >> 8) + (-this.f_carright_x * (this.f_car_vx * 255 >> 8) >> 8);
        this.f_car_vx = 0;
        this.f_cam_z += incz;
        this.f_cam_x += incx;
        int animID = 3;
        this.effective_speed = this.tires == 0 ? this.f_car_vz * 220 >> 8 : this.f_car_vz * 240 >> 8;
        if (!this.on_the_road && this.effective_speed > 25) {
            this.bTrick = false;
            if (this.f_car_steer_speed < -100) {
                animID = 4;
            } else if (this.f_car_steer_speed > 100) {
                animID = 2;
            }
        } else if (raceStatus < 2) {
            if (this.f_car_steer_speed < -200 && this.effective_speed > 100) {
                animID = 6;
            } else if (this.f_car_steer_speed < -120 && this.effective_speed > 75) {
                animID = 5;
            } else if (this.f_car_steer_speed < -50 && this.effective_speed > 50) {
                animID = 4;
            } else if (this.f_car_steer_speed > 200 && this.effective_speed > 100) {
                animID = 0;
            } else if (this.f_car_steer_speed > 120 && this.effective_speed > 75) {
                animID = 1;
            } else if (this.f_car_steer_speed > 50 && this.effective_speed > 50) {
                animID = 2;
            }
        }
        int car_angle = this.f_car_angle - this.f_car_road_angle;
        if (raceStatus == 0 || raceStatus == -1) {
            animID = 10;
            this.carActor.currentFrame = 0;
        }
        if (raceStatus == 1 && this.CAMERA_IS_DOWN && !this.TRICK_AT_START_DONE && !this.DONE_THIS) {
            this.trick_time = CGame.frame_time;
            this.DONE_THIS = true;
        }
        if (raceStatus == 1 && !this.TRICK_AT_START_DONE) {
            animID = 7;
            if (CGame.frame_time - this.trick_time > 1000L) {
                this.TRICK_AT_START_DONE = true;
                animID = 3;
            }
        }
        if (raceStatus == 1 && !this.CAMERA_IS_DOWN) {
            animID = 9;
            ++this.effective_speed;
            if (this.carActor.currentFrame == 1) {
                this.CAMERA_IS_DOWN = true;
                this.TRICK_AT_START_DONE = false;
            }
        }
        if (this.effective_speed == 0) {
            animID = 10;
            this.carActor.currentFrame = 0;
            this.bTrick = false;
        } else if (this.bTrick) {
            if (this.urcare) {
                animID = CGame.frame_time - this.trick_time_up < 300L ? 7 : (this.effective_speed > 100 ? 8 : 7);
            }
            if (this.coborare) {
                if (CGame.frame_time - this.trick_time_down < 50L) {
                    animID = 7;
                } else {
                    animID = 3;
                    bTrickNow = false;
                    this.bTrick = false;
                    this.urcare = false;
                    this.coborare = false;
                }
            }
        }
        if (this.bShakeIt) {
            animID = 14;
        }
        if (!game_crashed && this.carActor.animationID != animID) {
            if (animID != this.last_animation) {
                this.last_animation = this.carActor.animationID;
                this.carActor.setAnimation(animID);
                this.last_animation_time = CGame.frame_time;
            } else if (CGame.frame_time - this.last_animation_time > 300L) {
                this.last_animation = this.carActor.animationID;
                this.carActor.setAnimation(animID);
                this.last_animation_time = CGame.frame_time;
            }
        }
        if (animID >= 0 && animID <= 8 || animID == 14) {
            this.carActor.currentFrame = CGame.randInt(2);
        }
        this.f_cam_y = this.f_cam_road_height - (CAMERA_ELEVATION + this.camera_elevation_plus);
        this.f_cam_yaw = this.f_car_angle;
        this.f_cam_road_height = this.f_road_y[14] + (this.f_road_y[15] - this.f_road_y[14]) * this.cam_dot / 512;
        this.f_camdir_x = this.f_cardir_x;
        this.f_camdir_z = this.f_cardir_z;
        this.f_camright_x = this.f_carright_x;
        this.f_camright_z = this.f_carright_z;
        this.updateRoad();
        this.startDrawPt = 0;
        for (int ii = 15; ii >= 0; --ii) {
            int xt = this.f_road_x[ii] - this.f_cam_x;
            int yt = this.f_road_y[ii] - this.f_cam_road_height;
            int zt = this.f_road_z[ii] - this.f_cam_z;
            int xtn = (zt * this.sin(this.f_cam_yaw >> 8) >> 8) + (xt * this.cos(this.f_cam_yaw >> 8) >> 8);
            int ztn = (zt * this.cos(this.f_cam_yaw >> 8) >> 8) - (xt * this.sin(this.f_cam_yaw >> 8) >> 8);
            int ytn = yt;
            this.transformPipeX = xtn;
            this.transformPipeY = ytn;
            this.transformPipeZ = ztn;
            this.transformPipeY += CAMERA_ELEVATION + this.camera_elevation_plus;
            if (this.transformPipeZ == 0) {
                this.transformPipeZ = 1;
            }
            this.road_draw_hw[ii] = 132800 / this.transformPipeZ << 8 | this.road_angle_hw[ii] & 0xFF;
            this.road_draw_x[ii] = 66 + (this.transformPipeX * 40960 >> 8) / this.transformPipeZ;
            this.road_draw_y[ii] = 88 + (this.transformPipeY * 15360 >> 8) / this.transformPipeZ;
            if (ii >= 13 || this.road_draw_x[ii] >= 0 && this.road_draw_x[ii] + 2 * this.road_draw_hw[ii] <= 132 || this.road_draw_y[ii] <= this.road_draw_y[ii + 1]) continue;
            this.road_draw_y[0] = this.road_draw_y[ii + 1];
            this.startDrawPt = ii + 1;
            break;
        }
        int car_road_hw = (this.road_draw_hw[13] >> 8) + ((this.road_draw_hw[14] >> 8) - (this.road_draw_hw[13] >> 8)) * this.cam_dot / 512 << 1;
        if (raceStatus == 2) {
            if (this.car_road_x < -10) {
                this.car_road_x += 10;
            } else if (this.car_road_x > 10) {
                this.car_road_x -= 10;
            }
        } else {
            this.car_road_x = (66 - (this.road_draw_x[13] + (this.road_draw_x[14] - this.road_draw_x[13]) * this.cam_dot / 512) << 8) / car_road_hw;
        }
        int colPack = this.roadCollision[this.abs((this.cameraSegmentCursor - 16 + 1) % this.circuitLength)];
        int colTypeL = (colPack & 0xFF000000) >> 24;
        int colLimitL = -1 * ((colPack & 0xFF0000) >> 16);
        int colTypeR = (colPack & 0xFF00) >> 8;
        int colLimitR = colPack & 0xFF;
        if (this.car_road_x < 0) {
            switch (colTypeL) {
                case 1: {
                    if (this.car_road_x >= colLimitL + 16 || this.car_road_x <= colLimitL - 16) break;
                    this.f_car_vz /= 2;
                    this.f_car_steer_speed = -40;
                    this.f_car_angle -= 768;
                    this.f_car_vx = 255;
                    if (!this.autoPilot) {
                        CGame.sound.startSound(1, 1);
                    }
                    CGame.vibrate();
                    break;
                }
                case 2: {
                    if (this.car_road_x >= colLimitL + 16 || this.car_road_x <= colLimitL - 16) break;
                    this.f_car_vz = 20;
                    this.f_car_vx = 5100;
                    if (!this.autoPilot) {
                        CGame.sound.startSound(1, 1);
                    }
                    CGame.vibrate();
                    break;
                }
                case 3: {
                    if (this.car_road_x < colLimitL - 32) {
                        this.f_car_vz = 0;
                        this.f_car_steer_speed = -40;
                        this.f_car_angle -= 768;
                        this.f_car_vx = 510;
                        if (!this.autoPilot) {
                            CGame.sound.startSound(1, 1);
                        }
                        CGame.vibrate();
                        break;
                    }
                    if (this.car_road_x >= colLimitL) break;
                    this.f_car_vz /= 2;
                    this.f_car_steer_speed = -40;
                    this.f_car_angle -= 768;
                    this.f_car_vx = 255;
                    if (!this.autoPilot) {
                        CGame.sound.startSound(1, 1);
                    }
                    CGame.vibrate();
                }
            }
        } else {
            switch (colTypeR) {
                case 1: {
                    if (this.car_road_x >= colLimitR + 16 || this.car_road_x <= colLimitR - 16) break;
                    this.f_car_vz /= 2;
                    this.f_car_steer_speed = 40;
                    this.f_car_angle += 768;
                    this.f_car_vx = -255;
                    if (!this.autoPilot) {
                        CGame.sound.startSound(1, 1);
                    }
                    CGame.vibrate();
                    break;
                }
                case 2: {
                    if (this.car_road_x >= colLimitR + 16 || this.car_road_x <= colLimitR - 16) break;
                    this.f_car_vz = 20;
                    this.f_car_vx = -5100;
                    if (!this.autoPilot) {
                        CGame.sound.startSound(1, 1);
                    }
                    CGame.vibrate();
                    break;
                }
                case 3: {
                    if (this.car_road_x > colLimitR + 32) {
                        this.f_car_vz = 0;
                        this.f_car_steer_speed = 40;
                        this.f_car_angle += 768;
                        this.f_car_vx = -510;
                        if (!this.autoPilot) {
                            CGame.sound.startSound(1, 1);
                        }
                        CGame.vibrate();
                        break;
                    }
                    if (this.car_road_x <= colLimitR) break;
                    this.f_car_vz /= 2;
                    this.f_car_steer_speed = -40;
                    this.f_car_angle += 768;
                    this.f_car_vx = -255;
                    if (!this.autoPilot) {
                        CGame.sound.startSound(1, 1);
                    }
                    CGame.vibrate();
                }
            }
        }
        if ((this.car_segm % this.circuitLength < 5 || this.car_segm % this.circuitLength > 10) && (this.car_road_x < -120 || this.car_road_x > 120 && this.f_car_vz > 30)) {
            this.f_car_vz = this.f_car_vz * 250 >> 8;
            useParticles = true;
            if (this.abs(this.car_road_x) > 150) {
                partID = 2 + this.sand;
            } else {
                if (this.car_road_x < 0) {
                    partID = 0 + this.sand;
                }
                if (this.car_road_x > 0) {
                    partID = 1 + this.sand;
                }
            }
        }
        if (partID != -1 && this.partActor.animationID != partID) {
            this.partActor.setAnimation(partID);
        }
        int delta_angle = this.f_car_angle - old_angle;
        if (!this.autoPilot) {
            this.f_car_vx += (delta_angle << 8) / 1792;
            this.f_car_vx = this.f_car_vx * this.f_car_vz >> 8;
        }
        this.bg_x = 4 * this.f_car_angle * this.bg_w / 360 >> 8;
        this.bg_x %= this.bg_w;
        int dirx = this.f_road_x[14] - this.f_road_x[15];
        int dirz = this.f_road_z[14] - this.f_road_z[15];
        int car_dot = (dirx * this.f_camdir_x >> 8) + (dirz * this.f_camdir_z >> 8);
        this.car_segm = this.roadCursor - 16 + 2;
        this.car_z = this.car_segm * 512 + (512 - this.cam_dot);
        if (hasOpponents) {
            int i;
            if (raceStatus == 1) {
                this.position = 1;
            }
            int minDelta = -1;
            for (int i2 = 0; i2 < this.enemy.length; ++i2) {
                if (this.enemy[i2].resigned) continue;
                this.enemy[i2].visible = false;
                this.enemy[i2].update();
                this.positions[i2] = this.enemy[i2].delta;
                this.positions2[i2] = this.enemy[i2].delta2;
                if (raceStatus != 1) continue;
                if (this.positions[i2] > 40) {
                    ++this.position;
                } else if (minDelta == -1 || minDelta > this.positions2[i2]) {
                    minDelta = this.positions2[i2];
                }
                if (CGame.gameType != 0) continue;
                if (this.positions[i2] < -1024) {
                    this.enemy[0].init(0, this.enemy[0].f_z + 15360);
                    continue;
                }
                if (this.positions[i2] <= 15360) continue;
                this.enemy[0].init(0, this.enemy[0].f_z - 16384);
            }
            int NUM_VISIBLE = 4;
            for (i = 0; i < NUM_VISIBLE; ++i) {
                int min = -1;
                int jmin = -1;
                for (int j = 0; j < this.enemy.length; ++j) {
                    if (this.positions2[j] <= 0 || this.positions2[j] >= min && min != -1) continue;
                    min = this.positions2[j];
                    jmin = j;
                }
                if (jmin == -1) break;
                this.positions2[jmin] = -1;
                this.enemy[jmin].visible = true;
            }
            if (raceStatus == 1 && this.position != this.lastPos) {
                if (this.position == 1 && this.lastPos != 1 && minDelta < -300 && CGame.gameType != 0 && (this.startingPos != 0 || this.car_segm >= 2)) {
                    this.postMessage(4);
                }
                this.lastPos = this.position;
            }
            for (i = 0; i < this.enemy.length; ++i) {
                if (this.enemy[i].resigned || this.enemy[i].idx <= 0 || this.enemy[i].idx >= 16) continue;
                for (int j = 0; j < this.enemy.length; ++j) {
                    if (this.enemy[j].resigned || this.enemy[j].idx <= 0 || this.enemy[j].idx >= 16 || i == j || this.abs(this.enemy[i].f_z - this.enemy[j].f_z) >= 1024 || this.abs(this.enemy[i].f_x - this.enemy[j].f_x) >= 100) continue;
                    int back = j;
                    int front = i;
                    if (this.enemy[i].f_z < this.enemy[j].f_z) {
                        back = i;
                        front = j;
                    }
                    this.enemy[front].f_vz += 0;
                    this.enemy[back].f_vz -= 0;
                    int SPEED_MOD = 22;
                    if (this.enemy[back].f_x > this.enemy[front].f_x) {
                        if (this.enemy[back].f_x > -110) {
                            this.enemy[back].f_x -= SPEED_MOD;
                            continue;
                        }
                        this.enemy[back].f_x += SPEED_MOD;
                        continue;
                    }
                    if (this.enemy[back].f_x < 110) {
                        this.enemy[back].f_x += SPEED_MOD;
                        continue;
                    }
                    this.enemy[back].f_x -= SPEED_MOD;
                }
            }
        }
        this.on_the_road = this.car_road_x >= -(limit = 125) && this.car_road_x <= limit;
        if (!game_crashed) {
            if (!this.on_the_road && this.effective_speed > 0) {
                this.camera_elevation_plus = (this.camera_elevation_plus + 1) % 2;
                this.camera_elevation_plus *= 51;
                this.carActor.posY = 153 + this.camera_elevation_plus * 7 / 51;
            } else if (raceStatus == 1) {
                this.carActor.posY = 153;
                this.carActor.posX = 66;
            }
        }
        if (this.car_road_x < -200) {
            this.f_car_vx += 100;
            this.f_car_steer_speed = -40;
            this.f_car_angle = this.f_car_road_angle - 768;
            if (!this.autoPilot && !CGame.sound.isSoundPlaying()) {
                CGame.sound.startSound(1, 1);
                CGame.vibrate();
            }
        } else if (this.car_road_x > 200) {
            this.f_car_vx += -100;
            this.f_car_steer_speed = 40;
            this.f_car_angle = this.f_car_road_angle - 768;
            if (!this.autoPilot && !CGame.sound.isSoundPlaying()) {
                CGame.sound.startSound(1, 1);
                CGame.vibrate();
            }
        }
        this.segm = this.car_segm % this.circuitLength;
        if (raceStatus != 1 || CGame.paused || this.effective_speed == 0) {
            useParticles = false;
        }
        if (this.segm == 0) {
            if (!this.lapTimed) {
                long now = CGame.frame_time;
                if (this.laps < maxLaps) {
                    this.lapTime = now - this.lapStart;
                }
                int lap = this.car_segm / this.circuitLength;
                if (((long)CGame.trkBestTime[CGame.currentTrack] > this.lapTime || CGame.trkBestTime[CGame.currentTrack] == -1) && lap > 0) {
                    CGame.trkBestTime[CGame.currentTrack] = (int)this.lapTime;
                    this.newLapRecord = true;
                } else {
                    this.newLapRecord = false;
                }
                if (this.bestLapTime > this.lapTime) {
                    this.bestLapTime = this.lapTime;
                }
                this.messagelapTime = now;
                this.lapTimed = true;
                if (lap > 0) {
                    this.lapStart = now;
                    if (lap < maxLaps) {
                        this.postMessage(6);
                    }
                }
            }
        } else {
            this.lapTimed = false;
        }
        this.updateRadio();
        try {
            if (this.f_car_vz > 15 && !CGame.paused && !game_crashed) {
                this.carActor.update(this.carSprMan, false);
            }
        }
        catch (Exception ex) {
            System.out.println("LIFE IS LIFE");
        }
    }

    void paintSpeedEffect(Graphics gr) {
        int NUM_LINES = 5;
        int x1 = 66;
        int y1 = this.carActor.posY - 15;
        int x2 = 66;
        int y2 = this.carActor.posY + 30;
        for (int i = 0; i < NUM_LINES; ++i) {
            int x = CGlobals.randSignInt(30);
            int y = CGlobals.randSignInt(7);
            gr.setColor(0xFFFFFF);
            gr.drawLine(x1 + x, y1 + y, x2 + 2 * x, y2);
        }
    }

    void paintMotionBlurEffect(Graphics gr) {
        int NUM_LINES = 6;
        int cx = 66;
        int cy = 88;
        int RAZA1 = 56;
        int RAZA2 = 96;
        for (int i = 0; i < NUM_LINES; ++i) {
            int angle = CGlobals.randInt(360);
            int dx = CGlobals.randSignInt(10);
            int x1 = this.sin(angle) * (RAZA1 + dx) >> 8;
            int y1 = this.cos(angle) * (RAZA1 + dx) >> 8;
            int x2 = this.sin(angle) * (RAZA2 + dx) >> 8;
            int y2 = this.cos(angle) * (RAZA2 + dx) >> 8;
            gr.setColor(0);
            gr.drawLine(cx + x1, cy + y1, cx + x2, cy + y2);
        }
    }

    public void paint(Graphics g) {
        int ii;
        if (this.nr_paints_skipped <= 3) {
            ++this.nr_paints_skipped;
            return;
        }
        g.setClip(0, 0, 132, 176);
        g.clipRect(0, 0, 132, 156);
        g.setColor(SKY_COLOR);
        g.fillRect(0, 0, 132, 88);
        if (CGame.menuState == 7) {
            g.setClip(0, CDef.INGAME_MENU_HEIGHT, 132, 176 - CDef.INGAME_MENU_HEIGHT);
        }
        g.setColor(BG_COLOR_FAR);
        g.fillRect(0, 88, 132, this.bg_h - this.road_draw_y[0]);
        int add = 4;
        if (this.bg_x == 0) {
            g.drawImage(this.bg, this.bg_x, 88 - this.bg_h + add, 0);
        } else if (this.bg_x < 0) {
            g.drawRegion(this.bg, -this.bg_x, 0, this.bg_w + this.bg_x, this.bg_h, 0, 0, 88 - this.bg_h + add, 0);
            g.drawRegion(this.bg, 0, 0, -this.bg_x - 1, this.bg_h, 0, this.bg_w + this.bg_x, 88 - this.bg_h + add, 0);
        } else {
            g.drawRegion(this.bg, 0, 0, this.bg_w - this.bg_x, this.bg_h, 0, this.bg_x, 88 - this.bg_h + add, 0);
            g.drawRegion(this.bg, this.bg_w - this.bg_x, 0, this.bg_x, this.bg_h, 0, 0, 88 - this.bg_h + add, 0);
        }
        int rectStartY = 0;
        int rectEndY = 0;
        for (int ii2 = 0; ii2 < 5; ++ii2) {
            int rap = (ii2 << 8) / 5;
            int underColor = (BG_COLOR_FAR_R * (255 - rap) >> 8) + (BG_COLOR_NEAR_R * rap >> 8) << 16 | (BG_COLOR_FAR_G * (255 - rap) >> 8) + (BG_COLOR_NEAR_G * rap >> 8) << 8 | (BG_COLOR_FAR_B * (255 - rap) >> 8) + (BG_COLOR_NEAR_B * rap >> 8);
            g.setColor(underColor);
            rectStartY = this.road_draw_y[0] + ii2 * ii2;
            rectEndY = this.road_draw_y[0] + (ii2 + 1) * (ii2 + 1);
            if (ii2 == 0) {
                rectStartY = 88 + add;
            }
            if (rectEndY > 176) {
                rectEndY = 176;
            }
            g.fillRect(0, rectStartY, 132, rectEndY - rectStartY);
        }
        g.setColor(BG_COLOR_NEAR);
        g.fillRect(0, rectEndY, 132, 176 - rectEndY);
        int endp = 1000;
        for (ii = this.startDrawPt; ii < 15; ++ii) {
            int bkobjcursor = (ii + this.nearestObjectCursor + 1) % 16;
            if (this.backPrimitives[bkobjcursor][0] >= 0) {
                int x1 = this.road_draw_x[ii];
                int y1 = this.road_draw_y[ii];
                int x2 = this.road_draw_x[ii + 1];
                int y2 = this.road_draw_y[ii + 1];
                if (y2 > 176) {
                    y2 = 176;
                }
                int bktype = this.backPrimitives[bkobjcursor][0];
                int bkcolor = this.backPrimitives[bkobjcursor][1];
                int rap = (ii + 5 << 8) / 20;
                int red = (bkcolor & 0xFF0000) >> 16;
                int green = (bkcolor & 0xFF00) >> 8;
                int blue = bkcolor & 0xFF;
                bkcolor = red * rap >> 8 << 16 | green * rap >> 8 << 8 | blue * rap >> 8;
                g.setColor(bkcolor);
                switch (bktype) {
                    case 0: {
                        g.fillRect(0, y1, 132, y2 - y1);
                        break;
                    }
                    case 2: {
                        g.fillRect(0, y1, x1, y2 - y1);
                        break;
                    }
                    case 1: {
                        g.fillRect(x1, y1, 132 - x1, y2 - y1);
                        break;
                    }
                    case 4: {
                        g.setColor(bkcolor);
                        int rhw1 = this.road_draw_hw[ii] >> 8;
                        int rhw2 = this.road_draw_hw[ii + 1] >> 8;
                        g.fillRect(x1 + rhw1, 0, x2 + rhw2 - x1 - rhw1, y2 + 1);
                    }
                }
            }
            if (ii < 1 || ii >= 15) continue;
            int startx = this.road_draw_x[ii];
            int starthw = this.road_draw_hw[ii] >> 8;
            int starty = this.road_draw_y[ii];
            int dst = this.road_draw_y[ii + 1] - this.road_draw_y[ii];
            if (dst <= 0) continue;
            int xpas = (this.road_draw_x[ii + 1] - startx << 8) / dst;
            int hwpas = ((this.road_draw_hw[ii + 1] >> 8) - starthw << 8) / dst;
            for (int jj = 0; jj < dst && starty + jj <= 176; ++jj) {
                int curhw = starthw + (jj * hwpas >> 8);
                int curx = startx + (jj * xpas >> 8);
                int modcurhw = curhw * (this.road_draw_hw[ii] & 0xFF) >> 8;
                if (curhw << 1 <= 48) {
                    g.setColor(ROAD_COLOR_FAR);
                    g.fillRect(curx - (curhw - modcurhw), starty + jj, 2 * (curhw - modcurhw), 1);
                    continue;
                }
                if (curhw << 1 >= 500) {
                    g.setColor(ROAD_COLOR_NEAR);
                    g.fillRect(curx - (curhw - modcurhw), starty + jj, 2 * (curhw - modcurhw), 1);
                    continue;
                }
                int roadline = ((curhw << 1) - 48) * 64 / 452;
                g.setColor(this.roadColors[(this.cameraSegmentCursor + ii) % 2][roadline]);
                g.fillRect(curx - (curhw - modcurhw), starty + jj, 2 * (curhw - modcurhw), 1);
            }
        }
        for (int i = 0; i < 156 - endp; ++i) {
            g.setColor(ROAD_COLOR_NEAR);
            g.drawLine(0, endp + i, 132, endp + i);
        }
        for (ii = 0; ii < 15; ++ii) {
            int objcursor;
            this.x1 = this.road_draw_x[ii];
            this.y1 = this.road_draw_y[ii];
            this.w1 = this.road_draw_hw[ii] >> 8;
            this.x2 = this.road_draw_x[ii + 1];
            this.y2 = this.road_draw_y[ii + 1];
            this.w2 = this.road_draw_hw[ii + 1] >> 8;
            this.ystep = this.y2 - this.y1 + 1;
            this.wstep = this.w2 - this.w1 + 1;
            this.xstep = this.x2 - this.x1 + 1;
            if (hasOpponents) {
                for (int i = 0; i < this.enemy.length; ++i) {
                    if (this.enemy[i].idx != ii + 1) continue;
                    this.enemy[i].paint(g);
                }
            }
            if (this.primitives[objcursor = (ii + this.nearestObjectCursor + 1) % 16][0] <= 0 || ii >= 14) continue;
            int cursor = 1;
            block36: for (int jj = 0; jj < this.primitives[objcursor][0]; ++jj) {
                switch (this.primitives[objcursor][cursor]) {
                    case 1: {
                        int n = ++cursor;
                        int rcol = this.primitives[objcursor][n];
                        g.setColor(rcol);
                        int n2 = ++cursor;
                        int rc1_x = this.primitives[objcursor][n2];
                        int n3 = ++cursor;
                        int rc1_y = this.primitives[objcursor][n3];
                        int n4 = ++cursor;
                        int rc1_z = this.primitives[objcursor][n4];
                        int n5 = ++cursor;
                        int rc1_w = this.primitives[objcursor][n5];
                        int n6 = ++cursor;
                        ++cursor;
                        int rc1_h = this.primitives[objcursor][n6];
                        int rw1 = this.w1 + (this.wstep * rc1_z >> 8);
                        int rx1 = this.x1 + (this.xstep * rc1_z >> 8);
                        int ry1 = this.y1 + (this.ystep * rc1_z >> 8);
                        int rcx = rx1 + (rc1_x * rw1 >> 8);
                        int rcy = ry1 + (rc1_y * rw1 >> 8);
                        int rcw = rc1_w * rw1 >> 8;
                        int rch = rc1_h * rw1 >> 8;
                        if (rcx < 0) {
                            if ((rcw += rcx) > 132) {
                                rcw = 132;
                            }
                            rcx = 0;
                        }
                        if (rcy < 0) {
                            if ((rch += rcy) > 176) {
                                rch = 176;
                            }
                            rcy = 0;
                        }
                        g.fillRect(rcx, rcy, rcw, rch);
                        continue block36;
                    }
                    case 0: {
                        int n = ++cursor;
                        int tcol = this.primitives[objcursor][n];
                        g.setColor(tcol);
                        int n7 = ++cursor;
                        int tr1_x = this.primitives[objcursor][n7];
                        int n8 = ++cursor;
                        int tr1_y = this.primitives[objcursor][n8];
                        int n9 = ++cursor;
                        int tr1_z = this.primitives[objcursor][n9];
                        int n10 = ++cursor;
                        int tr2_x = this.primitives[objcursor][n10];
                        int n11 = ++cursor;
                        int tr2_y = this.primitives[objcursor][n11];
                        int n12 = ++cursor;
                        int tr2_z = this.primitives[objcursor][n12];
                        int n13 = ++cursor;
                        int tr3_x = this.primitives[objcursor][n13];
                        int n14 = ++cursor;
                        int tr3_y = this.primitives[objcursor][n14];
                        int n15 = ++cursor;
                        ++cursor;
                        int tr3_z = this.primitives[objcursor][n15];
                        int tw1 = this.w1 + (this.wstep * tr1_z >> 8);
                        int tx1 = this.x1 + (this.xstep * tr1_z >> 8);
                        int ty1 = this.y1 + (this.ystep * tr1_z >> 8);
                        int tw2 = this.w1 + (this.wstep * tr2_z >> 8);
                        int tx2 = this.x1 + (this.xstep * tr2_z >> 8);
                        int ty2 = this.y1 + (this.ystep * tr2_z >> 8);
                        int tw3 = this.w1 + (this.wstep * tr3_z >> 8);
                        int tx3 = this.x1 + (this.xstep * tr3_z >> 8);
                        int ty3 = this.y1 + (this.ystep * tr3_z >> 8);
                        int trix1 = tx1 + (tr1_x * tw1 >> 8);
                        int triy1 = ty1 + (tr1_y * tw1 >> 8);
                        int trix2 = tx2 + (tr2_x * tw2 >> 8);
                        int triy2 = ty2 + (tr2_y * tw2 >> 8);
                        int trix3 = tx3 + (tr3_x * tw3 >> 8);
                        int triy3 = ty3 + (tr3_y * tw3 >> 8);
                        g.fillTriangle(trix1, triy1, trix2, triy2, trix3, triy3);
                        continue block36;
                    }
                    case 2: {
                        int n = ++cursor;
                        int lcol = this.primitives[objcursor][n];
                        g.setColor(lcol);
                        int n16 = ++cursor;
                        int r1_x = this.primitives[objcursor][n16];
                        int n17 = ++cursor;
                        int r1_y = this.primitives[objcursor][n17];
                        int n18 = ++cursor;
                        int r1_z = this.primitives[objcursor][n18];
                        int n19 = ++cursor;
                        int r2_x = this.primitives[objcursor][n19];
                        int n20 = ++cursor;
                        int r2_y = this.primitives[objcursor][n20];
                        int n21 = ++cursor;
                        ++cursor;
                        int r2_z = this.primitives[objcursor][n21];
                        int lw1 = this.w1 + (this.wstep * r1_z >> 8);
                        int lx1 = this.x1 + (this.xstep * r1_z >> 8);
                        int ly1 = this.y1 + (this.ystep * r1_z >> 8);
                        int lw2 = this.w1 + (this.wstep * r2_z >> 8);
                        int lx2 = this.x1 + (this.xstep * r2_z >> 8);
                        int ly2 = this.y1 + (this.ystep * r2_z >> 8);
                        g.drawLine(lx1 + (r1_x * lw1 >> 8), ly1 + (r1_y * lw1 >> 8), lx2 + (r2_x * lw2 >> 8), ly2 + (r2_y * lw2 >> 8));
                        continue block36;
                    }
                    case 3: {
                        int n = ++cursor;
                        int id = this.primitives[objcursor][n];
                        int n22 = ++cursor;
                        int s1_x = this.primitives[objcursor][n22];
                        int n23 = ++cursor;
                        int s1_y = this.primitives[objcursor][n23];
                        int n24 = ++cursor;
                        ++cursor;
                        int s1_z = this.primitives[objcursor][n24];
                        int sw1 = this.w1 + (this.wstep * s1_z >> 8);
                        int sx1 = this.x1 + (this.xstep * s1_z >> 8);
                        int sy1 = this.y1 + (this.ystep * s1_z >> 8);
                        int frame = CEnemy.scaleIdx[ii];
                        if (frame >= 6) {
                            frame = 6;
                        } else if (frame < 0) {
                            frame = 0;
                        }
                        if (frame >= 6) {
                            frame = 6;
                        } else if (frame < 0) {
                            frame = 0;
                        }
                        try {
                            g.drawImage(this.spriteImgs[id][frame], sx1 + (s1_x * sw1 >> 8) - (this.spriteImgSize[id][frame] >> 8), sy1 + (s1_y * sw1 >> 8) - (this.spriteImgSize[id][frame] & 0xFF), 0);
                            continue block36;
                        }
                        catch (Exception ex) {
                            System.out.println("id :::" + id + " frame ::::" + frame + "  " + ex.toString());
                        }
                    }
                }
            }
        }
        if (raceStatus != -1 && raceStatus != 0 && !game_crashed) {
            this.carActor.posY = 153 + this.camera_elevation_plus * 2 / 51;
        }
        if (this.bTrick && !this.coborare && this.effective_speed > 120) {
            this.paintSpeedEffect(g);
            this.paintMotionBlurEffect(g);
        }
        if (after_crash) {
            if (CGame.frame_time - crash_time < 2000L && show_player % 5 == 0) {
                try {
                    this.carActor.draw(g, this.carSprMan);
                }
                catch (Exception ex) {
                    System.out.println("ERoare de carActor ");
                }
            }
            if (CGame.frame_time - crash_time > 2000L) {
                after_crash = false;
            }
            show_player = (show_player + 1) % 5;
        } else {
            try {
                if (this.carActor.animationID == 10) {
                    this.carActor.currentFrame = 0;
                }
                if (!CGame.firstPaint) {
                    this.carActor.draw(g, this.carSprMan);
                } else {
                    CGame.firstPaint = false;
                }
            }
            catch (Exception ex) {
                System.out.println("caranim ::: " + this.carActor.animationID + "  frame ::: " + this.carActor.currentFrame);
                System.out.println("ERROR DRAWPLAYER ::: " + ex.toString());
                ex.printStackTrace();
            }
        }
        if (game_crashed) {
            if (!this.animationSet) {
                this.pilotAuxActor.setAnimation(13);
                this.carActor.setAnimation(12);
                this.animationSet = true;
                crash_time = CGame.frame_time;
            }
            if (!this.directionSet) {
                this.directionCrash = CGame.randInt(2) == 0 ? -1 : 1;
                this.directionSet = true;
            }
            if (this.pilotAuxActor.currentFrame < 2 && CGame.frame_time - crash_time > 300L) {
                ++this.pilotAuxActor.currentFrame;
                crash_time = CGame.frame_time;
            }
            try {
                this.pilotAuxActor.draw(g, this.carSprMan);
            }
            catch (Exception ex) {
                System.out.println("CEVVVVV");
            }
            if (this.pilotAuxActor.currentFrame == 2) {
                game_crashed = false;
                crash_time = CGame.frame_time;
                after_crash = true;
                show_player = 0;
                this.pilotAuxActor.currentFrame = -1;
                this.f_car_vz = 0;
                crash_time = CGame.frame_time;
                this.animationSet = false;
                this.directionSet = false;
                game_crashed = false;
            }
        }
        if (this.bShakeIt) {
            try {
                this.pilotAuxActor.draw(g, this.carSprMan);
            }
            catch (Exception ex) {
                System.out.println("CEVVVVV");
            }
        }
        if ((this.car_segm % this.circuitLength < 5 || this.car_segm % this.circuitLength > 10) && useParticles) {
            this.partActor.posY = this.carActor.posY;
            if (!CGame.paused) {
                this.partActor.update(this.partSprMan, false);
            }
            this.partActor.draw(g, this.partSprMan);
        }
        if (raceStatus == -1 && this.semActor.framelock) {
            if (CGame.frame_time - this.camera_goes_down_time > 100L) {
                this.carActor.posY = 153 + this.camera_elevation_plus * 62 / 600;
                this.camera_elevation_plus -= 20;
                this.camera_goes_down_time = CGame.frame_time;
            }
            if (this.camera_elevation_plus < 0) {
                this.semActor.framelock = false;
                raceStatus = 0;
            }
        }
        if (game_crashed) {
            this.carActor.posY = 153 - dy_crash * (this.pilotAuxActor.currentFrame + 1);
            this.pilotAuxActor.posY = 153 - dy_crash * (this.pilotAuxActor.currentFrame + 1);
            this.carActor.posX = 66 + this.directionCrash * dx_crash * (this.pilotAuxActor.currentFrame + 1);
            this.pilotAuxActor.posX = 66 - this.directionCrash * dx_crash * (this.pilotAuxActor.currentFrame + 1);
        }
        if (!this.semActor.framelock && this.semActor.posY > -50) {
            int x = g.getClipX();
            int y = g.getClipY();
            int width = g.getClipWidth();
            int height = g.getClipHeight();
            g.setClip(0, 0, 132, 176);
            g.setColor(0x111111);
            g.fillRect(0, this.semActor.posY - 5, 132, 5);
            g.setClip(x, y, width, height);
            this.semActor.draw(g, this.semSprMan);
            if (CGame.frame_time - this.semaphore_time > 550L) {
                if (!this.semActor.framelock && !CGame.paused) {
                    this.semActor.update(this.semSprMan, false);
                }
                this.semaphore_time = CGame.frame_time;
            }
            if (this.semActor.currentFrame == 6) {
                if (raceStatus == 0) {
                    raceStatus = 1;
                    this.lapStart = this.startTime = CGame.frame_time;
                    this.time = 0L;
                } else {
                    this.semActor.posY -= 3;
                }
                if (this.semActor.framelock) {
                    this.postMessage(1);
                }
            }
        }
        CGame.pGame.paintInterface();
        this.paintRadio(g);
        switch (raceStatus) {
            case 2: 
            case 3: {
                String msg;
                if (CGame.qualify) {
                    msg = CGame.strings[168] + ":" + (this.startingPos + 1);
                } else {
                    msg = CGame.strings[201];
                    switch (this.position) {
                        case 1: {
                            msg = msg + " 1st";
                            break;
                        }
                        case 2: {
                            msg = msg + " 2nd";
                            break;
                        }
                        case 3: {
                            msg = msg + " 3nd";
                            break;
                        }
                        default: {
                            msg = msg + " " + this.position + "th";
                        }
                    }
                }
                if (raceStatus == 3 || raceStatus == 2) {
                    msg = msg + ".|" + CGame.strings[166];
                }
                if ((raceStatus == 2 || raceStatus == 3) && CGame.qualify) {
                    if (!this.updateRaceFinished) break;
                    this.messageBox(g, msg);
                    break;
                }
                this.messageBox(g, msg);
            }
        }
    }

    static {
        dy_crash = 10;
        dx_crash = 25;
        hasOpponents = true;
        raceStatus = -1;
        SCALING_FACTORS = new int[]{27, 50, 67, 82, 107, 151, 215};
        SKY_COLOR = 3494296;
        BG_COLOR_NEAR = 5219417;
        BG_COLOR_FAR = 1987393;
        FOG_COLOR = 7250837;
        ROAD_COLOR_NEAR = 0x3F3F3B;
        ROAD_COLOR_FAR = 4807767;
        BG_COLOR_NEAR_R = (BG_COLOR_NEAR & 0xFF0000) >> 16;
        BG_COLOR_NEAR_G = (BG_COLOR_NEAR & 0xFF00) >> 8;
        BG_COLOR_NEAR_B = BG_COLOR_NEAR & 0xFF;
        BG_COLOR_FAR_R = (BG_COLOR_FAR & 0xFF0000) >> 16;
        BG_COLOR_FAR_G = (BG_COLOR_FAR & 0xFF00) >> 8;
        BG_COLOR_FAR_B = BG_COLOR_FAR & 0xFF;
        FOG_COLOR_R = (FOG_COLOR & 0xFF0000) >> 16;
        FOG_COLOR_G = (FOG_COLOR & 0xFF00) >> 8;
        FOG_COLOR_B = FOG_COLOR & 0xFF;
        ROAD_COLOR_NEAR_R = (ROAD_COLOR_NEAR & 0xFF0000) >> 16;
        ROAD_COLOR_NEAR_G = (ROAD_COLOR_NEAR & 0xFF00) >> 8;
        ROAD_COLOR_NEAR_B = ROAD_COLOR_NEAR & 0xFF;
        ROAD_COLOR_FAR_R = (ROAD_COLOR_FAR & 0xFF0000) >> 16;
        ROAD_COLOR_FAR_G = (ROAD_COLOR_FAR & 0xFF00) >> 8;
        ROAD_COLOR_FAR_B = ROAD_COLOR_FAR & 0xFF;
        bg_sets = new int[][]{{7133694, 11178345, 15324326, 11178345, 13611650, 0xECEACE, 0, 2}, {13029355, 2506766, 5998387, 2506766, 2506766, 2506766, 1, 3}, {4818883, 4087815, 5998387, 3165461, 5666084, 7575885, 2, 1}, {11653106, 4087815, 5998387, 3165461, 5666084, 7575885, 2, 0}, {11653106, 2506766, 5998387, 7443627, 5202023, 4341814, 1, 0}, {4818883, 2506766, 5998387, 2506766, 2506766, 2506766, 3, 1}, {11653106, 2832654, 3640355, 9150394, 11178345, 15324326, 2, 0}, {13029355, 2506766, 5998387, 7443627, 5202023, 4341814, 1, 3}, {7133694, 4087815, 5998387, 3165461, 5666084, 7575885, 1, 2}, {4818883, 4087815, 5998387, 3165461, 5666084, 7575885, 2, 1}, {13029355, 2506766, 5998387, 7443627, 5202023, 4341814, 1, 3}, {4818883, 4087815, 5998387, 3165461, 5666084, 7575885, 1, 1}, {7133694, 4087815, 5998387, 3165461, 5666084, 7575885, 2, 2}, {4818883, 4087815, 5998387, 3165461, 5666084, 7575885, 1, 1}, {13029355, 2506766, 5998387, 7443627, 5202023, 4341814, 1, 3}, {11653106, 2506766, 5998387, 7443627, 5202023, 4341814, 1, 0}, {7133694, 2506766, 5998387, 7443627, 5202023, 4341814, 2, 2}, {13029355, 2506766, 5998387, 7443627, 5202023, 4341814, 3, 3}};
        maxLaps = 4;
        writeCursor = -1;
        readCursor = 0;
        lastEvent = -1L;
        currEvent = -1;
    }
}

