/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;
import javax.microedition.lcdui.Image;

public class CGlobals {
    public static final int PLT_MASK = 1347179589;
    static byte num_files;
    static byte[][] files;
    static boolean loaded_all;
    static boolean[] file_loaded;
    static String libname;
    static InputStream lib_is;
    static int fileIndex;
    public static Random randomizer;

    public static String[] loadString(String resourseFile, InputStream in) {
        InputStream is = null;
        try {
            is = in != null ? in : "".getClass().getResourceAsStream(resourseFile);
        }
        catch (Exception ioe) {
            ioe.getMessage();
        }
        DataInputStream dis = new DataInputStream(is);
        int nrString = 0;
        try {
            nrString = dis.readUnsignedByte();
            nrString += dis.readUnsignedByte() << 8;
            nrString += dis.readUnsignedByte() << 16;
            nrString += dis.readUnsignedByte() << 24;
        }
        catch (IOException ex) {
            // empty catch block
        }
        String[] stringuri = new String[nrString];
        for (int i = 0; i < nrString; ++i) {
            StringBuffer strB = new StringBuffer();
            int nrCar = 0;
            try {
                int ii;
                byte[] byteTmp = new byte[2];
                for (ii = 0; ii < 2; ++ii) {
                    byteTmp[ii] = dis.readByte();
                }
                for (ii = 1; ii >= 0; --ii) {
                    nrCar = (nrCar << 8) + (byteTmp[ii] & 0xFF);
                }
                for (ii = 0; ii < nrCar; ++ii) {
                    strB.append((char)dis.readByte());
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            stringuri[i] = strB.toString();
        }
        is = null;
        return stringuri;
    }

    static int getHEADER(int header, byte[] pngTemp) {
        for (int i = 0; i < pngTemp.length; ++i) {
            long actualValue = 0L;
            for (int j = i; j < i + 4; ++j) {
                actualValue += (long)((pngTemp[j] & 0xFF) << 8 * (3 - (j - i)));
            }
            if (actualValue != (long)header) continue;
            return i;
        }
        return -1;
    }

    public static Image getImg(InputStream is, int image_id, int plt_number) {
        try {
            is.skip(1 + 2 * image_id);
            short image_offset = CGlobals.readShort(is);
            is.skip(image_offset - (3 + 2 * image_id));
            short image_len = CGlobals.readShort(is);
            byte[] imageTemp = new byte[image_len];
            is.read(imageTemp);
            if (plt_number == 0) {
                Image image = Image.createImage((byte[])imageTemp, (int)0, (int)imageTemp.length);
                imageTemp = null;
                System.gc();
                return image;
            }
            int plt_offset = CGlobals.getHEADER(1347179589, imageTemp) - 4;
            int nb_colors = ((imageTemp[plt_offset + 3] & 0xFF) + ((imageTemp[plt_offset + 2] & 0xFF) << 8) + ((imageTemp[plt_offset + 1] & 0xFF) << 16) + ((imageTemp[plt_offset] & 0xFF) << 24)) / 3;
            is.skip(1L);
            is.skip((plt_number - 1) * (3 * nb_colors + 4));
            plt_offset += 8;
            for (int i = 0; i < 3 * nb_colors + 4; ++i) {
                imageTemp[plt_offset + i] = CGlobals.readByte(is);
            }
            Image image = Image.createImage((byte[])imageTemp, (int)0, (int)image_len);
            return image;
        }
        catch (Exception e) {
            System.out.println("eroare fisier de resurse " + e.toString());
            return null;
        }
    }

    public static InputStream getFile(int index) {
        if (!loaded_all && !file_loaded[index]) {
            CGlobals.files[index] = CGlobals.readBuffer(index);
        }
        return new ByteArrayInputStream(files[index]);
    }

    public static byte[] getBuffer(int index) {
        if (!loaded_all && !file_loaded[index]) {
            CGlobals.files[index] = CGlobals.readBuffer(index);
        }
        return files[index];
    }

    public static byte[] readBuffer(int index) {
        byte[] buff = null;
        if (index <= fileIndex) {
            try {
                if (lib_is.markSupported()) {
                    lib_is.reset();
                } else {
                    lib_is = ((Object)((Object)CMIDlet.pMIDlet)).getClass().getResourceAsStream(libname);
                }
                num_files = CGlobals.readByte(lib_is);
                fileIndex = -1;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        for (int i = 0; i < index - fileIndex - 1; ++i) {
            int length = CGlobals.readShort(lib_is);
            if (length < 0) {
                length += 65536;
            }
            try {
                lib_is.skip(length);
                continue;
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        int length = CGlobals.readShort(lib_is);
        if (length < 0) {
            length += 65536;
        }
        buff = new byte[length];
        for (int j = 0; j < length; ++j) {
            try {
                buff[j] = (byte)lib_is.read();
                continue;
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        CGlobals.file_loaded[index] = true;
        fileIndex = index;
        return buff;
    }

    public static void loadLib(String library, boolean _loaded_all) {
        if (library.compareTo(libname) == 0 && loaded_all == _loaded_all) {
            return;
        }
        System.out.println("loadlib " + library);
        loaded_all = _loaded_all;
        libname = library;
        try {
            lib_is = ((Object)((Object)CMIDlet.pMIDlet)).getClass().getResourceAsStream(library);
            num_files = CGlobals.readByte(lib_is);
            files = null;
            files = new byte[num_files][1];
            file_loaded = new boolean[num_files];
            fileIndex = -1;
            if (!loaded_all) {
                return;
            }
            for (int i = 0; i < num_files; ++i) {
                int length = CGlobals.readShort(lib_is);
                if (length < 0) {
                    length += 65536;
                }
                CGlobals.files[i] = new byte[length];
                for (int j = 0; j < length; ++j) {
                    CGlobals.files[i][j] = (byte)lib_is.read();
                }
                CGlobals.file_loaded[i] = true;
            }
            lib_is.close();
            lib_is = null;
        }
        catch (Exception e) {
            System.out.println("openLib: " + e.toString());
        }
    }

    public static void closeFile(int index) {
        if (files == null || files[index] == null) {
            return;
        }
        CGlobals.files[index] = null;
        libname = "";
        CGlobals.file_loaded[index] = false;
    }

    public static void closeAll() {
        for (int i = 0; i < num_files; ++i) {
            CGlobals.closeFile(i);
        }
        files = null;
    }

    public static String readLine(InputStream is) {
        StringBuffer str = new StringBuffer();
        try {
            byte[] b = new byte[1];
            while (is.read(b) != -1) {
                if (b[0] == 13) {
                    is.read(b);
                    break;
                }
                str.append(new String(b));
            }
        }
        catch (IOException e) {
            System.err.println("error reading in readLine:\n" + e.toString());
        }
        System.err.println("strread(" + str.toString() + ")");
        return str.toString();
    }

    public static void writeByte(OutputStream out, byte val) {
        try {
            out.write(val);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void writeShort(OutputStream out, short val) {
        byte[] buf = new byte[]{(byte)(val & 0xFF), (byte)(val >> 8 & 0xFF)};
        try {
            out.write(buf);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void writeInt(OutputStream out, int val) {
        byte[] buf = new byte[]{(byte)(val & 0xFF), (byte)(val >> 8 & 0xFF), (byte)(val >> 16 & 0xFF), (byte)(val >> 24 & 0xFF)};
        try {
            out.write(buf);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static void writeLong(OutputStream out, long val) {
        byte[] buf = new byte[]{(byte)(val & 0xFFL), (byte)(val >> 8 & 0xFFL), (byte)(val >> 16 & 0xFFL), (byte)(val >> 24 & 0xFFL), (byte)(val >> 32 & 0xFFL), (byte)(val >> 40 & 0xFFL), (byte)(val >> 48 & 0xFFL), (byte)(val >> 56 & 0xFFL)};
        try {
            out.write(buf);
        }
        catch (IOException ex) {
            // empty catch block
        }
    }

    public static byte readByte(InputStream is) {
        byte retval = 0;
        try {
            retval = (byte)is.read();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retval;
    }

    public static short readUnsignedByte(InputStream is) {
        short retval = 0;
        try {
            retval = (byte)is.read();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (retval < 0) {
            retval = (short)(retval + 256);
        }
        return retval;
    }

    public static short readShort(InputStream is) {
        int retval = 0;
        try {
            retval = is.read() + (is.read() << 8);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (short)retval;
    }

    public static int readInt(InputStream is) {
        int retval = 0;
        try {
            retval = is.read();
            retval += is.read() << 8;
            retval += is.read() << 16;
            retval += is.read() << 24;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retval;
    }

    public static long readLong(InputStream is) {
        long retval = 0L;
        try {
            retval = is.read();
            retval += (long)(is.read() << 8);
            retval += (long)(is.read() << 16);
            retval += (long)(is.read() << 24);
            retval += (long)(is.read() << 32);
            retval += (long)(is.read() << 40);
            retval += (long)(is.read() << 48);
            retval += (long)(is.read() << 56);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retval;
    }

    public static int distance(int dx, int dy) {
        int max;
        int min;
        if (dx < 0) {
            dx = -dx;
        }
        if (dy < 0) {
            dy = -dy;
        }
        if (dx < dy) {
            min = dx;
            max = dy;
        } else {
            min = dy;
            max = dx;
        }
        return (max << 8) + (max << 3) - (max << 4) - (max << 1) + (min << 7) - (min << 5) + (min << 3) - (min << 1) >> 8;
    }

    public static boolean intersectSide(int x1, int x2, int a1, int a2) {
        return x1 < a1 && x2 > a1 || x1 < a2 && x2 > a2 || x1 > a1 && x2 < a2;
    }

    public static int randInt(int limit) {
        return Math.abs(randomizer.nextInt() % limit);
    }

    public static int randInt(int a, int b) {
        return a + CGlobals.randInt(b - a);
    }

    public static int signe(int a) {
        if (a > 0) {
            return 1;
        }
        if (a < 0) {
            return -1;
        }
        return 0;
    }

    static {
        loaded_all = false;
        file_loaded = null;
        libname = "";
        lib_is = null;
        fileIndex = -1;
        randomizer = new Random(System.currentTimeMillis());
    }
}

