/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.memory;

import org.jpc.emulator.memory.AbstractMemory;
import org.jpc.emulator.memory.Memory;

public abstract class AddressSpace
extends AbstractMemory {
    public static final int BLOCK_SIZE = 4096;
    public static final int BLOCK_MASK = 4095;
    public static final int INDEX_MASK = -4096;
    public static final int INDEX_SHIFT = 12;
    public static final int INDEX_SIZE = 0x100000;

    public final long getSize() {
        return 0x100000000L;
    }

    public final int getBlockStart(int n) {
        return n & 0xFFFFF000;
    }

    public final int getBlockEnd(int n) {
        return (n & 0xFFFFF000) + 4096;
    }

    public abstract Memory getReadMemoryBlockAt(int var1);

    public abstract Memory getWriteMemoryBlockAt(int var1);

    public abstract void clear();

    public byte getByte(int n) {
        return this.getReadMemoryBlockAt(n).getByte(n & 0xFFF);
    }

    public void setByte(int n, byte by) {
        this.getWriteMemoryBlockAt(n).setByte(n & 0xFFF, by);
    }

    public short getWord(int n) {
        try {
            return this.getReadMemoryBlockAt(n).getWord(n & 0xFFF);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return super.getWord(n);
        }
    }

    public int getDoubleWord(int n) {
        try {
            return this.getReadMemoryBlockAt(n).getDoubleWord(n & 0xFFF);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return super.getDoubleWord(n);
        }
    }

    public long getQuadWord(int n) {
        try {
            return this.getReadMemoryBlockAt(n).getQuadWord(n & 0xFFF);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return super.getQuadWord(n);
        }
    }

    public long getLowerDoubleQuadWord(int n) {
        try {
            return this.getReadMemoryBlockAt(n).getLowerDoubleQuadWord(n & 0xFFF);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return super.getLowerDoubleQuadWord(n);
        }
    }

    public long getUpperDoubleQuadWord(int n) {
        try {
            return this.getReadMemoryBlockAt(n).getUpperDoubleQuadWord(n & 0xFFF);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return super.getUpperDoubleQuadWord(n);
        }
    }

    public void setWord(int n, short s) {
        try {
            this.getWriteMemoryBlockAt(n).setWord(n & 0xFFF, s);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            super.setWord(n, s);
        }
    }

    public void setDoubleWord(int n, int n2) {
        try {
            this.getWriteMemoryBlockAt(n).setDoubleWord(n & 0xFFF, n2);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            super.setDoubleWord(n, n2);
        }
    }

    public void setQuadWord(int n, long l) {
        try {
            this.getWriteMemoryBlockAt(n).setQuadWord(n & 0xFFF, l);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            super.setQuadWord(n, l);
        }
    }

    public void setLowerDoubleQuadWord(int n, long l) {
        try {
            this.getWriteMemoryBlockAt(n).setLowerDoubleQuadWord(n & 0xFFF, l);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            super.setLowerDoubleQuadWord(n, l);
        }
    }

    public void setUpperDoubleQuadWord(int n, long l) {
        try {
            this.getWriteMemoryBlockAt(n).setUpperDoubleQuadWord(n & 0xFFF, l);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            super.setUpperDoubleQuadWord(n, l);
        }
    }

    public void copyContentsFrom(int n, byte[] byArray, int n2, int n3) {
        int n4;
        do {
            n4 = Math.min(4096 - (n & 0xFFF), n3);
            this.getWriteMemoryBlockAt(n).copyContentsFrom(n & 0xFFF, byArray, n2, n4);
            n += n4;
            n2 += n4;
        } while ((n3 -= n4) > 0);
    }

    public void copyContentsInto(int n, byte[] byArray, int n2, int n3) {
        int n4;
        do {
            n4 = Math.min(4096 - (n & 0xFFF), n3);
            this.getReadMemoryBlockAt(n).copyContentsInto(n & 0xFFF, byArray, n2, n4);
            n += n4;
            n2 += n4;
        } while ((n3 -= n4) > 0);
    }

    abstract void replaceBlocks(Memory var1, Memory var2);
}

