/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.memory.codeblock;

import java.util.Enumeration;
import java.util.Hashtable;
import org.jpc.emulator.memory.ByteArray;
import org.jpc.emulator.memory.SimpleByteArray;
import org.jpc.emulator.memory.codeblock.ObjectTreeVisitor;

public class ObjectTree {
    private Node root;
    private Hashtable leafIndex = new Hashtable();

    public ObjectTree() {
        this.clearAllObjects();
    }

    public void clearAllObjects() {
        this.root = new WideNode();
    }

    public Object getObject(ByteArray byteArray, int n) {
        return this.root.getObject(byteArray, n);
    }

    public void setObject(ByteArray byteArray, int n, Object object, int n2) {
        this.root = this.root.setObject(object, byteArray, n, n + n2 - 1);
    }

    public void visitNodes(ObjectTreeVisitor objectTreeVisitor) {
        if (this.root != null) {
            this.root.visitNodes(objectTreeVisitor);
        }
    }

    public void printTree() {
        this.root.print("");
    }

    public static class LeafNode
    extends Node {
        private int useageCount = 1;
        private Object obj;

        LeafNode(Object object) {
            this.obj = object;
        }

        public Node setNode(Node node, ByteArray byteArray, int n, int n2) {
            throw new IllegalStateException("Setting node on a leaf");
        }

        public Node getNode(ByteArray byteArray, int n) {
            throw new IllegalStateException("Getting a node from a leaf");
        }

        public Object getObject(ByteArray byteArray, int n) {
            ++this.useageCount;
            return this.obj;
        }

        public Node setObject(Object object, ByteArray byteArray, int n, int n2) {
            this.useageCount = 1;
            this.obj = object;
            return this;
        }

        public int size() {
            return 0;
        }

        public int getUsageCount() {
            return this.useageCount;
        }

        public Object peekObject() {
            return this.obj;
        }

        public void print(String string) {
            System.out.println(string + "Leaf[" + this.obj + "]");
        }
    }

    public static class SequenceNode
    extends Node {
        byte[] sequence;
        Node child;

        public SequenceNode(Node node, ByteArray byteArray, int n, int n2) {
            this.child = node;
            this.sequence = new byte[n2 - n + 1];
            byteArray.copyContentsInto(n, this.sequence, 0, this.sequence.length);
        }

        public int size() {
            return 1;
        }

        public Node setNode(Node node, ByteArray byteArray, int n, int n2) {
            for (int i = 0; i < this.sequence.length; ++i) {
                if (byteArray.getByte(n + i) == this.sequence[i]) continue;
                BinaryNode binaryNode = new BinaryNode();
                SimpleByteArray simpleByteArray = new SimpleByteArray(this.sequence);
                Node node2 = null;
                node2 = i + 1 == this.sequence.length ? this.child : new SequenceNode(this.child, simpleByteArray, i + 1, this.sequence.length - 1);
                Node node3 = null;
                node3 = n + i == n2 ? node : new SequenceNode(node, byteArray, n + i + 1, n2);
                binaryNode.setNode(node2, simpleByteArray, i, i);
                binaryNode.setNode(node3, byteArray, n + i, n + i);
                if (i == 0) {
                    return binaryNode;
                }
                return new SequenceNode(binaryNode, simpleByteArray, 0, i - 1);
            }
            if (node == null) {
                return null;
            }
            this.child = node;
            return this;
        }

        public Node getNode(ByteArray byteArray, int n) {
            for (int i = 0; i < this.sequence.length; ++i) {
                if (byteArray.getByte(n + i) == this.sequence[i]) continue;
                return null;
            }
            return this.child;
        }

        public Object getObject(ByteArray byteArray, int n) {
            Node node = this.getNode(byteArray, n);
            if (node == null) {
                return null;
            }
            return node.getObject(byteArray, n + this.sequence.length);
        }

        public Node setObject(Object object, ByteArray byteArray, int n, int n2) {
            Node node = this.getNode(byteArray, n);
            if (node == null) {
                return this.setNode(new LeafNode(object), byteArray, n, n2);
            }
            Node node2 = node.setObject(object, byteArray, n + this.sequence.length, n2);
            if (node2 == node) {
                return this;
            }
            return this.setNode(node2, byteArray, n, n2);
        }

        public void print(String string) {
            String string2 = "";
            if (this.sequence == null) {
                string2 = "[null]";
            } else {
                for (int i = 0; i < this.sequence.length; ++i) {
                    string2 = string2 + String.valueOf(this.sequence[i]) + ",";
                }
                string2 = string2 + "]";
            }
            System.out.println(string + "SEQ" + string2);
            this.child.print(string + " ");
        }
    }

    public static class SingularNode
    extends Node {
        private Node childNode;
        private byte childIndex;
        private boolean childUsed = false;

        SingularNode() {
        }

        public int size() {
            if (this.childUsed) {
                return 1;
            }
            return 0;
        }

        public Node setNode(Node node, ByteArray byteArray, int n, int n2) {
            byte by = byteArray.getByte(n);
            if (!this.childUsed || this.childUsed && this.childIndex == by) {
                if (node == null) {
                    return null;
                }
                this.childIndex = by;
                this.childNode = node;
                this.childUsed = true;
                return this;
            }
            Node node2 = new BinaryNode();
            SimpleByteArray simpleByteArray = new SimpleByteArray(1);
            simpleByteArray.setByte(0, this.childIndex);
            node2 = node2.setNode(this.childNode, simpleByteArray, 0, 0);
            node2 = node2.setNode(node, byteArray, n, n2);
            return node2;
        }

        public Node getNode(ByteArray byteArray, int n) {
            if (this.childIndex == byteArray.getByte(n)) {
                return this.childNode;
            }
            return null;
        }

        public boolean visitNodes(ObjectTreeVisitor objectTreeVisitor) {
            if (!super.visitNodes(objectTreeVisitor)) {
                return false;
            }
            return this.childNode == null || this.childNode.visitNodes(objectTreeVisitor);
        }

        public void print(String string) {
            System.out.println(string + "SINGLE!!!!");
        }
    }

    public static class BinaryNode
    extends Node {
        private Node leftNode;
        private Node rightNode;
        private byte leftIndex;
        private byte rightIndex;
        private boolean leftUsed = false;
        private boolean rightUsed = false;

        BinaryNode() {
        }

        public int size() {
            if (this.leftUsed && this.rightUsed) {
                return 2;
            }
            if (this.leftUsed || this.rightUsed) {
                return 1;
            }
            return 0;
        }

        public Node setNode(Node node, ByteArray byteArray, int n, int n2) {
            byte by = byteArray.getByte(n);
            boolean bl = false;
            if (!this.leftUsed || this.leftUsed && this.leftIndex == by) {
                this.leftIndex = by;
                this.leftNode = node;
                this.leftUsed = true;
                if (node == null) {
                    this.leftUsed = false;
                }
                bl = true;
            } else if (!this.rightUsed || this.rightUsed && this.rightIndex == by) {
                this.rightIndex = by;
                this.rightNode = node;
                this.rightUsed = true;
                if (node == null) {
                    this.rightUsed = false;
                }
                bl = true;
            }
            if (this.size() == 0) {
                return null;
            }
            if (bl) {
                return this;
            }
            Node node2 = new NarrowNode();
            SimpleByteArray simpleByteArray = new SimpleByteArray(1);
            simpleByteArray.setByte(0, this.leftIndex);
            node2 = node2.setNode(this.leftNode, simpleByteArray, 0, 0);
            simpleByteArray.setByte(0, this.rightIndex);
            node2 = node2.setNode(this.rightNode, simpleByteArray, 0, 0);
            node2 = node2.setNode(node, byteArray, n, n2);
            return node2;
        }

        public Node getNode(ByteArray byteArray, int n) {
            byte by = byteArray.getByte(n);
            if (this.leftIndex == by && this.leftUsed) {
                return this.leftNode;
            }
            if (this.rightIndex == by && this.rightUsed) {
                return this.rightNode;
            }
            return null;
        }

        public boolean visitNodes(ObjectTreeVisitor objectTreeVisitor) {
            if (!super.visitNodes(objectTreeVisitor)) {
                return false;
            }
            if (this.rightNode != null && !this.rightNode.visitNodes(objectTreeVisitor)) {
                return false;
            }
            return this.leftNode == null || this.leftNode.visitNodes(objectTreeVisitor);
        }

        public void print(String string) {
            System.out.println(string + "Binary[" + this.leftIndex + " " + this.rightIndex + "]");
            if (this.leftNode != null) {
                this.leftNode.print(string + " ");
            }
            if (this.rightNode != null) {
                this.rightNode.print(string + " ");
            }
        }
    }

    public static class NarrowNode
    extends Node {
        private Hashtable nodes = new Hashtable(0);

        NarrowNode() {
        }

        public int size() {
            return this.nodes.size();
        }

        public Node getNode(ByteArray byteArray, int n) {
            Byte by = new Byte(byteArray.getByte(n));
            return (Node)this.nodes.get(by);
        }

        public Node setNode(Node node, ByteArray byteArray, int n, int n2) {
            Byte by = new Byte(byteArray.getByte(n));
            if (node == null) {
                this.nodes.remove(by);
                if (this.nodes.size() == 0) {
                    return null;
                }
                return this;
            }
            this.nodes.put(by, node);
            if (this.nodes.size() <= 8) {
                return this;
            }
            Node node2 = new WideNode();
            SimpleByteArray simpleByteArray = new SimpleByteArray(1);
            Enumeration enumeration = this.nodes.keys();
            while (enumeration.hasMoreElements()) {
                Byte by2 = (Byte)enumeration.nextElement();
                Node node3 = (Node)this.nodes.get(by2);
                simpleByteArray.setByte(0, by2);
                node2 = node2.setNode(node3, simpleByteArray, 0, 0);
            }
            node2 = node2.setNode(node, byteArray, n, n2);
            return node2;
        }

        public boolean visitNodes(ObjectTreeVisitor objectTreeVisitor) {
            if (!super.visitNodes(objectTreeVisitor)) {
                return false;
            }
            Enumeration enumeration = this.nodes.keys();
            while (enumeration.hasMoreElements()) {
                Integer n = (Integer)enumeration.nextElement();
                Node node = (Node)this.nodes.get(n);
                if (((Node)this.nodes.get(n)).visitNodes(objectTreeVisitor)) continue;
                return false;
            }
            return true;
        }
    }

    public static class WideNode
    extends Node {
        private int valid = 0;
        private Node[] nodes = new Node[256];

        WideNode() {
        }

        public int size() {
            return this.valid;
        }

        public Node setNode(Node node, ByteArray byteArray, int n, int n2) {
            int n3 = 0xFF & byteArray.getByte(n);
            if (this.nodes[n3] == null) {
                ++this.valid;
            }
            this.nodes[n3] = node;
            if (node == null) {
                --this.valid;
            }
            return this;
        }

        public Node getNode(ByteArray byteArray, int n) {
            int n2 = 0xFF & byteArray.getByte(n);
            return this.nodes[n2];
        }

        public boolean visitNodes(ObjectTreeVisitor objectTreeVisitor) {
            if (!super.visitNodes(objectTreeVisitor)) {
                return false;
            }
            for (int i = 0; i < this.nodes.length; ++i) {
                if (this.nodes[i] == null || this.nodes[i].visitNodes(objectTreeVisitor)) continue;
                return false;
            }
            return true;
        }

        public void print(String string) {
            System.out.println(string + "Wide Node");
            for (int i = 0; i < this.nodes.length; ++i) {
                if (this.nodes[i] == null) continue;
                System.out.println(string + i);
                this.nodes[i].print(string + " ");
            }
        }
    }

    public static abstract class Node {
        static final int MAX_NARROW_SIZE = 8;

        public abstract int size();

        public abstract Node setNode(Node var1, ByteArray var2, int var3, int var4);

        public abstract Node getNode(ByteArray var1, int var2);

        public Object getObject(ByteArray byteArray, int n) {
            Node node = this.getNode(byteArray, n);
            if (node == null) {
                return null;
            }
            return node.getObject(byteArray, n + 1);
        }

        public Node setObject(Object object, ByteArray byteArray, int n, int n2) {
            Node node = this.getNode(byteArray, n);
            if (node == null) {
                node = new SequenceNode(new LeafNode(object), byteArray, n + 1, n2);
                return this.setNode(node, byteArray, n, n2);
            }
            Node node2 = node.setObject(object, byteArray, n + 1, n2);
            if (node2 == node) {
                return this;
            }
            return this.setNode(node2, byteArray, n, n2);
        }

        public boolean visitNodes(ObjectTreeVisitor objectTreeVisitor) {
            return objectTreeVisitor.visitNode(this);
        }

        public void print(String string) {
            System.out.println(string + this.getClass().getName());
        }
    }
}

