/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.memory.codeblock;

import java.util.Enumeration;
import java.util.Hashtable;
import org.jpc.emulator.memory.codeblock.ObjectTreeStateMachineVisitor;

public class ObjectTreeStateMachine {
    private Node root;
    private Node currentNode;
    private Node currentParent;
    private int parentIndex;

    public ObjectTreeStateMachine() {
        this.clearAllObjects();
        this.resetTreeState();
    }

    public void clearAllObjects() {
        this.root = new WideNode();
    }

    public void resetTreeState() {
        this.currentNode = this.root;
        this.currentParent = null;
    }

    public boolean stepTree(int n) {
        if (this.currentNode == null) {
            throw new IllegalStateException("Null Current Node?!");
        }
        Node node = this.currentNode.getNode(n);
        boolean bl = false;
        if (node == null) {
            bl = true;
            node = new SingularNode();
            Node node2 = this.currentNode.setNode(node, n);
            if (node2 == null) {
                throw new IllegalStateException("Null Current Node?!");
            }
            if (this.currentParent != null && node2 != this.currentNode) {
                this.currentParent.setNode(node2, this.parentIndex);
                this.currentNode = node2;
            }
        }
        this.currentParent = this.currentNode;
        this.parentIndex = n;
        this.currentNode = node;
        return !bl;
    }

    public Object getObjectAtState() {
        if (this.currentNode == null) {
            return null;
        }
        return this.currentNode.getObject();
    }

    public void setObjectAtState(Object object) {
        if (this.currentNode == null) {
            throw new IllegalStateException("Cannot Add Object To null Node");
        }
        this.currentNode.setObject(object);
    }

    public void visitNodes(ObjectTreeStateMachineVisitor objectTreeStateMachineVisitor) {
        if (this.root != null) {
            this.root.visitNodes(objectTreeStateMachineVisitor);
        }
    }

    public void printTree() {
        this.root.print("");
    }

    public static class SingularNode
    extends Node {
        private Node childNode = null;
        private int childIndex;

        SingularNode() {
        }

        public int size() {
            if (this.childNode != null) {
                return 1;
            }
            return 0;
        }

        public Node setNode(Node node, int n) {
            if (this.childNode == null || this.childIndex == n) {
                this.childIndex = n;
                this.childNode = node;
                return this;
            }
            Node node2 = new BinaryNode();
            node2 = node2.setNode(this.childNode, this.childIndex);
            node2 = node2.setNode(node, n);
            return node2;
        }

        public Node getNode(int n) {
            if (this.childIndex == n) {
                return this.childNode;
            }
            return null;
        }

        public boolean visitNodes(ObjectTreeStateMachineVisitor objectTreeStateMachineVisitor) {
            if (!super.visitNodes(objectTreeStateMachineVisitor)) {
                return false;
            }
            return this.childNode == null || this.childNode.visitNodes(objectTreeStateMachineVisitor);
        }

        public void print(String string) {
            super.print(string);
            System.out.println(string + "[" + this.childIndex + "]");
            if (this.childNode != null) {
                this.childNode.print(string + " ");
            }
        }
    }

    public static class BinaryNode
    extends Node {
        private Node leftNode = null;
        private Node rightNode = null;
        private int leftIndex;
        private int rightIndex;

        BinaryNode() {
        }

        public int size() {
            if (this.leftNode != null && this.rightNode != null) {
                return 2;
            }
            if (this.leftNode != null || this.rightNode != null) {
                return 1;
            }
            return 0;
        }

        public Node setNode(Node node, int n) {
            boolean bl = false;
            if (this.leftNode == null || this.leftIndex == n) {
                this.leftIndex = n;
                this.leftNode = node;
                bl = true;
            } else if (this.rightNode == null || this.rightIndex == n) {
                this.rightIndex = n;
                this.rightNode = node;
                bl = true;
            }
            if (bl) {
                return this;
            }
            Node node2 = new NarrowNode();
            node2 = node2.setNode(this.leftNode, this.leftIndex);
            node2 = node2.setNode(this.rightNode, this.rightIndex);
            node2 = node2.setNode(node, n);
            return node2;
        }

        public Node getNode(int n) {
            if (this.leftIndex == n) {
                return this.leftNode;
            }
            if (this.rightIndex == n) {
                return this.rightNode;
            }
            return null;
        }

        public boolean visitNodes(ObjectTreeStateMachineVisitor objectTreeStateMachineVisitor) {
            if (!super.visitNodes(objectTreeStateMachineVisitor)) {
                return false;
            }
            if (this.rightNode != null && !this.rightNode.visitNodes(objectTreeStateMachineVisitor)) {
                return false;
            }
            return this.leftNode == null || this.leftNode.visitNodes(objectTreeStateMachineVisitor);
        }

        public void print(String string) {
            super.print(string);
            System.out.println(string + "[" + this.leftIndex + " " + this.rightIndex + "]");
            if (this.leftNode != null) {
                this.leftNode.print(string + " ");
            }
            if (this.rightNode != null) {
                this.rightNode.print(string + " ");
            }
        }
    }

    public static class NarrowNode
    extends Node {
        private Hashtable nodes = new Hashtable(0);

        NarrowNode() {
        }

        public int size() {
            return this.nodes.size();
        }

        public Node setNode(Node node, int n) {
            if (node == null) {
                this.nodes.remove(new Integer(n));
                return this;
            }
            this.nodes.put(new Integer(n), node);
            if (this.nodes.size() <= 8) {
                return this;
            }
            Node node2 = new WideNode();
            Enumeration enumeration = this.nodes.keys();
            while (enumeration.hasMoreElements()) {
                Integer n2 = (Integer)enumeration.nextElement();
                node2 = ((Node)node2).setNode((Node)this.nodes.get(n2), n2);
            }
            node2 = ((Node)node2).setNode(node, n);
            return node2;
        }

        public Node getNode(int n) {
            return (Node)this.nodes.get(new Integer(n));
        }

        public boolean visitNodes(ObjectTreeStateMachineVisitor objectTreeStateMachineVisitor) {
            if (!super.visitNodes(objectTreeStateMachineVisitor)) {
                return false;
            }
            Enumeration enumeration = this.nodes.keys();
            while (enumeration.hasMoreElements()) {
                Integer n = (Integer)enumeration.nextElement();
                Node node = (Node)this.nodes.get(n);
                if (((Node)this.nodes.get(n)).visitNodes(objectTreeStateMachineVisitor)) continue;
                return false;
            }
            return true;
        }

        public void print(String string) {
            super.print(string);
            Enumeration enumeration = this.nodes.keys();
            System.out.print("[");
            while (enumeration.hasMoreElements()) {
                Integer n = (Integer)enumeration.nextElement();
                ((Node)this.nodes.get(n)).print(string + " ");
                System.out.print(n + ", ");
            }
        }
    }

    public static class WideNode
    extends Node {
        private int valid = 0;
        private Node[] nodes = new Node[700];
        private Hashtable mappedNodes = null;

        WideNode() {
        }

        public int size() {
            if (this.mappedNodes == null) {
                return this.valid;
            }
            return this.mappedNodes.size() + this.valid;
        }

        public Node setNode(Node node, int n) {
            try {
                if (this.nodes[n] == null) {
                    ++this.valid;
                }
                this.nodes[n] = node;
                if (node == null) {
                    --this.valid;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (this.mappedNodes == null) {
                    this.mappedNodes = new Hashtable(0);
                }
                this.mappedNodes.put(new Integer(n), node);
            }
            return this;
        }

        public Node getNode(int n) {
            try {
                return this.nodes[n];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (this.mappedNodes != null) {
                    return (Node)this.mappedNodes.get(new Integer(n));
                }
                return null;
            }
        }

        public boolean visitNodes(ObjectTreeStateMachineVisitor objectTreeStateMachineVisitor) {
            if (!super.visitNodes(objectTreeStateMachineVisitor)) {
                return false;
            }
            for (int i = 0; i < this.nodes.length; ++i) {
                if (this.nodes[i] == null || this.nodes[i].visitNodes(objectTreeStateMachineVisitor)) continue;
                return false;
            }
            if (this.mappedNodes != null) {
                Enumeration enumeration = this.mappedNodes.keys();
                while (enumeration.hasMoreElements()) {
                    Integer n = (Integer)enumeration.nextElement();
                    Node node = (Node)this.mappedNodes.get(n);
                    if (((Node)this.mappedNodes.get(n)).visitNodes(objectTreeStateMachineVisitor)) continue;
                    return false;
                }
            }
            return true;
        }

        public void print(String string) {
            super.print(string);
            for (int i = 0; i < this.nodes.length; ++i) {
                if (this.nodes[i] == null) continue;
                System.out.print(string + i);
                this.nodes[i].print(string + " ");
            }
            if (this.mappedNodes != null) {
                Enumeration enumeration = this.mappedNodes.keys();
                System.out.print("[");
                while (enumeration.hasMoreElements()) {
                    Integer n = (Integer)enumeration.nextElement();
                    ((Node)this.mappedNodes.get(n)).print(string + " ");
                    System.out.print(n + ", ");
                }
                System.out.println("]");
            }
        }
    }

    public static abstract class Node {
        static final int MAX_NARROW_SIZE = 8;
        static final int MAX_WIDE_SIZE = 700;
        protected int useageCount;
        protected Object obj;

        Node() {
            this.useageCount = 0;
            this.obj = null;
        }

        Node(Object object) {
            this.useageCount = 1;
            this.obj = object;
        }

        public abstract int size();

        public abstract Node setNode(Node var1, int var2);

        public abstract Node getNode(int var1);

        public Object getObject() {
            ++this.useageCount;
            return this.obj;
        }

        public void setObject(Object object) {
            this.useageCount = 1;
            this.obj = object;
        }

        public int getUsageCount() {
            return this.useageCount;
        }

        public Object peekObject() {
            return this.obj;
        }

        public boolean visitNodes(ObjectTreeStateMachineVisitor objectTreeStateMachineVisitor) {
            return objectTreeStateMachineVisitor.visitNode(this);
        }

        public void print(String string) {
            System.out.println(string + this.getClass().getName() + "(" + this.size() + ")");
        }
    }
}

