/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.pci.peripheral;

import org.jpc.emulator.pci.AbstractPCIDevice;
import org.jpc.emulator.pci.ByteBuffer;
import org.jpc.emulator.pci.IOPortIORegion;
import org.jpc.emulator.pci.IORegion;
import org.jpc.support.EthernetOutput;

public class EthernetCard
extends AbstractPCIDevice {
    private static final int MAX_ETH_FRAME_SIZE = 1514;
    private static final int E8390_CMD = 0;
    private static final int EN0_CLDALO = 1;
    private static final int EN0_STARTPG = 1;
    private static final int EN0_CLDAHI = 2;
    private static final int EN0_STOPPG = 2;
    private static final int EN0_BOUNDARY = 3;
    private static final int EN0_TSR = 4;
    private static final int EN0_TPSR = 4;
    private static final int EN0_NCR = 5;
    private static final int EN0_TCNTLO = 5;
    private static final int EN0_FIFO = 6;
    private static final int EN0_TCNTHI = 6;
    private static final int EN0_ISR = 7;
    private static final int EN0_CRDALO = 8;
    private static final int EN0_RSARLO = 8;
    private static final int EN0_CRDAHI = 9;
    private static final int EN0_RSARHI = 9;
    private static final int EN0_RCNTLO = 10;
    private static final int EN0_RCNTHI = 11;
    private static final int EN0_RSR = 12;
    private static final int EN0_RXCR = 12;
    private static final int EN0_TXCR = 13;
    private static final int EN0_COUNTER0 = 13;
    private static final int EN0_DCFG = 14;
    private static final int EN0_COUNTER1 = 14;
    private static final int EN0_IMR = 15;
    private static final int EN0_COUNTER2 = 15;
    private static final int EN1_PHYS = 17;
    private static final int EN1_CURPAG = 23;
    private static final int EN1_MULT = 24;
    private static final byte E8390_STOP = 1;
    private static final byte E8390_START = 2;
    private static final byte E8390_TRANS = 4;
    private static final byte E8390_RREAD = 8;
    private static final byte E8390_RWRITE = 16;
    private static final byte E8390_NODMA = 32;
    private static final byte E8390_PAGE0 = 0;
    private static final byte E8390_PAGE1 = 64;
    private static final byte E8390_PAGE2 = -128;
    private static final byte ENISR_RX = 1;
    private static final byte ENISR_TX = 2;
    private static final byte ENISR_RX_ERR = 4;
    private static final byte ENISR_TX_ERR = 8;
    private static final byte ENISR_OVER = 16;
    private static final byte ENISR_COUNTERS = 32;
    private static final byte ENISR_RDC = 64;
    private static final byte ENISR_RESET = -128;
    private static final byte ENISR_ALL = 63;
    private static final byte ENRSR_RXOK = 1;
    private static final byte ENRSR_CRC = 2;
    private static final byte ENRSR_FAE = 4;
    private static final byte ENRSR_FO = 8;
    private static final byte ENRSR_MPA = 16;
    private static final byte ENRSR_PHY = 32;
    private static final byte ENRSR_DIS = 64;
    private static final byte ENRSR_DEF = -128;
    private static final byte ENTSR_PTX = 1;
    private static final byte ENTSR_ND = 2;
    private static final byte ENTSR_COL = 4;
    private static final byte ENTSR_ABT = 8;
    private static final byte ENTSR_CRS = 16;
    private static final byte ENTSR_FU = 32;
    private static final byte ENTSR_CDH = 64;
    private static final byte ENTSR_OWC = -128;
    private static final int NE2000_PMEM_SIZE = 32768;
    private static final int NE2000_PMEM_START = 16384;
    private static final int NE2000_PMEM_END = 49152;
    private static final int NE2000_MEM_SIZE = 49152;
    private static boolean DEBUG = false;
    private byte command;
    private int start;
    private int stop;
    private byte boundary;
    private byte tsr;
    private byte tpsr;
    private short tcnt;
    private short rcnt;
    private int rsar;
    private byte rsr;
    private byte isr;
    private byte dcfg;
    private byte imr;
    private byte[] phys;
    private byte curpag;
    private byte[] mult;
    private int irq;
    EthernetOutput outputDevice;
    private ByteBuffer mem;
    private EthernetIORegion ioRegion;

    public EthernetCard() {
        this(null);
    }

    public EthernetCard(EthernetOutput ethernetOutput) {
        this.setIRQIndex(16);
        this.putConfigByte(0, (byte)-20);
        this.putConfigByte(1, (byte)16);
        this.putConfigByte(2, (byte)41);
        this.putConfigByte(3, (byte)-128);
        this.putConfigByte(10, (byte)0);
        this.putConfigByte(11, (byte)2);
        this.putConfigByte(14, (byte)0);
        this.putConfigByte(61, (byte)1);
        this.ioRegion = new EthernetIORegion();
        this.outputDevice = ethernetOutput;
        this.mem = new ByteBuffer(49152);
        this.phys = new byte[6];
        this.mult = new byte[8];
        this.internalReset();
    }

    public void reset() {
        this.putConfigByte(0, (byte)-20);
        this.putConfigByte(1, (byte)16);
        this.putConfigByte(2, (byte)41);
        this.putConfigByte(3, (byte)-128);
        this.putConfigByte(10, (byte)0);
        this.putConfigByte(11, (byte)2);
        this.putConfigByte(14, (byte)0);
        this.putConfigByte(61, (byte)1);
        this.mem = new ByteBuffer(49152);
        this.phys = new byte[6];
        this.mult = new byte[8];
        this.internalReset();
        super.reset();
    }

    private void internalReset() {
        this.setISR((byte)-128);
        this.mem.set(14, (byte)87);
        this.mem.set(15, (byte)87);
        for (int i = 15; i >= 0; --i) {
            this.mem.set(2 * i, this.mem.get(i));
            this.mem.set(2 * i + 1, this.mem.get(i));
        }
    }

    private void updateIRQ() {
        int n = this.getISR() & this.getIMR();
        if (n != 0) {
            this.getIRQBouncer().setIRQ(this, 0, 1);
        } else {
            this.getIRQBouncer().setIRQ(this, 0, 0);
        }
    }

    private int canReceive() {
        return 0;
    }

    public IORegion[] getIORegions() {
        return new IORegion[]{this.ioRegion};
    }

    public IORegion getIORegion(int n) {
        if (n == 0) {
            return this.ioRegion;
        }
        return null;
    }

    private void ioPortWrite(int n, byte by) {
        if ((n &= 0xF) == 0) {
            this.setCommand(by);
            if (0 != (by & 2)) {
                this.andISR((byte)127);
                if (0 != (by & 0x18) && this.getRCNT() == 0) {
                    this.orISR((byte)64);
                    this.updateIRQ();
                }
                if (0 != (by & 4)) {
                    this.getEthernetOutput().sendPacket(null, 0, 0);
                    this.setTSR((byte)1);
                    this.orISR((byte)2);
                    this.updateIRQ();
                }
            }
        } else {
            int n2 = this.getCommand() >> 6;
            int n3 = n | n2 << 4;
            switch (n3) {
                case 1: {
                    this.setStart(by << 8);
                    break;
                }
                case 2: {
                    this.setStop(by << 8);
                    break;
                }
                case 3: {
                    this.setBoundary(by);
                    break;
                }
                case 15: {
                    this.setIMR(by);
                    this.updateIRQ();
                    break;
                }
                case 4: {
                    this.setTPSR(by);
                    break;
                }
                case 5: {
                    this.setTCNT((short)(this.getTCNT() & 0xFF00 | by));
                    break;
                }
                case 6: {
                    this.setTCNT((short)(this.getTCNT() & 0xFF | by << 8));
                    break;
                }
                case 8: {
                    this.setRSAR(this.getRSAR() & 0xFF00 | by);
                    break;
                }
                case 9: {
                    this.setRSAR(this.getRSAR() & 0xFF | by << 8);
                    break;
                }
                case 10: {
                    this.setRCNT((short)(this.getRCNT() & 0xFF00 | by));
                    break;
                }
                case 11: {
                    this.setRCNT((short)(this.getRCNT() & 0xFF | by << 8));
                    break;
                }
                case 14: {
                    this.setDCfg(by);
                    break;
                }
                case 7: {
                    this.andISR((byte)(~(by & 0x7F)));
                    this.updateIRQ();
                    break;
                }
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: {
                    this.setPhysical(n3 - 17, by);
                    break;
                }
                case 23: {
                    this.setCurrentPage(by);
                    break;
                }
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: {
                    this.setMulticast(n3 - 24, by);
                }
            }
        }
    }

    private void asicIOPortWriteByte(int n, short s) {
        if (this.getRCNT() == 0) {
            return;
        }
        if (0 != (this.getDCfg() & 1)) {
            this.memoryWriteWord(this.getRSAR(), s);
            this.dmaUpdate(2);
        } else {
            this.memoryWriteByte(this.getRSAR(), (byte)s);
            this.dmaUpdate(1);
        }
    }

    private void asicIOPortWriteWord(int n, short s) {
        if (this.getRCNT() == 0) {
            return;
        }
        if (0 != (this.getDCfg() & 1)) {
            this.memoryWriteWord(this.getRSAR(), s);
            this.dmaUpdate(2);
        } else {
            this.memoryWriteByte(this.getRSAR(), (byte)s);
            this.dmaUpdate(1);
        }
    }

    private void asicIOPortWriteLong(int n, int n2) {
        if (this.getRCNT() == 0) {
            return;
        }
        this.memoryWriteLong(this.getRSAR(), n2);
        this.dmaUpdate(4);
    }

    private byte ioPortRead(int n) {
        if ((n &= 0xF) == 0) {
            return this.getCommand();
        }
        int n2 = this.getCommand() >> 6;
        int n3 = n | n2 << 4;
        switch (n3) {
            case 4: {
                return this.getTSR();
            }
            case 3: {
                return this.getBoundary();
            }
            case 7: {
                return this.getISR();
            }
            case 8: {
                return (byte)(this.getRSAR() & 0xFF);
            }
            case 9: {
                return (byte)(this.getRSAR() >> 8);
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                return this.getPhysical(n3 - 17);
            }
            case 23: {
                return this.getCurrentPage();
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                return this.getMulticast(n3 - 24);
            }
            case 12: {
                return this.getRSR();
            }
        }
        return 0;
    }

    private short asicIOPortReadByte(int n) {
        short s;
        if (0 != (this.getDCfg() & 1)) {
            s = this.memoryReadWord(this.getRSAR());
            this.dmaUpdate(2);
        } else {
            s = this.memoryReadByte(this.getRSAR());
            s = (short)(s & 0xFF);
            this.dmaUpdate(1);
        }
        return s;
    }

    private short asicIOPortReadWord(int n) {
        short s;
        if (0 != (this.getDCfg() & 1)) {
            s = this.memoryReadWord(this.getRSAR());
            this.dmaUpdate(2);
        } else {
            s = this.memoryReadByte(this.getRSAR());
            s = (short)(s & 0xFF);
            this.dmaUpdate(1);
        }
        return s;
    }

    private int asicIOPortReadLong(int n) {
        int n2 = this.memoryReadLong(this.getRSAR());
        this.dmaUpdate(4);
        return n2;
    }

    private byte resetIOPortRead(int n) {
        this.internalReset();
        return 0;
    }

    private void dmaUpdate(int n) {
        this.setRSAR(this.getRSAR() + n);
        if (this.getRSAR() == this.getStop()) {
            this.setRSAR(this.getStart());
        }
        if (this.getRCNT() <= n) {
            this.setRCNT((short)0);
            this.orISR((byte)64);
            this.updateIRQ();
        } else {
            this.setRCNT((short)(this.getRCNT() - n));
        }
    }

    private void memoryWriteByte(int n, byte by) {
        if (n < 32 || n >= 16384 && n < 49152) {
            this.mem.set(n, by);
        }
    }

    private void memoryWriteWord(int n, short s) {
        if ((n &= 0xFFFFFFFE) < 32 || n >= 16384 && n < 49152) {
            this.mem.setShort(n, s);
        }
    }

    private void memoryWriteLong(int n, int n2) {
        if ((n &= 0xFFFFFFFE) < 32 || n >= 16384 && n < 49152) {
            this.mem.setInt(n, n2);
        }
    }

    private byte memoryReadByte(int n) {
        if (n < 32 || n >= 16384 && n < 49152) {
            return this.mem.get(n);
        }
        return -1;
    }

    private short memoryReadWord(int n) {
        if ((n &= 0xFFFFFFFE) < 32 || n >= 16384 && n < 49152) {
            return this.mem.getShort(n);
        }
        return -1;
    }

    private int memoryReadLong(int n) {
        if ((n &= 0xFFFFFFFE) < 32 || n >= 16384 && n < 49152) {
            return this.mem.getInt(n);
        }
        return -1;
    }

    private byte getCommand() {
        return this.command;
    }

    private void setCommand(byte by) {
        this.command = by;
    }

    private int getStart() {
        return this.start;
    }

    private void setStart(int n) {
        this.start = n;
    }

    private int getStop() {
        return this.stop;
    }

    private void setStop(int n) {
        this.stop = n;
    }

    private byte getBoundary() {
        return this.boundary;
    }

    private void setBoundary(byte by) {
        this.boundary = by;
    }

    private byte getTSR() {
        return this.tsr;
    }

    private void setTSR(byte by) {
        this.tsr = by;
    }

    private byte getTPSR() {
        return this.tpsr;
    }

    private void setTPSR(byte by) {
        this.tpsr = by;
    }

    private short getTCNT() {
        return this.tcnt;
    }

    private void setTCNT(short s) {
        this.tcnt = s;
    }

    private short getRCNT() {
        return this.rcnt;
    }

    private void setRCNT(short s) {
        this.rcnt = s;
    }

    private int getRSAR() {
        return this.rsar;
    }

    private void setRSAR(int n) {
        this.rsar = n;
    }

    private byte getRSR() {
        return this.rsr;
    }

    private void setRSR(byte by) {
        this.rsr = by;
    }

    private byte getISR() {
        return this.isr;
    }

    private void setISR(byte by) {
        this.isr = by;
    }

    private void andISR(byte by) {
        this.setISR((byte)(this.getISR() & by));
    }

    private void orISR(byte by) {
        this.setISR((byte)(this.getISR() | by));
    }

    private byte getDCfg() {
        return this.dcfg;
    }

    private void setDCfg(byte by) {
        this.dcfg = by;
    }

    private byte getIMR() {
        return this.imr;
    }

    private void setIMR(byte by) {
        this.imr = by;
    }

    private byte getPhysical(int n) {
        return this.phys[n];
    }

    private void setPhysical(int n, byte by) {
        this.phys[n] = by;
    }

    private byte getCurrentPage() {
        return this.curpag;
    }

    private void setCurrentPage(byte by) {
        this.curpag = by;
    }

    private byte getMulticast(int n) {
        return this.mult[n];
    }

    private void setMulticast(int n, byte by) {
        this.mult[n] = by;
    }

    private EthernetOutput getEthernetOutput() {
        return this.outputDevice;
    }

    public void testPacket() {
        this.setIMR((byte)-1);
        this.orISR((byte)1);
        this.updateIRQ();
    }

    class EthernetIORegion
    implements IOPortIORegion {
        private int address = -1;

        public int getAddress() {
            return this.address;
        }

        public long getSize() {
            return 256L;
        }

        public int getType() {
            return 1;
        }

        public int getRegionNumber() {
            return 0;
        }

        public void setAddress(int n) {
            this.address = n;
        }

        public void ioPortWriteByte(int n, int n2) {
            switch (n - this.getAddress()) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    EthernetCard.this.ioPortWrite(n, (byte)n2);
                    break;
                }
                case 16: {
                    EthernetCard.this.asicIOPortWriteByte(n, (short)n2);
                    break;
                }
                case 31: {
                    break;
                }
            }
        }

        public void ioPortWriteWord(int n, int n2) {
            switch (n - this.getAddress()) {
                case 16: 
                case 17: {
                    EthernetCard.this.asicIOPortWriteWord(n, (short)n2);
                    break;
                }
            }
        }

        public void ioPortWriteLong(int n, int n2) {
            switch (n - this.getAddress()) {
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    EthernetCard.this.asicIOPortWriteLong(n, n2);
                    break;
                }
            }
        }

        public int ioPortReadByte(int n) {
            switch (n - this.getAddress()) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    return EthernetCard.this.ioPortRead(n);
                }
                case 16: {
                    return 0xFFFF & EthernetCard.this.asicIOPortReadByte(n);
                }
                case 31: {
                    return EthernetCard.this.resetIOPortRead(n);
                }
            }
            return -1;
        }

        public int ioPortReadWord(int n) {
            switch (n - this.getAddress()) {
                case 16: 
                case 17: {
                    return EthernetCard.this.asicIOPortReadWord(n);
                }
            }
            return -1;
        }

        public int ioPortReadLong(int n) {
            switch (n - this.getAddress()) {
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    return EthernetCard.this.asicIOPortReadLong(n);
                }
            }
            return -1;
        }

        public int[] ioPortsRequested() {
            int n = this.getAddress();
            int[] nArray = new int[32];
            for (int i = 0; i < 32; ++i) {
                nArray[i] = n + i;
            }
            return nArray;
        }
    }
}

