/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.support;

import org.jpc.emulator.AbstractHardwareComponent;
import org.jpc.support.BlockDevice;
import org.jpc.support.CDROMBlockDevice;
import org.jpc.support.FloppyBlockDevice;
import org.jpc.support.RawBlockDevice;
import org.jpc.support.SeekableIODevice;

public class DriveSet
extends AbstractHardwareComponent {
    public static final int FLOPPY_BOOT = 0;
    public static final int HARD_DRIVE_BOOT = 1;
    public static final int CD_BOOT = 2;
    private int bootType;
    private BlockDevice bootDevice;
    private BlockDevice[] floppies;
    private BlockDevice[] ides;

    public DriveSet(int n, BlockDevice blockDevice, BlockDevice blockDevice2) {
        this(n, blockDevice, null, blockDevice2, null, null, null);
    }

    public DriveSet(int n, BlockDevice blockDevice, BlockDevice blockDevice2, BlockDevice blockDevice3, BlockDevice blockDevice4, BlockDevice blockDevice5, BlockDevice blockDevice6) {
        this.bootType = n;
        this.floppies = new BlockDevice[2];
        this.floppies[0] = blockDevice;
        this.floppies[1] = blockDevice2;
        this.ides = new BlockDevice[4];
        this.ides[0] = blockDevice3;
        this.ides[1] = blockDevice4;
        this.ides[2] = blockDevice5 == null ? new CDROMBlockDevice() : blockDevice5;
        this.ides[3] = blockDevice6;
        this.bootDevice = n == 0 ? blockDevice : (n == 2 ? blockDevice5 : blockDevice3);
    }

    public BlockDevice getHardDrive(int n) {
        if (n > 3) {
            return null;
        }
        return this.ides[n];
    }

    public void setHardDrive(int n, BlockDevice blockDevice) {
        this.ides[n] = blockDevice;
    }

    public BlockDevice getFloppyDrive(int n) {
        if (n > 1) {
            return null;
        }
        return this.floppies[n];
    }

    public BlockDevice getBootDevice() {
        return this.bootDevice;
    }

    public int getBootType() {
        return this.bootType;
    }

    public static String findArg(String[] stringArray, String string, String string2) {
        if (string.startsWith("-")) {
            string = string.substring(1);
        }
        for (int i = 0; i < stringArray.length - 1; ++i) {
            String string3 = stringArray[i];
            if (string3.startsWith("-")) {
                string3 = string3.substring(1);
            }
            if (!string3.equalsIgnoreCase(string)) continue;
            return stringArray[i + 1];
        }
        return string2;
    }

    private static BlockDevice createFloppyBlockDevice(String string) {
        if (string == null) {
            return null;
        }
        SeekableIODevice seekableIODevice = null;
        Class<?> clazz = null;
        FloppyBlockDevice floppyBlockDevice = null;
        try {
            if (string.startsWith("mem:")) {
                string = string.substring(4);
                clazz = Class.forName("org.jpc.support.ArrayBackedSeekableIODevice");
            } else if (string.startsWith("rms:")) {
                string = string.substring(4);
                clazz = Class.forName("org.jpc.support.RecordBackedSeekableIODevice");
            } else {
                clazz = Class.forName("org.jpc.support.FileBackedSeekableIODevice");
            }
            seekableIODevice = (SeekableIODevice)clazz.newInstance();
            seekableIODevice.configure(string);
            floppyBlockDevice = new FloppyBlockDevice(seekableIODevice);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return floppyBlockDevice;
    }

    private static BlockDevice createHardDiskBlockDevice(String string) {
        if (string == null) {
            return null;
        }
        BlockDevice blockDevice = null;
        try {
            if (string.startsWith("dir:")) {
                Class<?> clazz = Class.forName("org.jpc.support.TreeBlockDevice");
                string = string.substring(4);
                blockDevice = (BlockDevice)clazz.newInstance();
                blockDevice.configure(string);
            } else if (string.startsWith("net:")) {
                Class<?> clazz = Class.forName("org.jpc.support.RemoteBlockDevice");
                string = string.substring(4);
                blockDevice = (BlockDevice)clazz.newInstance();
                blockDevice.configure(string);
            } else if (string.startsWith("mem:")) {
                Class<?> clazz = Class.forName("org.jpc.support.ArrayBackedSeekableIODevice");
                SeekableIODevice seekableIODevice = (SeekableIODevice)clazz.newInstance();
                string = string.substring(4);
                seekableIODevice.configure(string);
                blockDevice = new RawBlockDevice(seekableIODevice);
            } else {
                Class<?> clazz = Class.forName("org.jpc.support.FileBackedSeekableIODevice");
                SeekableIODevice seekableIODevice = (SeekableIODevice)clazz.newInstance();
                seekableIODevice.configure(string);
                blockDevice = new RawBlockDevice(seekableIODevice);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return blockDevice;
    }

    public static DriveSet buildFromArgs(String[] stringArray) {
        Object object;
        Object object2;
        int n = 1;
        BlockDevice blockDevice = null;
        BlockDevice blockDevice2 = null;
        BlockDevice blockDevice3 = null;
        BlockDevice blockDevice4 = null;
        BlockDevice blockDevice5 = null;
        BlockDevice blockDevice6 = null;
        String string = DriveSet.findArg(stringArray, "-fda", null);
        blockDevice = DriveSet.createFloppyBlockDevice(string);
        if (blockDevice != null) {
            n = 0;
        }
        String string2 = DriveSet.findArg(stringArray, "-fdb", null);
        blockDevice2 = DriveSet.createFloppyBlockDevice(string2);
        String string3 = DriveSet.findArg(stringArray, "-cdrom", null);
        if (string3 != null) {
            try {
                object2 = Class.forName("org.jpc.support.FileBackedSeekableIODevice");
                object = (SeekableIODevice)((Class)object2).newInstance();
                object.configure(string3);
                blockDevice5 = new CDROMBlockDevice((SeekableIODevice)object);
                n = 2;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((blockDevice3 = DriveSet.createHardDiskBlockDevice((String)(object2 = DriveSet.findArg(stringArray, "-hda", null)))) != null) {
            n = 1;
        }
        object = DriveSet.findArg(stringArray, "-hdb", null);
        blockDevice4 = DriveSet.createHardDiskBlockDevice((String)object);
        String string4 = DriveSet.findArg(stringArray, "-hdc", null);
        blockDevice5 = DriveSet.createHardDiskBlockDevice(string4);
        String string5 = DriveSet.findArg(stringArray, "-hdd", null);
        blockDevice6 = DriveSet.createHardDiskBlockDevice(string5);
        String string6 = DriveSet.findArg(stringArray, "-boot", null);
        if (string6 != null) {
            if ((string6 = string6.toLowerCase()).equals("fda")) {
                n = 0;
            } else if (string6.equals("hda")) {
                n = 1;
            } else if (string6.equals("cdrom")) {
                n = 2;
            }
        }
        return new DriveSet(n, blockDevice, blockDevice2, blockDevice3, blockDevice4, blockDevice5, blockDevice6);
    }
}

