/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.support;

import java.io.IOException;
import org.jpc.support.BlockDevice;
import org.jpc.support.SeekableIODevice;

public class RawBlockDevice
implements BlockDevice {
    private static final String formatName = "raw";
    protected long totalSectors;
    protected boolean readOnly;
    protected boolean inserted;
    protected boolean removable;
    protected boolean locked;
    protected boolean bootSectorEnabled;
    protected byte[] bootSectorData;
    protected SeekableIODevice data;
    protected int cylinders;
    protected int heads;
    protected int sectors;

    public RawBlockDevice() {
    }

    public RawBlockDevice(SeekableIODevice seekableIODevice) {
        this.data = seekableIODevice;
        byte[] byArray = new byte[512];
        try {
            this.totalSectors = seekableIODevice.length() / 512;
            seekableIODevice.seek(0);
            if (seekableIODevice.read(byArray, 0, 512) != 512) {
                System.err.println("Not big enough image file");
            }
        }
        catch (IOException iOException) {
            System.err.println("RawBlockDevice: Error in File Read: " + iOException);
        }
        if (byArray[510] == 85 && byArray[511] == -86) {
            for (int i = 0; i < 4; ++i) {
                int n = byArray[446 + 16 * i + 12] & 0xFF | byArray[446 + 16 * i + 13] << 8 & 0xFF00 | byArray[446 + 16 * i + 14] << 16 & 0xFF0000 | byArray[446 + 16 * i + 15] << 24 & 0xFF000000;
                if ((0xFF & byArray[446 + 16 * i + 5] & n) == 0) continue;
                this.heads = 1 + (byArray[446 + 16 * i + 5] & 0xFF);
                this.sectors = byArray[446 + 16 * i + 6] & 0x3F;
                if (this.sectors == 0) continue;
                this.cylinders = (int)(this.totalSectors / (long)(this.heads * this.sectors));
                if (this.cylinders >= 1 && this.cylinders <= 16383) continue;
                this.cylinders = 0;
            }
        }
        if (this.cylinders == 0) {
            this.cylinders = (int)(this.totalSectors / 1008L);
            if (this.cylinders > 16383) {
                this.cylinders = 16383;
            } else if (this.cylinders < 2) {
                this.cylinders = 2;
            }
            this.heads = 16;
            this.sectors = 63;
            System.err.println("No Geometry Information, Guessing CHS = " + this.cylinders + ":" + this.heads + ":" + this.sectors);
        }
    }

    public String getImageFileName() {
        return this.data.toString();
    }

    public void close() {
    }

    public int read(long l, byte[] byArray, int n) {
        try {
            this.data.seek((int)(l * 512L));
            int n2 = 0;
            int n3 = Math.min(byArray.length, 512 * n);
            while (true) {
                int n4;
                if ((n4 = this.data.read(byArray, n2, n3 - n2)) < 0 || n2 == n3) {
                    return n2;
                }
                n2 += n4;
            }
        }
        catch (IOException iOException) {
            System.err.println("IO Error Reading From " + this.data.toString());
            iOException.printStackTrace();
            return -1;
        }
    }

    public int write(long l, byte[] byArray, int n) {
        try {
            this.data.seek((int)(l * 512L));
            this.data.write(byArray, 0, n * 512);
        }
        catch (IOException iOException) {
            System.err.println("IO Error Writing To " + this.data.toString());
            iOException.printStackTrace();
            return -1;
        }
        return 0;
    }

    public boolean inserted() {
        return this.data != null;
    }

    public boolean locked() {
        return false;
    }

    public boolean readOnly() {
        return false;
    }

    public void setLock(boolean bl) {
    }

    public long getTotalSectors() {
        return this.totalSectors;
    }

    public int cylinders() {
        return this.cylinders;
    }

    public int heads() {
        return this.heads;
    }

    public int sectors() {
        return this.sectors;
    }

    public int type() {
        return 0;
    }

    public void configure(String string) throws Exception {
        this.data.configure(string);
    }
}

