/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.motherboard;

import org.jpc.emulator.HardwareComponent;
import org.jpc.emulator.memory.PhysicalAddressSpace;
import org.jpc.emulator.motherboard.DMATransferCapable;
import org.jpc.emulator.motherboard.IOPortCapable;
import org.jpc.emulator.motherboard.IOPortHandler;

public class DMAController
implements IOPortCapable,
HardwareComponent {
    private static final int pagePortList0 = 1;
    private static final int pagePortList1 = 2;
    private static final int pagePortList2 = 3;
    private static final int pagePortList3 = 7;
    private static final int[] pagePortList = new int[]{1, 2, 3, 7};
    private static final int CMD_MEMORY_TO_MEMORY = 1;
    private static final int CMD_FIXED_ADDRESS = 2;
    private static final int CMD_BLOCK_CONTROLLER = 4;
    private static final int CMD_COMPRESSED_TIME = 8;
    private static final int CMD_CYCLIC_PRIORITY = 16;
    private static final int CMD_EXTENDED_WRITE = 32;
    private static final int CMD_LOW_DREQ = 64;
    private static final int CMD_LOW_DACK = 128;
    private static final int CMD_NOT_SUPPORTED = 251;
    private int status;
    private int command;
    private int mask;
    private boolean flipFlop;
    private int dShift;
    private int iobase;
    private int pageBase;
    private int pageHBase;
    private int controllerNumber;
    private PhysicalAddressSpace memory;
    private DMARegister[] dmaRegs;
    private static final int[] channels = new int[]{-1, 2, 3, 1, -1, -1, -1, 0};
    private boolean ioportRegistered = false;

    public DMAController(boolean bl, boolean bl2) {
        this.dShift = bl2 ? 0 : 1;
        this.iobase = bl2 ? 0 : 192;
        int n = this.pageBase = bl2 ? 128 : 136;
        this.pageHBase = bl ? (bl2 ? 1152 : 1160) : -1;
        this.controllerNumber = bl2 ? 0 : 1;
        this.dmaRegs = new DMARegister[4];
        for (int i = 0; i < 4; ++i) {
            this.dmaRegs[i] = new DMARegister();
        }
        this.reset();
    }

    public boolean isFirst() {
        return this.dShift == 0;
    }

    public void reset() {
        for (int i = 0; i < this.dmaRegs.length; ++i) {
            this.dmaRegs[i].reset();
        }
        this.writeController(13 << this.dShift, 0);
        this.memory = null;
        this.ioportRegistered = false;
    }

    private void writeChannel(int n, int n2) {
        int n3 = n >> this.dShift & 0xF;
        int n4 = n3 >> 1;
        DMARegister dMARegister = this.dmaRegs[n4];
        if (this.getFlipFlop()) {
            if ((n3 & 1) == 0) {
                dMARegister.baseAddress = (short)(dMARegister.baseAddress & 0xFF | n2 << 8 & 0xFF00);
            } else {
                dMARegister.baseCount = (short)(dMARegister.baseCount & 0xFF | n2 << 8 & 0xFF00);
            }
            this.initChannel(n4);
        } else if ((n3 & 1) == 0) {
            dMARegister.baseAddress = (short)(dMARegister.baseAddress & 0xFF00 | n2 & 0xFF);
        } else {
            dMARegister.baseCount = (short)(dMARegister.baseCount & 0xFF00 | n2 & 0xFF);
        }
    }

    private void writeController(int n, int n2) {
        int n3 = n >> this.dShift & 0xF;
        switch (n3) {
            case 8: {
                if (n2 != 0 && (n2 & 0xFB) != 0) {
                    return;
                }
                this.command = n2;
                return;
            }
            case 9: {
                int n4 = n2 & 3;
                this.status = (n2 & 4) != 0 ? (this.status |= 1 << n4 + 4) : (this.status &= ~(1 << n4 + 4));
                this.status &= ~(1 << n4);
                return;
            }
            case 10: {
                this.mask = (n2 & 4) != 0 ? (this.mask |= 1 << (n2 & 3)) : (this.mask &= ~(1 << (n2 & 3)));
                return;
            }
            case 11: {
                int n5 = n2 & 3;
                this.dmaRegs[n5].mode = n2;
                return;
            }
            case 12: {
                this.flipFlop = false;
                return;
            }
            case 13: {
                this.flipFlop = false;
                this.mask = -1;
                this.status = 0;
                this.command = 0;
                return;
            }
            case 14: {
                this.mask = 0;
                return;
            }
            case 15: {
                this.mask = n2;
                return;
            }
        }
    }

    private void writePage(int n, int n2) {
        int n3 = channels[n & 7];
        if (-1 == n3) {
            return;
        }
        this.dmaRegs[n3].page = (byte)n2;
    }

    private void writePageH(int n, int n2) {
        int n3 = channels[n & 7];
        if (-1 == n3) {
            return;
        }
        this.dmaRegs[n3].pageh = (byte)n2;
    }

    private int readChannel(int n) {
        int n2 = n >> this.dShift & 0xF;
        int n3 = n2 >> 1;
        int n4 = n2 & 1;
        DMARegister dMARegister = this.dmaRegs[n3];
        int n5 = (dMARegister.mode & 0x20) == 0 ? 1 : -1;
        boolean bl = this.getFlipFlop();
        int n6 = n4 != 0 ? ((0xFFFF & dMARegister.baseCount) << this.dShift) - dMARegister.nowCount : dMARegister.nowAddress + dMARegister.nowCount * n5;
        return n6 >>> this.dShift + (bl ? 8 : 0) & 0xFF;
    }

    private int readController(int n) {
        int n2;
        int n3 = n >> this.dShift & 0xF;
        switch (n3) {
            case 8: {
                n2 = this.status;
                this.status &= 0xF0;
                break;
            }
            case 15: {
                n2 = this.mask;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        return n2;
    }

    private int readPage(int n) {
        int n2 = channels[n & 7];
        if (-1 == n2) {
            return 0;
        }
        return 0xFF & this.dmaRegs[n2].page;
    }

    private int readPageH(int n) {
        int n2 = channels[n & 7];
        if (-1 == n2) {
            return 0;
        }
        return 0xFF & this.dmaRegs[n2].pageh;
    }

    public void ioPortWriteByte(int n, int n2) {
        if (this.dShift == 0) {
            switch (n - this.iobase) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    this.writeChannel(n, n2);
                    return;
                }
            }
            switch (n - this.iobase) {
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    this.writeController(n, n2);
                    return;
                }
            }
        } else {
            switch (n - this.iobase) {
                case 0: 
                case 2: 
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 12: 
                case 14: {
                    this.writeChannel(n, n2);
                    return;
                }
            }
            switch (n - this.iobase) {
                case 16: 
                case 18: 
                case 20: 
                case 22: 
                case 24: 
                case 26: 
                case 28: 
                case 30: {
                    this.writeController(n, n2);
                    return;
                }
            }
        }
        switch (n - this.pageBase) {
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                this.writePage(n, n2);
                return;
            }
        }
        switch (n - this.pageHBase) {
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                this.writePageH(n, n2);
                return;
            }
        }
    }

    public void ioPortWriteWord(int n, int n2) {
        this.ioPortWriteByte(n, n2);
        this.ioPortWriteByte(n + 1, n2 >> 8);
    }

    public void ioPortWriteLong(int n, int n2) {
        this.ioPortWriteWord(n, n2);
        this.ioPortWriteWord(n + 2, n2 >> 16);
    }

    public int ioPortReadByte(int n) {
        switch (n - this.iobase >> this.dShift) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return this.readChannel(n);
            }
        }
        switch (n - this.iobase >> this.dShift) {
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                return this.readController(n);
            }
        }
        switch (n - this.pageBase) {
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                return this.readPage(n);
            }
        }
        switch (n - this.pageHBase) {
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                return this.readPageH(n);
            }
        }
        return 255;
    }

    public int ioPortReadWord(int n) {
        return 0xFF & this.ioPortReadByte(n) | this.ioPortReadByte(n) << 8 & 0xFF;
    }

    public int ioPortReadLong(int n) {
        return 0xFFFF & this.ioPortReadByte(n) | this.ioPortReadByte(n) << 16 & 0xFFFF;
    }

    public int[] ioPortsRequested() {
        int n;
        int[] nArray = this.pageHBase >= 0 ? new int[16 + 2 * pagePortList.length] : new int[16 + pagePortList.length];
        int n2 = 0;
        for (n = 0; n < 8; ++n) {
            nArray[n2++] = this.iobase + (n << this.dShift);
        }
        for (n = 0; n < pagePortList.length; ++n) {
            nArray[n2++] = this.pageBase + pagePortList[n];
            if (this.pageHBase < 0) continue;
            nArray[n2++] = this.pageHBase + pagePortList[n];
        }
        for (n = 0; n < 8; ++n) {
            nArray[n2++] = this.iobase + (n + 8 << this.dShift);
        }
        return nArray;
    }

    private boolean getFlipFlop() {
        boolean bl = this.flipFlop;
        this.flipFlop = !bl;
        return bl;
    }

    private void initChannel(int n) {
        DMARegister dMARegister = this.dmaRegs[n];
        dMARegister.nowAddress = (0xFFFF & dMARegister.baseAddress) << this.dShift;
        dMARegister.nowCount = 0;
    }

    public void runTransfers() {
        for (int i = 0; i < 4; ++i) {
            int n = 1 << i;
            if (0 != (this.mask & n) || 0 == (this.status & n << 4)) continue;
            this.runChannel(i);
        }
    }

    private void runChannel(int n) {
        int n2;
        DMARegister dMARegister = this.dmaRegs[n];
        dMARegister.nowCount = n2 = dMARegister.transferDevice.transferHandler(n + (this.controllerNumber << 2), dMARegister.nowCount, dMARegister.baseCount + 1 << this.controllerNumber);
    }

    public int getChannelMode(int n) {
        return this.dmaRegs[n].mode;
    }

    public void holdDREQ(int n) {
        this.status |= 1 << n + 4;
    }

    public void releaseDREQ(int n) {
        this.status &= ~(1 << n + 4);
    }

    public void registerChannel(int n, DMATransferCapable dMATransferCapable) {
        this.dmaRegs[n].transferDevice = dMATransferCapable;
    }

    public int readMemory(int n, byte[] byArray, int n2, int n3, int n4) {
        DMARegister dMARegister = this.dmaRegs[n];
        long l = ((long)dMARegister.pageh & 0x7FL) << 24 | (0xFFL & (long)dMARegister.page) << 16 | 0xFFFFFFFFL & (long)dMARegister.nowAddress;
        if ((dMARegister.mode & 0x20) != 0) {
            System.err.println("DMA Read In Address Decrement Mode!");
            this.memory.copyContentsInto((int)(l - (long)n3 - (long)n4), byArray, n2, n4);
            int n5 = n2;
            for (int i = n2 + n4 - 1; n5 < i; ++n5, --i) {
                byte by = byArray[n5];
                byArray[n5] = byArray[i];
                byArray[i] = by;
            }
        } else {
            this.memory.copyContentsInto((int)(l + (long)n3), byArray, n2, n4);
        }
        return n4;
    }

    public int writeMemory(int n, byte[] byArray, int n2, int n3, int n4) {
        DMARegister dMARegister = this.dmaRegs[n];
        long l = (0x7FL & (long)dMARegister.pageh) << 24 | (0xFFL & (long)dMARegister.page) << 16 | 0xFFFFFFFFL & (long)dMARegister.nowAddress;
        if ((dMARegister.mode & 0x20) != 0) {
            System.err.println("DMA Write In Address Decrement Mode!");
            int n5 = n2;
            for (int i = n2 + n4 - 1; n5 < i; ++n5, --i) {
                byte by = byArray[n5];
                byArray[n5] = byArray[i];
                byArray[i] = by;
            }
            this.memory.copyContentsFrom((int)(l - (long)n3 - (long)n4), byArray, n2, n4);
        } else {
            this.memory.copyContentsFrom((int)(l + (long)n3), byArray, n2, n4);
        }
        return n4;
    }

    public boolean initialised() {
        return this.memory != null && this.ioportRegistered;
    }

    public void acceptComponent(HardwareComponent hardwareComponent) {
        if (hardwareComponent instanceof PhysicalAddressSpace) {
            this.memory = (PhysicalAddressSpace)hardwareComponent;
        }
        if (hardwareComponent instanceof IOPortHandler) {
            ((IOPortHandler)hardwareComponent).registerIOPortCapable(this);
            this.ioportRegistered = true;
        }
    }

    public String toString() {
        return "DMA Controller [element " + this.dShift + "]";
    }

    class DMARegister {
        public static final int ADDRESS = 0;
        public static final int COUNT = 1;
        public int nowAddress;
        public int nowCount;
        public short baseAddress;
        public short baseCount;
        public int mode;
        public byte page;
        public byte pageh;
        public byte dack;
        public byte eop;
        public DMATransferCapable transferDevice;

        public void reset() {
            this.transferDevice = null;
            this.mode = 0;
            this.nowCount = 0;
            this.nowAddress = 0;
            this.baseCount = 0;
            this.baseAddress = 0;
            this.eop = 0;
            this.dack = 0;
            this.pageh = 0;
            this.page = 0;
        }
    }
}

