/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.motherboard;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jpc.emulator.AbstractHardwareComponent;
import org.jpc.emulator.HardwareComponent;
import org.jpc.emulator.memory.EPROMMemory;
import org.jpc.emulator.memory.PhysicalAddressSpace;
import org.jpc.emulator.motherboard.IOPortCapable;
import org.jpc.emulator.motherboard.IOPortHandler;

public class VGABIOS
extends AbstractHardwareComponent
implements IOPortCapable {
    private byte[] imageData;
    private boolean ioportRegistered;
    private boolean loaded;

    public VGABIOS(byte[] byArray) {
        this.loaded = false;
        this.ioportRegistered = false;
        this.imageData = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.imageData, 0, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VGABIOS(String string) throws IOException {
        InputStream inputStream = null;
        try {
            int n;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            inputStream = this.getClass().getResourceAsStream("/" + string);
            while ((n = inputStream.read()) >= 0) {
                byteArrayOutputStream.write((byte)n);
            }
            this.imageData = byteArrayOutputStream.toByteArray();
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    public int[] ioPortsRequested() {
        return new int[]{1280, 1281, 1282, 1283};
    }

    public int ioPortReadByte(int n) {
        return 255;
    }

    public int ioPortReadWord(int n) {
        return 65535;
    }

    public int ioPortReadLong(int n) {
        return -1;
    }

    public void ioPortWriteByte(int n, int n2) {
        switch (n) {
            case 1280: 
            case 1283: {
                try {
                    System.out.print(new String(new byte[]{(byte)n2}, "US-ASCII"));
                }
                catch (Exception exception) {
                    System.out.print(new String(new byte[]{(byte)n2}));
                }
                break;
            }
        }
    }

    public void ioPortWriteWord(int n, int n2) {
        switch (n) {
            case 1281: 
            case 1282: {
                System.err.println("VGA-BIOS panic line " + n2);
            }
        }
    }

    public void ioPortWriteLong(int n, int n2) {
    }

    public void load(PhysicalAddressSpace physicalAddressSpace) {
        int n = 4096;
        int n2 = ((this.imageData.length - 1) / n + 1) * n;
        for (int i = 0; i < n2 / n; ++i) {
            EPROMMemory ePROMMemory = new EPROMMemory(n, 0, this.imageData, i * n, n);
            physicalAddressSpace.allocateMemory(786432 + i * n, ePROMMemory);
        }
    }

    public byte[] getImage() {
        return (byte[])this.imageData.clone();
    }

    public boolean initialised() {
        return this.loaded && this.ioportRegistered;
    }

    public void acceptComponent(HardwareComponent hardwareComponent) {
        if (hardwareComponent instanceof PhysicalAddressSpace && hardwareComponent.initialised()) {
            this.load((PhysicalAddressSpace)hardwareComponent);
            this.loaded = true;
        }
        if (hardwareComponent instanceof IOPortHandler && hardwareComponent.initialised()) {
            ((IOPortHandler)hardwareComponent).registerIOPortCapable(this);
            this.ioportRegistered = true;
        }
    }

    public void reset() {
        this.ioportRegistered = false;
        this.loaded = false;
    }
}

