/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.pci;

import org.jpc.emulator.HardwareComponent;
import org.jpc.emulator.motherboard.InterruptController;
import org.jpc.emulator.pci.AbstractPCIDevice;
import org.jpc.emulator.pci.IORegion;
import org.jpc.emulator.pci.IRQBouncer;
import org.jpc.emulator.pci.PCIDevice;

public class PCIISABridge
extends AbstractPCIDevice
implements HardwareComponent {
    private int[][] irqLevels = new int[4][2];
    private InterruptController irqDevice;

    public PCIISABridge() {
        this.putConfigByte(0, (byte)-122);
        this.putConfigByte(1, (byte)-128);
        this.putConfigByte(2, (byte)0);
        this.putConfigByte(3, (byte)112);
        this.putConfigByte(10, (byte)1);
        this.putConfigByte(11, (byte)6);
        this.putConfigByte(14, (byte)-128);
        this.internalReset();
    }

    private void internalReset() {
        this.putConfigByte(4, (byte)7);
        this.putConfigByte(5, (byte)0);
        this.putConfigByte(6, (byte)0);
        this.putConfigByte(7, (byte)2);
        this.putConfigByte(76, (byte)77);
        this.putConfigByte(78, (byte)3);
        this.putConfigByte(79, (byte)0);
        this.putConfigByte(96, (byte)-128);
        this.putConfigByte(105, (byte)2);
        this.putConfigByte(112, (byte)-128);
        this.putConfigByte(118, (byte)12);
        this.putConfigByte(119, (byte)12);
        this.putConfigByte(120, (byte)2);
        this.putConfigByte(121, (byte)0);
        this.putConfigByte(128, (byte)0);
        this.putConfigByte(130, (byte)0);
        this.putConfigByte(160, (byte)8);
        this.putConfigByte(162, (byte)0);
        this.putConfigByte(163, (byte)0);
        this.putConfigByte(164, (byte)0);
        this.putConfigByte(165, (byte)0);
        this.putConfigByte(166, (byte)0);
        this.putConfigByte(167, (byte)0);
        this.putConfigByte(168, (byte)15);
        this.putConfigByte(170, (byte)0);
        this.putConfigByte(171, (byte)0);
        this.putConfigByte(172, (byte)0);
        this.putConfigByte(174, (byte)0);
    }

    public void setIRQ(PCIDevice pCIDevice, int n, int n2) {
        n = this.slotGetPIRQ(pCIDevice, n);
        int n3 = pCIDevice.getIRQIndex();
        int n4 = n3 & 0x1F;
        int n5 = this.irqLevels[n][n3 >> 5];
        this.irqLevels[n][n3 >> 5] = n5 & ~(1 << n4) | n2 << n4;
        byte by = this.getConfigByte(96 + n);
        if (by < 16) {
            int n6 = 0;
            for (int i = 0; i < 4; ++i) {
                if (by != this.getConfigByte(96 + i)) continue;
                n6 |= this.getIRQLevel(i);
            }
            this.getInterruptController().setIRQ(by, n6);
        }
    }

    private int getIRQLevel(int n) {
        for (int i = 0; i < 2; ++i) {
            if (this.irqLevels[n][i] == 0) continue;
            return 1;
        }
        return 0;
    }

    public IRQBouncer makeBouncer(PCIDevice pCIDevice) {
        return new DefaultIRQBouncer(this);
    }

    public int slotGetPIRQ(PCIDevice pCIDevice, int n) {
        int n2 = pCIDevice.getCurrentDevFN() >> 3;
        return n + n2 & 3;
    }

    public IORegion getIORegion(int n) {
        return null;
    }

    public IORegion[] getIORegions() {
        return null;
    }

    public InterruptController getInterruptController() {
        return this.irqDevice;
    }

    public void reset() {
        this.irqDevice = null;
        this.putConfigByte(0, (byte)-122);
        this.putConfigByte(1, (byte)-128);
        this.putConfigByte(2, (byte)0);
        this.putConfigByte(3, (byte)112);
        this.putConfigByte(10, (byte)1);
        this.putConfigByte(11, (byte)6);
        this.putConfigByte(14, (byte)-128);
        this.internalReset();
        super.reset();
    }

    public boolean initialised() {
        return this.irqDevice != null && super.initialised();
    }

    public void acceptComponent(HardwareComponent hardwareComponent) {
        if (hardwareComponent instanceof InterruptController && hardwareComponent.initialised()) {
            this.irqDevice = (InterruptController)hardwareComponent;
        }
        super.acceptComponent(hardwareComponent);
    }

    public String toString() {
        return "Intel 82371SB PIIX3 PCI ISA Bridge";
    }

    class DefaultIRQBouncer
    implements IRQBouncer {
        private PCIISABridge attachedISABridge;

        public DefaultIRQBouncer(PCIISABridge pCIISABridge2) {
            this.attachedISABridge = pCIISABridge2;
        }

        public void setIRQ(PCIDevice pCIDevice, int n, int n2) {
            this.attachedISABridge.setIRQ(pCIDevice, n, n2);
        }
    }
}

