/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.peripheral;

public class FloppyFormat {
    private static final FloppyFormat[] formats = new FloppyFormat[]{new FloppyFormat(0, 2, 18, 80, 1, "1.44 MB 3\"1/2"), new FloppyFormat(0, 2, 20, 80, 1, "1.6 MB 3\"1/2"), new FloppyFormat(0, 2, 21, 80, 1, "1.68 MB 3\"1/2"), new FloppyFormat(0, 2, 21, 82, 1, "1.72 MB 3\"1/2"), new FloppyFormat(0, 2, 21, 83, 1, "1.74 MB 3\"1/2"), new FloppyFormat(0, 2, 22, 80, 1, "1.76 MB 3\"1/2"), new FloppyFormat(0, 2, 23, 80, 1, "1.84 MB 3\"1/2"), new FloppyFormat(0, 2, 24, 80, 1, "1.92 MB 3\"1/2"), new FloppyFormat(1, 1, 36, 80, 1, "2.88 MB 3\"1/2"), new FloppyFormat(1, 1, 39, 80, 1, "3.12 MB 3\"1/2"), new FloppyFormat(1, 1, 40, 80, 1, "3.2 MB 3\"1/2"), new FloppyFormat(1, 1, 44, 80, 1, "3.52 MB 3\"1/2"), new FloppyFormat(1, 1, 48, 80, 1, "3.84 MB 3\"1/2"), new FloppyFormat(0, 3, 9, 80, 1, "720 kB 3\"1/2"), new FloppyFormat(0, 3, 10, 80, 1, "800 kB 3\"1/2"), new FloppyFormat(0, 3, 10, 82, 1, "820 kB 3\"1/2"), new FloppyFormat(0, 3, 10, 83, 1, "830 kB 3\"1/2"), new FloppyFormat(0, 3, 13, 80, 1, "1.04 MB 3\"1/2"), new FloppyFormat(0, 3, 14, 80, 1, "1.12 MB 3\"1/2"), new FloppyFormat(2, 1, 15, 80, 1, "1.2 kB 5\"1/4"), new FloppyFormat(2, 1, 18, 80, 1, "1.44 MB 5\"1/4"), new FloppyFormat(2, 1, 18, 82, 1, "1.48 MB 5\"1/4"), new FloppyFormat(2, 1, 18, 83, 1, "1.49 MB 5\"1/4"), new FloppyFormat(2, 1, 20, 80, 1, "1.6 MB 5\"1/4"), new FloppyFormat(2, 1, 9, 80, 1, "720 kB 5\"1/4"), new FloppyFormat(2, 1, 11, 80, 1, "880 kB 5\"1/4"), new FloppyFormat(2, 1, 9, 40, 1, "360 kB 5\"1/4"), new FloppyFormat(2, 1, 9, 40, 0, "180 kB 5\"1/4"), new FloppyFormat(2, 1, 10, 41, 1, "410 kB 5\"1/4"), new FloppyFormat(2, 1, 10, 42, 1, "420 kB 5\"1/4"), new FloppyFormat(2, 1, 8, 40, 1, "320 kB 5\"1/4"), new FloppyFormat(2, 1, 8, 40, 0, "160 kB 5\"1/4"), new FloppyFormat(0, 3, 9, 80, 0, "360 kB 3\"1/2"), new FloppyFormat(3, 5, -1, -1, 0, "")};
    private int drive;
    private int disk;
    private int lastSector;
    private int maxTrack;
    private int maxHead;
    private String description;

    private FloppyFormat(int n, int n2, int n3, int n4, int n5, String string) {
        this.drive = n;
        this.disk = n2;
        this.lastSector = n3;
        this.maxTrack = n4;
        this.maxHead = n5;
        this.description = string;
    }

    public int heads() {
        return this.maxHead + 1;
    }

    public int tracks() {
        return this.maxTrack;
    }

    public int sectors() {
        return this.lastSector;
    }

    public int drive() {
        return this.drive;
    }

    public long length() {
        return this.heads() * this.tracks() * this.sectors() * 512;
    }

    public String toString() {
        return this.description;
    }

    public static FloppyFormat findFormat(long l, int n) {
        int n2 = -1;
        for (int i = 0; i < formats.length && formats[i].drive() != 3; ++i) {
            if (n != formats[i].drive() && n != 3) continue;
            if (formats[i].length() == l) {
                return formats[i];
            }
            if (n2 != -1) continue;
            n2 = i;
        }
        if (n2 == -1) {
            return formats[1];
        }
        return formats[n2];
    }
}

