/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.peripheral;

import org.jpc.emulator.AbstractHardwareComponent;
import org.jpc.emulator.HardwareComponent;
import org.jpc.emulator.memory.LinearAddressSpace;
import org.jpc.emulator.memory.PhysicalAddressSpace;
import org.jpc.emulator.motherboard.IOPortCapable;
import org.jpc.emulator.motherboard.IOPortHandler;
import org.jpc.emulator.motherboard.InterruptController;
import org.jpc.emulator.processor.Processor;

public class Keyboard
extends AbstractHardwareComponent
implements IOPortCapable {
    private static final byte KBD_CCMD_READ_MODE = 32;
    private static final byte KBD_CCMD_WRITE_MODE = 96;
    private static final byte KBD_CCMD_GET_VERSION = -95;
    private static final byte KBD_CCMD_MOUSE_DISABLE = -89;
    private static final byte KBD_CCMD_MOUSE_ENABLE = -88;
    private static final byte KBD_CCMD_TEST_MOUSE = -87;
    private static final byte KBD_CCMD_SELF_TEST = -86;
    private static final byte KBD_CCMD_KBD_TEST = -85;
    private static final byte KBD_CCMD_KBD_DISABLE = -83;
    private static final byte KBD_CCMD_KBD_ENABLE = -82;
    private static final byte KBD_CCMD_READ_INPORT = -64;
    private static final byte KBD_CCMD_READ_OUTPORT = -48;
    private static final byte KBD_CCMD_WRITE_OUTPORT = -47;
    private static final byte KBD_CCMD_WRITE_OBUF = -46;
    private static final byte KBD_CCMD_WRITE_AUX_OBUF = -45;
    private static final byte KBD_CCMD_WRITE_MOUSE = -44;
    private static final byte KBD_CCMD_DISABLE_A20 = -35;
    private static final byte KBD_CCMD_ENABLE_A20 = -33;
    private static final byte KBD_CCMD_RESET = -2;
    private static final byte KBD_CMD_SET_LEDS = -19;
    private static final byte KBD_CMD_ECHO = -18;
    private static final byte KBD_CMD_GET_ID = -14;
    private static final byte KBD_CMD_SET_RATE = -13;
    private static final byte KBD_CMD_ENABLE = -12;
    private static final byte KBD_CMD_RESET_DISABLE = -11;
    private static final byte KBD_CMD_RESET_ENABLE = -10;
    private static final byte KBD_CMD_RESET = -1;
    private static final byte KBD_REPLY_POR = -86;
    private static final byte KBD_REPLY_ACK = -6;
    private static final byte KBD_REPLY_RESEND = -2;
    private static final byte KBD_STAT_OBF = 1;
    private static final byte KBD_STAT_IBF = 2;
    private static final byte KBD_STAT_SELFTEST = 4;
    private static final byte KBD_STAT_CMD = 8;
    private static final byte KBD_STAT_UNLOCKED = 16;
    private static final byte KBD_STAT_MOUSE_OBF = 32;
    private static final byte KBD_STAT_GTO = 64;
    private static final byte KBD_STAT_PERR = -128;
    private static final byte KBD_MODE_KBD_INT = 1;
    private static final byte KBD_MODE_MOUSE_INT = 2;
    private static final byte KBD_MODE_SYS = 4;
    private static final byte KBD_MODE_NO_KEYLOCK = 8;
    private static final byte KBD_MODE_DISABLE_KBD = 16;
    private static final byte KBD_MODE_DISABLE_MOUSE = 32;
    private static final byte KBD_MODE_KCC = 64;
    private static final byte KBD_MODE_RFU = -128;
    private static final byte AUX_SET_SCALE11 = -26;
    private static final byte AUX_SET_SCALE21 = -25;
    private static final byte AUX_SET_RES = -24;
    private static final byte AUX_GET_SCALE = -23;
    private static final byte AUX_SET_STREAM = -22;
    private static final byte AUX_POLL = -21;
    private static final byte AUX_RESET_WRAP = -20;
    private static final byte AUX_SET_WRAP = -18;
    private static final byte AUX_SET_REMOTE = -16;
    private static final byte AUX_GET_TYPE = -14;
    private static final byte AUX_SET_SAMPLE = -13;
    private static final byte AUX_ENABLE_DEV = -12;
    private static final byte AUX_DISABLE_DEV = -11;
    private static final byte AUX_SET_DEFAULT = -10;
    private static final byte AUX_RESET = -1;
    private static final byte AUX_ACK = -6;
    private static final byte MOUSE_STATUS_REMOTE = 64;
    private static final byte MOUSE_STATUS_ENABLED = 32;
    private static final byte MOUSE_STATUS_SCALE21 = 16;
    private static final int KBD_QUEUE_SIZE = 256;
    private KeyboardQueue queue = new KeyboardQueue();
    private byte commandWrite;
    private byte status;
    private byte mode;
    private int keyboardWriteCommand;
    private boolean keyboardScanEnabled;
    private int mouseWriteCommand;
    private byte mouseStatus;
    private byte mouseResolution;
    private byte mouseSampleRate;
    private boolean mouseWrap;
    private byte mouseType;
    private byte mouseDetectState;
    private int mouseDx;
    private int mouseDy;
    private int mouseDz;
    private byte mouseButtons;
    private boolean ioportRegistered = false;
    private InterruptController irqDevice;
    private Processor cpu = null;
    private PhysicalAddressSpace physicalAddressSpace = null;
    private LinearAddressSpace linearAddressSpace = null;

    public Keyboard() {
        this.reset();
    }

    public int[] ioPortsRequested() {
        return new int[]{96, 100};
    }

    public int ioPortReadByte(int n) {
        switch (n) {
            case 96: {
                return this.readData();
            }
            case 100: {
                return 0xFF & this.status;
            }
        }
        return -1;
    }

    public int ioPortReadWord(int n) {
        return 0xFF & this.ioPortReadByte(n) | 0xFF00 & this.ioPortReadByte(n + 1);
    }

    public int ioPortReadLong(int n) {
        System.out.println("Keyboard Read Long");
        return -1;
    }

    public void ioPortWriteByte(int n, int n2) {
        switch (n) {
            case 96: {
                this.writeData((byte)n2);
                break;
            }
            case 100: {
                this.writeCommand((byte)n2);
                break;
            }
        }
    }

    public void ioPortWriteWord(int n, int n2) {
        this.ioPortWriteByte(n, n2);
        this.ioPortWriteByte(n + 1, n2 >> 8);
    }

    public void ioPortWriteLong(int n, int n2) {
        this.ioPortWriteWord(n, n2);
        this.ioPortWriteWord(n + 2, n2 >> 16);
    }

    public void reset() {
        this.irqDevice = null;
        this.cpu = null;
        this.physicalAddressSpace = null;
        this.linearAddressSpace = null;
        this.ioportRegistered = false;
        this.keyboardWriteCommand = -1;
        this.mouseWriteCommand = -1;
        this.mode = (byte)3;
        this.status = (byte)24;
        this.queue.reset();
        this.commandWrite = 0;
        this.keyboardWriteCommand = 0;
        this.keyboardScanEnabled = false;
        this.mouseWriteCommand = 0;
        this.mouseStatus = 0;
        this.mouseResolution = 0;
        this.mouseSampleRate = 0;
        this.mouseWrap = false;
        this.mouseType = 0;
        this.mouseDetectState = 0;
        this.mouseDx = 0;
        this.mouseDy = 0;
        this.mouseDz = 0;
        this.mouseButtons = 0;
    }

    private void setGateA20State(boolean bl) {
        this.physicalAddressSpace.setGateA20State(bl);
    }

    private synchronized byte readData() {
        byte by = this.queue.readData();
        this.updateIRQ();
        return by;
    }

    private synchronized void writeData(byte by) {
        switch (this.commandWrite) {
            case 0: {
                this.writeKeyboard(by);
                break;
            }
            case 96: {
                this.mode = by;
                this.updateIRQ();
                break;
            }
            case -46: {
                this.queue.writeData(by, (byte)0);
                break;
            }
            case -45: {
                this.queue.writeData(by, (byte)1);
                break;
            }
            case -47: {
                this.setGateA20State((by & 2) != 0);
                if (1 == (by & 1)) break;
                this.cpu.reset();
                break;
            }
            case -44: {
                this.writeMouse(by);
                break;
            }
        }
        this.commandWrite = 0;
    }

    private synchronized void writeCommand(byte by) {
        switch (by) {
            case 32: {
                this.queue.writeData(this.mode, (byte)0);
                break;
            }
            case -47: 
            case -46: 
            case -45: 
            case -44: 
            case 96: {
                this.commandWrite = by;
                break;
            }
            case -89: {
                this.mode = (byte)(this.mode | 0x20);
                break;
            }
            case -88: {
                this.mode = (byte)(this.mode & 0xFFFFFFDF);
                break;
            }
            case -87: {
                this.queue.writeData((byte)0, (byte)0);
                break;
            }
            case -86: {
                this.status = (byte)(this.status | 4);
                this.queue.writeData((byte)85, (byte)0);
                break;
            }
            case -85: {
                this.queue.writeData((byte)0, (byte)0);
                break;
            }
            case -83: {
                this.mode = (byte)(this.mode | 0x10);
                this.updateIRQ();
                break;
            }
            case -82: {
                this.mode = (byte)(this.mode & 0xFFFFFFEF);
                this.updateIRQ();
                break;
            }
            case -64: {
                this.queue.writeData((byte)0, (byte)0);
                break;
            }
            case -48: {
                by = (byte)(1 | (this.physicalAddressSpace.getGateA20State() ? 2 : 0));
                if (0 != (this.status & 1)) {
                    by = (byte)(by | 0x10);
                }
                if (0 != (this.status & 0x20)) {
                    by = (byte)(by | 0x20);
                }
                this.queue.writeData(by, (byte)0);
                break;
            }
            case -33: {
                this.setGateA20State(true);
                break;
            }
            case -35: {
                this.setGateA20State(false);
                break;
            }
            case -2: {
                this.cpu.reset();
                break;
            }
            case -1: {
                break;
            }
            default: {
                System.err.println("Unsupported Keyboard Command " + Integer.toHexString(0xFF & by));
            }
        }
    }

    private synchronized void writeKeyboard(byte by) {
        block0 : switch (this.keyboardWriteCommand) {
            default: {
                switch (by) {
                    case 0: {
                        this.queue.writeData((byte)-6, (byte)0);
                        break block0;
                    }
                    case 5: {
                        this.queue.writeData((byte)-2, (byte)0);
                        break block0;
                    }
                    case -14: {
                        this.queue.writeData((byte)-6, (byte)0);
                        this.queue.writeData((byte)-85, (byte)0);
                        this.queue.writeData((byte)-125, (byte)0);
                        break block0;
                    }
                    case -18: {
                        this.queue.writeData((byte)-18, (byte)0);
                        break block0;
                    }
                    case -12: {
                        this.keyboardScanEnabled = true;
                        this.queue.writeData((byte)-6, (byte)0);
                        break block0;
                    }
                    case -19: 
                    case -13: {
                        this.keyboardWriteCommand = by;
                        this.queue.writeData((byte)-6, (byte)0);
                        break block0;
                    }
                    case -11: {
                        this.resetKeyboard();
                        this.keyboardScanEnabled = false;
                        this.queue.writeData((byte)-6, (byte)0);
                        break block0;
                    }
                    case -10: {
                        this.resetKeyboard();
                        this.keyboardScanEnabled = true;
                        this.queue.writeData((byte)-6, (byte)0);
                        break block0;
                    }
                    case -1: {
                        this.resetKeyboard();
                        this.queue.writeData((byte)-6, (byte)0);
                        this.queue.writeData((byte)-86, (byte)0);
                        break block0;
                    }
                }
                this.queue.writeData((byte)-6, (byte)0);
                break;
            }
            case -19: {
                this.queue.writeData((byte)-6, (byte)0);
                this.keyboardWriteCommand = -1;
                break;
            }
            case -13: {
                this.queue.writeData((byte)-6, (byte)0);
                this.keyboardWriteCommand = -1;
            }
        }
    }

    private synchronized void writeMouse(byte by) {
        block0 : switch (this.mouseWriteCommand) {
            default: {
                if (this.mouseWrap) {
                    if (by == -20) {
                        this.mouseWrap = false;
                        this.queue.writeData((byte)-6, (byte)1);
                        return;
                    }
                    if (by != -1) {
                        this.queue.writeData(by, (byte)1);
                        return;
                    }
                }
                switch (by) {
                    case -26: {
                        this.mouseStatus = (byte)(this.mouseStatus & 0xFFFFFFEF);
                        this.queue.writeData((byte)-6, (byte)1);
                        break block0;
                    }
                    case -25: {
                        this.mouseStatus = (byte)(this.mouseStatus | 0x10);
                        this.queue.writeData((byte)-6, (byte)1);
                        break block0;
                    }
                    case -22: {
                        this.mouseStatus = (byte)(this.mouseStatus & 0xFFFFFFBF);
                        this.queue.writeData((byte)-6, (byte)1);
                        break block0;
                    }
                    case -18: {
                        this.mouseWrap = true;
                        this.queue.writeData((byte)-6, (byte)1);
                        break block0;
                    }
                    case -16: {
                        this.mouseStatus = (byte)(this.mouseStatus | 0x40);
                        this.queue.writeData((byte)-6, (byte)1);
                        break block0;
                    }
                    case -14: {
                        this.queue.writeData((byte)-6, (byte)1);
                        this.queue.writeData(this.mouseType, (byte)1);
                        break block0;
                    }
                    case -24: 
                    case -13: {
                        this.mouseWriteCommand = by;
                        this.queue.writeData((byte)-6, (byte)1);
                        break block0;
                    }
                    case -23: {
                        this.queue.writeData((byte)-6, (byte)1);
                        this.queue.writeData(this.mouseStatus, (byte)1);
                        this.queue.writeData(this.mouseResolution, (byte)1);
                        this.queue.writeData(this.mouseSampleRate, (byte)1);
                        break block0;
                    }
                    case -21: {
                        this.queue.writeData((byte)-6, (byte)1);
                        this.mouseSendPacket();
                        break block0;
                    }
                    case -12: {
                        this.mouseStatus = (byte)(this.mouseStatus | 0x20);
                        this.queue.writeData((byte)-6, (byte)1);
                        break block0;
                    }
                    case -11: {
                        this.mouseStatus = (byte)(this.mouseStatus & 0xFFFFFFDF);
                        this.queue.writeData((byte)-6, (byte)1);
                        break block0;
                    }
                    case -10: {
                        this.mouseSampleRate = (byte)100;
                        this.mouseResolution = (byte)2;
                        this.mouseStatus = 0;
                        this.queue.writeData((byte)-6, (byte)1);
                        break block0;
                    }
                    case -1: {
                        this.mouseSampleRate = (byte)100;
                        this.mouseResolution = (byte)2;
                        this.mouseStatus = 0;
                        this.queue.writeData((byte)-6, (byte)1);
                        this.queue.writeData((byte)-86, (byte)1);
                        this.queue.writeData(this.mouseType, (byte)1);
                        break block0;
                    }
                }
                break;
            }
            case -13: {
                this.mouseSampleRate = by;
                this.queue.writeData((byte)-6, (byte)1);
                this.mouseWriteCommand = -1;
                break;
            }
            case -24: {
                this.mouseResolution = by;
                this.queue.writeData((byte)-6, (byte)1);
                this.mouseWriteCommand = -1;
            }
        }
    }

    private void resetKeyboard() {
        this.keyboardScanEnabled = true;
    }

    private synchronized void mouseSendPacket() {
        int n = this.mouseDx;
        int n2 = this.mouseDy;
        int n3 = this.mouseDz;
        if (n > 127) {
            n = 127;
        } else if (n < -127) {
            n = -127;
        }
        if (n2 > 127) {
            n2 = 127;
        } else if (n2 < -127) {
            n2 = -127;
        }
        int n4 = 0;
        int n5 = 0;
        if (n < 0) {
            n4 = 1;
        }
        if (n2 < 0) {
            n5 = 1;
        }
        byte by = (byte)(8 | n4 << 4 | n5 << 5 | this.mouseButtons & 7);
        this.queue.writeData(by, (byte)1);
        this.queue.writeData((byte)n, (byte)1);
        this.queue.writeData((byte)n2, (byte)1);
        switch (this.mouseType) {
            default: {
                break;
            }
            case 3: {
                if (n3 > 127) {
                    n3 = 127;
                } else if (n3 < -127) {
                    n3 = -127;
                }
                this.queue.writeData((byte)n3, (byte)1);
                break;
            }
            case 4: {
                if (n3 > 7) {
                    n3 = 7;
                } else if (n3 < -7) {
                    n3 = -7;
                }
                by = (byte)(n3 & 0xF | (this.mouseButtons & 0x18) << 1);
                this.queue.writeData(by, (byte)1);
            }
        }
        this.deltaMouseDX(-n);
        this.deltaMouseDY(-n2);
        this.deltaMouseDZ(-n3);
    }

    private synchronized void updateIRQ() {
        int n = 0;
        int n2 = 0;
        this.status = (byte)(this.status & 0xFFFFFFDE);
        if (this.queue.getCount() != 0) {
            this.status = (byte)(this.status | 1);
            if (0 != this.queue.getAux()) {
                this.status = (byte)(this.status | 0x20);
                if (0 != (this.mode & 2)) {
                    n2 = 1;
                }
            } else if (0 != (this.mode & 1) && 0 == (this.mode & 0x10)) {
                n = 1;
            }
        }
        this.irqDevice.setIRQ(1, n);
        this.irqDevice.setIRQ(12, n2);
    }

    private void deltaMouseDX(int n) {
        this.mouseDx += n;
    }

    private void deltaMouseDY(int n) {
        this.mouseDy += n;
    }

    private void deltaMouseDZ(int n) {
        this.mouseDz += n;
    }

    public synchronized void keyPressed(byte by) {
        switch (by) {
            case -1: {
                this.putKeyboardEvent((byte)-31);
                this.putKeyboardEvent((byte)29);
                this.putKeyboardEvent((byte)69);
                this.putKeyboardEvent((byte)-31);
                this.putKeyboardEvent((byte)-99);
                this.putKeyboardEvent((byte)-59);
                return;
            }
        }
        if (by < 0) {
            this.putKeyboardEvent((byte)-32);
        }
        this.putKeyboardEvent((byte)(by & 0x7F));
    }

    public synchronized void keyReleased(byte by) {
        if (by < 0) {
            this.putKeyboardEvent((byte)-32);
        }
        this.putKeyboardEvent((byte)(by | 0x80));
    }

    public synchronized void putKeyboardEvent(byte by) {
        this.queue.writeData(by, (byte)0);
    }

    public synchronized void putMouseEvent(int n, int n2, int n3, int n4) {
        block2: {
            if (0 == (this.mouseStatus & 0x20)) {
                return;
            }
            this.deltaMouseDX(n);
            this.deltaMouseDY(-n2);
            this.deltaMouseDZ(n3);
            this.mouseButtons = (byte)n4;
            if (0 != (this.mouseStatus & 0x40) || this.queue.getCount() >= 240) break block2;
            do {
                this.mouseSendPacket();
            } while (this.mouseDx != 0 || this.mouseDy != 0 || this.mouseDz != 0);
        }
    }

    public boolean initialised() {
        return this.ioportRegistered && this.irqDevice != null && this.cpu != null && this.physicalAddressSpace != null && this.linearAddressSpace != null;
    }

    public void acceptComponent(HardwareComponent hardwareComponent) {
        if (hardwareComponent instanceof InterruptController && hardwareComponent.initialised()) {
            this.irqDevice = (InterruptController)hardwareComponent;
        }
        if (hardwareComponent instanceof IOPortHandler && hardwareComponent.initialised()) {
            ((IOPortHandler)hardwareComponent).registerIOPortCapable(this);
            this.ioportRegistered = true;
        }
        if (hardwareComponent instanceof Processor && hardwareComponent.initialised()) {
            this.cpu = (Processor)hardwareComponent;
        }
        if (hardwareComponent instanceof PhysicalAddressSpace) {
            this.physicalAddressSpace = (PhysicalAddressSpace)hardwareComponent;
        }
        if (hardwareComponent instanceof LinearAddressSpace) {
            this.linearAddressSpace = (LinearAddressSpace)hardwareComponent;
        }
    }

    private class KeyboardQueue {
        private byte[] aux = new byte[256];
        private byte[] data = new byte[256];
        private int readPosition = 0;
        private int writePosition = 0;
        private int count = 0;

        public void reset() {
            this.readPosition = 0;
            this.writePosition = 0;
            this.count = 0;
        }

        public int getCount() {
            return this.count;
        }

        public byte getAux() {
            return this.aux[this.readPosition];
        }

        public byte readData() {
            if (this.count == 0) {
                int n = this.readPosition - 1;
                if (n < 0) {
                    n = 255;
                }
                return this.data[n];
            }
            byte by = this.aux[this.readPosition];
            byte by2 = this.data[this.readPosition];
            if (++this.readPosition == 256) {
                this.readPosition = 0;
            }
            --this.count;
            if (0 != by) {
                Keyboard.this.irqDevice.setIRQ(12, 0);
            } else {
                Keyboard.this.irqDevice.setIRQ(1, 0);
            }
            return by2;
        }

        public void writeData(byte by, byte by2) {
            if (this.count >= 256) {
                return;
            }
            this.aux[this.writePosition] = by2;
            this.data[this.writePosition] = by;
            if (++this.writePosition == 256) {
                this.writePosition = 0;
            }
            ++this.count;
            Keyboard.this.updateIRQ();
        }
    }
}

