/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.peripheral;

import org.jpc.emulator.AbstractHardwareComponent;
import org.jpc.emulator.HardwareComponent;
import org.jpc.emulator.motherboard.IOPortCapable;
import org.jpc.emulator.motherboard.IOPortHandler;
import org.jpc.emulator.motherboard.IntervalTimer;
import org.jpc.support.Clock;

public class PCSpeaker
extends AbstractHardwareComponent
implements IOPortCapable {
    private int dummyRefreshClock;
    private int speakerData;
    private IntervalTimer pit;
    private Clock timeSource;
    private boolean ioportRegistered = false;

    public int[] ioPortsRequested() {
        return new int[]{97};
    }

    public int ioPortReadByte(int n) {
        int n2 = this.pit.getOut(2, this.timeSource.getTime());
        this.dummyRefreshClock ^= 1;
        return this.speakerData << 1 | (this.pit.getGate(2) ? 1 : 0) | n2 << 5 | this.dummyRefreshClock << 4;
    }

    public int ioPortReadWord(int n) {
        return 0xFF & this.ioPortReadByte(n) | 0xFF00 & this.ioPortReadByte(n + 1) << 8;
    }

    public int ioPortReadLong(int n) {
        return 0xFFFF & this.ioPortReadWord(n) | 0xFFFF0000 & this.ioPortReadWord(n + 2) << 16;
    }

    public void ioPortWriteByte(int n, int n2) {
        this.speakerData = n2 >> 1 & 1;
        this.pit.setGate(2, (n2 & 1) != 0);
    }

    public void ioPortWriteWord(int n, int n2) {
        this.ioPortWriteByte(n, n2);
        this.ioPortWriteByte(n + 1, n2 >> 8);
    }

    public void ioPortWriteLong(int n, int n2) {
        this.ioPortWriteWord(n, n2);
        this.ioPortWriteWord(n + 2, n2 >> 16);
    }

    public boolean initialised() {
        return this.ioportRegistered && this.pit != null && this.timeSource != null;
    }

    public void reset() {
        this.pit = null;
        this.timeSource = null;
        this.ioportRegistered = false;
    }

    public void acceptComponent(HardwareComponent hardwareComponent) {
        if (hardwareComponent instanceof IntervalTimer && hardwareComponent.initialised()) {
            this.pit = (IntervalTimer)hardwareComponent;
        }
        if (hardwareComponent instanceof Clock && hardwareComponent.initialised()) {
            this.timeSource = (Clock)hardwareComponent;
        }
        if (hardwareComponent instanceof IOPortHandler && hardwareComponent.initialised()) {
            ((IOPortHandler)hardwareComponent).registerIOPortCapable(this);
            this.ioportRegistered = true;
        }
    }
}

