/*
 * Decompiled with CFR 0.152.
 */
package com.lemonquest.lq3d;

import com.lemonquest.util.LQConsole;
import java.io.DataInputStream;

public class LQBufferedTexture {
    protected int width;
    protected int height;
    protected int[] palette;
    protected byte[] data;
    protected byte[] indices;
    protected byte[] alphaIndices;

    public LQBufferedTexture(DataInputStream dis) {
        this.init(dis);
    }

    public boolean isIndexed() {
        return this.palette != null;
    }

    protected void init(DataInputStream dis) {
        try {
            int i;
            boolean isIndexedImage;
            this.width = dis.readShort();
            this.height = dis.readShort();
            boolean hasAlphaChannel = dis.readByte() > 0;
            byte[] alphaChannelPalette = null;
            if (hasAlphaChannel) {
                int i2;
                int alphaNum = dis.readShort();
                alphaChannelPalette = new byte[alphaNum];
                for (i2 = 0; i2 < alphaNum; ++i2) {
                    alphaChannelPalette[i2] = dis.readByte();
                }
                this.alphaIndices = new byte[this.width * this.height];
                for (i2 = 0; i2 < this.alphaIndices.length; ++i2) {
                    int index = dis.readUnsignedByte();
                    this.alphaIndices[i2] = (byte)index;
                }
            }
            boolean bl = isIndexedImage = dis.readByte() > 0;
            if (isIndexedImage) {
                int index;
                int paletteNum = dis.readShort();
                this.palette = new int[paletteNum];
                for (i = 0; i < paletteNum; ++i) {
                    int color;
                    this.palette[i] = color = dis.readInt();
                }
                this.indices = new byte[this.width * this.height];
                if (this.alphaIndices != null) {
                    this.data = new byte[this.width * this.height * 4];
                    for (i = 0; i < this.width * this.height; ++i) {
                        index = dis.readUnsignedByte();
                        this.indices[i] = (byte)index;
                        this.data[i * 4 + 0] = (byte)(this.palette[index] >> 16);
                        this.data[i * 4 + 1] = (byte)(this.palette[index] >> 8 & 0xFF);
                        this.data[i * 4 + 2] = (byte)(this.palette[index] >> 0 & 0xFF);
                        this.data[i * 4 + 3] = alphaChannelPalette[this.alphaIndices[i] & 0xFF];
                    }
                } else {
                    this.data = new byte[this.width * this.height * 3];
                    for (i = 0; i < this.width * this.height; ++i) {
                        index = dis.readUnsignedByte();
                        this.indices[i] = (byte)index;
                        this.data[i * 3 + 0] = (byte)(this.palette[index] >> 16);
                        this.data[i * 3 + 1] = (byte)(this.palette[index] >> 8 & 0xFF);
                        this.data[i * 3 + 2] = (byte)(this.palette[index] >> 0 & 0xFF);
                    }
                }
            } else if (this.alphaIndices != null) {
                int datalen = this.width * this.height * 4;
                this.data = new byte[datalen];
                dis.read(this.data, 0, datalen);
                for (i = 0; i < this.data.length; i += 4) {
                    byte tmp = this.data[i + 0];
                    this.data[i + 0] = this.data[i + 2];
                    this.data[i + 2] = tmp;
                    this.data[i + 3] = alphaChannelPalette[this.alphaIndices[i / 4] & 0xFF];
                }
            } else {
                int pixelNum = this.width * this.height;
                byte[] rawData = new byte[pixelNum * 4];
                dis.read(rawData, 0, rawData.length);
                this.data = new byte[pixelNum * 3];
                for (int i3 = 0; i3 < pixelNum; ++i3) {
                    this.data[i3 * 3 + 0] = rawData[i3 * 4 + 2];
                    this.data[i3 * 3 + 1] = rawData[i3 * 4 + 1];
                    this.data[i3 * 3 + 2] = rawData[i3 * 4 + 0];
                }
                rawData = null;
            }
        }
        catch (Exception e) {
            LQConsole.println("Failed to create texture. Error: " + e);
            e.printStackTrace();
        }
    }

    public boolean hasAlpha() {
        return this.alphaIndices != null;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public byte[] data() {
        return this.data;
    }

    public int[] getPalette() {
        return this.palette;
    }

    public byte[] getIndices() {
        return this.indices;
    }

    public void updatePalette(int[] pal) {
        this.palette = pal;
    }

    public static int unsignedByteToInt(byte b) {
        return b & 0xFF;
    }
}

