/*
 * Decompiled with CFR 0.152.
 */
package com.lemonquest.lq3d_m3g;

import com.lemonquest.lq3d.LQAppearance;
import com.lemonquest.lq3d.LQBillboard;
import com.lemonquest.lq3d.LQCamera;
import com.lemonquest.lq3d.LQFactory;
import com.lemonquest.lq3d.LQGraphics3D;
import com.lemonquest.lq3d.LQPrimitive;
import com.lemonquest.lq3d.LQTransform;
import com.lemonquest.lq3d_m3g.LQCamera_m3g;
import javax.microedition.m3g.Transform;

public class LQBillboard_m3g
extends LQBillboard {
    private LQPrimitive bbPrim;
    private LQTransform bbTrans = LQFactory.LQTransform();

    public LQBillboard_m3g(float scaleX, float scaleY, String textureFile, int pixelBlendMode) {
        super(scaleX, scaleY, textureFile, pixelBlendMode);
        LQAppearance primApp = LQFactory.LQAppearance(0, textureFile, 0, pixelBlendMode, 0);
        this.create(scaleX, scaleY, primApp);
    }

    public LQBillboard_m3g(float scaleX, float scaleY, LQAppearance app) {
        super(scaleX, scaleY, app);
        this.create(scaleX, scaleY, app);
    }

    private void create(float scaleX, float scaleY, LQAppearance app) {
        short[] verts = new short[]{(short)(-1.0f * (scaleX /= 2.0f)), (short)(-1.0f * (scaleY /= 2.0f)), 0, (short)(1.0f * scaleX), (short)(-1.0f * scaleY), 0, (short)(-1.0f * scaleX), (short)(1.0f * scaleY), 0, (short)(1.0f * scaleX), (short)(1.0f * scaleY), 0};
        short[] texels = new short[]{0, 1, 1, 1, 0, 0, 1, 0};
        this.bbPrim = LQFactory.LQPrimitive(verts, null, null, texels, 1, app);
    }

    public void setAppearance(LQAppearance app) {
        this.bbPrim.setAppearance(app);
    }

    public void update(LQCamera camera, float[] newPosition, short[] texels) {
        if (newPosition != null) {
            this.bbTrans.identity();
            this.bbTrans.translateWorld(newPosition[0], newPosition[1], newPosition[2]);
        }
        float[] matrix = new float[16];
        this.bbTrans.get(matrix);
        float[] pos = new float[]{matrix[3], matrix[7], matrix[11]};
        Transform camTrans = (Transform)((LQCamera_m3g.CamData)camera.data()).m_transform.data();
        float[] camMatrix = new float[16];
        camTrans.get(camMatrix);
        float[] target = new float[]{pos[0] + (pos[0] - camMatrix[3]), pos[1] + (pos[1] - camMatrix[7]), pos[2] + (pos[2] - camMatrix[11])};
        float[] up = new float[]{camMatrix[1], camMatrix[5], camMatrix[9]};
        camera.targetAt(this.bbTrans, pos, target, up);
        if (texels != null) {
            this.bbPrim.fastUpdateTexels(texels);
        }
    }

    public void draw(LQGraphics3D g3d) {
        g3d.render(this.bbPrim, this.bbTrans);
    }

    public LQPrimitive getPrimitive() {
        return this.bbPrim;
    }
}

