/*
 * Decompiled with CFR 0.152.
 */
package com.lemonquest.lq3d_m3g;

import com.lemonquest.lq3d.LQCamera;
import com.lemonquest.lq3d.LQConfig;
import com.lemonquest.lq3d.LQGraphics3D;
import com.lemonquest.lq3d.LQMesh;
import com.lemonquest.lq3d.LQPrimitive;
import com.lemonquest.lq3d.LQTransform;
import com.lemonquest.lq3d_m3g.LQCamera_m3g;
import com.lemonquest.lq3d_m3g.LQPrimitive_m3g;
import javax.microedition.lcdui.Graphics;
import javax.microedition.m3g.Appearance;
import javax.microedition.m3g.Background;
import javax.microedition.m3g.Graphics3D;
import javax.microedition.m3g.Light;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.Transform;

public class LQGraphics3D_m3g
extends LQGraphics3D {
    protected Graphics3D m_g3d = Graphics3D.getInstance();
    protected LQCamera m_camera;
    protected Background m_background;

    public LQGraphics3D_m3g() {
        Light light = new Light();
        light.setMode(128);
        light.setIntensity(LQConfig.M3G_LIGHT_INTENSITY);
        this.m_g3d.addLight(light, null);
        this.m_background = new Background();
        this.m_background.setColorClearEnable(false);
        this.m_background.setDepthClearEnable(true);
    }

    public void bindTarget(Object target) {
        ((Graphics)target).setClip(LQConfig.ScreenX, LQConfig.ScreenY, LQConfig.ScreenWidth, LQConfig.ScreenHeight);
        this.m_g3d.bindTarget(target, LQConfig.M3G_EnableDepthBuffer, 0);
        renderedVertNum = 0;
    }

    public void flush() {
    }

    public void releaseTarget() {
        this.m_g3d.releaseTarget();
    }

    public void clear() {
        this.m_g3d.clear(this.m_background);
    }

    public void render(LQMesh mesh, LQTransform transform) {
        LQCamera_m3g.CamData camData = (LQCamera_m3g.CamData)this.m_camera.data();
        this.m_g3d.setCamera(camData.m_camera, (Transform)camData.m_transform.data());
        this.m_g3d.render((Node)mesh.data(), (Transform)transform.data());
    }

    public void render(LQPrimitive primitive, LQTransform transform) {
        LQCamera_m3g.CamData camData = (LQCamera_m3g.CamData)this.m_camera.data();
        this.m_g3d.setCamera(camData.m_camera, (Transform)camData.m_transform.data());
        Appearance app = (Appearance)primitive.getAppearance().data();
        LQPrimitive_m3g.MeshData data = (LQPrimitive_m3g.MeshData)primitive.data();
        this.m_g3d.render(data.vertexBuf, data.indexBuf, app, (Transform)transform.data());
        renderedVertNum += primitive.getTotalVertNum();
    }

    public void render(LQMesh mesh, int pixelBlendingMode, LQTransform transform) {
        int oldPixelBlendingMode = mesh.getAppearance().getPixelBlending();
        mesh.getAppearance().setPixelBlending(pixelBlendingMode);
        this.render(mesh, transform);
        mesh.getAppearance().setPixelBlending(oldPixelBlendingMode);
    }

    public void render(LQPrimitive primitive, int pixelBlendingMode, LQTransform transform) {
        int oldPixelBlendingMode = primitive.getAppearance().getPixelBlending();
        primitive.getAppearance().setPixelBlending(pixelBlendingMode);
        this.render(primitive, transform);
        primitive.getAppearance().setPixelBlending(oldPixelBlendingMode);
        renderedVertNum += primitive.getTotalVertNum();
    }

    public void setCamera(LQCamera camera) {
        this.m_camera = camera;
    }

    public LQCamera getCamera() {
        return this.m_camera;
    }

    public Object data() {
        return this.m_g3d;
    }
}

