/*
 * Decompiled with CFR 0.152.
 */
package com.lemonquest.lq3d_m3g;

import com.lemonquest.lq3d.LQAppearance;
import com.lemonquest.lq3d.LQPrimitive;
import com.lemonquest.lq3d.renderlist.LQRenderNode;
import java.io.DataInputStream;
import java.io.IOException;
import javax.microedition.m3g.Appearance;
import javax.microedition.m3g.IndexBuffer;
import javax.microedition.m3g.Texture2D;
import javax.microedition.m3g.TriangleStripArray;
import javax.microedition.m3g.VertexArray;
import javax.microedition.m3g.VertexBuffer;

public class LQPrimitive_m3g
extends LQPrimitive {
    protected MeshData m_data;
    VertexArray verticesArray;
    VertexArray normalArray;
    VertexArray colorArray;
    VertexArray texelArray;
    float m_texScale = 1.0f;
    protected int m_primitiveType;
    protected int m_maxVertices;
    protected int m_curVerticesNumber;

    public LQPrimitive_m3g(int primitiveType, LQAppearance appearance, int maxVertices) {
        this.init(primitiveType, appearance, maxVertices);
    }

    public LQPrimitive_m3g(short[] vertices, short[] normals, byte[] colors, short[] texels, int primitiveType, LQAppearance appearance) {
        this.init(primitiveType, appearance, vertices.length / 3);
        this.addSubPrim(vertices, normals, colors, texels);
    }

    public LQPrimitive_m3g(LQRenderNode renderNode, LQAppearance app) {
        this.init(0, app, renderNode.getVertex().length / 3);
        this.addSubPrim(renderNode.getVertex(), null, renderNode.getColor(), renderNode.getTexels());
    }

    public void v2FromFileStream(DataInputStream dis, String meshName, LQAppearance appearance) throws Exception {
        Texture2D tex;
        boolean haveColorArray;
        int i;
        int i2;
        if (dis == null) {
            throw new IOException();
        }
        int version = dis.readInt();
        int vertNum = dis.readInt();
        short[] vertices = new short[vertNum * 3];
        for (i2 = 0; i2 < vertNum * 3; ++i2) {
            vertices[i2] = dis.readShort();
        }
        for (i2 = 0; i2 < vertNum; ++i2) {
            System.out.println("v" + i2 + "(" + vertices[i2 * 3] + ", " + vertices[i2 * 3 + 1] + ", " + vertices[i2 * 3 + 2] + ")");
        }
        int[] stripIndices = null;
        int[] stripLengths = null;
        boolean useStripOptimize = dis.readInt() > 0;
        int vertNum2 = 0;
        short[] vertices2 = null;
        short[] texels = null;
        if (!useStripOptimize) {
            int i3;
            int faceNum = dis.readInt();
            int vertPerFace = 3;
            int[] faces = new int[faceNum * 3];
            for (i = 0; i < faceNum * 3; ++i) {
                faces[i] = dis.readInt();
            }
            int texFaceNum = dis.readInt();
            vertices2 = new short[texFaceNum * 3 * 3];
            texels = new short[texFaceNum * 3 * 2];
            int TexImgWidth = 256;
            int TexImgHeight = 256;
            for (i3 = 0; i3 < texFaceNum; ++i3) {
                for (int verIndex = 0; verIndex < 3; ++verIndex) {
                    vertices2[(i3 * 3 + verIndex) * 3 + 0] = (short)dis.readFloat();
                    vertices2[(i3 * 3 + verIndex) * 3 + 1] = (short)dis.readFloat();
                    vertices2[(i3 * 3 + verIndex) * 3 + 2] = (short)dis.readFloat();
                    texels[(i3 * 3 + verIndex) * 2 + 0] = (short)(dis.readFloat() * 256.0f);
                    texels[(i3 * 3 + verIndex) * 2 + 1] = (short)(dis.readFloat() * 256.0f);
                }
            }
            stripIndices = faces;
            stripLengths = new int[faceNum];
            for (i3 = 0; i3 < faceNum; ++i3) {
                stripLengths[i3] = 3;
            }
        } else {
            int stripNum = dis.readInt();
            int stripIndicesNum = dis.readInt();
            stripIndices = new int[stripIndicesNum];
            stripLengths = new int[stripNum];
            int count = 0;
            for (int stripIndex = 0; stripIndex < stripNum; ++stripIndex) {
                stripLengths[stripIndex] = dis.readInt();
                for (int vertexIndex = 0; vertexIndex < stripLengths[stripIndex]; ++vertexIndex) {
                    stripIndices[count++] = dis.readInt();
                }
            }
        }
        byte[] colors = null;
        boolean bl = haveColorArray = dis.readInt() > 0;
        if (haveColorArray) {
            int colorNum = dis.readInt();
            colors = new byte[colorNum * 4];
            for (i = 0; i < colorNum; ++i) {
                int c = dis.readInt();
                colors[i * 4] = (byte)(c >> 16 & 0xFF);
                colors[i * 4 + 1] = (byte)(c >> 8 & 0xFF);
                colors[i * 4 + 2] = (byte)(c & 0xFF);
                colors[i * 4 + 3] = -1;
            }
        }
        this.m_primitiveType = 0;
        this.setAppearance(appearance);
        int textureSize = 0;
        Appearance app = (Appearance)this.m_appearance.data();
        if (app != null && (tex = app.getTexture(0)) != null) {
            textureSize = Math.max(tex.getImage().getWidth(), tex.getImage().getHeight());
        }
        if (textureSize > 0) {
            this.m_texScale /= (float)textureSize;
        }
        this.m_maxVertices = vertNum2;
        this.m_data = new MeshData();
        this.m_data.vertexBuf = new VertexBuffer();
        this.m_data.indexBuf = new TriangleStripArray(stripIndices, stripLengths);
        this.verticesArray = new VertexArray(this.m_maxVertices, 3, 2);
        this.texelArray = new VertexArray(this.m_maxVertices, 2, 2);
        int verticesNumber = this.m_maxVertices;
        this.verticesArray.set(this.m_curVerticesNumber, verticesNumber, vertices2);
        this.m_data.vertexBuf.setPositions(this.verticesArray, 0.1f, null);
        if (colors != null && colors.length * 3 == vertices2.length * 4) {
            if (this.colorArray == null) {
                this.colorArray = new VertexArray(this.m_maxVertices, 4, 1);
            }
            this.colorArray.set(this.m_curVerticesNumber, verticesNumber, colors);
            this.m_data.vertexBuf.setColors(this.colorArray);
        }
        if (texels != null && texels.length / 2 == verticesNumber) {
            this.texelArray.set(this.m_curVerticesNumber, verticesNumber, texels);
            this.m_data.vertexBuf.setTexCoords(0, this.texelArray, this.m_texScale, null);
        }
        this.m_curVerticesNumber = this.m_maxVertices;
    }

    public void fromFile(String fileName, String meshName) {
    }

    protected void init(int primitiveType, LQAppearance appearance, int maxVertices) {
        Texture2D tex;
        this.m_primitiveType = primitiveType;
        this.setAppearance(appearance);
        int textureSize = 0;
        Appearance app = (Appearance)this.m_appearance.data();
        if (app != null && (tex = app.getTexture(0)) != null) {
            textureSize = Math.max(tex.getImage().getWidth(), tex.getImage().getHeight());
        }
        if (textureSize > 0) {
            this.m_texScale /= (float)textureSize;
        }
        this.m_maxVertices = maxVertices;
        this.m_data = new MeshData();
        this.m_data.vertexBuf = new VertexBuffer();
        int[] stripLengths = null;
        if (this.m_primitiveType == 0) {
            stripLengths = new int[this.m_maxVertices / 3];
            for (int i = 0; i < stripLengths.length; ++i) {
                stripLengths[i] = 3;
            }
        } else if (this.m_primitiveType == 1) {
            stripLengths = new int[this.m_maxVertices / 4];
            for (int i = 0; i < stripLengths.length; ++i) {
                stripLengths[i] = 4;
            }
        }
        this.m_data.indexBuf = new TriangleStripArray(0, stripLengths);
        this.verticesArray = new VertexArray(this.m_maxVertices, 3, 2);
        this.texelArray = new VertexArray(this.m_maxVertices, 2, 2);
    }

    public int addSubPrim(short[] vertices, short[] normals, byte[] colors, short[] texels) {
        if (vertices == null) {
            return -1;
        }
        int verticesNumber = vertices.length / 3;
        if (this.m_curVerticesNumber + verticesNumber > this.m_maxVertices) {
            return -1;
        }
        this.verticesArray.set(this.m_curVerticesNumber, verticesNumber, vertices);
        this.m_data.vertexBuf.setPositions(this.verticesArray, 0.1f, null);
        if (normals != null) {
            if (this.normalArray == null) {
                this.normalArray = new VertexArray(this.m_maxVertices, 3, 2);
            }
            if (normals.length == verticesNumber * 3) {
                this.normalArray.set(this.m_curVerticesNumber, verticesNumber, normals);
            }
            if (this.m_primitiveType == 0 && normals.length == verticesNumber || this.m_primitiveType == 1 && normals.length / 3 == verticesNumber / 4) {
                short[] per_face_normal = new short[normals.length * 4];
                for (int i = 0; i < per_face_normal.length; i += 12) {
                    short x = normals[i / 12];
                    short y = normals[i / 12 + 1];
                    short z = normals[i / 12 + 2];
                    per_face_normal[i] = x;
                    per_face_normal[i + 1] = y;
                    per_face_normal[i + 2] = z;
                    per_face_normal[i + 3] = x;
                    per_face_normal[i + 4] = y;
                    per_face_normal[i + 5] = z;
                    per_face_normal[i + 6] = x;
                    per_face_normal[i + 7] = y;
                    per_face_normal[i + 8] = z;
                    per_face_normal[i + 9] = x;
                    per_face_normal[i + 10] = y;
                    per_face_normal[i + 11] = z;
                }
                this.normalArray.set(this.m_curVerticesNumber, verticesNumber, per_face_normal);
            }
            this.m_data.vertexBuf.setNormals(this.normalArray);
        }
        if (colors != null && colors.length * 3 == vertices.length * 4) {
            if (this.colorArray == null) {
                this.colorArray = new VertexArray(this.m_maxVertices, 4, 1);
            }
            this.colorArray.set(this.m_curVerticesNumber, verticesNumber, colors);
            this.m_data.vertexBuf.setColors(this.colorArray);
        }
        if (texels != null && texels.length / 2 == verticesNumber) {
            this.texelArray.set(this.m_curVerticesNumber, verticesNumber, texels);
            this.m_data.vertexBuf.setTexCoords(0, this.texelArray, this.m_texScale, null);
        }
        this.m_curVerticesNumber += verticesNumber;
        return this.m_curVerticesNumber - verticesNumber;
    }

    public int getTotalVertNum() {
        return this.m_maxVertices;
    }

    public void fastUpdateVert(int vertexIndex, short[] vertices) {
        this.fastUpdateVert(vertexIndex, vertices, vertices.length / 3);
    }

    public void fastUpdateVert(int vertexIndex, short[] vertices, int vertexNum) {
        try {
            this.verticesArray.set(vertexIndex, vertexNum, vertices);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.m_data.vertexBuf.setPositions(this.verticesArray, 0.1f, null);
    }

    public void fastUpdateTexels(int vertexIndex, short[] texels) {
        this.fastUpdateTexels(vertexIndex, texels, texels.length / 2);
    }

    public void fastUpdateTexels(int vertexIndex, short[] texels, int vertNum) {
        if (texels == null) {
            return;
        }
        this.texelArray.set(vertexIndex, vertNum, texels);
        this.m_data.vertexBuf.setTexCoords(0, this.texelArray, this.m_texScale, null);
    }

    public Object data() {
        return this.m_data;
    }

    public void setAppearance(LQAppearance appearance) {
        this.m_appearance = null;
        this.m_appearance = appearance;
    }

    public void create(short[] vertices, short[] normals, byte[] colors, short[] texels, int primitiveType, LQAppearance appearance) {
    }

    public void fastUpdateVert(short[] vertices) {
        if (vertices.length > this.m_maxVertices * 3) {
            return;
        }
        this.verticesArray.set(0, vertices.length / 3, vertices);
        this.m_data.vertexBuf.setPositions(this.verticesArray, 0.1f, null);
    }

    public void fastUpdateTexels(short[] texels) {
        if (texels == null) {
            return;
        }
        this.texelArray.set(0, texels.length / 2, texels);
        this.m_data.vertexBuf.setTexCoords(0, this.texelArray, this.m_texScale, null);
    }

    public void fastUpdateColors(byte[] colors) {
        if (colors == null) {
            return;
        }
        if (this.colorArray == null) {
            this.colorArray = new VertexArray(this.m_maxVertices, 4, 1);
        }
        if (colors.length == this.m_maxVertices * 4) {
            this.colorArray.set(0, colors.length / 4, colors);
            this.m_data.vertexBuf.setColors(this.colorArray);
        } else if (colors.length == 4) {
            int color = colors[3] << 24 | colors[0] << 16 | colors[1] << 8 | colors[0];
            this.m_data.vertexBuf.setDefaultColor(color);
        }
    }

    public void fastUpdateColors(int vertexIndex, byte[] colors) {
        if (colors == null) {
            return;
        }
        if (this.colorArray == null) {
            this.colorArray = new VertexArray(this.m_maxVertices, 4, 1);
        }
        this.colorArray.set(vertexIndex, colors.length / 4, colors);
        this.m_data.vertexBuf.setColors(this.colorArray);
    }

    public void setARGBColor(int color) {
        this.m_data.vertexBuf.setDefaultColor(color);
    }

    public static class MeshData {
        public VertexBuffer vertexBuf;
        public IndexBuffer indexBuf;
    }
}

