/*
 * Decompiled with CFR 0.152.
 */
package com.lemonquest.math;

import com.lemonquest.math.LQMath;

public abstract class MathFP {
    private static int _fbits = 12;
    private static int _digits = 4;
    private static int _one;
    private static int _fmask;
    private static int _dmul;
    private static int _flt;
    private static int _pi;
    private static int[] e;
    public static int degree2radian;
    public static int Epsilon;
    public static int PI;
    public static int E;
    public static final int MAX_VALUE = Integer.MAX_VALUE;
    public static final int MIN_VALUE = -2147483647;
    public static final int ONE;
    static int[] SinTable;

    public static int setPrecision(int p) {
        if (p > 12 || p < 0) {
            return _digits;
        }
        _fbits = p;
        _one = 1 << p;
        _flt = 12 - p;
        _digits = 0;
        _dmul = 1;
        _fmask = _one - 1;
        PI = _pi >> _flt;
        E = e[1] >> _flt;
        degree2radian = MathFP.toFP("0.0174533");
        int j = _one;
        while (j != 0) {
            j /= 10;
            ++_digits;
            _dmul *= 10;
        }
        return _digits;
    }

    public static int getPrecision() {
        return _fbits;
    }

    public static int toInt(int x) {
        if (x < 0) {
            return -(MathFP.round(-x, 0) >> _fbits);
        }
        return MathFP.round(x, 0) >> _fbits;
    }

    public static int toFP(int x) {
        return x << _fbits;
    }

    public static int toFP(float f) {
        return LQMath.round(f * (float)ONE);
    }

    public static int convert(int i, int p) {
        int byte0;
        int n = byte0 = i >= 0 ? 1 : -1;
        if (MathFP.abs(p) < 13) {
            i = _fbits < p ? i + byte0 * (1 << (p - _fbits >> 1)) >> p - _fbits : (i <<= _fbits - p);
        }
        return i;
    }

    public static int toFP(String s) {
        int i = 0;
        if (s.charAt(0) == '-') {
            i = 1;
        }
        String s1 = "-1";
        int j = s.indexOf(46);
        if (j >= 0) {
            s1 = s.substring(j + 1, s.length());
            while (s1.length() < _digits) {
                s1 = s1 + "0";
            }
            if (s1.length() > _digits) {
                s1 = s1.substring(0, _digits);
            }
        } else {
            j = s.length();
        }
        int k = 0;
        if (i != j) {
            k = Integer.parseInt(s.substring(i, j));
        }
        int l = Integer.parseInt(s1) + 1;
        int i1 = (k << _fbits) + (l << _fbits) / _dmul;
        if (i == 1) {
            i1 = -i1;
        }
        return i1;
    }

    public static String toString(int x) {
        boolean flag = false;
        if (x < 0) {
            flag = true;
            x = -x;
        }
        int j = x >> _fbits;
        int k = _dmul * (x & _fmask) >> _fbits;
        String s = Integer.toString(k);
        while (s.length() < _digits) {
            s = "0" + s;
        }
        return (flag ? "-" : "") + Integer.toString(j) + "." + s;
    }

    public static String toString(int x, int d) {
        if (d > _digits) {
            d = _digits;
        }
        String s = MathFP.toString(MathFP.round(x, d));
        return s.substring(0, s.length() - _digits + d);
    }

    public static int max(int m, int n) {
        return m >= n ? m : n;
    }

    public static int min(int m, int n) {
        return n >= m ? m : n;
    }

    public static int round(int x, int p) {
        int k = 10;
        for (int l = 0; l < p; ++l) {
            k *= 10;
        }
        k = MathFP.div(MathFP.toFP(5), MathFP.toFP(k));
        if (x < 0) {
            k = -k;
        }
        return x + k;
    }

    public static int mul(int m, int n) {
        boolean flag = false;
        int k = _fbits;
        int l = _fmask;
        if ((m & l) == 0) {
            return (m >> k) * n;
        }
        if ((n & l) == 0) {
            return m * (n >> k);
        }
        if (m < 0 && n > 0 || m > 0 && n < 0) {
            flag = true;
        }
        if (m < 0) {
            m = -m;
        }
        if (n < 0) {
            n = -n;
        }
        while (MathFP.max(m, n) >= 1 << 31 - k) {
            m >>= 1;
            n >>= 1;
            l >>= 1;
            --k;
        }
        int i1 = (m >> k) * (n >> k) << k;
        int j1 = (m & l) * (n & l) >> k;
        if ((i1 = i1 + (j1 += (m & ~l) * (n & l) >> k) + ((m & l) * (n & ~l) >> k) << _fbits - k) < 0) {
            throw new ArithmeticException("Overflow");
        }
        return flag ? -i1 : i1;
    }

    public static int div(int m, int n) {
        boolean flag = false;
        int k = _fbits;
        if (n == _one) {
            return m;
        }
        if ((n & _fmask) == 0) {
            return m / (n >> k);
        }
        if (m < 0 && n > 0 || m > 0 && n < 0) {
            flag = true;
        }
        if (m < 0) {
            m = -m;
        }
        if (n < 0) {
            n = -n;
        }
        while (MathFP.max(m, n) >= 1 << 31 - k) {
            m >>= 1;
            n >>= 1;
            --k;
        }
        int l = (m << k) / n << _fbits - k;
        return flag ? -l : l;
    }

    public static int add(int m, int n) {
        return m + n;
    }

    public static int sub(int m, int n) {
        return m - n;
    }

    public static int abs(int x) {
        if (x < 0) {
            return -x;
        }
        return x;
    }

    public static int sqrt(int n, int r) {
        if (n < 0) {
            throw new ArithmeticException("Bad Input");
        }
        if (n == 0) {
            return 0;
        }
        int k = n + _one >> 1;
        for (int l = 0; l < r; ++l) {
            k = k + MathFP.div(n, k) >> 1;
        }
        if (k < 0) {
            throw new ArithmeticException("Overflow");
        }
        return k;
    }

    public static int FastDistance2D(int x, int y) {
        x = MathFP.abs(x);
        y = MathFP.abs(y);
        int mn = MathFP.min(x, y);
        return x + y - (mn >> 1) - (mn >> 2) + (mn >> 4);
    }

    public static int sqrt(int n) {
        return MathFP.sqrt(n, 16);
    }

    public static int sin(int r) {
        int j = MathFP.mul(r, MathFP.div(MathFP.toFP(180), PI));
        if ((j %= MathFP.toFP(360)) < 0) {
            j = MathFP.toFP(360) + j;
        }
        int k = j;
        if (j >= MathFP.toFP(90) && j < MathFP.toFP(270)) {
            k = MathFP.toFP(180) - j;
        } else if (j >= MathFP.toFP(270) && j < MathFP.toFP(360)) {
            k = -(MathFP.toFP(360) - j);
        }
        int l = k / 90;
        int i1 = MathFP.mul(l, l);
        int j1 = MathFP.mul(MathFP.mul(MathFP.mul(MathFP.mul(-18 >> _flt, i1) + (326 >> _flt), i1) - (2646 >> _flt), i1) + (6434 >> _flt), l);
        return j1;
    }

    public static int asin(int x) {
        boolean flag;
        if (MathFP.abs(x) > _one) {
            throw new ArithmeticException("asin bad input: " + x);
        }
        boolean bl = flag = x < 0;
        if (x < 0) {
            x = -x;
        }
        int j = MathFP.mul(MathFP.mul(MathFP.mul(MathFP.mul(35 >> _flt, x) - (146 >> _flt), x) + (347 >> _flt), x) - (877 >> _flt), x) + (6434 >> _flt);
        int k = PI / 2 - MathFP.mul(MathFP.sqrt(_one - x), j);
        return flag ? -k : k;
    }

    public static int cos(int r) {
        return MathFP.sin(PI / 2 - r);
    }

    public static int acos(int r) {
        return PI / 2 - MathFP.asin(r);
    }

    public static int tan(int r) {
        return MathFP.div(MathFP.sin(r), MathFP.cos(r));
    }

    public static int cot(int r) {
        return MathFP.div(MathFP.cos(r), MathFP.sin(r));
    }

    public static int atan(int r) {
        return MathFP.asin(MathFP.div(r, MathFP.sqrt(_one + MathFP.mul(r, r))));
    }

    public static int lookupSin(int g) {
        int delta = 1;
        if (g < 0) {
            g *= -1;
            delta = -1;
        }
        if (g > 360) {
            g %= 360;
        }
        if (g <= 90) {
            return SinTable[g] * delta;
        }
        if (g > 90 && g <= 180) {
            return SinTable[90 - (g - 90)] * delta;
        }
        if (g > 180 && g <= 270) {
            return -SinTable[g - 180] * delta;
        }
        return -SinTable[360 - g] * delta;
    }

    public static int lookupCos(int g) {
        if ((g = Math.abs(g)) >= 360) {
            g %= 360;
        }
        if (g <= 90) {
            return MathFP.lookupSin(90 - g);
        }
        if (g > 90 && g <= 180) {
            return -MathFP.lookupSin(g - 90);
        }
        if (g > 180 && g <= 270) {
            return MathFP.lookupSin(270 - (g - 180));
        }
        return -MathFP.lookupSin(360 - (g - 270));
    }

    public static int lookupTan(int g) {
        return MathFP.lookupSin(g) / MathFP.lookupCos(g);
    }

    public static int lookupArcsin(int n) {
        for (int i = 0; i < 360; ++i) {
            if (MathFP.lookupSin(i) < n) continue;
            return i;
        }
        return 0;
    }

    public static int exp(int x) {
        if (x == 0) {
            return _one;
        }
        boolean flag = x < 0;
        x = MathFP.abs(x);
        int j = x >> _fbits;
        int k = _one;
        for (int l = 0; l < j / 4; ++l) {
            k = MathFP.mul(k, e[4] >> _flt);
        }
        if (j % 4 > 0) {
            k = MathFP.mul(k, e[j % 4] >> _flt);
        }
        if ((x &= _fmask) > 0) {
            int i1 = _one;
            int j1 = 0;
            int k1 = 1;
            for (int l1 = 0; l1 < 16; ++l1) {
                j1 += i1 / k1;
                if ((k1 *= l1 + 1) > (i1 = MathFP.mul(i1, x)) || i1 <= 0 || k1 <= 0) break;
            }
            k = MathFP.mul(k, j1);
        }
        if (flag) {
            k = MathFP.div(_one, k);
        }
        return k;
    }

    public static int log(int s) {
        int k;
        if (s <= 0) {
            throw new ArithmeticException("log bad input: " + s);
        }
        int j = 0;
        boolean flag = false;
        int l = 0;
        while (s >= _one << 1) {
            s >>= 1;
            ++l;
        }
        int i1 = l * (2839 >> _flt);
        int j1 = 0;
        if (s < _one) {
            return -MathFP.log(MathFP.div(_one, s));
        }
        s -= _one;
        for (int k1 = 1; k1 < 20 && (k = j == 0 ? s : MathFP.mul(j, s)) != 0; ++k1) {
            j1 += (k1 % 2 != 0 ? 1 : -1) * k / k1;
            j = k;
        }
        return i1 + j1;
    }

    public static int pow(int b, int e) {
        boolean flag = e < 0;
        int k = _one;
        e = MathFP.abs(e);
        int l = e >> _fbits;
        while (l-- > 0) {
            k = MathFP.mul(k, b);
        }
        if (k < 0) {
            throw new ArithmeticException("Overflow");
        }
        k = b != 0 ? MathFP.mul(k, MathFP.exp(MathFP.mul(MathFP.log(b), e & _fmask))) : 0;
        if (flag) {
            return MathFP.div(_one, k);
        }
        return k;
    }

    public static int atan2(int y, int x) {
        int k = 0;
        if (x > 0) {
            k = MathFP.atan(MathFP.div(y, x));
        } else if (x < 0) {
            k = (x >= 0 ? PI : -PI) - MathFP.atan(MathFP.abs(MathFP.div(y, x)));
        } else {
            if (x == 0 && y == 0) {
                throw new ArithmeticException("atan2 bad input: (" + y + ", " + x + ")");
            }
            k = (x >= 0 ? PI : -PI) / 2;
        }
        return k;
    }

    static {
        _fmask = 4095;
        _dmul = 10000;
        _flt = 0;
        Epsilon = 2;
        ONE = MathFP.toFP(1);
        SinTable = new int[]{0, 71, 143, 214, 286, 357, 428, 499, 570, 641, 711, 782, 852, 921, 991, 1060, 1129, 1198, 1266, 1334, 1401, 1468, 1534, 1600, 1666, 1731, 1796, 1860, 1923, 1986, 2048, 2110, 2171, 2231, 2290, 2349, 2408, 2465, 2522, 2578, 2633, 2687, 2741, 2793, 2845, 2896, 2946, 2996, 3044, 3091, 3138, 3183, 3228, 3271, 3314, 3355, 3396, 3435, 3474, 3511, 3547, 3582, 3617, 3650, 3681, 3712, 3742, 3770, 3798, 3824, 3849, 3873, 3896, 3917, 3937, 3956, 3974, 3991, 4006, 4021, 4034, 4046, 4056, 4065, 4074, 4080, 4086, 4090, 4094, 4095, 4096};
        _one = 4096;
        _pi = 12868;
        e = new int[]{_one, 11134, 30266, 82270, 223636};
        PI = _pi;
        E = e[1];
        degree2radian = MathFP.toFP("0.0174533");
    }
}

