/*
 * Decompiled with CFR 0.152.
 */
package com.lemonquest.physics_v2;

import com.lemonquest.math.MathFP;
import com.lemonquest.math.Vec2D;
import com.lemonquest.physics_v2.AABB;
import com.lemonquest.physics_v2.RaceWorld;
import com.lemonquest.physics_v2.ShapeCircle;
import game.Bike;

public class DynamicObj {
    private int normEnginePower = MathFP.toFP("75");
    private int turnSpeed = MathFP.toFP("4");
    private int turnRestoreSpeed = MathFP.toFP("12");
    private int brakeResistFactor = MathFP.toFP("5");
    public int[] gearRatios = new int[]{MathFP.toFP("0"), MathFP.toFP("1.23"), MathFP.toFP("1.15"), MathFP.toFP("1.10"), MathFP.toFP("1"), MathFP.toFP("0.95"), MathFP.toFP("0.90")};
    public int[] gearSpeeds = new int[]{MathFP.toFP("0"), MathFP.toFP("16"), MathFP.toFP("23"), MathFP.toFP("29"), MathFP.toFP("36"), MathFP.toFP("43"), MathFP.toFP("48")};
    private Bike bike;
    private final int NromalResistFactor = MathFP.toFP("0.696");
    private final int SandResistFactor = MathFP.toFP("6.0");
    private int rollingResistenceFactor = this.NromalResistFactor;
    private boolean isInSand = false;
    private boolean isBraking = false;
    private final int AirResistenceFactor = MathFP.toFP("0.0161");
    private int spring = MathFP.toFP("0.1");
    private ShapeCircle shape = new ShapeCircle();
    private float x_float;
    private float y_float;
    protected AABB aabb = new AABB();
    protected AABB lookAheadAABB = new AABB();
    protected Vec2D lookAheadDelta = new Vec2D();
    private int reactionTime_toEdge = MathFP.toFP(6);
    protected Vec2D lastCenter = new Vec2D();
    private int z;
    private int lastZ;
    private int height;
    private int mass = MathFP.toFP(200);
    private int gear;
    private Vec2D wheelDir = new Vec2D(MathFP.ONE, 0);
    private Vec2D dir = new Vec2D(MathFP.ONE, 0);
    private int turnAngle;
    private float wheelTurnSpeed = 0.25f;
    private static int MaxTurnAngle = MathFP.toFP(45);
    private int enginePower;
    private Vec2D force = new Vec2D();
    private Vec2D velocity = new Vec2D();
    private int speed;
    private Vec2D acc = new Vec2D();
    private boolean isInWayPoint = false;
    private Vec2D deltaUnit = new Vec2D();
    private boolean isGhost = false;
    private short id;
    Vec2D motor = new Vec2D();

    public DynamicObj(int index) {
        this.id = (short)index;
    }

    public void setBike(Bike bike) {
        this.bike = bike;
    }

    public Bike getBike() {
        return this.bike;
    }

    public void setEnginePower(int enginePowerFP) {
        this.normEnginePower = enginePowerFP;
    }

    public int getNormEnginePower() {
        return this.normEnginePower;
    }

    public void setGearRatios(int[] ratios) {
        this.gearRatios = new int[ratios.length];
        System.arraycopy(ratios, 0, this.gearRatios, 0, ratios.length);
    }

    public void setGearSpeeds(int[] speeds) {
        this.gearSpeeds = new int[speeds.length];
        System.arraycopy(speeds, 0, this.gearSpeeds, 0, speeds.length);
    }

    public int getSpring() {
        return this.spring;
    }

    public int getRadius() {
        return this.shape.getRadius();
    }

    public void setRadius(int radius) {
        this.shape.setRadius(radius);
    }

    public float getXf() {
        return this.x_float;
    }

    public float getYf() {
        return this.y_float;
    }

    public int getXFP() {
        return this.shape.getCenter().X;
    }

    public int getYFP() {
        return this.shape.getCenter().Y;
    }

    public void setGhost(boolean isGhost) {
        this.isGhost = isGhost;
    }

    public boolean isGhost() {
        return this.isGhost;
    }

    public int getZ() {
        return this.z;
    }

    public int getLastZ() {
        return this.lastZ;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setCenter(Vec2D c) {
        this.setCenter(c.X, c.Y);
    }

    public void setCenter(int x, int y) {
        this.x_float = (float)x * 2.4414062E-4f;
        this.y_float = (float)y * 2.4414062E-4f;
        this.lastCenter.set(x, y);
        this.shape.setCenter(x, y);
        this.updateZ();
        this.updateZ();
        this.updateDeltaUnit();
    }

    public Vec2D getCenter() {
        return this.shape.getCenter();
    }

    public void resetDir(Vec2D newDir) {
        this.wheelDir.set(newDir);
        this.dir.set(newDir);
        this.turnAngle = 0;
    }

    public void moveTo(Vec2D dest) {
        this.setCenter(dest);
        if (this.lastCenter.X < this.shape.getCenter().X) {
            this.aabb.left = this.lastCenter.X - this.shape.getRadius();
            this.aabb.right = this.shape.getCenter().X + this.shape.getRadius();
        } else {
            this.aabb.left = this.shape.getCenter().X - this.shape.getRadius();
            this.aabb.right = this.lastCenter.X + this.shape.getRadius();
        }
        if (this.lastCenter.Y < this.shape.getCenter().Y) {
            this.aabb.top = this.lastCenter.Y - this.shape.getRadius();
            this.aabb.bottom = this.shape.getCenter().Y + this.shape.getRadius();
        } else {
            this.aabb.top = this.shape.getCenter().Y - this.shape.getRadius();
            this.aabb.bottom = this.lastCenter.Y + this.shape.getRadius();
        }
    }

    public Vec2D getLastCenter() {
        return this.lastCenter;
    }

    public AABB getAABB() {
        return this.aabb;
    }

    public AABB getLookAheadAABB() {
        return this.lookAheadAABB;
    }

    public Vec2D getLookAheadDelta() {
        return this.lookAheadDelta;
    }

    public int getReactionTime() {
        return this.reactionTime_toEdge;
    }

    public void resetToPosition(Vec2D pos, Vec2D dir) {
        this.rollingResistenceFactor = this.NromalResistFactor;
        this.isBraking = false;
        this.setCenter(pos);
        this.lastCenter.set(pos);
        this.aabb.bottom = 0;
        this.aabb.top = 0;
        this.aabb.right = 0;
        this.aabb.left = 0;
        this.gear = 0;
        this.wheelDir.set(dir);
        this.dir.set(dir);
        this.turnAngle = 0;
        this.velocity.set(0, 0);
        this.speed = 0;
        this.acc.set(0, 0);
        this.isInWayPoint = false;
    }

    public void applyImpulse(int collideType, int spring, Vec2D impulseNormal) {
        if (collideType == 2) {
            this.velocity.div(RaceWorld.CONST_2);
        } else {
            int tmp = MathFP.mul(this.velocity.X, impulseNormal.X) + MathFP.mul(this.velocity.Y, impulseNormal.Y);
            int nx = -MathFP.mul(tmp, impulseNormal.X);
            int ny = -MathFP.mul(tmp, impulseNormal.Y);
            this.velocity.set(this.velocity.X + nx + nx, this.velocity.Y + ny + ny);
            int normalVelLength = Vec2D.dotProduct(this.velocity, impulseNormal);
            normalVelLength = MathFP.mul(normalVelLength, MathFP.ONE - spring);
            Vec2D normalVector = new Vec2D(impulseNormal);
            normalVector.mul(normalVelLength);
            this.velocity.sub(normalVector);
        }
        this.speed = this.velocity.magnitude();
    }

    public void applyImpulse(Vec2D impulseVel) {
        this.velocity.add(impulseVel);
        this.speed = this.velocity.magnitude();
    }

    public Vec2D getVelocity() {
        return this.velocity;
    }

    public int getSpeedFP() {
        return this.speed;
    }

    public int getGear() {
        return this.gear;
    }

    public void setGear(int newGear) {
        this.gear = newGear;
        this.enginePower = MathFP.mul(this.normEnginePower, this.gearRatios[this.gear]);
    }

    public int getAngle() {
        int atan = 0;
        int x = this.dir.X;
        int y = this.dir.Y;
        if (x == 0) {
            if (y > 0) {
                return 90;
            }
            if (y < 0) {
                return -90;
            }
            return 0;
        }
        if (Math.abs(x) < 8) {
            x = x < 0 ? -8 : 8;
        }
        try {
            atan = MathFP.atan(MathFP.div(y, x));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int degree = MathFP.toInt(MathFP.div(atan * 180, MathFP.PI));
        if (this.dir.X < 0) {
            if (this.dir.Y < 0) {
                return degree + 180;
            }
            return degree + 180;
        }
        if (this.dir.Y < 0) {
            return degree + 360;
        }
        return degree;
    }

    public int getTurnAngle() {
        return MathFP.toInt(this.turnAngle);
    }

    public int getTurnAngleFP() {
        return this.turnAngle;
    }

    public int getMaxTurnAngleFP() {
        return MaxTurnAngle;
    }

    public Vec2D getDir() {
        return this.dir;
    }

    public Vec2D getTurnDir() {
        return this.wheelDir;
    }

    public void setTurnSpeed(int speedFP) {
        this.turnSpeed = speedFP;
    }

    public int getTurnSpeedFP() {
        return this.turnSpeed;
    }

    public void setTurnRestoreSpeed(int restoreSpeedFP) {
        this.turnRestoreSpeed = restoreSpeedFP;
    }

    public void turnLeft() {
        this.turnAngle -= this.turnSpeed;
        if (this.turnAngle < -MaxTurnAngle) {
            this.turnAngle = -MaxTurnAngle;
        }
    }

    public void turnRight() {
        this.turnAngle += this.turnSpeed;
        if (this.turnAngle > MaxTurnAngle) {
            this.turnAngle = MaxTurnAngle;
        }
    }

    public void restoreTurn() {
        if (this.turnAngle > 0) {
            this.turnAngle -= this.turnRestoreSpeed;
            if (this.turnAngle < 0) {
                this.turnAngle = 0;
            }
        } else if (this.turnAngle < 0) {
            this.turnAngle += this.turnRestoreSpeed;
            if (this.turnAngle > 0) {
                this.turnAngle = 0;
            }
        }
    }

    public void setBrakeResistFactor(int factorFP) {
        this.brakeResistFactor = factorFP;
    }

    public int getBrakeResistFactor() {
        return this.brakeResistFactor;
    }

    public void brake() {
        this.isBraking = true;
    }

    public void restoreBrake() {
        this.isBraking = false;
    }

    public boolean isBraking() {
        return this.isBraking;
    }

    public void intoSand() {
        this.isInSand = true;
    }

    public void inToRoad() {
        this.isInSand = false;
    }

    public boolean isInSand() {
        return this.isInSand;
    }

    public void update() {
        boolean enableDebugInfo = false;
        if (this.isInWayPoint) {
            return;
        }
        int oldx = this.shape.getCenter().X;
        int oldy = this.shape.getCenter().Y;
        this.lastCenter.set(oldx, oldy);
        this.wheelDir.set(this.dir);
        this.wheelDir.rotate2Dfast(this.turnAngle);
        int maxSpeedFP = 0;
        if (this.gear > 0) {
            maxSpeedFP = this.gearSpeeds[this.gear];
        }
        if (this.speed < maxSpeedFP) {
            this.motor.set(this.wheelDir);
            this.motor.mul(this.enginePower);
        }
        Vec2D resistance = new Vec2D();
        Vec2D airResistance = new Vec2D();
        if (this.speed > 0) {
            airResistance.set(this.dir);
            airResistance.reverse();
            int v2 = MathFP.mul(this.speed, this.speed);
            airResistance.mul(v2);
            airResistance.mul(this.AirResistenceFactor);
        }
        Vec2D roadResistance = new Vec2D();
        if (this.speed > 0) {
            this.rollingResistenceFactor = this.NromalResistFactor;
            if (this.isBraking) {
                this.rollingResistenceFactor += this.brakeResistFactor;
            }
            if (this.bike.isInSand()) {
                this.rollingResistenceFactor += this.SandResistFactor;
            }
            roadResistance.set(this.dir);
            roadResistance.reverse();
            int r = this.rollingResistenceFactor;
            int f = MathFP.mul(r, this.speed);
            roadResistance.mul(f);
        }
        resistance.set(airResistance);
        resistance.add(roadResistance);
        if (this.isBraking) {
            this.motor.set(0, 0);
        }
        this.force.set(this.motor);
        this.force.add(resistance);
        this.acc.set(this.force);
        this.acc.div(this.mass);
        this.velocity.add(this.acc);
        this.velocity.rotate2Dfast((int)((float)this.turnAngle * this.wheelTurnSpeed));
        Vec2D tmp = new Vec2D(this.velocity);
        this.speed = tmp.normalize();
        if (this.speed < RaceWorld.MinSpeed) {
            if (this.isBraking) {
                this.speed = 0;
                this.velocity.set(0, 0);
            }
        } else {
            this.dir.set(tmp);
        }
        this.shape.getCenter().add(this.velocity);
        this.updateZ();
        this.updateDeltaUnit();
        this.x_float = (float)this.shape.getCenter().X * 2.4414062E-4f;
        this.y_float = (float)this.shape.getCenter().Y * 2.4414062E-4f;
        int newx = this.shape.getCenter().X;
        int newy = this.shape.getCenter().Y;
        int radius = this.shape.getRadius();
        if (oldx < newx) {
            this.aabb.left = oldx - radius;
            this.aabb.right = newx + radius;
        } else {
            this.aabb.left = newx - radius;
            this.aabb.right = oldx + radius;
        }
        if (oldy < newy) {
            this.aabb.top = oldy - radius;
            this.aabb.bottom = newy + radius;
        } else {
            this.aabb.top = newy - radius;
            this.aabb.bottom = oldy + radius;
        }
        this.lookAheadDelta.set(this.velocity);
        this.lookAheadDelta.mul(this.reactionTime_toEdge);
        oldx = this.shape.getCenter().X;
        oldy = this.shape.getCenter().Y;
        newx = this.shape.getCenter().X + this.lookAheadDelta.X;
        newy = this.shape.getCenter().Y + this.lookAheadDelta.Y;
        if (oldx < newx) {
            this.lookAheadAABB.left = oldx - radius;
            this.lookAheadAABB.right = newx + radius;
        } else {
            this.lookAheadAABB.left = newx - radius;
            this.lookAheadAABB.right = oldx + radius;
        }
        if (oldy < newy) {
            this.lookAheadAABB.top = oldy - radius;
            this.lookAheadAABB.bottom = newy + radius;
        } else {
            this.lookAheadAABB.top = newy - radius;
            this.lookAheadAABB.bottom = oldy + radius;
        }
    }

    private void updateZ() {
    }

    private void updateDeltaUnit() {
        this.deltaUnit.set(this.dir);
    }

    public Vec2D getDeltaUnit() {
        return this.deltaUnit;
    }

    public void enterWayPoint() {
        if (this.isInWayPoint) {
            return;
        }
        this.isInWayPoint = true;
    }

    public boolean isInWayPoint() {
        return this.isInWayPoint;
    }

    public void exitWayPoint() {
        this.isInWayPoint = false;
    }

    public void collideOtherDyn(DynamicObj dynObj) {
        this.bike.collideOtherBike(dynObj.getBike());
    }
}

