/*
 * Decompiled with CFR 0.152.
 */
package com.lemonquest.physics_v2;

import com.lemonquest.math.MathFP;
import com.lemonquest.math.Vec2D;
import com.lemonquest.physics_v2.AABB;
import com.lemonquest.physics_v2.DefaultEventHandler;
import com.lemonquest.physics_v2.DynamicObj;
import com.lemonquest.physics_v2.ShapeCircle;
import com.lemonquest.physics_v2.ShapeLine;
import com.lemonquest.physics_v2.StaticObj;
import javax.microedition.lcdui.Graphics;

public class RaceWorld {
    public static boolean EnableLineUnitVecCache = true;
    public static int MinSpeed = MathFP.toFP("0.5");
    public static int G_ACC = MathFP.toFP("9.8");
    public static int backStep = MathFP.toFP("2.5");
    private DynamicObj[] ballArray;
    private int ballNum;
    private StaticObj[] objArray;
    private int objNum;
    private boolean pause;
    public static Contact nearestContact = new Contact();
    private static Vec2D collide_center = new Vec2D();
    public static Vec2D collisionPoint = new Vec2D();
    public static final byte EventType_Null = -1;
    public static final byte EventType_EnterWayPoint = 0;
    public static final byte EventType_ExitWayPoint = 1;
    public static final byte EventType_Slingshot = 2;
    public static final byte EventType_Bumper = 3;
    static Vec2D newCenter = new Vec2D();
    static Vec2D inVel = new Vec2D();
    static Vec2D outVel = new Vec2D();
    static Vec2D collideNormal = new Vec2D();
    static Vec2D lineUnit = new Vec2D();
    static Vec2D lineNormal = new Vec2D();
    static Vec2D lineVec = new Vec2D();
    static Vec2D D = new Vec2D();
    static Vec2D N = new Vec2D();
    static Vec2D B2E = new Vec2D();
    static Vec2D tmpVec = new Vec2D();
    static Vec2D t1_center = new Vec2D();
    public static final int CONST_0_5 = MathFP.toFP("0.5");
    public static final int CONST_0_7 = MathFP.toFP("0.7");
    public static final int CONST_0_8 = MathFP.toFP("0.8");
    public static final int CONST_2 = MathFP.toFP(2);
    public static final int CONST_3 = MathFP.toFP(3);
    public static final int CONST_5 = MathFP.toFP(5);
    public static final int CONST_8 = MathFP.toFP(8);
    public static final int CONST_10 = MathFP.toFP(10);
    public static final int CONST_15 = MathFP.toFP(15);
    public static final int CONST_20 = MathFP.toFP(20);
    public static final int CONST_30 = MathFP.toFP(30);
    public static final int CONST_60 = MathFP.toFP(60);
    public static final int CONST_100 = MathFP.toFP(100);
    public static final int CONST_600 = MathFP.toFP(600);
    static boolean haveFrameTime = false;
    static Vec2D p = new Vec2D();
    public static final float DrawScale = 0.5f;
    int cx;
    int cy;
    private static boolean drawAABB = false;

    public RaceWorld(int dynamicObjNum, int staticObjNum) {
        this.ballArray = new DynamicObj[dynamicObjNum];
        this.objArray = new StaticObj[staticObjNum];
    }

    public int addBall(Vec2D center, int radius, Vec2D initSpeed) {
        int index = this.ballNum++;
        DynamicObj ball = new DynamicObj(index);
        ball.setCenter(center);
        ball.setRadius(radius);
        if (initSpeed != null) {
            ball.getVelocity().set(initSpeed);
        }
        this.ballArray[index] = ball;
        return index;
    }

    public int addLine(Vec2D start, Vec2D end) {
        int index = this.objNum++;
        ShapeLine line = new ShapeLine();
        line.set(start, end);
        this.objArray[index] = new StaticObj(index, line, DefaultEventHandler.instance());
        return index;
    }

    public int addCircle(Vec2D center, int radius) {
        int index = this.objNum++;
        ShapeCircle circle = new ShapeCircle();
        circle.setCenter(center);
        circle.setRadius(radius);
        this.objArray[index] = new StaticObj(index, circle, DefaultEventHandler.instance());
        return index;
    }

    public void activateGroundCollision(int groundID) {
        for (int i = 0; i < this.objArray.length; ++i) {
            if (this.objArray[i].groundID != groundID) continue;
            this.objArray[i].activate();
        }
    }

    public void sleepGroundCollision(int groundID) {
        for (int i = 0; i < this.objArray.length; ++i) {
            if (this.objArray[i].groundID != groundID) continue;
            this.objArray[i].sleep();
        }
    }

    public DynamicObj getDynObj(int id) {
        return this.ballArray[id];
    }

    public StaticObj getStaticObj(int id) {
        return this.objArray[id];
    }

    public StaticObj getFirstRoadLineObj(int groundID) {
        for (int i = 0; i < this.objArray.length; ++i) {
            if (this.objArray[i].groundID != groundID) continue;
            return this.objArray[i];
        }
        return null;
    }

    public int debugGetStaticObjCount() {
        return this.objArray.length;
    }

    public Vec2D debugGetLineStart(int index) {
        StaticObj obj = this.objArray[index];
        if (obj.getShape() instanceof ShapeLine) {
            return ((ShapeLine)obj.getShape()).getStart();
        }
        return null;
    }

    public Vec2D debugGetLineEnd(int index) {
        StaticObj obj = this.objArray[index];
        if (obj.getShape() instanceof ShapeLine) {
            return ((ShapeLine)obj.getShape()).getEnd();
        }
        return null;
    }

    public Contact getNearestContact() {
        return nearestContact;
    }

    public void update() {
        int ballIndex;
        for (ballIndex = 0; ballIndex < this.ballArray.length; ++ballIndex) {
            this.ballArray[ballIndex].update();
        }
        haveFrameTime = true;
        while (haveFrameTime) {
            for (ballIndex = 0; ballIndex < this.ballArray.length; ++ballIndex) {
                DynamicObj ball = this.ballArray[ballIndex];
                if (ball.isInWayPoint()) {
                    haveFrameTime = false;
                    continue;
                }
                boolean isCollide = false;
                RaceWorld.nearestContact.time = MathFP.ONE;
                if (!ball.isGhost() && ball.getBike().canCollideOtherBike()) {
                    for (int otherBallIndex = 0; otherBallIndex < this.ballArray.length; ++otherBallIndex) {
                        DynamicObj otherBall = this.ballArray[otherBallIndex];
                        if (otherBallIndex == ballIndex || otherBall.isGhost() || !otherBall.getBike().canCollideOtherBike() || !ball.getAABB().intersects(otherBall.getAABB())) continue;
                        isCollide |= RaceWorld.isCollideBallBall(ball, otherBall);
                    }
                }
                for (int objIndex = 0; objIndex < this.objArray.length; ++objIndex) {
                    StaticObj obj = this.objArray[objIndex];
                    if (!obj.isActivated() || !ball.getAABB().intersects(obj.getAABB())) continue;
                    if (obj.getShape() instanceof ShapeLine) {
                        isCollide |= RaceWorld.isCollideBallLine(ball, obj);
                        continue;
                    }
                    if (!(obj.getShape() instanceof ShapeCircle)) continue;
                    isCollide |= RaceWorld.isCollideBallCircle(ball, obj);
                }
                if (isCollide) {
                    RaceWorld.resolveContacts();
                    continue;
                }
                haveFrameTime = false;
            }
        }
    }

    public void pause() {
        this.pause = !this.pause;
    }

    public boolean isPause() {
        return this.pause;
    }

    public static boolean isCollideBallLine(DynamicObj ball, StaticObj obj) {
        int t1 = MathFP.ONE;
        int t2 = MathFP.ONE;
        lineVec.set(((ShapeLine)obj.getShape()).getEnd());
        lineVec.sub(((ShapeLine)obj.getShape()).getStart());
        int lineLength = 0;
        if (EnableLineUnitVecCache) {
            lineUnit.set(((ShapeLine)obj.getShape()).getUnit());
            lineLength = ((ShapeLine)obj.getShape()).getLineLength();
        } else {
            lineUnit.set(lineVec);
            lineLength = lineUnit.normalize();
        }
        lineNormal.set(lineUnit);
        lineNormal.getPerp2D_CW();
        D.set(ball.getCenter());
        D.sub(ball.getLastCenter());
        tmpVec.set(ball.getLastCenter());
        tmpVec.sub(((ShapeLine)obj.getShape()).getStart());
        int d_dot_n = Vec2D.dotProduct(D, lineNormal);
        int dist_to_ball = Vec2D.dotProduct(tmpVec, lineNormal);
        if (Math.abs(d_dot_n) < 4) {
            if (obj.isEventOnly()) {
                obj.fireInstantEvent(ball);
                return false;
            }
            if (Math.abs(dist_to_ball) > ball.getRadius()) {
                return false;
            }
            t1_center.set(ball.getLastCenter());
            int dx = RaceWorld.t1_center.X - ((ShapeLine)obj.getShape()).getStart().X;
            int dy = RaceWorld.t1_center.Y - ((ShapeLine)obj.getShape()).getStart().Y;
            int distStart = MathFP.mul(dx, dx) + MathFP.mul(dy, dy);
            dx = RaceWorld.t1_center.X - ((ShapeLine)obj.getShape()).getEnd().X;
            dy = RaceWorld.t1_center.Y - ((ShapeLine)obj.getShape()).getEnd().Y;
            int distEnd = MathFP.mul(dx, dx) + MathFP.mul(dy, dy);
            Vec2D E = null;
            E = distStart < distEnd ? ((ShapeLine)obj.getShape()).getStart() : ((ShapeLine)obj.getShape()).getEnd();
            int t = RaceWorld.isCollideBallCircle(ball, E, 0);
            if (t < 0 || t > RaceWorld.nearestContact.time) {
                if (obj.isEventOnly()) {
                    obj.fireInstantEvent(ball);
                }
                return false;
            }
            t1 = t;
            if (obj.isEventOnly()) {
                obj.fireEvent(ball);
                return false;
            }
            RaceWorld.nearestContact.type = 1;
            RaceWorld.nearestContact.normal.set(t1_center);
            RaceWorld.nearestContact.normal.sub(E);
            RaceWorld.nearestContact.normal.normalize();
            RaceWorld.nearestContact.time = t1;
            RaceWorld.nearestContact.ball = ball;
            RaceWorld.nearestContact.obj = obj;
            return true;
        }
        t1 = MathFP.div(ball.getRadius() - dist_to_ball, d_dot_n);
        if (t1 > (t2 = MathFP.div(-ball.getRadius() - dist_to_ball, d_dot_n))) {
            int old = t2;
            t2 = t1;
            t1 = old;
        }
        if (t1 > MathFP.ONE || t2 < 0) {
            if (obj.isEventOnly()) {
                obj.fireInstantEvent(ball);
            }
            return false;
        }
        if (t1 < 0) {
            if (obj.isEventOnly()) {
                obj.fireInstantEvent(ball);
                return false;
            }
            t1 = 0;
        }
        if (t2 > MathFP.ONE) {
            t2 = MathFP.ONE;
        }
        if (t1 < RaceWorld.nearestContact.time) {
            Vec2D t1_center = new Vec2D(D);
            t1_center.mul(t1);
            t1_center.add(ball.getLastCenter());
            collisionPoint.set(lineNormal);
            collisionPoint.reverse();
            collisionPoint.mul(ball.getRadius());
            collisionPoint.add(t1_center);
            if (RaceWorld.isPointInLine(collisionPoint, ((ShapeLine)obj.getShape()).getStart(), lineLength, lineUnit)) {
                if (obj.isEventOnly()) {
                    obj.fireEvent(ball);
                    return false;
                }
                RaceWorld.nearestContact.type = 0;
                RaceWorld.nearestContact.normal.set(lineNormal);
                collideNormal.set(lineNormal);
            } else {
                int dx = t1_center.X - ((ShapeLine)obj.getShape()).getStart().X;
                int dy = t1_center.Y - ((ShapeLine)obj.getShape()).getStart().Y;
                int distStart = MathFP.mul(dx, dx) + MathFP.mul(dy, dy);
                dx = t1_center.X - ((ShapeLine)obj.getShape()).getEnd().X;
                dy = t1_center.Y - ((ShapeLine)obj.getShape()).getEnd().Y;
                int distEnd = MathFP.mul(dx, dx) + MathFP.mul(dy, dy);
                Vec2D E = null;
                E = distStart < distEnd ? ((ShapeLine)obj.getShape()).getStart() : ((ShapeLine)obj.getShape()).getEnd();
                int t = RaceWorld.isCollideBallCircle(ball, E, 0);
                if (t < 0 || t > RaceWorld.nearestContact.time) {
                    if (obj.isEventOnly()) {
                        obj.fireInstantEvent(ball);
                    }
                    return false;
                }
                t1 = t;
                if (obj.isEventOnly()) {
                    obj.fireEvent(ball);
                    return false;
                }
                RaceWorld.nearestContact.type = 1;
                RaceWorld.nearestContact.normal.set(t1_center);
                RaceWorld.nearestContact.normal.sub(E);
                RaceWorld.nearestContact.normal.normalize();
            }
            RaceWorld.nearestContact.time = t1;
            RaceWorld.nearestContact.ball = ball;
            RaceWorld.nearestContact.obj = obj;
        }
        return true;
    }

    public static boolean isCollideBallCircle(DynamicObj ball, StaticObj obj) {
        D.set(ball.getCenter());
        D.sub(ball.getLastCenter());
        Vec2D Delta_ONE = ball.getDeltaUnit();
        if (Delta_ONE.isZero()) {
            return false;
        }
        N.set(Delta_ONE);
        N.getPerp2D_CW();
        B2E.set(((ShapeCircle)obj.getShape()).getCenter());
        B2E.sub(ball.getLastCenter());
        int dist = Vec2D.dotProduct(B2E, N);
        int r = ball.getRadius() + ((ShapeCircle)obj.getShape()).getRadius();
        if (Math.abs(dist) > r) {
            return false;
        }
        int sqrt = MathFP.sqrt(MathFP.mul(r, r) - MathFP.mul(dist, dist));
        int b2e_dot_d = Vec2D.dotProduct(B2E, Delta_ONE);
        int d_dot_d = Vec2D.dotProduct(D, Delta_ONE);
        if (d_dot_d == 0) {
            return false;
        }
        int t1 = MathFP.div(b2e_dot_d - sqrt, d_dot_d);
        if (t1 < 0 || t1 > MathFP.ONE) {
            if (obj.isEventOnly()) {
                obj.fireInstantEvent(ball);
            }
            return false;
        }
        if (t1 < 0) {
            t1 = 0;
        }
        if (t1 < RaceWorld.nearestContact.time) {
            if (obj.isEventOnly()) {
                obj.fireEvent(ball);
                return false;
            }
            Vec2D normal = new Vec2D(D);
            normal.mul(t1);
            normal.add(ball.getLastCenter());
            collide_center.set(normal);
            normal.sub(((ShapeCircle)obj.getShape()).getCenter());
            normal.normalize();
            RaceWorld.nearestContact.time = t1;
            RaceWorld.nearestContact.normal.set(normal);
            RaceWorld.nearestContact.ball = ball;
            RaceWorld.nearestContact.obj = obj;
            collideNormal.set(normal);
        }
        return true;
    }

    public static int isCollideBallCircle(DynamicObj ball, Vec2D circleCenter, int circleRadius) {
        Vec2D Delta_ONE = ball.getDeltaUnit();
        if (Delta_ONE.isZero()) {
            return -1;
        }
        N.set(Delta_ONE);
        N.getPerp2D_CW();
        B2E.set(circleCenter);
        B2E.sub(ball.getLastCenter());
        int dist = Vec2D.dotProduct(B2E, N);
        int r = ball.getRadius() + circleRadius;
        if (Math.abs(dist) > r) {
            return -1;
        }
        int sqrt = MathFP.sqrt(MathFP.mul(r, r) - MathFP.mul(dist, dist));
        int b2e_dot_d = Vec2D.dotProduct(B2E, Delta_ONE);
        int d_dot_d = Vec2D.dotProduct(D, Delta_ONE);
        if (Math.abs(d_dot_d) < 4) {
            return 0;
        }
        int t1 = MathFP.div(b2e_dot_d - sqrt, d_dot_d);
        if (t1 < 0 || t1 > MathFP.ONE) {
            return -1;
        }
        if (t1 < 0) {
            t1 = 0;
        }
        return t1;
    }

    public static boolean isCollideBallBall(DynamicObj self, DynamicObj other) {
        D.set(self.getCenter());
        D.sub(self.getLastCenter());
        Vec2D otherD = new Vec2D(other.getCenter());
        otherD.sub(other.getLastCenter());
        D.sub(otherD);
        Vec2D Delta_ONE = self.getDeltaUnit();
        if (Delta_ONE.isZero()) {
            return false;
        }
        N.set(Delta_ONE);
        N.getPerp2D_CW();
        B2E.set(other.getLastCenter());
        B2E.sub(self.getLastCenter());
        int dist = Vec2D.dotProduct(B2E, N);
        int r = self.getRadius() + other.getRadius();
        if (dist < 0) {
            N.reverse();
        }
        if (Math.abs(dist) > r) {
            return false;
        }
        int sqrt = MathFP.sqrt(MathFP.mul(r, r) - MathFP.mul(dist, dist));
        int b2e_dot_d = Vec2D.dotProduct(B2E, Delta_ONE);
        int d_dot_d = Vec2D.dotProduct(D, Delta_ONE);
        if (d_dot_d == 0) {
            return false;
        }
        int t1 = MathFP.div(b2e_dot_d - sqrt, d_dot_d);
        if (t1 < 0 || t1 > MathFP.ONE) {
            return false;
        }
        if (t1 < 0) {
            t1 = 0;
        }
        if (t1 < RaceWorld.nearestContact.time) {
            RaceWorld.nearestContact.normal.set(D);
            RaceWorld.nearestContact.normal.mul(t1);
            RaceWorld.nearestContact.normal.add(self.getLastCenter());
            RaceWorld.nearestContact.normal.sub(other.getLastCenter());
            RaceWorld.nearestContact.normal.normalize();
            RaceWorld.nearestContact.type = (byte)2;
            RaceWorld.nearestContact.time = t1;
            RaceWorld.nearestContact.ball = self;
            RaceWorld.nearestContact.otherBall = other;
            RaceWorld.nearestContact.obj = null;
            collideNormal.set(N);
        }
        return true;
    }

    public StaticObj willCollideBallStaticObj(DynamicObj ball) {
        boolean isCollide = false;
        for (int objIndex = 0; objIndex < this.objArray.length; ++objIndex) {
            StaticObj obj = this.objArray[objIndex];
            if (!obj.isActivated() || !ball.getLookAheadAABB().intersects(obj.getAABB())) continue;
            if (obj.getShape() instanceof ShapeLine) {
                isCollide |= RaceWorld.willCollideBallLine(ball.getCenter(), ball.getLookAheadDelta(), ball.getTurnDir(), ball.getRadius(), ball.getReactionTime(), obj);
                continue;
            }
            if (!(obj.getShape() instanceof ShapeCircle)) continue;
            isCollide |= RaceWorld.willCollideBallCircle(ball.getCenter(), ball.getLookAheadDelta(), ball.getRadius(), ball.getTurnDir(), ball.getReactionTime(), obj);
        }
        if (isCollide) {
            return RaceWorld.nearestContact.obj;
        }
        return null;
    }

    public DynamicObj willCollideBallBall(DynamicObj ball) {
        boolean isCollide = false;
        for (int otherBallIndex = 0; otherBallIndex < this.ballArray.length; ++otherBallIndex) {
            DynamicObj otherBall = this.ballArray[otherBallIndex];
            if (otherBall == ball || otherBall.isGhost() || !ball.getLookAheadAABB().intersects(otherBall.getAABB()) || !(isCollide = RaceWorld.willCollideBallBall(ball.getCenter(), ball.getDir(), ball.getLookAheadDelta(), ball.getRadius(), otherBall.getCenter(), otherBall.getDir(), otherBall.getLookAheadDelta(), otherBall.getRadius(), ball.getReactionTime()))) continue;
            return otherBall;
        }
        return null;
    }

    public static boolean willCollideBallLine(Vec2D ballCenter, Vec2D delta, Vec2D ballDir, int ballRadius, int timeStep, StaticObj obj) {
        int t1 = MathFP.ONE;
        int t2 = MathFP.ONE;
        D.set(delta);
        lineVec.set(((ShapeLine)obj.getShape()).getEnd());
        lineVec.sub(((ShapeLine)obj.getShape()).getStart());
        int lineLength = 0;
        if (EnableLineUnitVecCache) {
            lineUnit.set(((ShapeLine)obj.getShape()).getUnit());
            lineLength = ((ShapeLine)obj.getShape()).getLineLength();
        } else {
            lineUnit.set(lineVec);
            lineLength = lineUnit.normalize();
        }
        lineNormal.set(lineUnit);
        lineNormal.getPerp2D_CW();
        tmpVec.set(ballCenter);
        tmpVec.sub(((ShapeLine)obj.getShape()).getStart());
        int d_dot_n = Vec2D.dotProduct(D, lineNormal);
        int dist_to_ball = Vec2D.dotProduct(tmpVec, lineNormal);
        if (Math.abs(d_dot_n) < 4) {
            if (Math.abs(dist_to_ball) > ballRadius) {
                return false;
            }
            t1_center.set(ballCenter);
            int dx = RaceWorld.t1_center.X - ((ShapeLine)obj.getShape()).getStart().X;
            int dy = RaceWorld.t1_center.Y - ((ShapeLine)obj.getShape()).getStart().Y;
            int distStart = MathFP.mul(dx, dx) + MathFP.mul(dy, dy);
            dx = RaceWorld.t1_center.X - ((ShapeLine)obj.getShape()).getEnd().X;
            dy = RaceWorld.t1_center.Y - ((ShapeLine)obj.getShape()).getEnd().Y;
            int distEnd = MathFP.mul(dx, dx) + MathFP.mul(dy, dy);
            Vec2D E = null;
            E = distStart < distEnd ? ((ShapeLine)obj.getShape()).getStart() : ((ShapeLine)obj.getShape()).getEnd();
            int t = RaceWorld.willCollideBallCircle(ballCenter, ballRadius, ballDir, E, 0);
            if (t < 0 || t > RaceWorld.nearestContact.time) {
                return false;
            }
            t1 = t;
            RaceWorld.nearestContact.type = 1;
            RaceWorld.nearestContact.normal.set(t1_center);
            RaceWorld.nearestContact.normal.sub(E);
            RaceWorld.nearestContact.normal.normalize();
            RaceWorld.nearestContact.time = t1;
            RaceWorld.nearestContact.obj = obj;
            return true;
        }
        t1 = MathFP.div(ballRadius - dist_to_ball, d_dot_n);
        if (t1 > (t2 = MathFP.div(-ballRadius - dist_to_ball, d_dot_n))) {
            int old = t2;
            t2 = t1;
            t1 = old;
        }
        if (t1 > MathFP.ONE || t2 < 0) {
            return false;
        }
        if (t1 < 0) {
            t1 = 0;
        }
        if (t2 > MathFP.ONE) {
            t2 = MathFP.ONE;
        }
        if (t1 < RaceWorld.nearestContact.time) {
            Vec2D t1_center = new Vec2D(D);
            t1_center.mul(t1);
            t1_center.add(ballCenter);
            collisionPoint.set(lineNormal);
            collisionPoint.reverse();
            collisionPoint.mul(ballRadius);
            collisionPoint.add(t1_center);
            if (RaceWorld.isPointInLine(collisionPoint, ((ShapeLine)obj.getShape()).getStart(), lineLength, lineUnit)) {
                RaceWorld.nearestContact.type = 0;
                RaceWorld.nearestContact.normal.set(lineNormal);
                collideNormal.set(lineNormal);
            } else {
                int dx = t1_center.X - ((ShapeLine)obj.getShape()).getStart().X;
                int dy = t1_center.Y - ((ShapeLine)obj.getShape()).getStart().Y;
                int distStart = MathFP.mul(dx, dx) + MathFP.mul(dy, dy);
                dx = t1_center.X - ((ShapeLine)obj.getShape()).getEnd().X;
                dy = t1_center.Y - ((ShapeLine)obj.getShape()).getEnd().Y;
                int distEnd = MathFP.mul(dx, dx) + MathFP.mul(dy, dy);
                Vec2D E = null;
                E = distStart < distEnd ? ((ShapeLine)obj.getShape()).getStart() : ((ShapeLine)obj.getShape()).getEnd();
                int t = RaceWorld.willCollideBallCircle(ballCenter, ballRadius, ballDir, E, 0);
                if (t < 0 || t > RaceWorld.nearestContact.time) {
                    return false;
                }
                t1 = t;
                RaceWorld.nearestContact.type = 1;
                RaceWorld.nearestContact.normal.set(t1_center);
                RaceWorld.nearestContact.normal.sub(E);
                RaceWorld.nearestContact.normal.normalize();
            }
            RaceWorld.nearestContact.time = t1;
            RaceWorld.nearestContact.obj = obj;
        }
        return true;
    }

    public static boolean willCollideBallCircle(Vec2D ballCenter, Vec2D delta, int ballRadius, Vec2D ballDir, int timeStep, StaticObj obj) {
        D.set(delta);
        Vec2D Delta_ONE = ballDir;
        if (Delta_ONE.isZero()) {
            return false;
        }
        N.set(Delta_ONE);
        N.getPerp2D_CW();
        B2E.set(((ShapeCircle)obj.getShape()).getCenter());
        B2E.sub(ballCenter);
        int dist = Vec2D.dotProduct(B2E, N);
        int r = ballRadius + ((ShapeCircle)obj.getShape()).getRadius();
        if (Math.abs(dist) > r) {
            return false;
        }
        int sqrt = MathFP.sqrt(MathFP.mul(r, r) - MathFP.mul(dist, dist));
        int b2e_dot_d = Vec2D.dotProduct(B2E, Delta_ONE);
        int d_dot_d = Vec2D.dotProduct(D, Delta_ONE);
        if (d_dot_d == 0) {
            return false;
        }
        int t1 = MathFP.div(b2e_dot_d - sqrt, d_dot_d);
        if (t1 < 0 || t1 > MathFP.ONE) {
            return false;
        }
        if (t1 < 0) {
            t1 = 0;
        }
        if (t1 < RaceWorld.nearestContact.time) {
            Vec2D normal = new Vec2D(D);
            normal.mul(t1);
            normal.add(ballCenter);
            collide_center.set(normal);
            normal.sub(((ShapeCircle)obj.getShape()).getCenter());
            normal.normalize();
            RaceWorld.nearestContact.time = t1;
            RaceWorld.nearestContact.normal.set(normal);
            RaceWorld.nearestContact.obj = obj;
            collideNormal.set(normal);
        }
        return true;
    }

    public static int willCollideBallCircle(Vec2D ballCenter, int ballRadius, Vec2D ballDir, Vec2D circleCenter, int circleRadius) {
        Vec2D Delta_ONE = ballDir;
        if (Delta_ONE.isZero()) {
            return -1;
        }
        N.set(Delta_ONE);
        N.getPerp2D_CW();
        B2E.set(circleCenter);
        B2E.sub(ballCenter);
        int dist = Vec2D.dotProduct(B2E, N);
        int r = ballRadius + circleRadius;
        if (Math.abs(dist) > r) {
            return -1;
        }
        int sqrt = MathFP.sqrt(MathFP.mul(r, r) - MathFP.mul(dist, dist));
        int b2e_dot_d = Vec2D.dotProduct(B2E, Delta_ONE);
        int d_dot_d = Vec2D.dotProduct(D, Delta_ONE);
        if (Math.abs(d_dot_d) < 4) {
            return 0;
        }
        int t1 = MathFP.div(b2e_dot_d - sqrt, d_dot_d);
        if (t1 < 0 || t1 > MathFP.ONE) {
            return -1;
        }
        if (t1 < 0) {
            t1 = 0;
        }
        return t1;
    }

    public static boolean willCollideBallBall(Vec2D selfCenter, Vec2D selfDir, Vec2D selfDelta, int selfRadius, Vec2D otherCenter, Vec2D otherDir, Vec2D otherDelta, int otherRadius, int timeStep) {
        D.set(selfDelta);
        D.sub(otherDelta);
        Vec2D Delta_ONE = selfDir;
        if (Delta_ONE.isZero()) {
            return false;
        }
        N.set(Delta_ONE);
        N.getPerp2D_CW();
        B2E.set(otherCenter);
        B2E.sub(selfCenter);
        int dist = Vec2D.dotProduct(B2E, N);
        int r = selfRadius + otherRadius;
        if (dist < 0) {
            N.reverse();
        }
        if (Math.abs(dist) > r) {
            return false;
        }
        int sqrt = MathFP.sqrt(MathFP.mul(r, r) - MathFP.mul(dist, dist));
        int b2e_dot_d = Vec2D.dotProduct(B2E, Delta_ONE);
        int d_dot_d = Vec2D.dotProduct(D, Delta_ONE);
        if (Math.abs(d_dot_d) < 4) {
            return false;
        }
        int t1 = MathFP.div(b2e_dot_d - sqrt, d_dot_d);
        if (t1 < 0 || t1 > MathFP.ONE) {
            return false;
        }
        if (t1 < 0) {
            t1 = 0;
        }
        if (t1 < RaceWorld.nearestContact.time) {
            RaceWorld.nearestContact.normal.set(D);
            RaceWorld.nearestContact.normal.mul(t1);
            RaceWorld.nearestContact.normal.add(selfCenter);
            RaceWorld.nearestContact.normal.sub(otherCenter);
            RaceWorld.nearestContact.normal.normalize();
            RaceWorld.nearestContact.type = (byte)2;
            RaceWorld.nearestContact.time = t1;
            RaceWorld.nearestContact.obj = null;
            collideNormal.set(N);
        }
        return true;
    }

    private static void resolveContacts() {
        switch (RaceWorld.nearestContact.type) {
            case 0: 
            case 1: {
                D.set(RaceWorld.nearestContact.ball.getCenter());
                D.sub(RaceWorld.nearestContact.ball.getLastCenter());
                newCenter.set(D);
                newCenter.mul(RaceWorld.nearestContact.time);
                newCenter.add(RaceWorld.nearestContact.ball.getLastCenter());
                collisionPoint.set(RaceWorld.nearestContact.normal);
                collisionPoint.reverse();
                collisionPoint.mul(RaceWorld.nearestContact.ball.getRadius());
                collisionPoint.add(newCenter);
                newCenter.set(D);
                newCenter.mul(RaceWorld.nearestContact.time);
                Vec2D d = new Vec2D(RaceWorld.nearestContact.ball.getDeltaUnit());
                d.reverse();
                d.mul(backStep);
                newCenter.add(d);
                newCenter.add(RaceWorld.nearestContact.ball.getLastCenter());
                d.set(RaceWorld.nearestContact.normal);
                newCenter.add(d);
                inVel.set(RaceWorld.nearestContact.ball.getVelocity());
                collideNormal.set(RaceWorld.nearestContact.normal);
                RaceWorld.nearestContact.ball.applyImpulse(0, RaceWorld.nearestContact.obj.getSpring(), RaceWorld.nearestContact.normal);
                RaceWorld.nearestContact.ball.setCenter(newCenter);
                Vec2D newVel = new Vec2D(RaceWorld.nearestContact.ball.getVelocity());
                newVel.mul(MathFP.ONE - RaceWorld.nearestContact.time);
                newCenter.add(newVel);
                RaceWorld.nearestContact.ball.moveTo(newCenter);
                haveFrameTime = Math.abs(MathFP.ONE - RaceWorld.nearestContact.time) >= 200;
                outVel.set(RaceWorld.nearestContact.ball.getVelocity());
                RaceWorld.nearestContact.obj.fireEvent(RaceWorld.nearestContact.ball);
                break;
            }
            case 2: {
                RaceWorld.nearestContact.ball.collideOtherDyn(RaceWorld.nearestContact.otherBall);
                RaceWorld.nearestContact.otherBall.collideOtherDyn(RaceWorld.nearestContact.ball);
                D.set(RaceWorld.nearestContact.ball.getCenter());
                D.sub(RaceWorld.nearestContact.ball.getLastCenter());
                newCenter.set(D);
                newCenter.mul(RaceWorld.nearestContact.time);
                newCenter.add(RaceWorld.nearestContact.ball.getLastCenter());
                collisionPoint.set(RaceWorld.nearestContact.normal);
                collisionPoint.reverse();
                collisionPoint.mul(RaceWorld.nearestContact.ball.getRadius());
                collisionPoint.add(newCenter);
                newCenter.set(D);
                newCenter.mul(RaceWorld.nearestContact.time);
                Vec2D d = new Vec2D(RaceWorld.nearestContact.ball.getDeltaUnit());
                d.reverse();
                d.mul(backStep);
                newCenter.add(d);
                newCenter.add(RaceWorld.nearestContact.ball.getLastCenter());
                d.set(RaceWorld.nearestContact.normal);
                d.mul(CONST_3);
                newCenter.add(d);
                inVel.set(RaceWorld.nearestContact.ball.getVelocity());
                Vec2D ballHalfVel = new Vec2D(RaceWorld.nearestContact.ball.getVelocity());
                ballHalfVel.div(CONST_2);
                Vec2D otherHalfVel = new Vec2D(RaceWorld.nearestContact.ball.getVelocity());
                otherHalfVel.div(CONST_2);
                RaceWorld.nearestContact.ball.getVelocity().set(otherHalfVel);
                RaceWorld.nearestContact.ball.getVelocity().add(ballHalfVel);
                RaceWorld.nearestContact.otherBall.getVelocity().set(ballHalfVel);
                RaceWorld.nearestContact.otherBall.getVelocity().add(otherHalfVel);
                RaceWorld.nearestContact.ball.setCenter(newCenter);
                Vec2D newVel = new Vec2D(RaceWorld.nearestContact.ball.getVelocity());
                newVel.mul(MathFP.ONE - RaceWorld.nearestContact.time);
                newCenter.add(newVel);
                RaceWorld.nearestContact.ball.moveTo(newCenter);
                haveFrameTime = Math.abs(MathFP.ONE - RaceWorld.nearestContact.time) >= 200;
                outVel.set(RaceWorld.nearestContact.ball.getVelocity());
            }
        }
    }

    private static boolean isPointInLine(Vec2D Q, Vec2D origin, int lineLength, Vec2D lineOne) {
        p.set(Q);
        p.sub(origin);
        p.rotate2D(lineOne);
        int left = -CONST_0_5;
        int right = lineLength + CONST_0_5;
        int top = -CONST_0_5;
        int bottom = CONST_0_5;
        return RaceWorld.p.X >= left && RaceWorld.p.X <= right && RaceWorld.p.Y >= top && RaceWorld.p.Y <= bottom;
    }

    public static boolean isSameSide(DynamicObj dynObj, Vec2D point, StaticObj staticObj) {
        boolean isSameSide = false;
        ShapeLine line = (ShapeLine)staticObj.getShape();
        Vec2D lineStart = line.getStart();
        Vec2D lineEnd = line.getEnd();
        if (lineStart.X == lineEnd.X) {
            Vec2D bikeCenter = dynObj.getCenter();
            if (bikeCenter.X <= lineStart.X && point.X <= lineStart.X || bikeCenter.X >= lineStart.X && point.X >= lineStart.X) {
                isSameSide = true;
            }
        } else {
            Vec2D bikeCenter = new Vec2D(dynObj.getCenter());
            bikeCenter.add(dynObj.getVelocity());
            bikeCenter.add(dynObj.getVelocity());
            bikeCenter.sub(lineStart);
            Vec2D p = new Vec2D(point);
            p.sub(lineStart);
            int crossBikeCenter = line.getUnit().crossProduct(bikeCenter);
            int pCenter = line.getUnit().crossProduct(p);
            if (crossBikeCenter >= 0 && pCenter >= 0 || crossBikeCenter <= 0 && pCenter <= 0) {
                isSameSide = true;
            }
        }
        return isSameSide;
    }

    public int toDrawX(int num) {
        return this.cx + (int)((float)MathFP.toInt(num) * 0.5f);
    }

    public int toDrawY(int num) {
        return this.cy - (int)((float)MathFP.toInt(num) * 0.5f);
    }

    public int toDrawLen(int num) {
        return (int)((float)MathFP.toInt(num) * 0.5f);
    }

    public void draw(Graphics g, int cx, int cy) {
        int y2;
        int x2;
        AABB aabb;
        int y;
        int x;
        int i;
        int DynObjColor = 0xFFFF00;
        int LineColor = 65535;
        int ActivatedLineColor = 0xFF0000;
        int PointColor = 0xFF00FF;
        int AABBColor = 0xAAAAAA;
        this.cx = cx;
        this.cy = cy;
        int radius = 0;
        for (i = 0; i < this.ballArray.length; ++i) {
            DynamicObj ball = this.ballArray[i];
            radius = this.toDrawLen(ball.getRadius());
            x = this.toDrawX(ball.getCenter().X);
            y = this.toDrawY(ball.getCenter().Y);
            g.setColor(0xFFFF00);
            g.drawArc(x - radius, y - radius, radius * 2, radius * 2, 0, 360);
            g.drawRect(x - 1, y - 1, 2, 2);
            g.drawString("" + (i + 1), x, y, 17);
            if (!drawAABB) continue;
            aabb = ball.getAABB();
            x = this.toDrawX(aabb.left);
            y = this.toDrawY(aabb.top);
            x2 = this.toDrawX(aabb.right);
            y2 = this.toDrawY(aabb.bottom);
            g.setColor(0xAAAAAA);
            g.drawRect(x, y, x2 - x, y2 - y);
        }
        for (i = 0; i < this.objArray.length; ++i) {
            StaticObj obj = this.objArray[i];
            if (obj.getShape() instanceof ShapeLine) {
                x = this.toDrawX(((ShapeLine)obj.getShape()).getStart().X);
                y = this.toDrawY(((ShapeLine)obj.getShape()).getStart().Y);
                x2 = this.toDrawX(((ShapeLine)obj.getShape()).getEnd().X);
                y2 = this.toDrawY(((ShapeLine)obj.getShape()).getEnd().Y);
                if (obj.isActivated()) {
                    if (obj.isEventOnly()) {
                        g.setColor(0xFFAAAA);
                    } else {
                        g.setColor(0xFF0000);
                    }
                } else {
                    g.setColor(65535);
                }
                g.drawLine(x, y, x2, y2);
                Vec2D normal = new Vec2D(((ShapeLine)obj.getShape()).getUnit());
                normal.mul(MathFP.toFP(10.0f));
                normal.getPerp2D_CW();
                g.setColor(0xFFFF00);
                g.drawLine((x + x2) / 2, (y + y2) / 2, (x + x2) / 2 + MathFP.toInt(normal.X), (y + y2) / 2 + -MathFP.toInt(normal.Y));
                Vec2D unit = new Vec2D(((ShapeLine)obj.getShape()).getUnit());
                unit.mul(MathFP.toFP(10.0f));
                g.drawLine((x + x2) / 2, (y + y2) / 2, (x + x2) / 2 + MathFP.toInt(unit.X), (y + y2) / 2 + -MathFP.toInt(unit.Y));
                g.setColor(0xFF00FF);
                g.drawRect(x - 1, y - 1, 3, 3);
                g.drawRect(x2 - 1, y2 - 1, 3, 3);
            } else if (obj.getShape() instanceof ShapeCircle) {
                x = this.toDrawX(((ShapeCircle)obj.getShape()).getCenter().X);
                y = this.toDrawY(((ShapeCircle)obj.getShape()).getCenter().Y);
                radius = this.toDrawLen(((ShapeCircle)obj.getShape()).getRadius());
                g.setColor(65535);
                g.drawArc(x - radius, y - radius, radius * 2, radius * 2, 0, 360);
            }
            if (!drawAABB) continue;
            aabb = obj.getAABB();
            x = this.toDrawX(aabb.left);
            y = this.toDrawY(aabb.top);
            x2 = this.toDrawX(aabb.right);
            y2 = this.toDrawY(aabb.bottom);
            g.setColor(0xAAAAAA);
            g.drawRect(x, y, x2 - x, y2 - y);
        }
    }

    public static class Contact {
        public static final byte TypeBall2Line = 0;
        public static final byte TypeBall2Circle = 1;
        public static final byte TypeBall2Ball = 2;
        byte type;
        public int time;
        public Vec2D normal = new Vec2D();
        DynamicObj ball;
        StaticObj obj;
        DynamicObj otherBall;
    }
}

