/*
 * Decompiled with CFR 0.152.
 */
package com.lemonquest.util;

import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class LQFrameCounter {
    private float averageFps = 0.0f;
    private int fpsDisplay = 0;
    private int framesPerSecond = 0;
    private String labelFps = "FPS/Avg";
    private long lastTimeCheck;
    private boolean showLabelFlag = true;
    public int updateEveryFrame = 20;
    private int collectAverages = 100;
    private long currentTime;
    private long frameTimestamp;
    private int num = 0;
    private long savedTime;
    private int[] savedTimesArray = new int[this.collectAverages];
    private String averageFpsString;

    public float calculateAverageFps() {
        int runTot = 0;
        for (int x = 0; x < this.num; ++x) {
            if (this.savedTimesArray[x] == 0) continue;
            runTot += this.savedTimesArray[x];
        }
        this.averageFps = (float)runTot / (float)this.num;
        this.averageFpsString = Float.toString(this.averageFps);
        int pPos = this.averageFpsString.indexOf(".");
        this.averageFpsString = this.averageFpsString.substring(0, pPos + 2);
        return this.averageFps;
    }

    public void drawFps(Graphics g) {
        Font font = Font.getFont((int)64, (int)0, (int)8);
        g.setFont(font);
        g.setColor(0xFFFFFF);
        if (this.framesPerSecond == 0) {
            return;
        }
        if (this.showLabelFlag) {
            try {
                g.drawString(this.labelFps, g.getClipWidth() - 1, g.getClipHeight() - font.getHeight(), 40);
            }
            catch (Exception e) {
                System.err.println("drawstring error");
            }
        }
        String message = String.valueOf(this.framesPerSecond) + "/" + this.averageFpsString;
        g.drawString(message, g.getClipWidth() - 1, g.getClipHeight() - 1, 40);
    }

    public float getAverageFps() {
        return this.averageFps;
    }

    public void restore() {
        this.lastTimeCheck = System.currentTimeMillis() - this.savedTime;
    }

    public void setAverageFps(float averageFps) {
        this.averageFps = averageFps;
    }

    public void suspend() {
        this.savedTime = System.currentTimeMillis() - this.lastTimeCheck;
    }

    public void update() {
        long currTime = System.currentTimeMillis();
        this.framesPerSecond = (int)(1000L / (currTime - this.lastTimeCheck));
        this.lastTimeCheck = currTime;
        this.averageFps = this.num > 0 ? this.calculateAverageFps() : 0.0f;
        ++this.num;
        if (this.num >= this.collectAverages) {
            this.num = 0;
        }
        this.savedTimesArray[this.num] = this.framesPerSecond;
    }

    public String getAverageFpsString() {
        return this.averageFpsString;
    }

    public void setAverageFpsString(String averageFpsString) {
        this.averageFpsString = averageFpsString;
    }

    public void setShowLabelFlag(boolean showLabelFlag) {
        this.showLabelFlag = showLabelFlag;
    }

    public boolean isShowLabelFlag() {
        return this.showLabelFlag;
    }
}

